/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.mdr.persistence.memoryimpl;

import java.util.Map;
import org.netbeans.mdr.persistence.MOFID;
import org.netbeans.mdr.persistence.MultivaluedIndex;
import org.netbeans.mdr.persistence.MultivaluedOrderedIndex;
import org.netbeans.mdr.persistence.SinglevaluedIndex;
import org.netbeans.mdr.persistence.Storage;
import org.netbeans.mdr.persistence.StorageException;
import org.netbeans.mdr.persistence.StorageFactory;
import org.netbeans.mdr.persistence.memoryimpl.IndexStorageCreator;
import org.netbeans.mdr.persistence.memoryimpl.MultivaluedOrderedIndexImpl;
import org.netbeans.mdr.persistence.memoryimpl.PrimaryIndex;
import org.netbeans.mdr.persistence.memoryimpl.PrimaryIndexImpl;
import org.netbeans.mdr.persistence.memoryimpl.SinglevaluedIndexImpl;
import org.netbeans.mdr.persistence.memoryimpl.StorageImpl;
import org.netbeans.mdr.util.AbstractCollectionFactory;
import org.netbeans.mdr.util.DebugException;

public abstract class AbstractStorageFactory
implements StorageFactory,
IndexStorageCreator {
    static final String NULL_STORAGE_ID = ".";
    private static final MOFID NULL_MOFID = new MOFID(0L, ".");
    private StorageImpl nullStorage;
    private final Map storages = AbstractCollectionFactory.getCollectionFactory().createHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Storage createStorage(Map properties) throws StorageException {
        String name = (String)properties.get(this.getStorageId());
        if (name == null || name.equals(NULL_STORAGE_ID)) {
            if (this.nullStorage == null) {
                this.nullStorage = new StorageImpl(NULL_STORAGE_ID, null, this);
            }
            return this.nullStorage;
        }
        Map map = this.storages;
        synchronized (map) {
            if (this.storages.containsKey(name)) {
                throw new DebugException("Storage '" + name + "' already created.");
            }
            StorageImpl result = new StorageImpl(name, (String)properties.get(this.getStorageName()), this);
            this.storages.put(name, result);
            return result;
        }
    }

    public SinglevaluedIndex createSingleValueIndex(String name, StorageImpl storage, Storage.EntryType keyType, Storage.EntryType valueType) throws StorageException {
        return new SinglevaluedIndexImpl(name, storage, keyType, valueType, this);
    }

    public MultivaluedOrderedIndex createMultivalueOrderedIndex(String name, Storage storage, Storage.EntryType keyType, Storage.EntryType valueType, boolean unique) {
        return new MultivaluedOrderedIndexImpl(name, storage, keyType, valueType, unique, this);
    }

    public MultivaluedIndex createMultivalueIndex(String name, Storage storage, Storage.EntryType keyType, Storage.EntryType valueType, boolean unique) {
        return new MultivaluedOrderedIndexImpl(name, storage, keyType, valueType, unique, this);
    }

    public PrimaryIndex createPrimaryIndex(StorageImpl storage) throws StorageException {
        return new PrimaryIndexImpl(this, storage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean serialize(String storageId) throws StorageException {
        StorageImpl storage;
        Map map = this.storages;
        synchronized (map) {
            storage = (StorageImpl)this.storages.get(storageId);
        }
        if (storage == null) {
            return false;
        }
        storage.serialize();
        return true;
    }

    public MOFID createNullMOFID() throws StorageException {
        return NULL_MOFID;
    }
}

