/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.mdr.persistence.memoryimpl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.netbeans.mdr.persistence.SinglevaluedIndex;
import org.netbeans.mdr.persistence.Storage;
import org.netbeans.mdr.persistence.StorageBadRequestException;
import org.netbeans.mdr.persistence.StorageException;
import org.netbeans.mdr.persistence.StorageIOException;
import org.netbeans.mdr.persistence.Streamable;
import org.netbeans.mdr.persistence.memoryimpl.IndexStorageCreator;
import org.netbeans.mdr.persistence.memoryimpl.TransactionSingleValueLog;
import org.netbeans.mdr.persistence.memoryimpl.Transactionable;
import org.netbeans.mdr.persistence.memoryimpl.Utils;
import org.netbeans.mdr.util.IOUtils;
import org.netbeans.mdr.util.MapEntryImpl;

public class SinglevaluedIndexImpl
implements SinglevaluedIndex,
Streamable,
Transactionable {
    private String name;
    private Storage.EntryType keyType;
    private Storage.EntryType valueType;
    protected Map table;
    protected Storage storage;
    protected TransactionSingleValueLog _transSingleValueLog = new TransactionSingleValueLog();

    public SinglevaluedIndexImpl() {
    }

    public SinglevaluedIndexImpl(String name, Storage storage, Storage.EntryType keyType, Storage.EntryType valueType, IndexStorageCreator indexStorageCreator) {
        this.name = name;
        this.keyType = keyType;
        this.valueType = valueType;
        this.table = indexStorageCreator.createIndexStorage(keyType);
        this.storage = storage;
    }

    public String getName() throws StorageException {
        return this.name;
    }

    public Storage.EntryType getValueType() throws StorageException {
        return this.valueType;
    }

    public Storage.EntryType getKeyType() throws StorageException {
        return this.keyType;
    }

    public synchronized Set keySet() throws StorageException {
        return this.table.keySet();
    }

    public synchronized void add(Object key, Object value) throws StorageException {
        Object original = this.table.put(key, value);
        if (original != null) {
            this.table.put(key, original);
            throw new StorageBadRequestException("Cannot add more than one item to key in single-valued index.");
        }
        this._transSingleValueLog.logAdd(key);
    }

    public synchronized boolean remove(Object key) throws StorageException {
        Object value = this.table.remove(key);
        if (value != null) {
            this._transSingleValueLog.logRemove(key, value);
            return true;
        }
        return false;
    }

    public void dispose() {
    }

    public synchronized boolean put(Object key, Object value) throws StorageException {
        Object old = this.table.put(key, value);
        if (old == null) {
            this._transSingleValueLog.logAdd(key);
            return false;
        }
        this._transSingleValueLog.logReplace(key, old);
        return true;
    }

    public synchronized void replace(Object key, Object value) throws StorageException {
        Object original = this.table.put(key, value);
        if (original == null) {
            this.table.remove(key);
            throw new StorageBadRequestException("Cannot replace item that does not exist in the index.");
        }
        this._transSingleValueLog.logReplace(key, original);
    }

    public synchronized Object get(Object key) throws StorageException {
        Object value = this.table.get(key);
        if (value == null) {
            throw new StorageBadRequestException("Item not found: " + key);
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Object getObject(Object key, SinglevaluedIndex repos) throws StorageException {
        if (this.keyType == Storage.EntryType.MOFID) {
            SinglevaluedIndex singlevaluedIndex = repos;
            synchronized (singlevaluedIndex) {
                return repos.get(this.get(key));
            }
        }
        return this.get(key);
    }

    public synchronized Object getIfExists(Object key) throws StorageException {
        return this.table.get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Object getObjectIfExists(Object key, SinglevaluedIndex repos) throws StorageException {
        Object val = this.getIfExists(key);
        if (val == null) {
            return null;
        }
        if (this.keyType == Storage.EntryType.MOFID) {
            SinglevaluedIndex singlevaluedIndex = repos;
            synchronized (singlevaluedIndex) {
                return repos.get(val);
            }
        }
        return val;
    }

    public synchronized Collection values() throws StorageException {
        return this.table.values();
    }

    public void write(OutputStream out) throws StorageException {
        try {
            IOUtils.writeString(out, this.name);
            out.write(this.keyType.encode());
            out.write(this.valueType.encode());
            Utils.write(out, this.table, this.storage);
        }
        catch (IOException e) {
            throw new StorageIOException(e);
        }
    }

    public void read(InputStream is) throws StorageException {
        try {
            this.name = IOUtils.readString(is);
            this.keyType = Storage.EntryType.decodeEntryType((byte)is.read());
            this.valueType = Storage.EntryType.decodeEntryType((byte)is.read());
            this.table = (Map)Utils.read(is, this.storage);
        }
        catch (IOException e) {
            throw new StorageIOException(e);
        }
    }

    public synchronized Collection queryByKeyPrefix(Object prefix, SinglevaluedIndex primaryIndex) throws StorageException {
        if (this.keyType != Storage.EntryType.STRING) {
            throw new UnsupportedOperationException("Key type must be EntryType.STRING");
        }
        if (!(prefix instanceof String)) {
            throw new StorageBadRequestException("String object parameter expected.");
        }
        LinkedList<MapEntryImpl> result = new LinkedList<MapEntryImpl>();
        Iterator iter = this.table.keySet().iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            if (!key.startsWith((String)prefix)) continue;
            result.add(new MapEntryImpl(key, this.getObject(key, primaryIndex)));
        }
        return result;
    }

    public void changed(Object key) {
    }

    public final synchronized void rollBackChanges() throws StorageException {
        this._transSingleValueLog.rollBack(this);
        this._transSingleValueLog.clear();
    }

    public final synchronized void commitChanges() throws StorageException {
        this._transSingleValueLog.clear();
    }
}

