/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.mdr.persistence.memoryimpl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.netbeans.mdr.persistence.MOFID;
import org.netbeans.mdr.persistence.Storage;
import org.netbeans.mdr.util.AbstractCollectionFactory;
import org.netbeans.mdr.util.IOUtils;

public class Utils {
    public static void write(OutputStream outputStream, Object object, Storage storage) throws IOException {
        if (object instanceof Map) {
            outputStream.write(3);
            Map temp = (Map)object;
            IOUtils.writeInt(outputStream, temp.size());
            Iterator it = temp.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry key = it.next();
                Utils.write(outputStream, key.getKey(), storage);
                Utils.write(outputStream, key.getValue(), storage);
            }
        } else if (object instanceof Collection) {
            outputStream.write(5);
            Collection col = (Collection)object;
            IOUtils.writeInt(outputStream, col.size());
            Iterator it = col.iterator();
            while (it.hasNext()) {
                Utils.write(outputStream, it.next(), storage);
            }
        } else if (object instanceof MOFID) {
            outputStream.write(23);
            IOUtils.writeMOFID(outputStream, (MOFID)object, storage);
        } else {
            IOUtils.write(outputStream, object);
        }
    }

    public static Object read(InputStream inputStream, Storage storage) throws IOException {
        int type = inputStream.read();
        switch (type) {
            case 3: {
                int size = IOUtils.readInt(inputStream);
                Map result = AbstractCollectionFactory.getCollectionFactory().createHashMap(size);
                for (int i = 0; i < size; ++i) {
                    result.put(Utils.read(inputStream, storage), Utils.read(inputStream, storage));
                }
                return result;
            }
            case 5: {
                int size = IOUtils.readInt(inputStream);
                List result = AbstractCollectionFactory.getCollectionFactory().createArrayList(size);
                for (int i = 0; i < size; ++i) {
                    result.add(Utils.read(inputStream, storage));
                }
                return result;
            }
            case 23: {
                return IOUtils.readMOFID(inputStream, storage);
            }
        }
        return IOUtils.read(inputStream, null, null, type);
    }
}

