/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.mdr.storagemodel;

import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import javax.jmi.reflect.RefObject;
import org.netbeans.mdr.persistence.MOFID;
import org.netbeans.mdr.persistence.StorageException;
import org.netbeans.mdr.storagemodel.AttrCollection;
import org.netbeans.mdr.storagemodel.StorableClass;
import org.netbeans.mdr.storagemodel.StorableFeatured;
import org.netbeans.mdr.storagemodel.StorableObject;
import org.netbeans.mdr.util.DebugException;
import org.netbeans.mdr.util.Logger;

public class AttrList
extends AttrCollection
implements List {
    protected final List innerList;

    public AttrList() {
        this.innerList = (List)this.inner;
    }

    AttrList(StorableFeatured mdrObject, StorableClass.AttributeDescriptor desc) throws StorageException {
        this(mdrObject, desc, null);
    }

    protected AttrList(StorableFeatured mdrObject, StorableClass.AttributeDescriptor desc, List values) throws StorageException {
        super(mdrObject, desc, values);
        this.innerList = (List)this.inner;
    }

    protected AttrList(StorableFeatured mdrObject, List values, int maxSize, Class type, String attrName, boolean isRefObject, MOFID metaMofId) {
        super(mdrObject, values, maxSize, type, attrName, isRefObject, metaMofId);
        this.innerList = values;
    }

    public void add(int param, Object obj) {
        this.checkType(obj);
        this.checkMaxSize(1);
        this.mdrObject.objectWillChange();
        if (this.isIndexed) {
            ((StorableObject)this.mdrObject).removeFromIndex(this.metaMofId);
        }
        this.innerList.add(param, obj);
        if (this.isRefObject) {
            try {
                this.setAttribComposite((RefObject)obj);
            }
            catch (StorageException e) {
                throw (DebugException)Logger.getDefault().annotate((Throwable)new DebugException(e), (Throwable)e);
            }
        }
        if (this.isIndexed) {
            ((StorableObject)this.mdrObject).addToIndex(this.metaMofId);
        }
        this.mdrObject.objectChanged();
    }

    public boolean addAll(int param, Collection collection) {
        throw new DebugException(new UnsupportedOperationException());
    }

    public Object get(int param) {
        return this.innerList.get(param);
    }

    public int indexOf(Object obj) {
        return this.innerList.indexOf(obj);
    }

    public int lastIndexOf(Object obj) {
        return this.innerList.lastIndexOf(obj);
    }

    public ListIterator listIterator() {
        return new AttrListIterator(this.innerList.listIterator());
    }

    public ListIterator listIterator(int param) {
        return new AttrListIterator(this.innerList.listIterator(param));
    }

    public Object remove(int param) {
        this.mdrObject.objectWillChange();
        if (this.isIndexed) {
            ((StorableObject)this.mdrObject).removeFromIndex(this.metaMofId);
        }
        Object result = this.innerList.remove(param);
        if (this.isRefObject) {
            try {
                this.clearAttribComposite((RefObject)result);
            }
            catch (StorageException e) {
                throw (DebugException)Logger.getDefault().annotate((Throwable)new DebugException(e), (Throwable)e);
            }
        }
        if (this.isIndexed) {
            ((StorableObject)this.mdrObject).addToIndex(this.metaMofId);
        }
        this.mdrObject.objectChanged();
        return result;
    }

    public Object set(int param, Object obj) {
        this.checkType(obj);
        this.mdrObject.objectWillChange();
        if (this.isIndexed) {
            ((StorableObject)this.mdrObject).removeFromIndex(this.metaMofId);
        }
        Object result = this.innerList.set(param, obj);
        if (this.isRefObject) {
            try {
                this.clearAttribComposite((RefObject)result);
                this.setAttribComposite((RefObject)obj);
            }
            catch (StorageException e) {
                throw (DebugException)Logger.getDefault().annotate((Throwable)new DebugException(e), (Throwable)e);
            }
        }
        if (this.isIndexed) {
            ((StorableObject)this.mdrObject).addToIndex(this.metaMofId);
        }
        this.mdrObject.objectChanged();
        return result;
    }

    public List subList(int param, int param1) {
        return new AttrList(this.mdrObject, this.innerList.subList(param, param1), this.maxSize, this.type, this.attrName, this.isRefObject, this.metaMofId);
    }

    protected class AttrListIterator
    extends AttrCollection.AttrIterator
    implements ListIterator {
        private final ListIterator innerIterator;

        protected AttrListIterator(ListIterator iterator) {
            super(iterator);
            this.innerIterator = iterator;
        }

        public void add(Object obj) {
            AttrList.this.checkType(obj);
            AttrList.this.checkMaxSize(1);
            AttrList.this.mdrObject.objectWillChange();
            if (AttrList.this.isIndexed) {
                ((StorableObject)AttrList.this.mdrObject).removeFromIndex(AttrList.this.metaMofId);
            }
            this.innerIterator.add(obj);
            if (AttrList.this.isRefObject) {
                try {
                    AttrList.this.setAttribComposite((RefObject)obj);
                }
                catch (StorageException e) {
                    throw (DebugException)Logger.getDefault().annotate((Throwable)new DebugException(e), (Throwable)e);
                }
            }
            if (AttrList.this.isIndexed) {
                ((StorableObject)AttrList.this.mdrObject).addToIndex(AttrList.this.metaMofId);
            }
            AttrList.this.mdrObject.objectChanged();
        }

        public boolean hasPrevious() {
            return this.innerIterator.hasPrevious();
        }

        public int nextIndex() {
            return this.innerIterator.nextIndex();
        }

        public Object previous() {
            this.lastRead = this.innerIterator.previous();
            return this.lastRead;
        }

        public int previousIndex() {
            return this.innerIterator.previousIndex();
        }

        public void set(Object obj) {
            AttrList.this.checkType(obj);
            AttrList.this.mdrObject.objectWillChange();
            if (AttrList.this.isIndexed) {
                ((StorableObject)AttrList.this.mdrObject).removeFromIndex(AttrList.this.metaMofId);
            }
            this.innerIterator.set(obj);
            if (AttrList.this.isRefObject) {
                try {
                    AttrList.this.clearAttribComposite((RefObject)this.lastRead);
                    AttrList.this.setAttribComposite((RefObject)obj);
                }
                catch (StorageException e) {
                    throw (DebugException)Logger.getDefault().annotate((Throwable)new DebugException(e), (Throwable)e);
                }
            }
            if (AttrList.this.isIndexed) {
                ((StorableObject)AttrList.this.mdrObject).addToIndex(AttrList.this.metaMofId);
            }
            AttrList.this.mdrObject.objectChanged();
        }
    }
}

