/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.mdr.storagemodel;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.List;
import org.netbeans.mdr.handlers.BaseObjectHandler;
import org.netbeans.mdr.storagemodel.MdrStorage;
import org.netbeans.mdr.storagemodel.StorableBaseObject;
import org.netbeans.mdr.util.AbstractCollectionFactory;
import org.netbeans.mdr.util.DebugException;
import org.netbeans.mdr.util.IOUtils;
import org.netbeans.mdr.util.Logger;

public class DatatypeDescriptor {
    private final int[] memberIDs;
    private final int[] memberTypeIDs;
    private final int ifcIndex;
    private final int typeNameIndex;
    private final transient MdrStorage storage;
    private transient String ifcName = null;
    private transient List members = null;
    private transient List memberTypes = null;
    private transient List typeName = null;
    private transient String storageId = null;

    public DatatypeDescriptor(MdrStorage storage, List typeName, List members, List memberTypes, String ifcName, String storageId) {
        int i;
        this.storage = storage;
        this.ifcName = ifcName;
        this.storageId = storageId;
        this.ifcIndex = storage.storageValues(this.storageId).store(ifcName);
        this.members = Collections.unmodifiableList(members);
        this.memberIDs = new int[members.size()];
        for (i = 0; i < this.memberIDs.length; ++i) {
            this.memberIDs[i] = storage.storageValues(this.storageId).store(members.get(i));
        }
        if (typeName == null) {
            this.typeNameIndex = 0;
        } else {
            this.typeName = Collections.unmodifiableList(typeName);
            this.typeNameIndex = storage.storageValues(this.storageId).store(typeName);
        }
        if (memberTypes == null) {
            this.memberTypeIDs = null;
        } else {
            this.memberTypes = Collections.unmodifiableList(memberTypes);
            this.memberTypeIDs = new int[memberTypes.size()];
            for (i = 0; i < this.memberTypeIDs.length; ++i) {
                this.memberTypeIDs[i] = storage.storageValues(this.storageId).store(((Class)memberTypes.get(i)).getName());
            }
        }
    }

    public DatatypeDescriptor(MdrStorage storage, List members, String ifcName, String storageId) {
        this(storage, null, members, null, ifcName, storageId);
    }

    private DatatypeDescriptor(MdrStorage storage, int typeNameIndex, int[] memberIDs, int[] memberTypeIDs, int ifcIndex, String storageId) {
        this.storage = storage;
        this.typeNameIndex = typeNameIndex;
        this.memberIDs = memberIDs;
        this.memberTypeIDs = memberTypeIDs;
        this.ifcIndex = ifcIndex;
        this.storageId = storageId;
    }

    public synchronized List getMembers() {
        if (this.members == null) {
            this.members = AbstractCollectionFactory.getCollectionFactory().createArrayList(this.memberIDs.length);
            for (int i = 0; i < this.memberIDs.length; ++i) {
                this.members.add(this.storage.storageValues(this.storageId).resolve(this.memberIDs[i]));
            }
            this.members = Collections.unmodifiableList(this.members);
        }
        return this.members;
    }

    public synchronized List getMemberTypes() {
        if (this.memberTypeIDs == null) {
            return null;
        }
        if (this.memberTypes == null) {
            this.memberTypes = AbstractCollectionFactory.getCollectionFactory().createArrayList(this.memberTypeIDs.length);
            for (int i = 0; i < this.memberTypeIDs.length; ++i) {
                try {
                    this.memberTypes.add(BaseObjectHandler.resolveInterface((String)this.storage.storageValues(this.storageId).resolve(this.memberTypeIDs[i])));
                    continue;
                }
                catch (ClassNotFoundException e) {
                    throw (DebugException)Logger.getDefault().annotate((Throwable)new DebugException(e), (Throwable)e);
                }
            }
            this.memberTypes = Collections.unmodifiableList(this.memberTypes);
        }
        return this.memberTypes;
    }

    public synchronized List getTypeName() {
        if (this.typeName == null) {
            this.typeName = (List)this.storage.storageValues(this.storageId).resolve(this.typeNameIndex);
        }
        return this.typeName;
    }

    public synchronized String getIfcName() {
        if (this.ifcName == null) {
            this.ifcName = (String)this.storage.storageValues(this.storageId).resolve(this.ifcIndex);
        }
        return this.ifcName;
    }

    static DatatypeDescriptor readResolve(InputStream inputStream, StorableBaseObject storable) throws IOException {
        int typeNameIndex = IOUtils.readInt(inputStream);
        int[] memberIDs = new int[IOUtils.readInt(inputStream)];
        for (int i = 0; i < memberIDs.length; ++i) {
            memberIDs[i] = IOUtils.readInt(inputStream);
        }
        int size = IOUtils.readInt(inputStream);
        int[] memberTypeIDs = null;
        if (size > 0) {
            memberTypeIDs = new int[size - 1];
            for (int i = 0; i < size - 1; ++i) {
                memberTypeIDs[i] = IOUtils.readInt(inputStream);
            }
        }
        return new DatatypeDescriptor(storable.getMdrStorage(), typeNameIndex, memberIDs, memberTypeIDs, IOUtils.readInt(inputStream), MdrStorage.getStorageIdFromMofId(storable.getMofId()));
    }

    void write(OutputStream outputStream) throws IOException {
        int i;
        IOUtils.writeInt(outputStream, this.typeNameIndex);
        IOUtils.writeInt(outputStream, this.memberIDs.length);
        for (i = 0; i < this.memberIDs.length; ++i) {
            IOUtils.writeInt(outputStream, this.memberIDs[i]);
        }
        if (this.memberTypeIDs == null) {
            IOUtils.writeInt(outputStream, 0);
        } else {
            IOUtils.writeInt(outputStream, this.memberTypeIDs.length + 1);
            for (i = 0; i < this.memberTypeIDs.length; ++i) {
                IOUtils.writeInt(outputStream, this.memberTypeIDs[i]);
            }
        }
        IOUtils.writeInt(outputStream, this.ifcIndex);
    }
}

