/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.mdr.storagemodel.transientimpl;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.netbeans.mdr.persistence.MOFID;
import org.netbeans.mdr.persistence.MultivaluedOrderedIndex;
import org.netbeans.mdr.persistence.SinglevaluedIndex;
import org.netbeans.mdr.persistence.Storage;
import org.netbeans.mdr.persistence.StorageBadRequestException;
import org.netbeans.mdr.persistence.StorageException;
import org.netbeans.mdr.storagemodel.MdrStorage;
import org.netbeans.mdr.storagemodel.transientimpl.CompensatingTransaction;
import org.netbeans.mdr.storagemodel.transientimpl.TransientIndex;
import org.netbeans.mdr.storagemodel.transientimpl.TransientMultivaluedIndex;
import org.netbeans.mdr.util.AbstractCollectionFactory;
import org.netbeans.mdr.util.DebugException;

public class TransientMultivaluedOrderedIndex
extends TransientMultivaluedIndex
implements MultivaluedOrderedIndex {
    public TransientMultivaluedOrderedIndex(MdrStorage storage, String name, Storage.EntryType keyType, Storage.EntryType valueType, boolean unique) {
        super(storage, name, keyType, valueType, unique);
    }

    public void add(Object key, int index, Object value) throws StorageException {
        List c;
        if (this.map == null) {
            this.map = AbstractCollectionFactory.getCollectionFactory().createHashMap();
        }
        if ((c = (List)this.map.get(key)) == null) {
            c = AbstractCollectionFactory.getCollectionFactory().createArrayList();
            this.map.put(key, c);
        }
        this.addToList(c, index, key, value);
        this.txlog.push(new CompensatingTransaction.AddOrderedCTx(key, value, index));
    }

    protected TransientMultivaluedIndex.SlotCollection createSlotCollection(Object key, Collection c) {
        return new OrderedSlotCollection(key, c);
    }

    protected TransientMultivaluedIndex.SlotCollection createSlotCollection(Object key, Collection c, SinglevaluedIndex repos) {
        return new OrderedSlotCollection(key, c, repos);
    }

    public List getItemsOrdered(Object key) throws StorageException {
        return (List)this.getItems(key);
    }

    public Collection getObjectsOrdered(Object key, SinglevaluedIndex repos) throws StorageException {
        return this.getObjects(key, repos);
    }

    public boolean remove(Object key, int index) throws StorageException {
        if (this.map == null) {
            return false;
        }
        List list = (List)this.map.get(key);
        Object result = this.removeFromList(list, index);
        if (result != null) {
            this.txlog.push(new CompensatingTransaction.RemoveOrderedCTx(key, result, index));
        }
        return result != null;
    }

    public void replace(Object key, int index, Object element) throws StorageException {
        if (this.map == null) {
            throw new StorageBadRequestException();
        }
        List list = (List)this.map.get(key);
        Object result = this.setInList(list, index, key, element);
        if (result != null) {
            this.txlog.push(new CompensatingTransaction.RemoveOrderedCTx(key, result, index));
        }
        this.txlog.push(new CompensatingTransaction.AddOrderedCTx(key, result, index));
    }

    protected void addNoTx(Object key, Object value, int index) throws StorageException {
        if (this.map == null) {
            return;
        }
        List l = (List)this.map.get(key);
        this.addToList(l, index, key, value);
    }

    protected Object removeNoTx(Object key, Object value, int index) throws StorageException {
        if (this.map == null) {
            return null;
        }
        List l = (List)this.map.get(key);
        return this.removeFromList(l, index);
    }

    private void addToList(List c, int index, Object key, Object value) throws StorageException {
        if (this.unique) {
            Iterator it = c.iterator();
            while (it.hasNext()) {
                TransientIndex.Entry e = (TransientIndex.Entry)it.next();
                if (!value.equals(e.getValue())) continue;
                throw new StorageBadRequestException("Value: " + value + " is already contained.");
            }
        }
        TransientIndex.Entry e = new TransientIndex.Entry(key, value);
        c.add(index, e);
    }

    private Object removeFromList(List list, int index) throws StorageException {
        if (list == null) {
            return null;
        }
        TransientIndex.Entry e = (TransientIndex.Entry)list.remove(index);
        MOFID value = e.getValue();
        e.dispose();
        return value;
    }

    private Object setInList(List list, int index, Object key, Object value) throws StorageException {
        if (list == null) {
            throw new StorageBadRequestException();
        }
        TransientIndex.Entry newEntry = new TransientIndex.Entry(key, value);
        TransientIndex.Entry old = list.set(index, newEntry);
        if (old != null) {
            old.dispose();
            return old.getValue();
        }
        return null;
    }

    protected class OrderedSlotIterator
    extends TransientMultivaluedIndex.SlotIterator
    implements ListIterator {
        private TransientIndex.Entry prev;
        private int position;

        public OrderedSlotIterator(List l) {
            this(null, l, null, 0);
        }

        public OrderedSlotIterator(List l, int index) {
            this(null, l, null, index);
        }

        public OrderedSlotIterator(Object key, List l, SinglevaluedIndex repos) {
            this(null, l, repos, 0);
        }

        public OrderedSlotIterator(Object key, List l, SinglevaluedIndex repos, int index) {
            super(key, l, repos, index == 0 ? l.listIterator() : l.listIterator(index));
        }

        public Object next() {
            while (this.top == null) {
                this.top = (TransientIndex.Entry)this.innerIt.next();
                if (this.top.isValid()) continue;
                this.innerIt.remove();
                this.top.dispose();
                this.top = null;
            }
            this.last = this.top;
            this.prev = null;
            this.top = null;
            try {
                Object result = TransientMultivaluedOrderedIndex.this.map(this.key, this.last.getValue(), this.repos);
                ++this.position;
                return result;
            }
            catch (StorageException se) {
                throw new DebugException(se.toString());
            }
        }

        public boolean hasPrevious() {
            while (this.prev == null) {
                if (!((ListIterator)this.innerIt).hasPrevious()) {
                    return false;
                }
                this.prev = (TransientIndex.Entry)((ListIterator)this.innerIt).previous();
                if (this.prev.isValid()) continue;
                this.innerIt.remove();
                this.prev.dispose();
                this.prev = null;
            }
            return true;
        }

        public Object previous() {
            while (this.prev == null) {
                this.prev = (TransientIndex.Entry)((ListIterator)this.innerIt).previous();
                if (this.prev.isValid()) continue;
                this.innerIt.remove();
                this.prev.dispose();
                this.prev = null;
            }
            this.last = this.prev;
            this.prev = null;
            this.top = null;
            try {
                Object result = TransientMultivaluedOrderedIndex.this.map(this.key, this.last.getValue(), this.repos);
                --this.position;
                return result;
            }
            catch (StorageException se) {
                throw new DebugException(se.toString());
            }
        }

        public int nextIndex() {
            return ((ListIterator)this.innerIt).nextIndex();
        }

        public int previousIndex() {
            return ((ListIterator)this.innerIt).previousIndex();
        }

        public void add(Object o) {
            if (this.repos != null) {
                throw new UnsupportedOperationException();
            }
            if (this.last == null) {
                throw new IllegalStateException();
            }
            if (TransientMultivaluedOrderedIndex.this.unique && this.collection.contains(o)) {
                throw new IllegalStateException("Object already contained in unique index.");
            }
            try {
                TransientIndex.Entry e = new TransientIndex.Entry(this.key, o);
                ((ListIterator)this.innerIt).add(e);
                TransientMultivaluedOrderedIndex.this.txlog.push(new CompensatingTransaction.AddOrderedCTx(this.key, o, this.position));
            }
            catch (StorageException e) {
                throw new DebugException(e);
            }
        }

        public void set(Object o) {
            if (this.repos != null) {
                throw new UnsupportedOperationException();
            }
            if (this.last == null) {
                throw new IllegalStateException();
            }
            if (TransientMultivaluedOrderedIndex.this.unique && this.collection.contains(o)) {
                throw new IllegalStateException("Object already contained in unique index.");
            }
            try {
                TransientIndex.Entry e = new TransientIndex.Entry(this.key, o);
                ((ListIterator)this.innerIt).set(e);
                TransientMultivaluedOrderedIndex.this.txlog.push(new CompensatingTransaction.RemoveOrderedCTx(this.key, this.last.getValue(), this.position));
                TransientMultivaluedOrderedIndex.this.txlog.push(new CompensatingTransaction.AddOrderedCTx(this.key, o, this.position));
            }
            catch (StorageException e) {
                throw new DebugException(e);
            }
        }
    }

    public class OrderedSlotCollection
    extends TransientMultivaluedIndex.SlotCollection
    implements List {
        public OrderedSlotCollection(Object key, Collection st) {
            this(key, st, null);
        }

        public OrderedSlotCollection(Object key, Collection st, int index, int toIndex) {
            this(key, st, null, index, toIndex);
        }

        public OrderedSlotCollection(Object key, Collection st, SinglevaluedIndex repos) {
            super(key, st, repos);
        }

        public OrderedSlotCollection(Object key, Collection st, SinglevaluedIndex repos, int fromIndex, int toIndex) {
            super(key, ((List)st).subList(fromIndex, toIndex), repos);
        }

        public void add(int index, Object element) {
            if (this.repos != null) {
                throw new UnsupportedOperationException();
            }
            try {
                TransientMultivaluedOrderedIndex.this.addToList((List)this.st, index, this.key, element);
                TransientMultivaluedOrderedIndex.this.txlog.push(new CompensatingTransaction.AddOrderedCTx(this.key, element, index));
            }
            catch (StorageException se) {
                throw new DebugException(se.toString());
            }
        }

        public boolean addAll(int index, Collection c) {
            boolean result = false;
            Iterator it = c.iterator();
            while (it.hasNext()) {
                this.add(index, it.next());
                result = true;
                ++index;
            }
            return result;
        }

        public Object get(int index) {
            TransientIndex.Entry e = (TransientIndex.Entry)((List)this.st).get(index);
            if (e == null) {
                return null;
            }
            if (!e.isValid()) {
                ((List)this.st).remove(index);
                e.dispose();
                return null;
            }
            try {
                return this.repos == null ? e.getValue() : TransientMultivaluedOrderedIndex.this.map(this.key, e.getValue(), this.repos);
            }
            catch (StorageException se) {
                throw new DebugException(se.toString());
            }
        }

        public int indexOf(Object o) {
            if (this.repos != null) {
                throw new UnsupportedOperationException();
            }
            List l = (List)this.st;
            int lSize = l.size();
            for (int i = 0; i < lSize; ++i) {
                TransientIndex.Entry e = (TransientIndex.Entry)l.get(i);
                if (!e.isValid()) {
                    l.remove(i);
                    e.dispose();
                    --i;
                    continue;
                }
                if (!o.equals(e.getValue())) continue;
                return i;
            }
            return -1;
        }

        public int lastIndexOf(Object o) {
            if (this.repos != null) {
                throw new UnsupportedOperationException();
            }
            List l = (List)this.st;
            for (int i = l.size() - 1; i >= 0; --i) {
                TransientIndex.Entry e = (TransientIndex.Entry)l.get(i);
                if (!e.isValid()) {
                    l.remove(i);
                    e.dispose();
                    continue;
                }
                if (!o.equals(e.getValue())) continue;
                return i;
            }
            return -1;
        }

        public ListIterator listIterator() {
            return new OrderedSlotIterator(this.key, (List)this.st, this.repos);
        }

        public ListIterator listIterator(int index) {
            return new OrderedSlotIterator(this.key, (List)this.st, this.repos, index);
        }

        public Object remove(int index) {
            if (this.repos != null) {
                throw new UnsupportedOperationException();
            }
            if (index < 0 || index >= this.st.size()) {
                throw new IndexOutOfBoundsException();
            }
            try {
                Object result = TransientMultivaluedOrderedIndex.this.removeFromList((List)this.st, index);
                TransientMultivaluedOrderedIndex.this.txlog.push(new CompensatingTransaction.RemoveOrderedCTx(this.key, result, index));
                return result;
            }
            catch (StorageException se) {
                throw new DebugException(se.toString());
            }
        }

        public Object set(int index, Object element) {
            if (this.repos != null) {
                throw new UnsupportedOperationException();
            }
            try {
                Object result = TransientMultivaluedOrderedIndex.this.setInList((List)this.st, index, this.key, element);
                if (result != null) {
                    TransientMultivaluedOrderedIndex.this.txlog.push(new CompensatingTransaction.RemoveOrderedCTx(this.key, result, index));
                }
                TransientMultivaluedOrderedIndex.this.txlog.push(new CompensatingTransaction.AddOrderedCTx(this.key, result, index));
                return result;
            }
            catch (StorageException se) {
                throw new DebugException(se.toString());
            }
        }

        public List subList(int fromIndex, int toIndex) {
            return new OrderedSlotCollection(this.key, this.st, this.repos, fromIndex, toIndex);
        }
    }
}

