/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.mdr.util;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.StringTokenizer;
import org.netbeans.mdr.util.Logger;

public class ClassUtils {
    private static final String byteCodeDir = System.getProperty("org.netbeans.mdr.byteCodeDir");
    private static final String cachedClassPattern = System.getProperty("org.netbeans.mdr.cachedClassPattern");
    private static String[] classPaterns;

    public static String getBaseClassDir() {
        return byteCodeDir;
    }

    public static boolean isSaveByteCode() {
        return byteCodeDir != null;
    }

    public static boolean isCachedClassPattern() {
        return cachedClassPattern != null;
    }

    public static void createPackage(String baseDir, String className) throws Exception {
        String dir = baseDir + ClassUtils.getPackageFolderPath(className);
        File df = new File(dir);
        if (!df.exists() && !df.mkdirs()) {
            Logger.getDefault().notify(1, (Throwable)new Exception("Incorrect directory" + dir + ']'));
        }
    }

    public static String getClassFile(String className) {
        return className.replace('.', '/') + ".class";
    }

    public static String getPackageFolderPath(String className) {
        return className.substring(0, className.lastIndexOf(46)).replace('.', '/');
    }

    public static void saveClass(byte[] handlerClassFile, String className) {
        try {
            ClassUtils.createPackage(byteCodeDir, className);
            BufferedOutputStream stream = new BufferedOutputStream(new FileOutputStream(byteCodeDir + ClassUtils.getClassFile(className)));
            stream.write(handlerClassFile);
            stream.close();
        }
        catch (Exception e) {
            Logger.getDefault().notify(1, (Throwable)e);
        }
    }

    public static boolean isStoredClass(String className) {
        for (int i = 0; i < classPaterns.length; ++i) {
            if (!className.startsWith(classPaterns[i])) continue;
            return true;
        }
        return false;
    }

    public static String getCachedclasspattern() {
        return cachedClassPattern;
    }

    public static synchronized byte[] loadHandler(File file) throws Exception {
        FileChannel roChannel = new RandomAccessFile(file, "r").getChannel();
        byte[] bytes = new byte[(int)roChannel.size()];
        ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
        roChannel.read(byteBuffer);
        roChannel.close();
        return bytes;
    }

    public static String getClassFilePath(String className) {
        return byteCodeDir + ClassUtils.getClassFile(className);
    }

    static {
        if (ClassUtils.isCachedClassPattern()) {
            StringTokenizer tokenizer = new StringTokenizer(cachedClassPattern, ";", false);
            classPaterns = new String[tokenizer.countTokens()];
            int i = 0;
            while (tokenizer.hasMoreTokens()) {
                ClassUtils.classPaterns[i++] = tokenizer.nextToken();
            }
        }
    }
}

