/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.mdr.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import javax.jmi.reflect.RefAssociation;
import javax.jmi.reflect.RefClass;
import javax.jmi.reflect.RefObject;
import javax.jmi.reflect.RefPackage;
import org.netbeans.api.mdr.events.AssociationEvent;
import org.netbeans.api.mdr.events.MDRChangeEvent;
import org.netbeans.api.mdr.events.MDRChangeListener;
import org.netbeans.api.mdr.events.MDRPreChangeListener;
import org.netbeans.mdr.handlers.BaseObjectHandler;
import org.netbeans.mdr.storagemodel.CompositeCollection;
import org.netbeans.mdr.util.AbstractCollectionFactory;
import org.netbeans.mdr.util.DebugException;
import org.netbeans.mdr.util.Logger;

public final class EventNotifier {
    public static final int EVENTMASK_BY_ASSOCIATION = 67239935;
    public static final int EVENTMASK_BY_INSTANCE = 117571583;
    public static final int EVENTMASK_BY_CLASS = 117702655;
    public static final int EVENTMASK_BY_PACKAGE = 117702655;
    public static final int EVENTMASK_BY_REPOSITORY = 0xF13FFFF;
    public final Association ASSOCIATION = new Association();
    public final Clazz CLASS = new Clazz();
    public final Instance INSTANCE = new Instance();
    public final Package PACKAGE = new Package();
    public final Repository REPOSITORY = new Repository();
    private final Thread dispatcher = new Thread((Runnable)new EventsDelivery(), "MDR event dispatcher");
    private final Map preChangeListeners = AbstractCollectionFactory.getCollectionFactory().createHashMap();
    private final Map changeListeners = AbstractCollectionFactory.getCollectionFactory().createHashMap();
    private final LinkedList localQueue = new LinkedList();
    private final LinkedList globalQueue = new LinkedList();
    private boolean shuttingDown = false;
    private boolean _block;

    public static String prettyPrintType(MDRChangeEvent e) {
        if (e.isOfType(0x1010002)) {
            return "EVENT_ATTRIBUTE_ADD";
        }
        if (e.isOfType(0x1010004)) {
            return "EVENT_ATTRIBUTE_REMOVE";
        }
        if (e.isOfType(0x1010001)) {
            return "EVENT_ATTRIBUTE_SET";
        }
        if (e.isOfType(0x1020002)) {
            return "EVENT_CLASSATTR_ADD";
        }
        if (e.isOfType(16908292)) {
            return "EVENT_CLASSATTR_REMOVE";
        }
        if (e.isOfType(0x1020001)) {
            return "EVENT_CLASSATTR_SET";
        }
        if (e.isOfType(0x2010001)) {
            return "EVENT_INSTANCE_CREATE";
        }
        if (e.isOfType(0x2010002)) {
            return "EVENT_INSTANCE_DELETE";
        }
        if (e.isOfType(67174402)) {
            return "EVENT_ASSOCIATION_ADD";
        }
        if (e.isOfType(0x4010004)) {
            return "EVENT_ASSOCIATION_REMOVE";
        }
        if (e.isOfType(0x4010001)) {
            return "EVENT_ASSOCIATION_SET";
        }
        if (e.isOfType(0x8010001)) {
            return "EVENT_EXTENT_CREATE";
        }
        if (e.isOfType(134283266)) {
            return "EVENT_EXTENT_DELETE";
        }
        if (e.isOfType(0x110002)) {
            return "EVENT_TRANSACTION_END";
        }
        if (e.isOfType(0x110001)) {
            return "EVENT_TRANSACTION_START";
        }
        return "<UNKNOWN>";
    }

    public static String prettyPrintMask(int mask) {
        StringBuffer buf = new StringBuffer();
        if ((mask & 0x1010002) == 0x1010002) {
            buf.append("IAA ");
        }
        if ((mask & 0x1010004) == 0x1010004) {
            buf.append("IAR ");
        }
        if ((mask & 0x1010001) == 0x1010001) {
            buf.append("IAS ");
        }
        if ((mask & 0x1020002) == 0x1020002) {
            buf.append("CAA ");
        }
        if ((mask & 0x1020004) == 16908292) {
            buf.append("CAR ");
        }
        if ((mask & 0x1020001) == 0x1020001) {
            buf.append("CAS ");
        }
        if ((mask & 0x2010001) == 0x2010001) {
            buf.append("IC ");
        }
        if ((mask & 0x2010002) == 0x2010002) {
            buf.append("ID ");
        }
        if ((mask & 0x4010002) == 67174402) {
            buf.append("AA ");
        }
        if ((mask & 0x4010004) == 0x4010004) {
            buf.append("AR ");
        }
        if ((mask & 0x4010001) == 0x4010001) {
            buf.append("AS ");
        }
        if ((mask & 0x8010001) == 0x8010001) {
            buf.append("EC ");
        }
        if ((mask & 0x8010002) == 134283266) {
            buf.append("ED ");
        }
        if ((mask & 0x110002) == 0x110002) {
            buf.append("TE ");
        }
        if ((mask & 0x110001) == 0x110001) {
            buf.append("TS ");
        }
        if (buf.length() > 0) {
            buf.deleteCharAt(buf.length() - 1);
        }
        return buf.toString();
    }

    public EventNotifier() {
        this.dispatcher.setDaemon(true);
        this.dispatcher.start();
    }

    public void fireCancelled(MDRChangeEvent event) {
        this.localQueue.remove(event);
        Set collected = (Set)this.preChangeListeners.remove(event);
        this.changeListeners.remove(event);
        if (collected == null) {
            Logger.getDefault().notify(1, (Throwable)new DebugException("Change cancelled event not corresponding to any planned change event."));
            return;
        }
        Iterator it = collected.iterator();
        while (it.hasNext()) {
            try {
                ((MDRPreChangeListener)it.next()).changeCancelled(event);
            }
            catch (RuntimeException e) {
                Logger.getDefault().notify(1, (Throwable)e);
            }
        }
    }

    public void fireCancelled() {
        while (!this.localQueue.isEmpty()) {
            MDRChangeEvent event = (MDRChangeEvent)this.localQueue.getFirst();
            this.fireCancelled(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireChanged() {
        this.preChangeListeners.clear();
        LinkedList linkedList = this.globalQueue;
        synchronized (linkedList) {
            this.globalQueue.addAll(this.localQueue);
            this.globalQueue.notify();
        }
        this.localQueue.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        LinkedList linkedList = this.globalQueue;
        synchronized (linkedList) {
            this.shuttingDown = true;
            this.globalQueue.notify();
        }
    }

    public void blockEvents(boolean block) {
        this._block = block;
    }

    static class RegisteredListenerSet {
        Map preChangeMap = AbstractCollectionFactory.getCollectionFactory().createHashMap();
        Map postChangeMap = AbstractCollectionFactory.getCollectionFactory().createHashMap();

        RegisteredListenerSet() {
        }

        void addListener(MDRChangeListener listener, int mask) {
            int currentMask;
            Integer value = (Integer)this.get(listener);
            if (value != null && ((mask |= (currentMask = value.intValue())) ^ currentMask) == 0) {
                return;
            }
            this.put(listener, mask);
        }

        private Object get(MDRChangeListener listener) {
            if (listener instanceof MDRPreChangeListener) {
                return this.preChangeMap.get(listener);
            }
            return this.postChangeMap.get(listener);
        }

        private void put(MDRChangeListener listener, int mask) {
            Integer maskAsInteger = new Integer(mask);
            if (listener instanceof MDRPreChangeListener) {
                this.preChangeMap.put(listener, maskAsInteger);
            } else {
                this.postChangeMap.put(listener, maskAsInteger);
            }
        }

        void removeListener(MDRChangeListener listener) {
            if (listener instanceof MDRPreChangeListener) {
                this.preChangeMap.remove(listener);
            } else {
                this.postChangeMap.remove(listener);
            }
        }

        void removeListener(MDRChangeListener listener, int mask) {
            Object value = this.get(listener);
            if (value != null) {
                int currentMask = (Integer)value;
                mask = currentMask & ~mask;
                if (mask == 0) {
                    this.removeListener(listener);
                } else {
                    this.put(listener, mask);
                }
            }
        }

        Set collectListeners(MDRChangeEvent event, boolean collectPreChangeListeners, Set listener) {
            Map mapToCollectListeners = collectPreChangeListeners ? this.preChangeMap : this.postChangeMap;
            return this.collectListeners(event, mapToCollectListeners, listener);
        }

        Set collectListeners(MDRChangeEvent event, Map map, Set listener) {
            Iterator it = map.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                if (!event.isOfType(((Integer)entry.getValue()).intValue())) continue;
                Object key = entry.getKey();
                if (listener == null) {
                    listener = AbstractCollectionFactory.getCollectionFactory().createHashSet();
                }
                listener.add(key);
            }
            return listener;
        }

        boolean isEmpty() {
            return this.preChangeMap.isEmpty() && this.postChangeMap.isEmpty();
        }
    }

    public final class Repository
    extends Abstract {
        private Repository() {
        }

        public void addListener(MDRChangeListener listener, int mask, Object source) {
            super.addListener(listener, mask & 0xF13FFFF, source);
        }

        public void removeListener(MDRChangeListener listener, int mask, Object source) {
            super.removeListener(listener, mask & 0xF13FFFF, source);
        }
    }

    public final class Package
    extends Abstract {
        private Package() {
        }

        public void addListener(MDRChangeListener listener, int mask, Object source) {
            super.addListener(listener, mask & 0x703FFFF, source);
        }

        public void removeListener(MDRChangeListener listener, int mask, Object source) {
            super.removeListener(listener, mask & 0x703FFFF, source);
        }

        protected Set collectListeners(Object current, MDRChangeEvent event, boolean collectPreChange, Set listener) {
            Set newListener = super.collectListeners(current, event, collectPreChange, listener);
            RefPackage immediate = ((RefPackage)current).refImmediatePackage();
            newListener = immediate != null ? this.collectListeners(immediate, event, collectPreChange, newListener) : EventNotifier.this.REPOSITORY.collectListeners(((BaseObjectHandler)current)._getDelegate().getMdrStorage(), event, collectPreChange, newListener);
            return newListener;
        }
    }

    public final class Instance
    extends Abstract {
        private Instance() {
        }

        public void addListener(MDRChangeListener listener, int mask, Object source) {
            super.addListener(listener, mask & 0x701FFFF, source);
        }

        public void removeListener(MDRChangeListener listener, int mask, Object source) {
            super.removeListener(listener, mask & 0x701FFFF, source);
        }

        protected Set collectListeners(Object current, MDRChangeEvent event, boolean collectPreChange, Set listener) {
            Set newListener = super.collectListeners(current, event, collectPreChange, listener);
            newListener = EventNotifier.this.CLASS.collectListeners(((RefObject)current).refClass(), event, collectPreChange, newListener);
            return newListener;
        }
    }

    public final class Clazz
    extends Abstract {
        private Clazz() {
        }

        public void addListener(MDRChangeListener listener, int mask, Object source) {
            super.addListener(listener, mask & 0x703FFFF, source);
        }

        public void removeListener(MDRChangeListener listener, int mask, Object source) {
            super.removeListener(listener, mask & 0x703FFFF, source);
        }

        protected Set collectListeners(Object current, MDRChangeEvent event, boolean collectPreChange, Set listener) {
            Set newListener = super.collectListeners(current, event, collectPreChange, listener);
            newListener = EventNotifier.this.PACKAGE.collectListeners(((RefClass)current).refImmediatePackage(), event, collectPreChange, newListener);
            return newListener;
        }
    }

    public final class Association
    extends Abstract {
        private Association() {
        }

        public void addListener(MDRChangeListener listener, int mask, Object source) {
            super.addListener(listener, mask & 0x401FFFF, source);
        }

        public void removeListener(MDRChangeListener listener, int mask, Object source) {
            super.removeListener(listener, mask & 0x401FFFF, source);
        }

        protected Set collectListeners(Object current, MDRChangeEvent event, boolean collectPreChange, Set listener) {
            Set newListener = super.collectListeners(current, event, collectPreChange, listener);
            if (event instanceof AssociationEvent) {
                AssociationEvent assocEvent = (AssociationEvent)event;
                if (assocEvent.getFixedElement() != null) {
                    newListener = EventNotifier.this.INSTANCE.collectListeners(assocEvent.getFixedElement(), event, collectPreChange, newListener);
                }
                if (assocEvent.getOldElement() != null) {
                    newListener = EventNotifier.this.INSTANCE.collectListeners(assocEvent.getOldElement(), event, collectPreChange, newListener);
                }
                if (assocEvent.getNewElement() != null) {
                    newListener = EventNotifier.this.INSTANCE.collectListeners(assocEvent.getNewElement(), event, collectPreChange, newListener);
                }
            }
            newListener = EventNotifier.this.PACKAGE.collectListeners(((RefAssociation)current).refImmediatePackage(), event, collectPreChange, newListener);
            return newListener;
        }
    }

    public abstract class Abstract {
        private final Map RegisteredListenerSets = AbstractCollectionFactory.getCollectionFactory().createHashMap();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addListener(MDRChangeListener listener, int mask, Object source) {
            if (listener == null || mask == 0) {
                return;
            }
            Map map = this.RegisteredListenerSets;
            synchronized (map) {
                RegisteredListenerSet value = (RegisteredListenerSet)this.RegisteredListenerSets.get(source);
                if (value == null) {
                    value = new RegisteredListenerSet();
                    this.RegisteredListenerSets.put(source, value);
                }
                value.addListener(listener, mask);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeListener(MDRChangeListener listener, Object source) {
            if (listener == null) {
                return;
            }
            Map map = this.RegisteredListenerSets;
            synchronized (map) {
                RegisteredListenerSet value = (RegisteredListenerSet)this.RegisteredListenerSets.get(source);
                if (value != null) {
                    value.removeListener(listener);
                    if (value.isEmpty()) {
                        this.RegisteredListenerSets.remove(source);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeListener(MDRChangeListener listener, int mask, Object source) {
            if (listener == null || mask == 0) {
                return;
            }
            Map map = this.RegisteredListenerSets;
            synchronized (map) {
                RegisteredListenerSet value = (RegisteredListenerSet)this.RegisteredListenerSets.get(source);
                if (value != null) {
                    value.removeListener(listener, mask);
                    if (value.isEmpty()) {
                        this.RegisteredListenerSets.remove(source);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void firePlannedChange(Object current, MDRChangeEvent event) {
            Collection all;
            if (EventNotifier.this._block && !event.isOfType(0x110002)) {
                return;
            }
            Set preChange = null;
            Set postChange = null;
            Map map = this.RegisteredListenerSets;
            synchronized (map) {
                preChange = this.collectListeners(current, event, true, null);
                postChange = this.collectListeners(current, event, false, null);
            }
            if (postChange == null && preChange == null) {
                return;
            }
            EventNotifier.this.localQueue.addLast(event);
            if (preChange != null) {
                Iterator it = preChange.iterator();
                while (it.hasNext()) {
                    try {
                        ((MDRPreChangeListener)it.next()).plannedChange(event);
                    }
                    catch (RuntimeException e) {
                        Logger.getDefault().notify(1, (Throwable)e);
                    }
                }
                if (EventNotifier.this.preChangeListeners.put(event, preChange) != null) {
                    throw new DebugException("Same event fired twice.");
                }
            }
            if (preChange != null && postChange != null) {
                all = new CompositeCollection();
                ((CompositeCollection)all).addCollection(preChange);
                ((CompositeCollection)all).addCollection(postChange);
            } else {
                all = preChange != null ? preChange : postChange;
            }
            if (EventNotifier.this.changeListeners.put(event, all) != null) {
                throw new DebugException("Same event fired twice.");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Set collectListeners(Object current, MDRChangeEvent event, boolean collectPreChange, Set listener) {
            Map map = this.RegisteredListenerSets;
            synchronized (map) {
                RegisteredListenerSet value = (RegisteredListenerSet)this.RegisteredListenerSets.get(current);
                if (value != null) {
                    Set newListener = value.collectListeners(event, collectPreChange, listener);
                    return newListener;
                }
            }
            return listener;
        }
    }

    private class EventsDelivery
    implements Runnable {
        private EventsDelivery() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            block7: while (true) {
                Collection collected;
                MDRChangeEvent event;
                LinkedList linkedList = EventNotifier.this.globalQueue;
                synchronized (linkedList) {
                    while (EventNotifier.this.globalQueue.isEmpty()) {
                        if (EventNotifier.this.shuttingDown) {
                            return;
                        }
                        try {
                            EventNotifier.this.globalQueue.wait();
                        }
                        catch (InterruptedException e) {
                            Logger.getDefault().notify(1, (Throwable)e);
                        }
                    }
                    event = (MDRChangeEvent)EventNotifier.this.globalQueue.removeFirst();
                    collected = (Collection)EventNotifier.this.changeListeners.remove(event);
                }
                if (collected == null) {
                    Logger.getDefault().notify(1, (Throwable)new DebugException("Change event not corresponding to any planned change event."));
                    return;
                }
                Iterator it = collected.iterator();
                while (true) {
                    if (!it.hasNext()) continue block7;
                    try {
                        ((MDRChangeListener)it.next()).change(event);
                        continue;
                    }
                    catch (RuntimeException e) {
                        Logger.getDefault().notify(1, (Throwable)e);
                        continue;
                    }
                    break;
                }
                break;
            }
        }
    }
}

