/*
 * Decompiled with CFR 0.152.
 */
package com.gentleware.mdr.trovememoryimpl;

import com.gentleware.mdr.storagemodel.TransactionLogSwitcher;
import com.gentleware.mdr.trovememoryimpl.MultivaluedIndexLogStrategy;
import com.gentleware.mdr.trovememoryimpl.MultivaluedIndexLogStrategyImpl;
import com.gentleware.mdr.trovememoryimpl.NullMultivaluedIndexLogStrategyImpl;
import com.gentleware.mdr.trovememoryimpl.Utils;
import gnu.trove.THashSet;
import gnu.trove.TLongObjectHashMap;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.netbeans.mdr.persistence.Index;
import org.netbeans.mdr.persistence.MultivaluedIndex;
import org.netbeans.mdr.persistence.SinglevaluedIndex;
import org.netbeans.mdr.persistence.Storage;
import org.netbeans.mdr.persistence.StorageException;
import org.netbeans.mdr.persistence.memoryimpl.MOWrapper;
import org.netbeans.mdr.persistence.memoryimpl.MultivaluedIndexImpl;
import org.netbeans.mdr.persistence.memoryimpl.TransactionLog;
import org.netbeans.mdr.persistence.memoryimpl.Transactionable;
import org.netbeans.mdr.util.AbstractCollectionFactory;

public class MOFIDMultivaluedIndexImpl
implements MultivaluedIndex,
Transactionable {
    private TLongObjectHashMap _entries = new TLongObjectHashMap();
    private TLongObjectHashMap _mofIds = new TLongObjectHashMap();
    protected boolean _unique;
    private String _name;
    private Storage.EntryType _valueType;
    protected MultivaluedIndexLogStrategy _multivaluedIndexLogStrategy;
    private PropertyChangeListener strategyLogChangerListener;

    public MOFIDMultivaluedIndexImpl(String name, Storage.EntryType valueType, boolean unique) {
        this._unique = unique;
        this._name = name;
        this._valueType = valueType;
        this.assignIndexLogStrategy(TransactionLogSwitcher.isNullStrategy());
        this.strategyLogChangerListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                MOFIDMultivaluedIndexImpl.this.assignIndexLogStrategy(Boolean.TRUE.equals(evt.getNewValue()));
            }
        };
        TransactionLogSwitcher.addPropertyChangeListener(this.strategyLogChangerListener);
    }

    private void assignIndexLogStrategy(boolean transactionLogStrategyIsNull) {
        this._multivaluedIndexLogStrategy = transactionLogStrategyIsNull ? new NullMultivaluedIndexLogStrategyImpl() : new MultivaluedIndexLogStrategyImpl();
    }

    public Collection getItems(Object key) throws StorageException {
        Collection items = this.getItemsInternal(key);
        return this._multivaluedIndexLogStrategy.getItems(this, (List)items, key);
    }

    protected Collection getItemsInternal(Object key) {
        long serialNumber = Utils.getSerialNumber(key);
        Collection items = null;
        if (this._entries.containsKey(serialNumber)) {
            items = (Collection)this._entries.get(serialNumber);
        }
        return items;
    }

    public Collection getObjects(Object key, SinglevaluedIndex singlevaluedIndex) throws StorageException {
        List items = (List)this.getItemsInternal(key);
        if (items == null) {
            items = (List)this.addNewRecord(key);
        }
        return new MOWrapper((MultivaluedIndex)this, items, singlevaluedIndex, key);
    }

    public boolean isUnique() throws StorageException {
        return this._unique;
    }

    public Collection queryByKeyPrefix(Object o, SinglevaluedIndex singlevaluedIndex) throws StorageException {
        return null;
    }

    public String getName() throws StorageException {
        return this._name;
    }

    public Storage.EntryType getValueType() throws StorageException {
        return this._valueType;
    }

    public Storage.EntryType getKeyType() throws StorageException {
        return Storage.EntryType.MOFID;
    }

    public Set keySet() throws StorageException {
        return new THashSet(Arrays.asList(this._mofIds.getValues()));
    }

    public void add(Object key, Object value) throws StorageException {
        Collection items = this.getItemsInternal(key);
        if (items == null) {
            items = this.addNewRecord(key);
        }
        if (this._unique && items.contains(value)) {
            throw MultivaluedIndexImpl.createValueAlreadyContainedExc((Object)key, (Object)value);
        }
        items.add(value);
        this._multivaluedIndexLogStrategy.addLog(key, value);
    }

    public Collection addNewRecord(Object key) {
        long serialNumber = Utils.getSerialNumber(key);
        List items = AbstractCollectionFactory.getCollectionFactory().createArrayList();
        this._entries.put(serialNumber, (Object)items);
        this._mofIds.put(serialNumber, key);
        return items;
    }

    public boolean remove(Object key, Object value) throws StorageException {
        Collection items = this.getItemsInternal(key);
        if (items.size() == 1) {
            return this.remove(key);
        }
        boolean removed = items.remove(value);
        this._multivaluedIndexLogStrategy.removeLog(removed, key, value);
        return removed;
    }

    public boolean remove(Object key) throws StorageException {
        long serialNumber = Utils.getSerialNumber(key);
        Object oldValue = this._entries.remove(serialNumber);
        boolean removed = oldValue != null;
        this._mofIds.remove(serialNumber);
        this._multivaluedIndexLogStrategy.removeKey(removed, key, oldValue);
        return removed;
    }

    public void dispose() {
        TransactionLogSwitcher.removePropertyChangeListener(this.strategyLogChangerListener);
    }

    public void setKey(Object key, Object vals) {
        long serialNumber = Utils.getSerialNumber(key);
        this._entries.put(serialNumber, vals);
    }

    public final synchronized void rollBackChanges() throws StorageException {
        TransactionLog transactionLog = this._multivaluedIndexLogStrategy.getTransactionLog();
        transactionLog.rollBack((Index)this);
        transactionLog.clear();
    }

    public final synchronized void commitChanges() throws StorageException {
        this._multivaluedIndexLogStrategy.getTransactionLog().clear();
    }
}

