/*
 * Decompiled with CFR 0.152.
 */
package com.gentleware.mdr.trovememoryimpl;

import com.gentleware.mdr.storagemodel.TransactionLogSwitcher;
import com.gentleware.mdr.trovememoryimpl.NullSinglevaluedIndexLogStrategyImpl;
import com.gentleware.mdr.trovememoryimpl.SinglevaluedIndexLogStrategy;
import com.gentleware.mdr.trovememoryimpl.SinglevaluedIndexLogStrategyImpl;
import com.gentleware.mdr.trovememoryimpl.Utils;
import gnu.trove.THashSet;
import gnu.trove.TLongObjectHashMap;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.netbeans.mdr.persistence.Index;
import org.netbeans.mdr.persistence.MOFID;
import org.netbeans.mdr.persistence.SinglevaluedIndex;
import org.netbeans.mdr.persistence.Storage;
import org.netbeans.mdr.persistence.StorageBadRequestException;
import org.netbeans.mdr.persistence.StorageException;
import org.netbeans.mdr.persistence.memoryimpl.TransactionLog;
import org.netbeans.mdr.persistence.memoryimpl.Transactionable;

public class MOFIDSinglevaluedIndexImpl
implements SinglevaluedIndex,
Transactionable {
    protected TLongObjectHashMap _entries = new TLongObjectHashMap();
    protected TLongObjectHashMap _mofIds = new TLongObjectHashMap();
    private String _name;
    private Storage.EntryType _valueType;
    protected SinglevaluedIndexLogStrategy _indexLogStrategy;
    private PropertyChangeListener _strategyLogChangerListener;

    protected MOFIDSinglevaluedIndexImpl(String name, Storage.EntryType valueType) {
        this._name = name;
        this._valueType = valueType;
    }

    public MOFIDSinglevaluedIndexImpl(String name, Storage.EntryType valueType, boolean createListener) {
        this(name, valueType);
        if (createListener) {
            this._strategyLogChangerListener = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    MOFIDSinglevaluedIndexImpl.this.assignIndexLogStrategy(Boolean.TRUE.equals(evt.getNewValue()));
                }
            };
            TransactionLogSwitcher.addPropertyChangeListener(this._strategyLogChangerListener);
        }
        this.assignIndexLogStrategy(TransactionLogSwitcher.isNullStrategy());
    }

    protected void assignIndexLogStrategy(boolean transactionLogStrategyIsNull) {
        this._indexLogStrategy = transactionLogStrategyIsNull ? new NullSinglevaluedIndexLogStrategyImpl() : new SinglevaluedIndexLogStrategyImpl();
    }

    public boolean put(Object key, Object value) throws StorageException {
        if (key instanceof MOFID) {
            long serialNumber = Utils.getSerialNumber(key);
            Object old = this._entries.put(serialNumber, value);
            this._mofIds.put(serialNumber, key);
            this._indexLogStrategy.putLog(old, key);
            return old != null;
        }
        return false;
    }

    public void replace(Object key, Object value) throws StorageException, StorageBadRequestException {
        long serialNumber = Utils.getSerialNumber(key);
        Object oldValue = this._entries.put(serialNumber, value);
        if (oldValue == null) {
            this._entries.remove(serialNumber);
            throw new StorageBadRequestException("Cannot replace item that does not exist in the index.");
        }
        this._indexLogStrategy.replaceLog(key, oldValue);
    }

    public Object get(Object key) throws StorageException, StorageBadRequestException {
        long serialNumber = Utils.getSerialNumber(key);
        Object value = this._entries.get(serialNumber);
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getObject(Object key, SinglevaluedIndex repos) throws StorageException {
        SinglevaluedIndex singlevaluedIndex = repos;
        synchronized (singlevaluedIndex) {
            return repos.get(this.get(key));
        }
    }

    public Object getIfExists(Object key) throws StorageException {
        long serialNumber = Utils.getSerialNumber(key);
        Object value = this._entries.get(serialNumber);
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getObjectIfExists(Object key, SinglevaluedIndex repos) throws StorageException {
        SinglevaluedIndex singlevaluedIndex = repos;
        synchronized (singlevaluedIndex) {
            return repos.get(this.getIfExists(key));
        }
    }

    public Collection values() throws StorageException {
        List<Object> values = Arrays.asList(this._entries.getValues());
        return values;
    }

    public Collection queryByKeyPrefix(Object o, SinglevaluedIndex singlevaluedIndex) throws StorageException {
        return null;
    }

    public String getName() throws StorageException {
        return this._name;
    }

    public Storage.EntryType getValueType() throws StorageException {
        return this._valueType;
    }

    public Storage.EntryType getKeyType() throws StorageException {
        return Storage.EntryType.MOFID;
    }

    public Set keySet() throws StorageException {
        return new THashSet(Arrays.asList(this._mofIds.getValues()));
    }

    public void add(Object key, Object value) throws StorageException {
        long serialNumber = Utils.getSerialNumber(key);
        Object oldValue = this._entries.put(serialNumber, value);
        if (oldValue != null) {
            this._entries.put(serialNumber, oldValue);
            throw new StorageBadRequestException("Cannot add more than one item to key in single-valued index.");
        }
        this._mofIds.put(serialNumber, key);
        this._indexLogStrategy.addLog(key);
    }

    public boolean remove(Object key) throws StorageException {
        long serialNumber = Utils.getSerialNumber(key);
        Object oldValue = this._entries.remove(serialNumber);
        this._mofIds.remove(serialNumber);
        boolean valueRemoved = oldValue != null;
        this._indexLogStrategy.removeLog(valueRemoved, key, oldValue);
        return valueRemoved;
    }

    public void dispose() {
        TransactionLogSwitcher.removePropertyChangeListener(this._strategyLogChangerListener);
    }

    public final synchronized void rollBackChanges() throws StorageException {
        TransactionLog transactionLog = this._indexLogStrategy.getTransactionLog();
        transactionLog.rollBack((Index)this);
        transactionLog.clear();
    }

    public final synchronized void commitChanges() throws StorageException {
        this._indexLogStrategy.getTransactionLog().clear();
    }
}

