/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.piccolox.swing;

import edu.umd.cs.piccolo.PCanvas;
import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolox.swing.PDefaultScrollDirector;
import edu.umd.cs.piccolox.swing.PScrollDirector;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import javax.swing.JViewport;
import javax.swing.ViewportLayout;

public class PViewport
extends JViewport {
    PScrollDirector scrollDirector;

    public PViewport() {
        this.setScrollDirector(this.createScrollDirector());
    }

    protected LayoutManager createLayoutManager() {
        return new PViewportLayout();
    }

    protected PScrollDirector createScrollDirector() {
        return new PDefaultScrollDirector();
    }

    public void setScrollDirector(PScrollDirector scrollDirector) {
        if (this.scrollDirector != null) {
            this.scrollDirector.unInstall();
        }
        this.scrollDirector = scrollDirector;
        if (scrollDirector != null) {
            this.scrollDirector.install(this, (PCanvas)this.getView());
        }
    }

    public PScrollDirector getScrollDirector() {
        return this.scrollDirector;
    }

    public void setView(Component view) {
        if (!(view instanceof PCanvas)) {
            throw new UnsupportedOperationException("PViewport only supports ZCanvas");
        }
        super.setView(view);
        if (this.scrollDirector != null) {
            this.scrollDirector.install(this, (PCanvas)view);
        }
    }

    public void setViewPosition(Point p) {
        if (this.getView() == null) {
            return;
        }
        double oldX = 0.0;
        double oldY = 0.0;
        double x = p.x;
        double y = p.y;
        Point vp = this.getViewPosition();
        if (vp != null) {
            oldX = ((Point2D)vp).getX();
            oldY = ((Point2D)vp).getY();
        }
        double newX = x;
        double newY = y;
        if (oldX != newX || oldY != newY) {
            this.scrollUnderway = true;
            this.scrollDirector.setViewPosition(newX, newY);
            this.fireStateChanged();
        }
    }

    public Point getViewPosition() {
        if (this.scrollDirector != null) {
            Dimension extent = this.getExtentSize();
            return this.scrollDirector.getViewPosition(new PBounds(0.0, 0.0, extent.getWidth(), extent.getHeight()));
        }
        return null;
    }

    public Dimension getViewSize() {
        Dimension extent = this.getExtentSize();
        return this.scrollDirector.getViewSize(new PBounds(0.0, 0.0, extent.getWidth(), extent.getHeight()));
    }

    public Dimension getViewSize(Rectangle2D r) {
        return this.scrollDirector.getViewSize(r);
    }

    public void fireStateChanged() {
        super.fireStateChanged();
    }

    public static class PViewportLayout
    extends ViewportLayout {
        public void layoutContainer(Container parent) {
            JViewport vp = (JViewport)parent;
            Component view = vp.getView();
            if (view == null) {
                return;
            }
            Dimension extentSize = vp.getSize();
            vp.setViewSize(extentSize);
        }
    }
}

