/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.piccolox.swt;

import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.util.PAffineTransform;
import edu.umd.cs.piccolo.util.PPaintContext;
import edu.umd.cs.piccolox.swt.SWTGraphics2D;
import edu.umd.cs.piccolox.swt.SWTShapeManager;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;

public class PSWTPath
extends PNode {
    public static final String PROPERTY_STROKE_PAINT = "strokePaint";
    public static final String PROPERTY_SHAPE = "shape";
    private static final Rectangle2D.Float TEMP_RECTANGLE = new Rectangle2D.Float();
    private static final Ellipse2D.Float TEMP_ELLIPSE = new Ellipse2D.Float();
    private static final PAffineTransform TEMP_TRANSFORM = new PAffineTransform();
    private static final Color DEFAULT_STROKE_PAINT = Color.black;
    private static final BasicStroke BASIC_STROKE = new BasicStroke();
    private Paint strokePaint = DEFAULT_STROKE_PAINT;
    Shape shape;
    double[] shapePts;

    public static PSWTPath createRectangle(float x, float y, float width, float height) {
        TEMP_RECTANGLE.setFrame(x, y, width, height);
        PSWTPath result = new PSWTPath(TEMP_RECTANGLE);
        result.setPaint(Color.white);
        return result;
    }

    public static PSWTPath createEllipse(float x, float y, float width, float height) {
        TEMP_ELLIPSE.setFrame(x, y, width, height);
        PSWTPath result = new PSWTPath(TEMP_ELLIPSE);
        result.setPaint(Color.white);
        return result;
    }

    public static PSWTPath createPolyline(Point2D[] points) {
        PSWTPath result = new PSWTPath();
        result.setPathToPolyline(points);
        result.setPaint(Color.white);
        return result;
    }

    public static PSWTPath createPolyline(float[] xp, float[] yp) {
        PSWTPath result = new PSWTPath();
        result.setPathToPolyline(xp, yp);
        result.setPaint(Color.white);
        return result;
    }

    public PSWTPath() {
    }

    public PSWTPath(Shape aShape) {
        this();
        this.setShape(aShape);
    }

    public Paint getStrokePaint() {
        return this.strokePaint;
    }

    public void setStrokeColor(Paint aPaint) {
        Paint old = this.strokePaint;
        this.strokePaint = aPaint;
        this.invalidatePaint();
        this.firePropertyChange(PROPERTY_STROKE_PAINT, old, this.strokePaint);
    }

    public boolean setBounds(double x, double y, double width, double height) {
        Rectangle2D rect = this.shape.getBounds2D();
        return super.setBounds(rect.getX(), rect.getY(), rect.getWidth(), rect.getHeight());
    }

    public boolean intersects(Rectangle2D aBounds) {
        if (super.intersects(aBounds)) {
            if (this.getPaint() != null && this.shape.intersects(aBounds)) {
                return true;
            }
            if (this.strokePaint != null) {
                return BASIC_STROKE.createStrokedShape(this.shape).intersects(aBounds);
            }
        }
        return false;
    }

    public void updateBoundsFromPath() {
        if (this.shape == null) {
            this.resetBounds();
        } else {
            Rectangle2D b = this.shape.getBounds2D();
            super.setBounds(b.getX(), b.getY(), b.getWidth(), b.getHeight());
        }
    }

    protected void paint(PPaintContext paintContext) {
        Paint p = this.getPaint();
        SWTGraphics2D g2 = (SWTGraphics2D)paintContext.getGraphics();
        if (p != null) {
            g2.setBackground((Color)p);
            if (this.shape instanceof Rectangle2D) {
                g2.fillRect(this.shapePts[0], this.shapePts[1], this.shapePts[2], this.shapePts[3]);
            } else if (this.shape instanceof Ellipse2D) {
                g2.fillOval(this.shapePts[0], this.shapePts[1], this.shapePts[2], this.shapePts[3]);
            } else if (this.shape instanceof Arc2D) {
                g2.fillArc(this.shapePts[0], this.shapePts[1], this.shapePts[2], this.shapePts[3], this.shapePts[4], this.shapePts[5]);
            } else if (this.shape instanceof RoundRectangle2D) {
                g2.fillRoundRect(this.shapePts[0], this.shapePts[1], this.shapePts[2], this.shapePts[3], this.shapePts[4], this.shapePts[5]);
            } else {
                g2.fillPolygon(this.shapePts);
            }
        }
        if (this.strokePaint != null) {
            g2.setColor((Color)this.strokePaint);
            if (this.shape instanceof Rectangle2D) {
                g2.drawRect(this.shapePts[0], this.shapePts[1], this.shapePts[2], this.shapePts[3]);
            } else if (this.shape instanceof Ellipse2D) {
                g2.drawOval(this.shapePts[0], this.shapePts[1], this.shapePts[2], this.shapePts[3]);
            } else if (this.shape instanceof Arc2D) {
                g2.drawArc(this.shapePts[0], this.shapePts[1], this.shapePts[2], this.shapePts[3], this.shapePts[4], this.shapePts[5]);
            } else if (this.shape instanceof RoundRectangle2D) {
                g2.drawRoundRect(this.shapePts[0], this.shapePts[1], this.shapePts[2], this.shapePts[3], this.shapePts[4], this.shapePts[5]);
            } else {
                g2.drawPolyline(this.shapePts);
            }
        }
    }

    public void setShape(Shape aShape) {
        this.shape = aShape;
        if (this.shape instanceof Rectangle2D) {
            this.shapePts = new double[4];
            this.shapePts[0] = ((Rectangle2D)this.shape).getX();
            this.shapePts[1] = ((Rectangle2D)this.shape).getY();
            this.shapePts[2] = ((Rectangle2D)this.shape).getWidth();
            this.shapePts[3] = ((Rectangle2D)this.shape).getHeight();
        } else if (this.shape instanceof Ellipse2D) {
            this.shapePts = new double[4];
            this.shapePts[0] = ((Ellipse2D)this.shape).getX();
            this.shapePts[1] = ((Ellipse2D)this.shape).getY();
            this.shapePts[2] = ((Ellipse2D)this.shape).getWidth();
            this.shapePts[3] = ((Ellipse2D)this.shape).getHeight();
        } else if (this.shape instanceof Arc2D) {
            this.shapePts = new double[6];
            this.shapePts[0] = ((Arc2D)this.shape).getX();
            this.shapePts[1] = ((Arc2D)this.shape).getY();
            this.shapePts[2] = ((Arc2D)this.shape).getWidth();
            this.shapePts[3] = ((Arc2D)this.shape).getHeight();
            this.shapePts[4] = ((Arc2D)this.shape).getAngleStart();
            this.shapePts[5] = ((Arc2D)this.shape).getAngleExtent();
        } else if (this.shape instanceof RoundRectangle2D) {
            this.shapePts = new double[6];
            this.shapePts[0] = ((RoundRectangle2D)this.shape).getX();
            this.shapePts[1] = ((RoundRectangle2D)this.shape).getY();
            this.shapePts[2] = ((RoundRectangle2D)this.shape).getWidth();
            this.shapePts[3] = ((RoundRectangle2D)this.shape).getHeight();
            this.shapePts[4] = ((RoundRectangle2D)this.shape).getArcWidth();
            this.shapePts[5] = ((RoundRectangle2D)this.shape).getArcHeight();
        } else {
            this.shapePts = SWTShapeManager.shapeToPolyline(this.shape);
        }
        this.firePropertyChange(PROPERTY_SHAPE, null, this.shape);
        this.updateBoundsFromPath();
        this.invalidatePaint();
    }

    public void setPathToRectangle(float x, float y, float width, float height) {
        TEMP_RECTANGLE.setFrame(x, y, width, height);
        this.setShape(TEMP_RECTANGLE);
    }

    public void setPathToEllipse(float x, float y, float width, float height) {
        TEMP_ELLIPSE.setFrame(x, y, width, height);
        this.setShape(TEMP_ELLIPSE);
    }

    public void setPathToPolyline(Point2D[] points) {
        GeneralPath path = new GeneralPath();
        path.reset();
        path.moveTo((float)points[0].getX(), (float)points[0].getY());
        for (int i = 1; i < points.length; ++i) {
            path.lineTo((float)points[i].getX(), (float)points[i].getY());
        }
        this.setShape(path);
    }

    public void setPathToPolyline(float[] xp, float[] yp) {
        GeneralPath path = new GeneralPath();
        path.reset();
        path.moveTo(xp[0], yp[0]);
        for (int i = 1; i < xp.length; ++i) {
            path.lineTo(xp[i], yp[i]);
        }
        this.setShape(path);
    }

    protected String paramString() {
        StringBuffer result = new StringBuffer();
        result.append("path=" + (this.shape == null ? "null" : this.shape.toString()));
        result.append(",strokePaint=" + (this.strokePaint == null ? "null" : this.strokePaint.toString()));
        result.append(',');
        result.append(super.paramString());
        return result.toString();
    }
}

