/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.piccolox.swt;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import org.eclipse.swt.graphics.Rectangle;

public class SWTShapeManager {
    static AffineTransform IDENTITY_XFORM = new AffineTransform();
    static Point2D aPoint = new Point2D.Double();
    static ArrayList segList = new ArrayList();
    static double[] pts = new double[8];

    public static void transform(Rectangle2D rect, AffineTransform at) {
        SWTShapeManager.pts[0] = rect.getX();
        SWTShapeManager.pts[1] = rect.getY();
        SWTShapeManager.pts[2] = rect.getX() + rect.getWidth();
        SWTShapeManager.pts[3] = rect.getY();
        SWTShapeManager.pts[4] = rect.getX() + rect.getWidth();
        SWTShapeManager.pts[5] = rect.getY() + rect.getHeight();
        SWTShapeManager.pts[6] = rect.getX();
        SWTShapeManager.pts[7] = rect.getY() + rect.getHeight();
        at.transform(pts, 0, pts, 0, 4);
        double minX = pts[0];
        double minY = pts[1];
        double maxX = pts[0];
        double maxY = pts[1];
        for (int i = 1; i < 4; ++i) {
            if (pts[2 * i] < minX) {
                minX = pts[2 * i];
            }
            if (pts[2 * i + 1] < minY) {
                minY = pts[2 * i + 1];
            }
            if (pts[2 * i] > maxX) {
                maxX = pts[2 * i];
            }
            if (!(pts[2 * i + 1] > maxY)) continue;
            maxY = pts[2 * i + 1];
        }
        rect.setRect(minX, minY, maxX - minX, maxY - minY);
    }

    public static void awtToSWT(Rectangle2D aRect, Rectangle sRect) {
        sRect.x = (int)(aRect.getX() + 0.5);
        sRect.y = (int)(aRect.getY() + 0.5);
        sRect.width = (int)(aRect.getWidth() + 0.5);
        sRect.height = (int)(aRect.getHeight() + 0.5);
    }

    public static double[] shapeToPolyline(Shape s) {
        segList.clear();
        aPoint.setLocation(0.0, 0.0);
        PathIterator pi = s.getPathIterator(IDENTITY_XFORM, 1.0E-9);
        while (!pi.isDone()) {
            int segType = pi.currentSegment(pts);
            switch (segType) {
                case 0: {
                    aPoint.setLocation(pts[0], pts[1]);
                    segList.add(new Point2D.Double(pts[0], pts[1]));
                    break;
                }
                case 1: {
                    segList.add(new Point2D.Double(pts[0], pts[1]));
                    break;
                }
                case 4: {
                    segList.add(new Point2D.Double(aPoint.getX(), aPoint.getY()));
                }
            }
            pi.next();
        }
        double[] polyObj = new double[2 * segList.size()];
        for (int i = 0; i < segList.size(); ++i) {
            Point2D p2 = (Point2D)segList.get(i);
            polyObj[2 * i] = (int)(p2.getX() + 0.5);
            polyObj[2 * i + 1] = (int)(p2.getY() + 0.5);
        }
        return polyObj;
    }

    public static int[] transform(double[] pts, AffineTransform at) {
        int[] intPts = new int[pts.length];
        for (int i = 0; i < pts.length / 2; ++i) {
            aPoint.setLocation(pts[2 * i], pts[2 * i + 1]);
            at.transform(aPoint, aPoint);
            intPts[2 * i] = (int)(aPoint.getX() + 0.5);
            intPts[2 * i + 1] = (int)(aPoint.getY() + 0.5);
        }
        return intPts;
    }
}

