/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import java.awt.Color;
import java.awt.Image;
import java.awt.Toolkit;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.Action;
import org.netbeans.editor.AnnotationTypes;
import org.netbeans.editor.Coloring;
import org.netbeans.editor.ImplementationProvider;
import org.netbeans.editor.Settings;

public class AnnotationType {
    public static final String PROP_NAME = "name";
    public static final String PROP_DESCRIPTION = "description";
    public static final String PROP_VISIBLE = "visible";
    public static final String PROP_GLYPH_URL = "glyph";
    public static final String PROP_HIGHLIGHT_COLOR = "highlight";
    public static final String PROP_FOREGROUND_COLOR = "foreground";
    public static final String PROP_WHOLE_LINE = "wholeline";
    public static final String PROP_CONTENT_TYPE = "contenttype";
    public static final String PROP_ACTIONS = "actions";
    public static final String PROP_TOOLTIP_TEXT = "tooltipText";
    public static final String PROP_INHERIT_FOREGROUND_COLOR = "inheritForegroundColor";
    public static final String PROP_USE_HIGHLIGHT_COLOR = "useHighlightColor";
    public static final String PROP_COMBINATIONS = "combinations";
    public static final String PROP_COMBINATION_ORDER = "combinationOrder";
    public static final String PROP_COMBINATION_MINIMUM_OPTIONALS = "combinationMinimumOptionals";
    public static final String PROP_FILE = "file";
    public static final String PROP_LOCALIZING_BUNDLE = "bundle";
    public static final String PROP_DESCRIPTION_KEY = "desciptionKey";
    public static final String PROP_ACTIONS_FOLDER = "actionsFolder";
    public static final String PROP_COMBINATION_TOOLTIP_TEXT_KEY = "tooltipTextKey";
    private Map properties = new HashMap(20);
    private PropertyChangeSupport support = new PropertyChangeSupport(this);
    private Image img = null;
    private Coloring col;

    public URL getGlyph() {
        URL uRL = (URL)this.getProp(PROP_GLYPH_URL);
        if (uRL == null) {
            uRL = AnnotationTypes.getDefaultGlyphURL();
        }
        return uRL;
    }

    public void setGlyph(URL uRL) {
        this.putProp(PROP_GLYPH_URL, uRL);
    }

    public Image getGlyphImage() {
        if (this.img == null) {
            this.img = Toolkit.getDefaultToolkit().getImage(this.getGlyph());
        }
        return this.img;
    }

    public boolean isDefaultGlyph() {
        return this.getProp(PROP_GLYPH_URL) == null;
    }

    public Color getHighlight() {
        return (Color)this.getProp(PROP_HIGHLIGHT_COLOR);
    }

    public void setHighlight(Color color) {
        this.col = null;
        this.putProp(PROP_HIGHLIGHT_COLOR, color);
        this.firePropertyChange(PROP_HIGHLIGHT_COLOR, null, null);
        this.processChange();
    }

    public boolean isUseHighlightColor() {
        Boolean bl = (Boolean)this.getProp(PROP_USE_HIGHLIGHT_COLOR);
        if (bl == null) {
            return true;
        }
        return bl;
    }

    public void setUseHighlightColor(boolean bl) {
        if (this.isUseHighlightColor() != bl) {
            this.col = null;
            this.putProp(PROP_USE_HIGHLIGHT_COLOR, new Boolean(bl));
            this.firePropertyChange(PROP_USE_HIGHLIGHT_COLOR, null, null);
            this.processChange();
        }
    }

    public Color getForegroundColor() {
        return (Color)this.getProp(PROP_FOREGROUND_COLOR);
    }

    public void setForegroundColor(Color color) {
        this.col = null;
        this.putProp(PROP_FOREGROUND_COLOR, color);
        this.firePropertyChange(PROP_FOREGROUND_COLOR, null, null);
        this.processChange();
    }

    public boolean isInheritForegroundColor() {
        Boolean bl = (Boolean)this.getProp(PROP_INHERIT_FOREGROUND_COLOR);
        if (bl == null) {
            return true;
        }
        return bl;
    }

    public void setInheritForegroundColor(boolean bl) {
        if (this.isInheritForegroundColor() != bl) {
            this.col = null;
            this.putProp(PROP_INHERIT_FOREGROUND_COLOR, new Boolean(bl));
            this.firePropertyChange(PROP_INHERIT_FOREGROUND_COLOR, null, null);
            this.processChange();
        }
    }

    private void processChange() {
        if (this.getProp(PROP_FILE) == null) {
            return;
        }
        Settings.touchValue(null, null);
        AnnotationTypes.getTypes().saveType(this);
    }

    public Coloring getColoring() {
        if (this.col == null) {
            this.col = new Coloring(null, this.isInheritForegroundColor() ? null : this.getForegroundColor(), this.isUseHighlightColor() ? this.getHighlight() : null);
        }
        return this.col;
    }

    public Action[] getActions() {
        return (Action[])this.getProp(PROP_ACTIONS);
    }

    public void setActions(Action[] actionArray) {
        this.putProp(PROP_ACTIONS, actionArray);
    }

    public CombinationMember[] getCombinations() {
        return (CombinationMember[])this.getProp(PROP_COMBINATIONS);
    }

    public void setCombinations(CombinationMember[] combinationMemberArray) {
        this.putProp(PROP_COMBINATIONS, combinationMemberArray);
    }

    public String getName() {
        return (String)this.getProp(PROP_NAME);
    }

    public void setName(String string) {
        this.putProp(PROP_NAME, string);
    }

    public String getDescription() {
        String string = (String)this.getProp(PROP_DESCRIPTION);
        if (string == null) {
            String string2 = (String)this.getProp(PROP_LOCALIZING_BUNDLE);
            String string3 = (String)this.getProp(PROP_DESCRIPTION_KEY);
            ResourceBundle resourceBundle = ImplementationProvider.getDefault().getResourceBundle(string2);
            string = resourceBundle.getString(string3);
            this.setDescription(string);
        }
        return string;
    }

    public void setDescription(String string) {
        this.putProp(PROP_DESCRIPTION, string);
    }

    public String getTooltipText() {
        String string = (String)this.getProp(PROP_TOOLTIP_TEXT);
        if (string == null) {
            String string2 = (String)this.getProp(PROP_LOCALIZING_BUNDLE);
            String string3 = (String)this.getProp(PROP_COMBINATION_TOOLTIP_TEXT_KEY);
            ResourceBundle resourceBundle = ImplementationProvider.getDefault().getResourceBundle(string2);
            string = resourceBundle.getString(string3);
            this.setTooltipText(string);
        }
        return string;
    }

    public void setTooltipText(String string) {
        this.putProp(PROP_TOOLTIP_TEXT, string);
    }

    public int getCombinationOrder() {
        if (this.getProp(PROP_COMBINATION_ORDER) == null) {
            return 0;
        }
        return (Integer)this.getProp(PROP_COMBINATION_ORDER);
    }

    public void setCombinationOrder(int n) {
        this.putProp(PROP_COMBINATION_ORDER, new Integer(n));
    }

    public void setCombinationOrder(String string) {
        int n;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            if (Boolean.getBoolean("netbeans.debug.exceptions")) {
                numberFormatException.printStackTrace();
            }
            return;
        }
        this.putProp(PROP_COMBINATION_ORDER, new Integer(n));
    }

    public int getMinimumOptionals() {
        if (this.getProp(PROP_COMBINATION_MINIMUM_OPTIONALS) == null) {
            return 0;
        }
        return (Integer)this.getProp(PROP_COMBINATION_MINIMUM_OPTIONALS);
    }

    public void setMinimumOptionals(int n) {
        this.putProp(PROP_COMBINATION_MINIMUM_OPTIONALS, new Integer(n));
    }

    public void setMinimumOptionals(String string) {
        int n;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            if (Boolean.getBoolean("netbeans.debug.exceptions")) {
                numberFormatException.printStackTrace();
            }
            return;
        }
        this.putProp(PROP_COMBINATION_MINIMUM_OPTIONALS, new Integer(n));
    }

    public boolean isVisible() {
        Boolean bl = (Boolean)this.getProp(PROP_VISIBLE);
        if (bl == null) {
            return false;
        }
        return bl;
    }

    public void setVisible(boolean bl) {
        this.putProp(PROP_VISIBLE, new Boolean(bl));
    }

    public void setVisible(String string) {
        this.putProp(PROP_VISIBLE, new Boolean(string));
    }

    public boolean isWholeLine() {
        Boolean bl = (Boolean)this.getProp(PROP_WHOLE_LINE);
        if (bl == null) {
            return true;
        }
        return bl;
    }

    public void setWholeLine(boolean bl) {
        this.putProp(PROP_WHOLE_LINE, new Boolean(bl));
    }

    public void setWholeLine(String string) {
        this.putProp(PROP_WHOLE_LINE, new Boolean(string));
    }

    public String getContentType() {
        return (String)this.getProp(PROP_CONTENT_TYPE);
    }

    public void setContentType(String string) {
        this.putProp(PROP_CONTENT_TYPE, string);
    }

    public Object getProp(String string) {
        return this.properties.get(string);
    }

    public void putProp(Object object, Object object2) {
        if (object2 == null) {
            this.properties.remove(object);
            return;
        }
        this.properties.put(object, object2);
    }

    public String toString() {
        return "AnnotationType: name='" + this.getName() + "', description='" + this.getDescription() + "', visible=" + this.isVisible() + ", wholeline=" + this.isWholeLine() + ", glyph=" + this.getGlyph() + ", highlight=" + this.getHighlight() + ", foreground=" + this.getForegroundColor() + "', inheritForeground=" + this.isInheritForegroundColor() + ", contenttype=" + this.getContentType();
    }

    public final void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    public final void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }

    protected final void firePropertyChange(String string, Object object, Object object2) {
        this.support.firePropertyChange(string, object, object2);
    }

    public static final class CombinationMember {
        private String type;
        private boolean absorbAll;
        private boolean optional;
        private int minimumCount;

        public CombinationMember(String string, boolean bl, boolean bl2, int n) {
            this.type = string;
            this.absorbAll = bl;
            this.optional = bl2;
            this.minimumCount = n;
        }

        public CombinationMember(String string, boolean bl, boolean bl2, String string2) {
            this.type = string;
            this.absorbAll = bl;
            this.optional = bl2;
            if (string2 != null && string2.length() > 0) {
                try {
                    this.minimumCount = Integer.parseInt(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    if (Boolean.getBoolean("netbeans.debug.exceptions")) {
                        numberFormatException.printStackTrace();
                    }
                    this.minimumCount = 0;
                }
            } else {
                this.minimumCount = 0;
            }
        }

        public String getName() {
            return this.type;
        }

        public boolean isAbsorbAll() {
            return this.absorbAll;
        }

        public boolean isOptional() {
            return this.optional;
        }

        public int getMinimumCount() {
            return this.minimumCount;
        }
    }
}

