/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import java.util.ArrayList;
import java.util.Arrays;
import org.netbeans.editor.DrawLayer;
import org.netbeans.editor.EditorDebug;

class DrawLayerList {
    private static final DrawLayer[] EMPTY = new DrawLayer[0];
    private DrawLayer[] layers = EMPTY;
    private final ArrayList visibilityList = new ArrayList();

    DrawLayerList() {
    }

    synchronized boolean add(DrawLayer drawLayer, int n) {
        if (this.indexOf(drawLayer.getName()) >= 0) {
            return false;
        }
        int n2 = this.layers.length;
        int n3 = 0;
        while (n3 < this.layers.length) {
            if ((Integer)this.visibilityList.get(n3) > n) {
                n2 = n3;
                break;
            }
            ++n3;
        }
        ArrayList<DrawLayer> arrayList = new ArrayList<DrawLayer>(Arrays.asList(this.layers));
        arrayList.add(n2, drawLayer);
        this.layers = new DrawLayer[this.layers.length + 1];
        arrayList.toArray(this.layers);
        this.visibilityList.add(n2, new Integer(n));
        return true;
    }

    synchronized void add(DrawLayerList drawLayerList) {
        DrawLayer[] drawLayerArray = drawLayerList.layers;
        int n = 0;
        while (n < drawLayerArray.length) {
            this.add(drawLayerArray[n], (Integer)drawLayerList.visibilityList.get(n));
            ++n;
        }
    }

    synchronized DrawLayer remove(String string) {
        int n = this.indexOf(string);
        DrawLayer drawLayer = null;
        if (n >= 0) {
            drawLayer = this.layers[n];
            ArrayList<DrawLayer> arrayList = new ArrayList<DrawLayer>(Arrays.asList(this.layers));
            arrayList.remove(n);
            this.layers = new DrawLayer[this.layers.length - 1];
            arrayList.toArray(this.layers);
            this.visibilityList.remove(n);
        }
        return drawLayer;
    }

    synchronized void remove(DrawLayerList drawLayerList) {
        DrawLayer[] drawLayerArray = drawLayerList.layers;
        int n = 0;
        while (n < drawLayerArray.length) {
            this.remove(drawLayerArray[n].getName());
            ++n;
        }
    }

    synchronized DrawLayer findLayer(String string) {
        int n = this.indexOf(string);
        return n >= 0 ? this.layers[n] : null;
    }

    synchronized DrawLayer[] currentLayers() {
        return (DrawLayer[])this.layers.clone();
    }

    private int indexOf(String string) {
        int n = 0;
        while (n < this.layers.length) {
            if (string.equals(this.layers[n].getName())) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public String toString() {
        switch (this.layers.length) {
            case 0: {
                return "No layers";
            }
            case 1: {
                return "Standalone " + this.layers[0];
            }
        }
        return "Layers:\n" + EditorDebug.debugArray(this.layers);
    }
}

