/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import java.util.Iterator;
import java.util.List;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.Segment;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseTextUI;
import org.netbeans.editor.BaseView;
import org.netbeans.editor.EditorUI;
import org.netbeans.editor.LeafView;
import org.netbeans.editor.Registry;
import org.netbeans.editor.SettingsDefaults;
import org.netbeans.editor.SettingsUtil;
import org.netbeans.editor.Utilities;

public class EditorDebug {
    static /* synthetic */ Class class$org$netbeans$editor$MarkFactory$LineMark;
    static /* synthetic */ Class class$org$netbeans$editor$MarkFactory$CaretMark;
    static /* synthetic */ Class class$org$netbeans$editor$MarkFactory$DrawMark;
    static /* synthetic */ Class class$org$netbeans$editor$MarkFactory$SyntaxMark;
    static /* synthetic */ Class class$org$netbeans$editor$Mark;

    private EditorDebug() {
    }

    public static void dumpPlanes(BaseDocument baseDocument) {
        Class[] classArray = new Class[]{class$org$netbeans$editor$MarkFactory$LineMark == null ? (class$org$netbeans$editor$MarkFactory$LineMark = EditorDebug.class$("org.netbeans.editor.MarkFactory$LineMark")) : class$org$netbeans$editor$MarkFactory$LineMark, class$org$netbeans$editor$MarkFactory$CaretMark == null ? (class$org$netbeans$editor$MarkFactory$CaretMark = EditorDebug.class$("org.netbeans.editor.MarkFactory$CaretMark")) : class$org$netbeans$editor$MarkFactory$CaretMark, class$org$netbeans$editor$MarkFactory$DrawMark == null ? (class$org$netbeans$editor$MarkFactory$DrawMark = EditorDebug.class$("org.netbeans.editor.MarkFactory$DrawMark")) : class$org$netbeans$editor$MarkFactory$DrawMark, class$org$netbeans$editor$MarkFactory$SyntaxMark == null ? (class$org$netbeans$editor$MarkFactory$SyntaxMark = EditorDebug.class$("org.netbeans.editor.MarkFactory$SyntaxMark")) : class$org$netbeans$editor$MarkFactory$SyntaxMark, class$org$netbeans$editor$Mark == null ? (class$org$netbeans$editor$Mark = EditorDebug.class$("org.netbeans.editor.Mark")) : class$org$netbeans$editor$Mark};
        char[] cArray = new char[]{'L', 'C', 'D', 'S', 'B'};
        System.out.println("--------------------------- DUMP OF MARK PLANES --------------------------------");
        System.out.println("Mark legend:\nD - DrawMark\nS - SyntaxMark\nB - BaseMark\nL - LineMark\nC - CaretMark");
        System.out.println(baseDocument.op.markPlanesToString(classArray, cArray));
        System.out.println("--------------------------------------------------------------------------------\n");
    }

    public static void dumpSyntaxMarks(BaseDocument baseDocument) {
        System.out.println("--------------------------- DUMP OF SYNTAX MARKS --------------------------------");
        int n = baseDocument.getLength();
        System.out.println("--------------------------------------------------------------------------------\n");
    }

    public static void test(JTextComponent jTextComponent) {
        BaseTextUI baseTextUI = (BaseTextUI)jTextComponent.getUI();
        BaseView baseView = (BaseView)baseTextUI.getRootView(jTextComponent);
        baseView = (BaseView)baseView.getView(0);
        BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
        EditorUI editorUI = baseTextUI.getEditorUI();
        int n = baseDocument.getLength();
        System.out.println("\n------------------------- Registry --------------------------------");
        System.out.println(Registry.registryToString());
        System.out.println("\n------------------------- DEBUGGING INFORMATION --------------------------------");
        String string = "Document: " + baseDocument + "\nview.mainHeight=" + ((LeafView)baseView).mainHeight + "\nDoubleBuffering=" + jTextComponent.isDoubleBuffered();
        string = string + "\ncomponent.getLocation()=" + jTextComponent.getLocation() + "\ncomponent.getSize()=" + jTextComponent.getSize() + "\nvirtualSize=" + editorUI.virtualSize;
        string = string + "\nEditorUI LAYERS:\n" + editorUI.getDrawLayerList();
        System.out.println(string);
        System.out.println(baseDocument.op.infoToString());
        string = "\n------------------------ CR occurence test ------------------------\n";
        try {
            char[] cArray = baseDocument.getChars(0, n);
            int n2 = 0;
            while (n2 < n) {
                if (cArray[n2] == '\r') {
                    string = string + "CR found at pos=" + n2 + ", line=" + baseDocument.op.getLine(n2) + "\n";
                    break;
                }
                ++n2;
            }
            if (n2 == n) {
                string = string + "No CR found. CR occurence test suceeded.";
            }
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
        System.out.println(string);
    }

    public static void checkSettings(Class clazz) throws Error {
        int n = SettingsUtil.getInteger(clazz, "read-buffer-size", SettingsDefaults.defaultReadBufferSize);
        int n2 = SettingsUtil.getInteger(clazz, "write-buffer-size", SettingsDefaults.defaultWriteBufferSize);
        int n3 = SettingsUtil.getInteger(clazz, "read-mark-distance", SettingsDefaults.defaultReadMarkDistance);
        int n4 = SettingsUtil.getInteger(clazz, "mark-distance", SettingsDefaults.defaultMarkDistance);
        int n5 = SettingsUtil.getInteger(clazz, "max-mark-distance", SettingsDefaults.defaultMaxMarkDistance);
        int n6 = SettingsUtil.getInteger(clazz, "min-mark-distance", SettingsDefaults.defaultMinMarkDistance);
        int n7 = SettingsUtil.getInteger(clazz, "syntax-update-batch-size", SettingsDefaults.defaultSyntaxUpdateBatchSize);
        if (n5 < n4) {
            throw new Error("maxMarkDistance=" + n5 + " < markDistance=" + n4);
        }
        if (n4 < n6) {
            throw new Error("markDistance=" + n4 + " < minMarkDistance=" + n6);
        }
        if (n3 < n6) {
            throw new Error("readMarkDistance=" + n3 + " < minMarkDistance=" + n6);
        }
        if (n7 < n5) {
            throw new Error("syntaxUpdateBatchSize=" + n7 + " < maxMarkDistance=" + n5);
        }
    }

    public static String debugString(String string) {
        return string != null ? EditorDebug.debugChars(string.toCharArray(), 0, string.length()) : "NULL STRING";
    }

    public static String debugChars(Segment segment) {
        return EditorDebug.debugChars(segment.array, segment.offset, segment.count);
    }

    public static String debugChars(char[] cArray) {
        return EditorDebug.debugChars(cArray, 0, cArray.length);
    }

    public static String debugChars(char[] cArray, int n, int n2) {
        if (n2 < 0) {
            return "EditorDebug.debugChars() !ERROR! len=" + n2 + " < 0";
        }
        if (n < 0) {
            return "EditorDebug.debugChars() !ERROR! offset=" + n + " < 0";
        }
        if (n + n2 > cArray.length) {
            return "EditorDebug.debugChars() !ERROR! offset=" + n + " + len=" + n2 + " > chars.length=" + cArray.length;
        }
        StringBuffer stringBuffer = new StringBuffer(n2);
        int n3 = n + n2;
        while (n < n3) {
            switch (cArray[n]) {
                case '\n': {
                    stringBuffer.append("\\n");
                    break;
                }
                case '\t': {
                    stringBuffer.append("\\t");
                    break;
                }
                case '\r': {
                    stringBuffer.append("\\r");
                    break;
                }
                default: {
                    stringBuffer.append(cArray[n]);
                }
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public static String debugChar(char c) {
        switch (c) {
            case '\n': {
                return "\\n";
            }
            case '\t': {
                return "\\t";
            }
            case '\r': {
                return "\\r";
            }
        }
        return String.valueOf(c);
    }

    public static String debugPairs(int[] nArray) {
        String string;
        if (nArray == null) {
            string = "Null pairs";
        } else if (nArray.length == 0) {
            string = "No pairs";
        } else {
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            while (n < nArray.length) {
                stringBuffer.append('[');
                stringBuffer.append(nArray[n]);
                stringBuffer.append(", ");
                stringBuffer.append(nArray[n + 1]);
                if (n < nArray.length - 1) {
                    stringBuffer.append("]\n");
                }
                n += 2;
            }
            string = stringBuffer.toString();
        }
        return string;
    }

    public static String debugArray(Object[] objectArray) {
        String string;
        if (objectArray == null) {
            string = "Null array";
        } else if (objectArray.length == 0) {
            string = "Empty array";
        } else {
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            while (n < objectArray.length) {
                stringBuffer.append('[');
                stringBuffer.append(n);
                stringBuffer.append("]=");
                stringBuffer.append(objectArray[n]);
                if (n != objectArray.length - 1) {
                    stringBuffer.append('\n');
                }
                ++n;
            }
            string = stringBuffer.toString();
        }
        return string;
    }

    public static String debugArray(int[] nArray) {
        String string;
        if (nArray == null) {
            string = "Null array";
        } else if (nArray.length == 0) {
            string = "Empty array";
        } else {
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            while (n < nArray.length) {
                stringBuffer.append('[');
                stringBuffer.append(n);
                stringBuffer.append("]=");
                stringBuffer.append(nArray[n]);
                if (n != nArray.length - 1) {
                    stringBuffer.append('\n');
                }
                ++n;
            }
            string = stringBuffer.toString();
        }
        return string;
    }

    public static String debugBlocks(BaseDocument baseDocument, int[] nArray) {
        String string;
        if (nArray == null) {
            string = "Null blocks";
        } else if (nArray.length == 0) {
            string = "Empty blocks";
        } else if (nArray.length % 2 != 0) {
            string = "Blocks.length=" + nArray.length + " is not even!";
        } else {
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            while (n < nArray.length) {
                stringBuffer.append('[');
                stringBuffer.append(n);
                stringBuffer.append("]=(");
                stringBuffer.append(nArray[n]);
                stringBuffer.append(", ");
                stringBuffer.append(nArray[n + 1]);
                stringBuffer.append(") or (");
                stringBuffer.append(Utilities.debugPosition(baseDocument, nArray[n]));
                stringBuffer.append(", ");
                stringBuffer.append(Utilities.debugPosition(baseDocument, nArray[n + 1]));
                stringBuffer.append(')');
                if (n != nArray.length - 1) {
                    stringBuffer.append('\n');
                }
                n += 2;
            }
            string = stringBuffer.toString();
        }
        return string;
    }

    public static String debugList(List list) {
        String string;
        if (list == null) {
            string = "Null list";
        } else if (list.size() == 0) {
            string = "Empty list";
        } else {
            int n = list.size();
            StringBuffer stringBuffer = new StringBuffer();
            int n2 = 0;
            while (n2 < n) {
                stringBuffer.append('[');
                stringBuffer.append(n2);
                stringBuffer.append("]=");
                stringBuffer.append(list.get(n2));
                if (n2 != n - 1) {
                    stringBuffer.append('\n');
                }
                ++n2;
            }
            string = stringBuffer.toString();
        }
        return string;
    }

    public static String debugIterator(Iterator iterator) {
        String string;
        if (iterator == null) {
            string = "Null iterator";
        } else if (!iterator.hasNext()) {
            string = "Empty iterator";
        } else {
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            while (iterator.hasNext()) {
                stringBuffer.append('[');
                stringBuffer.append(n++);
                stringBuffer.append("]=");
                stringBuffer.append(iterator.next().toString());
                if (!iterator.hasNext()) continue;
                stringBuffer.append('\n');
            }
            string = stringBuffer.toString();
        }
        return string;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

