/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import java.awt.Rectangle;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.BaseCaret;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseTextUI;
import org.netbeans.editor.DrawLayerFactory;
import org.netbeans.editor.EditorUI;
import org.netbeans.editor.Finder;
import org.netbeans.editor.FinderFactory;
import org.netbeans.editor.GuardedException;
import org.netbeans.editor.InvalidMarkException;
import org.netbeans.editor.JumpList;
import org.netbeans.editor.LocaleSupport;
import org.netbeans.editor.Mark;
import org.netbeans.editor.Settings;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.WeakPropertyChangeSupport;

public class FindSupport {
    private static final String FOUND_LOCALE = "find-found";
    private static final String NOT_FOUND_LOCALE = "find-not-found";
    private static final String WRAP_START_LOCALE = "find-wrap-start";
    private static final String WRAP_END_LOCALE = "find-wrap-end";
    private static final String ITEMS_REPLACED_LOCALE = "find-items-replaced";
    static FindSupport findSupport;
    private Map findProps;
    WeakPropertyChangeSupport changeSupport = new WeakPropertyChangeSupport();
    FinderCreator finderCreator;
    private boolean findPropsInited;
    static /* synthetic */ Class class$org$netbeans$editor$BaseKit;

    private FindSupport() {
    }

    public static FindSupport getFindSupport() {
        if (findSupport == null) {
            findSupport = new FindSupport();
        }
        return findSupport;
    }

    public FinderCreator getFinderCreator() {
        if (this.finderCreator == null) {
            this.finderCreator = new DefaultFinderCreator();
        }
        return this.finderCreator;
    }

    public void setFinderCreator(FinderCreator finderCreator) {
        this.finderCreator = finderCreator;
        this.firePropertyChange(null, null, null);
    }

    public Map getDefaultFindProperties() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        Class clazz = class$org$netbeans$editor$BaseKit == null ? (class$org$netbeans$editor$BaseKit = FindSupport.class$("org.netbeans.editor.BaseKit")) : class$org$netbeans$editor$BaseKit;
        hashMap.put("find-what", Settings.getValue(clazz, "find-what"));
        hashMap.put("find-replace-with", Settings.getValue(clazz, "find-replace-with"));
        hashMap.put("find-highlight-search", Settings.getValue(clazz, "find-highlight-search"));
        hashMap.put("find-inc-search", Settings.getValue(clazz, "find-inc-search"));
        hashMap.put("find-backward-search", Settings.getValue(clazz, "find-backward-search"));
        hashMap.put("find-wrap-search", Settings.getValue(clazz, "find-wrap-search"));
        hashMap.put("find-match-case", Settings.getValue(clazz, "find-match-case"));
        hashMap.put("find-whole-words", Settings.getValue(clazz, "find-whole-words"));
        hashMap.put("find-reg-exp", Settings.getValue(clazz, "find-reg-exp"));
        hashMap.put("find-history", Settings.getValue(clazz, "find-history"));
        return hashMap;
    }

    public Map getFindProperties() {
        if (this.findProps == null) {
            this.findProps = this.getDefaultFindProperties();
        }
        return this.findProps;
    }

    public Object getFindProperty(String string) {
        return this.getFindProperties().get(string);
    }

    private Map getValidFindProperties(Map map) {
        return map != null ? map : this.getFindProperties();
    }

    public FinderFactory.StringFinder getStringFinder(BaseDocument baseDocument, Map map) {
        FinderFactory.StringFinder stringFinder = (FinderFactory.StringFinder)baseDocument.getProperty("string-finder");
        if (stringFinder == null) {
            stringFinder = this.getFinderCreator().createFinder(baseDocument, this.getValidFindProperties(map));
            baseDocument.putProperty("string-finder", stringFinder);
        }
        return stringFinder;
    }

    public FinderFactory.StringFinder getStringBwdFinder(BaseDocument baseDocument, Map map) {
        FinderFactory.StringFinder stringFinder = (FinderFactory.StringFinder)baseDocument.getProperty("string-bwd-finder");
        if (stringFinder == null) {
            stringFinder = this.getFinderCreator().createBwdFinder(baseDocument, this.getValidFindProperties(map));
            baseDocument.putProperty("string-bwd-finder", stringFinder);
        }
        return stringFinder;
    }

    public FinderFactory.BlocksFinder getBlocksFinder(BaseDocument baseDocument, Map map) {
        FinderFactory.BlocksFinder blocksFinder = (FinderFactory.BlocksFinder)baseDocument.getProperty("blocks-finder");
        if (blocksFinder == null) {
            blocksFinder = this.getFinderCreator().createBlocksFinder(baseDocument, this.getValidFindProperties(map));
        }
        return blocksFinder;
    }

    int[] getBlocks(int[] nArray, BaseDocument baseDocument, int n, int n2) throws BadLocationException {
        FinderFactory.BlocksFinder blocksFinder = this.getBlocksFinder(baseDocument, null);
        if (blocksFinder == null) {
            return nArray;
        }
        FinderFactory.BlocksFinder blocksFinder2 = blocksFinder;
        synchronized (blocksFinder2) {
            blocksFinder.setBlocks(nArray);
            baseDocument.find(blocksFinder, n, n2);
            int[] nArray2 = blocksFinder.getBlocks();
            return nArray2;
        }
    }

    Object getPropertyNoInit(String string) {
        if (this.findProps == null) {
            return null;
        }
        return this.getFindProperty(string);
    }

    public void putFindProperty(String string, Object object) {
        Object object2 = this.getFindProperty(string);
        if (object2 == null && object == null || object2 != null && object2.equals(object)) {
            return;
        }
        if (object != null) {
            this.getFindProperties().put(string, object);
        } else {
            this.getFindProperties().remove(string);
        }
        this.firePropertyChange(string, object2, object);
    }

    public void putFindProperties(Map map) {
        if (!this.getFindProperties().equals(map)) {
            this.getFindProperties().putAll(map);
            this.firePropertyChange(null, null, null);
        }
    }

    public boolean incSearch(Map map) {
        Boolean bl = (Boolean)(map = this.getValidFindProperties(map)).get("find-inc-search");
        if (bl != null && bl.booleanValue()) {
            JTextComponent jTextComponent = Utilities.getLastActiveComponent();
            if (jTextComponent != null) {
                DrawLayerFactory.IncSearchLayer incSearchLayer;
                EditorUI editorUI;
                BaseTextUI baseTextUI;
                int n;
                block16: {
                    Caret caret = jTextComponent.getCaret();
                    BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
                    int n2 = caret.getDot();
                    FinderFactory.StringFinder stringFinder = this.getFinderCreator().createFinder(baseDocument, map);
                    try {
                        boolean bl2;
                        bl = (Boolean)map.get("find-backward-search");
                        boolean bl3 = bl2 = bl != null && bl != false;
                        n = bl2 ? baseDocument.find(stringFinder, n2, 0) : baseDocument.find(stringFinder, n2, -1);
                    }
                    catch (BadLocationException badLocationException) {
                        if (Boolean.getBoolean("netbeans.debug.exceptions")) {
                            badLocationException.printStackTrace();
                        }
                        return false;
                    }
                    baseTextUI = (BaseTextUI)jTextComponent.getUI();
                    editorUI = baseTextUI.getEditorUI();
                    incSearchLayer = (DrawLayerFactory.IncSearchLayer)editorUI.findLayer("inc-search-layer");
                    if (incSearchLayer == null) {
                        incSearchLayer = new DrawLayerFactory.IncSearchLayer();
                        if (!editorUI.addLayer(incSearchLayer, 9500)) {
                            return false;
                        }
                    } else if (incSearchLayer.isEnabled()) {
                        incSearchLayer.setEnabled(false);
                        try {
                            editorUI.repaintOffset(incSearchLayer.getOffset());
                        }
                        catch (BadLocationException badLocationException) {
                            if (!Boolean.getBoolean("netbeans.debug.exceptions")) break block16;
                            badLocationException.printStackTrace();
                        }
                    }
                }
                if (n >= 0) {
                    int n3;
                    String string = (String)map.get("find-what");
                    int n4 = n3 = string != null ? string.length() : 0;
                    if (n3 > 0) {
                        block17: {
                            incSearchLayer.setEnabled(true);
                            incSearchLayer.setArea(n, n3);
                            try {
                                Rectangle rectangle = baseTextUI.modelToView(jTextComponent, n, null);
                                Rectangle rectangle2 = baseTextUI.modelToView(jTextComponent, n + n3, null);
                                rectangle2.add(rectangle);
                                editorUI.repaintOffset(n);
                                editorUI.scrollRectToVisible(rectangle2, 0);
                            }
                            catch (BadLocationException badLocationException) {
                                if (!Boolean.getBoolean("netbeans.debug.exceptions")) break block17;
                                badLocationException.printStackTrace();
                                return false;
                            }
                        }
                        return true;
                    }
                }
            }
        } else {
            this.incSearchReset();
        }
        return false;
    }

    public void incSearchReset() {
        block3: {
            JTextComponent jTextComponent = Utilities.getLastActiveComponent();
            EditorUI editorUI = ((BaseTextUI)jTextComponent.getUI()).getEditorUI();
            DrawLayerFactory.IncSearchLayer incSearchLayer = (DrawLayerFactory.IncSearchLayer)editorUI.findLayer("inc-search-layer");
            if (incSearchLayer != null && incSearchLayer.isEnabled()) {
                incSearchLayer.setEnabled(false);
                try {
                    editorUI.repaintOffset(incSearchLayer.getOffset());
                }
                catch (BadLocationException badLocationException) {
                    if (!Boolean.getBoolean("netbeans.debug.exceptions")) break block3;
                    badLocationException.printStackTrace();
                }
            }
        }
    }

    private boolean isBackSearch(Map map, boolean bl) {
        boolean bl2;
        Boolean bl3 = (Boolean)map.get("find-backward-search");
        boolean bl4 = bl2 = bl3 != null && bl3 != false;
        if (bl) {
            bl2 = !bl2;
        }
        return bl2;
    }

    public boolean find(Map map, boolean bl) {
        block13: {
            this.incSearchReset();
            map = this.getValidFindProperties(map);
            boolean bl2 = this.isBackSearch(map, bl);
            JTextComponent jTextComponent = Utilities.getLastActiveComponent();
            Object v = map.get("find-what");
            if (v == null) {
                return true;
            }
            String string = "'" + v + "' ";
            if (jTextComponent != null) {
                Utilities.clearStatusText(jTextComponent);
                Caret caret = jTextComponent.getCaret();
                int n = caret.getDot();
                try {
                    int[] nArray = this.findInBlock(jTextComponent, n, 0, -1, map, bl);
                    if (nArray != null) {
                        Object object;
                        if (caret instanceof BaseCaret) {
                            object = (BaseCaret)caret;
                            if (bl2) {
                                ((BaseCaret)object).setDot(nArray[1], (Rectangle)object, 3);
                                ((BaseCaret)object).moveDot(nArray[0], (Rectangle)object, 3);
                            } else {
                                ((BaseCaret)object).setDot(nArray[0], (Rectangle)object, 3);
                                ((BaseCaret)object).moveDot(nArray[1], (Rectangle)object, 3);
                            }
                        } else if (bl2) {
                            caret.setDot(nArray[1]);
                            caret.moveDot(nArray[0]);
                        } else {
                            caret.setDot(nArray[0]);
                            caret.moveDot(nArray[1]);
                        }
                        JumpList.checkAddEntry();
                        object = string + LocaleSupport.getString(FOUND_LOCALE) + ' ' + Utilities.debugPosition((BaseDocument)jTextComponent.getDocument(), nArray[0]);
                        if (nArray[2] == 1) {
                            object = (String)object + "; ";
                            object = (String)object + (bl2 ? LocaleSupport.getString(WRAP_END_LOCALE) : LocaleSupport.getString(WRAP_START_LOCALE));
                            Utilities.setStatusBoldText(jTextComponent, (String)object);
                        } else {
                            Utilities.setStatusText(jTextComponent, (String)object);
                        }
                        return true;
                    }
                    Utilities.setStatusBoldText(jTextComponent, string + LocaleSupport.getString(NOT_FOUND_LOCALE));
                    jTextComponent.getCaret().setDot(jTextComponent.getCaret().getDot());
                }
                catch (BadLocationException badLocationException) {
                    if (!Boolean.getBoolean("netbeans.debug.exceptions")) break block13;
                    badLocationException.printStackTrace();
                }
            }
        }
        return false;
    }

    public int[] findInBlock(JTextComponent jTextComponent, int n, int n2, int n3, Map map, boolean bl) throws BadLocationException {
        if (jTextComponent != null) {
            map = this.getValidFindProperties(map);
            BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
            FinderFactory.StringFinder stringFinder = bl ? this.getStringBwdFinder(baseDocument, map) : this.getStringFinder(baseDocument, map);
            int n4 = -1;
            boolean bl2 = false;
            boolean bl3 = this.isBackSearch(map, bl);
            Boolean bl4 = (Boolean)map.get("find-wrap-search");
            boolean bl5 = bl4 != null && bl4 != false;
            int n5 = baseDocument.getLength();
            if (n3 == -1) {
                n3 = n5;
            }
            while ((n4 = baseDocument.find(stringFinder, n, bl3 ? n2 : n3)) == -1 && bl5) {
                if (bl3) {
                    n2 = n;
                    n = n3;
                } else {
                    n3 = n;
                    n = n2;
                }
                bl2 = true;
                bl5 = false;
            }
            if (n4 != -1) {
                int[] nArray = new int[]{n4, n4 + stringFinder.getFoundLength(), bl2 ? 1 : 0};
                return nArray;
            }
        }
        return null;
    }

    public boolean replace(Map map, boolean bl) throws BadLocationException {
        JTextComponent jTextComponent;
        boolean bl2;
        this.incSearchReset();
        map = this.getValidFindProperties(map);
        Boolean bl3 = (Boolean)map.get("find-backward-search");
        boolean bl4 = bl2 = bl3 != null && bl3 != false;
        if (bl) {
            boolean bl5 = bl2 = !bl2;
        }
        if ((jTextComponent = Utilities.getLastActiveComponent()) != null) {
            Caret caret = jTextComponent.getCaret();
            if (!caret.isSelectionVisible() && !this.find(map, bl)) {
                return false;
            }
            BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
            int n = jTextComponent.getSelectionStart();
            int n2 = jTextComponent.getSelectionEnd() - n;
            baseDocument.atomicLock();
            try {
                String string;
                if (n2 > 0) {
                    baseDocument.remove(n, n2);
                }
                if ((string = (String)map.get("find-replace-with")) != null && string.length() > 0) {
                    baseDocument.insertString(n, string, null);
                }
                Object var12_11 = null;
                baseDocument.atomicUnlock();
            }
            catch (Throwable throwable) {
                Object var12_12 = null;
                baseDocument.atomicUnlock();
                throw throwable;
            }
            if (bl2) {
                if (caret instanceof BaseCaret) {
                    ((BaseCaret)caret).setDot(n, (BaseCaret)caret, 3);
                } else {
                    caret.setDot(n);
                }
            }
        }
        return true;
    }

    public void replaceAll(Map hashMap) {
        this.incSearchReset();
        JTextComponent jTextComponent = Utilities.getLastActiveComponent();
        BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
        int n = baseDocument.getLength();
        int n2 = 0;
        int n3 = 0;
        hashMap = this.getValidFindProperties(hashMap);
        hashMap = new HashMap<String, Boolean>(hashMap);
        hashMap.put("find-wrap-search", Boolean.FALSE);
        String string = (String)hashMap.get("find-replace-with");
        if (jTextComponent != null) {
            Object object;
            baseDocument.atomicLock();
            try {
                try {
                    int n4 = 0;
                    while ((object = this.findInBlock(jTextComponent, n4, 0, -1, hashMap, false)) != null) {
                        ++n3;
                        int n5 = object[1] - object[0];
                        boolean bl = false;
                        try {
                            baseDocument.remove(object[0], n5);
                        }
                        catch (GuardedException guardedException) {
                            bl = true;
                        }
                        if (bl) {
                            n4 = object[0] + n5;
                            continue;
                        }
                        if (string != null && string.length() > 0) {
                            baseDocument.insertString(object[0], string, null);
                        }
                        n4 = object[0] + (string != null ? string.length() : 0);
                        ++n2;
                    }
                    Object var14_15 = null;
                    baseDocument.atomicUnlock();
                }
                catch (BadLocationException badLocationException) {
                    badLocationException.printStackTrace();
                    Object var14_16 = null;
                    baseDocument.atomicUnlock();
                }
            }
            catch (Throwable throwable) {
                Object var14_17 = null;
                baseDocument.atomicUnlock();
                throw throwable;
            }
            MessageFormat messageFormat = new MessageFormat(LocaleSupport.getString(ITEMS_REPLACED_LOCALE));
            object = messageFormat.format(new Object[]{new Integer(n2), new Integer(n3)});
            Utilities.setStatusText(jTextComponent, (String)object);
        }
    }

    public int getWrapSearchMarkPos(BaseDocument baseDocument) {
        Mark mark = (Mark)baseDocument.getProperty("wrap-search-mark");
        try {
            return mark != null ? mark.getOffset() : baseDocument.getLength();
        }
        catch (InvalidMarkException invalidMarkException) {
            throw new Error();
        }
    }

    public void setWrapSearchMarkPos(BaseDocument baseDocument, int n) {
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public synchronized void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.changeSupport.addPropertyChangeListener(string, propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    void firePropertyChange(String string, Object object, Object object2) {
        this.changeSupport.firePropertyChange(this, string, object, object2);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class DefaultFinderCreator
    implements FinderCreator {
        protected Finder createFinder(BaseDocument baseDocument, Map map, boolean bl, boolean bl2) {
            boolean bl3;
            boolean bl4;
            String string = (String)map.get("find-what");
            if (string == null || string.length() == 0) {
                if (bl2) {
                    return new FinderFactory.FalseBlocksFinder();
                }
                return new FinderFactory.FalseFinder();
            }
            Boolean bl5 = (Boolean)map.get("find-backward-search");
            boolean bl6 = bl4 = bl5 != null && bl5 != false;
            if (bl) {
                bl4 = !bl4;
            }
            boolean bl7 = (bl5 = (Boolean)map.get("find-match-case")) != null && bl5 != false;
            bl5 = (Boolean)map.get("find-smart-case");
            boolean bl8 = bl5 != null && bl5 != false;
            bl5 = (Boolean)map.get("find-whole-words");
            boolean bl9 = bl3 = bl5 != null && bl5 != false;
            if (bl8 && !bl7) {
                int n = string.length();
                int n2 = 0;
                while (n2 < n) {
                    if (Character.isUpperCase(string.charAt(n2))) {
                        bl7 = true;
                    }
                    ++n2;
                }
            }
            if (bl2) {
                if (bl3) {
                    return new FinderFactory.WholeWordsBlocksFinder(baseDocument, string, bl7);
                }
                return new FinderFactory.StringBlocksFinder(string, bl7);
            }
            if (bl3) {
                if (bl4) {
                    return new FinderFactory.WholeWordsBwdFinder(baseDocument, string, bl7);
                }
                return new FinderFactory.WholeWordsFwdFinder(baseDocument, string, bl7);
            }
            if (bl4) {
                return new FinderFactory.StringBwdFinder(string, bl7);
            }
            return new FinderFactory.StringFwdFinder(string, bl7);
        }

        public FinderFactory.StringFinder createFinder(BaseDocument baseDocument, Map map) {
            return (FinderFactory.StringFinder)this.createFinder(baseDocument, map, false, false);
        }

        public FinderFactory.StringFinder createBwdFinder(BaseDocument baseDocument, Map map) {
            return (FinderFactory.StringFinder)this.createFinder(baseDocument, map, true, false);
        }

        public FinderFactory.BlocksFinder createBlocksFinder(BaseDocument baseDocument, Map map) {
            return (FinderFactory.BlocksFinder)this.createFinder(baseDocument, map, false, true);
        }
    }

    public static interface FinderCreator {
        public FinderFactory.StringFinder createFinder(BaseDocument var1, Map var2);

        public FinderFactory.StringFinder createBwdFinder(BaseDocument var1, Map var2);

        public FinderFactory.BlocksFinder createBlocksFinder(BaseDocument var1, Map var2);
    }
}

