/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Registry;
import org.netbeans.editor.Utilities;

public class JumpList {
    private static final int MAX_SIZE = 50;
    private static final int CHECK_COUNT = 10;
    private static Entry currentEntry;
    private static int checkCnt;

    public static void checkAddEntry() {
        JTextComponent jTextComponent = Utilities.getLastActiveComponent();
        if (jTextComponent != null) {
            JumpList.checkAddEntry(jTextComponent, jTextComponent.getCaret().getDot());
        }
    }

    public static void checkAddEntry(JTextComponent jTextComponent) {
        JumpList.checkAddEntry(jTextComponent, jTextComponent.getCaret().getDot());
    }

    public static void checkAddEntry(JTextComponent jTextComponent, int n) {
        if (currentEntry == null || currentEntry.getComponent() != jTextComponent || currentEntry.getPosition() != n) {
            JumpList.addEntry(jTextComponent, n);
        }
    }

    public static void addEntry(JTextComponent jTextComponent, int n) {
        try {
            Entry entry;
            currentEntry = entry = new Entry(jTextComponent, n, currentEntry);
            if (++checkCnt >= 10) {
                JumpList.sizeCheck();
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public static void jumpPrev(JTextComponent jTextComponent) {
        int n = jTextComponent.getCaret().getDot();
        if (currentEntry != null) {
            while (true) {
                int n2 = currentEntry.getPosition();
                JTextComponent jTextComponent2 = currentEntry.getComponent();
                if (jTextComponent2 != null && (jTextComponent2 != jTextComponent || n2 >= 0 && n2 != n) && currentEntry.setDot() || JumpList.currentEntry.prev == null) break;
                currentEntry = JumpList.currentEntry.prev;
            }
        }
    }

    public static void jumpNext(JTextComponent jTextComponent) {
        int n = jTextComponent.getCaret().getDot();
        if (currentEntry != null) {
            while (true) {
                int n2 = currentEntry.getPosition();
                JTextComponent jTextComponent2 = currentEntry.getComponent();
                if (jTextComponent2 != null && (jTextComponent2 != jTextComponent || n2 >= 0 && n2 != n) && currentEntry.setDot() || JumpList.currentEntry.next == null) break;
                currentEntry = JumpList.currentEntry.next;
            }
        }
    }

    public static void jumpPrevComponent(JTextComponent jTextComponent) {
        if (currentEntry != null) {
            JTextComponent jTextComponent2;
            while (!((jTextComponent2 = currentEntry.getComponent()) != null && jTextComponent2 != jTextComponent && currentEntry.setDot() || JumpList.currentEntry.prev == null)) {
                currentEntry = JumpList.currentEntry.prev;
            }
        }
    }

    public static void jumpNextComponent(JTextComponent jTextComponent) {
        if (currentEntry != null) {
            JTextComponent jTextComponent2;
            while (!((jTextComponent2 = currentEntry.getComponent()) != null && jTextComponent2 != jTextComponent && currentEntry.setDot() || JumpList.currentEntry.next == null)) {
                currentEntry = JumpList.currentEntry.next;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public static String dump() {
        block5: {
            block3: {
                block4: {
                    var0 = new StringBuffer();
                    var1_1 = 0;
                    var2_2 = JumpList.currentEntry;
                    if (var2_2 == null) break block3;
                    while (var2_2.prev != null) {
                        var2_2 = var2_2.prev;
                        --var1_1;
                    }
                    break block4;
lbl10:
                    // 1 sources

                    while (true) {
                        var3_3 = var2_2.getComponent();
                        v0 = var4_4 = var3_3 != null ? (String)var3_3.getDocument().getProperty("title") : "<Invalid document>";
                        if (var4_4 == null) {
                            var4_4 = "Untitled";
                        }
                        var0.append("[" + var1_1++ + "]=" + var4_4 + ", " + var2_2.getPosition() + "\n");
                        var2_2 = var2_2.next;
                        break;
                    }
                }
                ** while (var2_2 != null)
lbl20:
                // 1 sources

                break block5;
            }
            var0.append("Empty list");
        }
        return var0.toString();
    }

    private static void sizeCheck() {
        int n = 50;
        Entry entry = currentEntry;
        while (entry != null && n > 0) {
            entry = entry.prev;
            --n;
        }
        if (entry != null) {
            entry.makeFirst();
        }
    }

    public static class Entry {
        private int componentID;
        private int posID;
        Entry prev;
        Entry next;

        Entry(JTextComponent jTextComponent, int n, Entry entry) throws BadLocationException {
            this.componentID = Registry.getID(jTextComponent);
            this.posID = ((BaseDocument)jTextComponent.getDocument()).storePosition(n);
            if (entry != null) {
                entry.next = this;
                this.prev = entry;
            }
        }

        public int getPosition() {
            JTextComponent jTextComponent = Registry.getComponent(this.componentID);
            int n = -1;
            if (jTextComponent != null) {
                n = ((BaseDocument)jTextComponent.getDocument()).getStoredPosition(this.posID);
            }
            return n;
        }

        public JTextComponent getComponent() {
            return Registry.getComponent(this.componentID);
        }

        public boolean setDot() {
            JTextComponent jTextComponent = this.getComponent();
            if (jTextComponent != null) {
                int n;
                if (Utilities.getLastActiveComponent() != jTextComponent) {
                    Utilities.requestFocus(jTextComponent);
                }
                if ((n = this.getPosition()) >= 0 && n <= jTextComponent.getDocument().getLength()) {
                    jTextComponent.getCaret().setDot(n);
                    return true;
                }
            }
            return false;
        }

        void makeLast() {
            if (this.next != null) {
                this.next.prev = null;
                this.next = null;
            }
        }

        void makeFirst() {
            if (this.prev != null) {
                this.prev.next = null;
                this.prev = null;
            }
        }

        protected void finalize() throws Throwable {
            JTextComponent jTextComponent = Registry.getComponent(this.componentID);
            if (jTextComponent != null) {
                ((BaseDocument)jTextComponent.getDocument()).removeStoredPosition(this.posID);
            }
            super.finalize();
        }
    }
}

