/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseElement;
import org.netbeans.editor.InvalidMarkException;
import org.netbeans.editor.Mark;

public class LeafElement
extends BaseElement {
    protected Mark startMark;
    protected Mark endMark;
    protected boolean bol;
    protected boolean eol;

    public LeafElement(BaseDocument baseDocument, BaseElement baseElement, AttributeSet attributeSet, int n, int n2, boolean bl, boolean bl2) {
        block2: {
            super(baseDocument, baseElement, attributeSet);
            this.bol = bl;
            this.eol = bl2;
            try {
                this.startMark = baseDocument.op.insertMark(n, true);
                this.endMark = baseDocument.op.insertMark(n2, false);
            }
            catch (BadLocationException badLocationException) {
                if (!Boolean.getBoolean("netbeans.debug.exceptions")) break block2;
                badLocationException.printStackTrace();
            }
        }
    }

    protected void finalize() throws Throwable {
        try {
            this.startMark.remove();
            this.endMark.remove();
        }
        catch (InvalidMarkException invalidMarkException) {
            // empty catch block
        }
        super.finalize();
    }

    public final Mark getStartMark() {
        return this.startMark;
    }

    public final int getStartOffset() {
        try {
            return this.startMark.getOffset();
        }
        catch (InvalidMarkException invalidMarkException) {
            return 0;
        }
    }

    public final Mark getEndMark() {
        return this.endMark;
    }

    public final int getEndOffset() {
        try {
            return this.endMark.getOffset();
        }
        catch (InvalidMarkException invalidMarkException) {
            return 0;
        }
    }

    public final boolean isBOL() {
        return this.bol;
    }

    public final boolean isEOL() {
        return this.eol;
    }

    public int getElementIndex(int n) {
        return -1;
    }

    public int getElementCount() {
        return 0;
    }

    public Element getElement(int n) {
        return null;
    }

    public boolean isLeaf() {
        return true;
    }

    public String toString() {
        return "startOffset=" + this.getStartOffset() + ", endOffset=" + this.getEndMark();
    }
}

