/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.MissingResourceException;

public class LocaleSupport {
    private static final String NULL_STRING = new String();
    private static final HashMap cache = new HashMap(503);
    private static Localizer[] localizers = new Localizer[0];

    public static void addLocalizer(Localizer localizer) {
        ArrayList<Localizer> arrayList = new ArrayList<Localizer>(Arrays.asList(localizers));
        arrayList.add(localizer);
        Localizer[] localizerArray = new Localizer[arrayList.size()];
        arrayList.toArray(localizerArray);
        localizers = localizerArray;
        cache.clear();
    }

    public static void removeLocalizer(Localizer localizer) {
        ArrayList<Localizer> arrayList = new ArrayList<Localizer>(Arrays.asList(localizers));
        ((AbstractCollection)arrayList).remove(localizer);
        Localizer[] localizerArray = new Localizer[arrayList.size()];
        arrayList.toArray(localizerArray);
        localizers = localizerArray;
        cache.clear();
    }

    public static synchronized String getString(String string) {
        String string2 = (String)cache.get(string);
        if (string2 == null) {
            int n = localizers.length - 1;
            while (n >= 0) {
                try {
                    string2 = localizers[n].getString(string);
                }
                catch (MissingResourceException missingResourceException) {
                    string2 = null;
                }
                if (string2 != null) break;
                --n;
            }
            if (string2 == null) {
                string2 = NULL_STRING;
            }
            cache.put(string, string2);
        }
        return string2 != NULL_STRING ? string2 : null;
    }

    public static String getString(String string, String string2) {
        String string3 = LocaleSupport.getString(string);
        return string3 != null ? string3 : string2;
    }

    public static char getChar(String string, char c) {
        String string2 = LocaleSupport.getString(string);
        if (string2 == null || string2.length() < 1) {
            return c;
        }
        return string2.charAt(0);
    }

    public static interface Localizer {
        public String getString(String var1);
    }
}

