/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.KeyStroke;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;
import org.netbeans.editor.MultiKeyBinding;

public class MultiKeymap
implements Keymap {
    public static final Action EMPTY_ACTION = new AbstractAction(){

        public void actionPerformed(ActionEvent actionEvent) {
        }
    };
    public static final Action BEEP_ACTION = new DefaultEditorKit.BeepAction();
    private Keymap delegate;
    private Keymap context;
    private boolean ignoreNextTyped = false;
    private Action contextKeyNotFoundAction = BEEP_ACTION;

    public MultiKeymap(String string) {
        this.delegate = JTextComponent.addKeymap(string, null);
    }

    void setContext(Keymap keymap) {
        this.context = keymap;
    }

    public void resetContext() {
        this.context = null;
    }

    public void setContextKeyNotFoundAction(Action action) {
        this.contextKeyNotFoundAction = action;
    }

    public void load(JTextComponent.KeyBinding[] keyBindingArray, Action[] actionArray) {
        HashMap<String, Action> hashMap = new HashMap<String, Action>(keyBindingArray.length);
        int n = 0;
        while (n < actionArray.length) {
            Action action = actionArray[n];
            String string = (String)action.getValue("Name");
            hashMap.put(string != null ? string : "", action);
            ++n;
        }
        this.load(keyBindingArray, hashMap);
    }

    public void load(JTextComponent.KeyBinding[] keyBindingArray, Map map) {
        int n = 0;
        while (n < keyBindingArray.length) {
            Action action = (Action)map.get(keyBindingArray[n].actionName);
            if (action != null) {
                boolean bl = false;
                if (keyBindingArray[n] instanceof MultiKeyBinding) {
                    MultiKeyBinding multiKeyBinding = (MultiKeyBinding)keyBindingArray[n];
                    if (multiKeyBinding.keys != null) {
                        Keymap keymap = this.delegate;
                        int n2 = 0;
                        while (n2 < multiKeyBinding.keys.length) {
                            if (n2 == multiKeyBinding.keys.length - 1) {
                                keymap.addActionForKeyStroke(multiKeyBinding.keys[n2], action);
                            } else {
                                Action action2 = keymap.getAction(multiKeyBinding.keys[n2]);
                                if (!(action2 instanceof KeymapSetContextAction)) {
                                    action2 = new KeymapSetContextAction(JTextComponent.addKeymap(null, null));
                                    keymap.addActionForKeyStroke(multiKeyBinding.keys[n2], action2);
                                }
                                keymap = ((KeymapSetContextAction)action2).contextKeymap;
                            }
                            ++n2;
                        }
                        bl = true;
                    }
                }
                if (!bl) {
                    if (keyBindingArray[n].key != null) {
                        this.delegate.addActionForKeyStroke(keyBindingArray[n].key, action);
                    } else {
                        this.setDefaultAction(action);
                    }
                }
            }
            ++n;
        }
    }

    public String getName() {
        return this.context != null ? this.context.getName() : this.delegate.getName();
    }

    public Action getDefaultAction() {
        return this.delegate.getDefaultAction();
    }

    public void setDefaultAction(Action action) {
        if (this.context != null) {
            this.context.setDefaultAction(action);
        } else {
            this.delegate.setDefaultAction(action);
        }
    }

    Action getActionImpl(KeyStroke keyStroke) {
        Action action = null;
        if (this.context != null) {
            action = this.context.getAction(keyStroke);
            if (action == null) {
                switch (keyStroke.getKeyCode()) {
                    case 16: 
                    case 17: 
                    case 18: 
                    case 157: {
                        return EMPTY_ACTION;
                    }
                }
                if (keyStroke.isOnKeyRelease() || keyStroke.getKeyChar() != '\u0000' && keyStroke.getKeyChar() != '\uffff') {
                    return EMPTY_ACTION;
                }
            }
        } else {
            action = this.delegate.getAction(keyStroke);
        }
        return action;
    }

    public Action getAction(KeyStroke keyStroke) {
        Action action = null;
        if (this.ignoreNextTyped) {
            if (keyStroke.isOnKeyRelease()) {
                action = EMPTY_ACTION;
            } else {
                this.ignoreNextTyped = false;
            }
            if (keyStroke.getKeyChar() != '\u0000' && keyStroke.getKeyChar() != '\uffff') {
                action = EMPTY_ACTION;
            }
        }
        if (action == null && (action = this.getActionImpl(keyStroke)) != EMPTY_ACTION) {
            if (!(action instanceof KeymapSetContextAction)) {
                if (this.context != null) {
                    this.ignoreNextTyped = true;
                } else if ((keyStroke.getModifiers() & 8) != 0 && (keyStroke.getModifiers() & 2) == 0) {
                    boolean bl = true;
                    if (keyStroke.getKeyChar() == '\u0000' || keyStroke.getKeyChar() == '\uffff') {
                        switch (keyStroke.getKeyCode()) {
                            case 18: 
                            case 25: 
                            case 96: 
                            case 97: 
                            case 98: 
                            case 99: 
                            case 100: 
                            case 101: 
                            case 102: 
                            case 103: 
                            case 104: 
                            case 105: 
                            case 241: 
                            case 242: 
                            case 259: 
                            case 260: 
                            case 263: {
                                bl = false;
                            }
                        }
                    }
                    if (bl) {
                        this.ignoreNextTyped = true;
                    }
                } else if ((keyStroke.getModifiers() & 4) != 0) {
                    this.ignoreNextTyped = true;
                }
                this.resetContext();
            }
            if (this.context != null && action == null) {
                action = this.contextKeyNotFoundAction;
            }
        }
        if (keyStroke == KeyStroke.getKeyStroke(32, 2)) {
            this.ignoreNextTyped = true;
        }
        return action;
    }

    public KeyStroke[] getBoundKeyStrokes() {
        return this.context != null ? this.context.getBoundKeyStrokes() : this.delegate.getBoundKeyStrokes();
    }

    public Action[] getBoundActions() {
        return this.context != null ? this.context.getBoundActions() : this.delegate.getBoundActions();
    }

    public KeyStroke[] getKeyStrokesForAction(Action action) {
        return this.context != null ? this.context.getKeyStrokesForAction(action) : this.delegate.getKeyStrokesForAction(action);
    }

    public boolean isLocallyDefined(KeyStroke keyStroke) {
        return this.context != null ? this.context.isLocallyDefined(keyStroke) : this.delegate.isLocallyDefined(keyStroke);
    }

    public void addActionForKeyStroke(KeyStroke keyStroke, Action action) {
        if (this.context != null) {
            this.context.addActionForKeyStroke(keyStroke, action);
        } else {
            this.delegate.addActionForKeyStroke(keyStroke, action);
        }
    }

    public void removeKeyStrokeBinding(KeyStroke keyStroke) {
        if (this.context != null) {
            this.context.removeKeyStrokeBinding(keyStroke);
        } else {
            this.delegate.removeKeyStrokeBinding(keyStroke);
        }
    }

    public void removeBindings() {
        if (this.context != null) {
            this.context.removeBindings();
        } else {
            this.delegate.removeBindings();
        }
    }

    public Keymap getResolveParent() {
        return this.context != null ? this.context.getResolveParent() : this.delegate.getResolveParent();
    }

    public void setResolveParent(Keymap keymap) {
        if (this.context != null) {
            this.context.setResolveParent(keymap);
        } else {
            this.delegate.setResolveParent(keymap);
        }
    }

    public String toString() {
        return "MK: name=" + this.getName();
    }

    class KeymapSetContextAction
    extends AbstractAction {
        Keymap contextKeymap;
        static final long serialVersionUID = 1034848289049566148L;

        KeymapSetContextAction(Keymap keymap) {
            this.contextKeymap = keymap;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MultiKeymap.this.setContext(this.contextKeymap);
        }
    }
}

