/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.io.Serializable;
import javax.swing.Action;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.plaf.TextUI;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.Analyzer;
import org.netbeans.editor.BaseAction;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.BaseTextUI;
import org.netbeans.editor.Coloring;
import org.netbeans.editor.EditorUI;
import org.netbeans.editor.Finder;
import org.netbeans.editor.FinderFactory;
import org.netbeans.editor.Formatter;
import org.netbeans.editor.InvalidMarkException;
import org.netbeans.editor.LocaleSupport;
import org.netbeans.editor.Mark;
import org.netbeans.editor.Registry;
import org.netbeans.editor.StatusBar;
import org.netbeans.editor.SyntaxSupport;

public class Utilities {
    private static final String WRONG_POSITION_LOCALE = "wrong_position";
    public static final int CASE_UPPER = 0;
    public static final int CASE_LOWER = 1;
    public static final int CASE_SWITCH = 2;

    private Utilities() {
    }

    public static int getRowStart(JTextComponent jTextComponent, int n) throws BadLocationException {
        return Utilities.getRowStart((BaseDocument)jTextComponent.getDocument(), n, 0);
    }

    public static int getRowStart(BaseDocument baseDocument, int n) throws BadLocationException {
        return Utilities.getRowStart(baseDocument, n, 0);
    }

    public static int getRowStart(BaseDocument baseDocument, int n, int n2) throws BadLocationException {
        if (n2 != 0) {
            return baseDocument.op.getBOLRelLine(n, n2);
        }
        return baseDocument.op.getBOL(n);
    }

    public static int getRowFirstNonWhite(BaseDocument baseDocument, int n) throws BadLocationException {
        return Utilities.getFirstNonWhiteFwd(baseDocument, baseDocument.op.getBOL(n), baseDocument.op.getEOL(n));
    }

    public static int getRowLastNonWhite(BaseDocument baseDocument, int n) throws BadLocationException {
        return Utilities.getFirstNonWhiteBwd(baseDocument, baseDocument.op.getEOL(n), baseDocument.op.getBOL(n));
    }

    public static int getRowIndent(BaseDocument baseDocument, int n) throws BadLocationException {
        if ((n = Utilities.getRowFirstNonWhite(baseDocument, n)) == -1) {
            return -1;
        }
        return baseDocument.op.getVisColFromPos(n);
    }

    public static int getRowIndent(BaseDocument baseDocument, int n, boolean bl) throws BadLocationException {
        int n2 = Utilities.getRowFirstNonWhite(baseDocument, n);
        if (n2 == -1) {
            n2 = Utilities.getFirstNonWhiteRow(baseDocument, n, bl);
            if (n2 == -1) {
                return -1;
            }
            if ((n2 = Utilities.getRowFirstNonWhite(baseDocument, n2)) == -1) {
                return -1;
            }
        }
        return baseDocument.op.getVisColFromPos(n2);
    }

    public static int getRowEnd(JTextComponent jTextComponent, int n) throws BadLocationException {
        return Utilities.getRowEnd((BaseDocument)jTextComponent.getDocument(), n);
    }

    public static int getRowEnd(BaseDocument baseDocument, int n) throws BadLocationException {
        return baseDocument.op.getEOL(n);
    }

    public static int getPositionAbove(JTextComponent jTextComponent, int n, int n2) throws BadLocationException {
        BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
        BaseTextUI baseTextUI = (BaseTextUI)jTextComponent.getUI();
        n = baseTextUI.viewToModel(jTextComponent, n2, baseTextUI.getYFromPos(n) - baseTextUI.getEditorUI().getLineHeight());
        return n;
    }

    public static int getPositionBelow(JTextComponent jTextComponent, int n, int n2) throws BadLocationException {
        BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
        BaseTextUI baseTextUI = (BaseTextUI)jTextComponent.getUI();
        n = baseTextUI.viewToModel(jTextComponent, n2, baseTextUI.getYFromPos(n) + baseTextUI.getEditorUI().getLineHeight());
        return n;
    }

    public static int getWordStart(JTextComponent jTextComponent, int n) throws BadLocationException {
        return Utilities.getWordStart((BaseDocument)jTextComponent.getDocument(), n);
    }

    public static int getWordStart(BaseDocument baseDocument, int n) throws BadLocationException {
        int n2 = baseDocument.getLength();
        return baseDocument.find(new FinderFactory.PreviousWordBwdFinder(baseDocument, false, true), n, 0);
    }

    public static int getWordEnd(JTextComponent jTextComponent, int n) throws BadLocationException {
        return Utilities.getWordEnd((BaseDocument)jTextComponent.getDocument(), n);
    }

    public static int getWordEnd(BaseDocument baseDocument, int n) throws BadLocationException {
        return baseDocument.find(new FinderFactory.NextWordFwdFinder(baseDocument, false, true), n, -1);
    }

    public static int getNextWord(JTextComponent jTextComponent, int n) throws BadLocationException {
        return Utilities.getNextWord((BaseDocument)jTextComponent.getDocument(), n);
    }

    public static int getNextWord(BaseDocument baseDocument, int n) throws BadLocationException {
        Finder finder = (Finder)baseDocument.getProperty("next-word-finder");
        n = baseDocument.find(finder, n, -1);
        if (n < 0) {
            n = baseDocument.getLength();
        }
        return n;
    }

    public static int getPreviousWord(JTextComponent jTextComponent, int n) throws BadLocationException {
        return Utilities.getPreviousWord((BaseDocument)jTextComponent.getDocument(), n);
    }

    public static int getPreviousWord(BaseDocument baseDocument, int n) throws BadLocationException {
        Finder finder = (Finder)baseDocument.getProperty("previous-word-finder");
        n = baseDocument.find(finder, n, 0);
        if (n < 0) {
            n = 0;
        }
        return n;
    }

    public static int getFirstWhiteFwd(BaseDocument baseDocument, int n) throws BadLocationException {
        return Utilities.getFirstWhiteFwd(baseDocument, n, -1);
    }

    public static int getFirstWhiteFwd(BaseDocument baseDocument, int n, int n2) throws BadLocationException {
        return baseDocument.find(new FinderFactory.WhiteFwdFinder(baseDocument), n, n2);
    }

    public static int getFirstNonWhiteFwd(BaseDocument baseDocument, int n) throws BadLocationException {
        return Utilities.getFirstNonWhiteFwd(baseDocument, n, -1);
    }

    public static int getFirstNonWhiteFwd(BaseDocument baseDocument, int n, int n2) throws BadLocationException {
        return baseDocument.find(new FinderFactory.NonWhiteFwdFinder(baseDocument), n, n2);
    }

    public static int getFirstWhiteBwd(BaseDocument baseDocument, int n) throws BadLocationException {
        return Utilities.getFirstWhiteBwd(baseDocument, n, 0);
    }

    public static int getFirstWhiteBwd(BaseDocument baseDocument, int n, int n2) throws BadLocationException {
        return baseDocument.find(new FinderFactory.WhiteBwdFinder(baseDocument), n, n2);
    }

    public static int getFirstNonWhiteBwd(BaseDocument baseDocument, int n) throws BadLocationException {
        return Utilities.getFirstNonWhiteBwd(baseDocument, n, 0);
    }

    public static int getFirstNonWhiteBwd(BaseDocument baseDocument, int n, int n2) throws BadLocationException {
        return baseDocument.find(new FinderFactory.NonWhiteBwdFinder(baseDocument), n, n2);
    }

    public static int getLineOffset(BaseDocument baseDocument, int n) throws BadLocationException {
        return baseDocument.op.getLine(n);
    }

    public static int getRowStartFromLineOffset(BaseDocument baseDocument, int n) {
        return baseDocument.op.getBOLFromLine(n);
    }

    public static int getVisualColumn(BaseDocument baseDocument, int n) throws BadLocationException {
        return baseDocument.op.getVisColFromPos(n);
    }

    public static String getIdentifier(BaseDocument baseDocument, int n) throws BadLocationException {
        int[] nArray = Utilities.getIdentifierBlock(baseDocument, n);
        return nArray != null ? baseDocument.getText(nArray[0], nArray[1] - nArray[0]) : null;
    }

    public static int[] getIdentifierBlock(BaseDocument baseDocument, int n) throws BadLocationException {
        int n2;
        int[] nArray = null;
        int n3 = Utilities.getWordStart(baseDocument, n);
        if (n3 >= 0 && (n2 = Utilities.getWordEnd(baseDocument, n3)) >= 0) {
            String string = baseDocument.getText(n3, n2 - n3);
            if (baseDocument.getSyntaxSupport().isIdentifier(string)) {
                nArray = new int[]{n3, n2};
            } else {
                string = Utilities.getWord(baseDocument, n);
                if (baseDocument.getSyntaxSupport().isIdentifier(string)) {
                    nArray = new int[]{n, n + string.length()};
                }
            }
        }
        return nArray;
    }

    public static String getWord(JTextComponent jTextComponent, int n) throws BadLocationException {
        int n2;
        String string = null;
        Document document = jTextComponent.getDocument();
        int n3 = javax.swing.text.Utilities.getWordStart(jTextComponent, n);
        if (n3 >= 0 && (n2 = javax.swing.text.Utilities.getWordEnd(jTextComponent, n3)) >= 0) {
            string = document.getText(n3, n2 - n3);
            if (string.trim().length() == 0) {
                int n4 = javax.swing.text.Utilities.getPreviousWord(jTextComponent, n);
                if (n == javax.swing.text.Utilities.getWordEnd(jTextComponent, n4)) {
                    string = document.getText(n4, n - n4);
                }
            } else if (string != null && string.length() != 0 && string.indexOf(".") != -1) {
                int n5 = n - n3;
                int n6 = string.substring(0, n5).lastIndexOf(".");
                n6 = n6 == -1 ? 0 : n6 + 1;
                int n7 = string.indexOf(".", n5);
                n7 = n7 == -1 ? string.length() : n7;
                string = string.substring(n6, n7);
            }
        }
        return string;
    }

    public static int[] getSelectionOrIdentifierBlock(JTextComponent jTextComponent, int n) throws BadLocationException {
        BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
        Caret caret = jTextComponent.getCaret();
        int[] nArray = caret.isSelectionVisible() ? new int[]{jTextComponent.getSelectionStart(), jTextComponent.getSelectionEnd()} : Utilities.getIdentifierBlock(baseDocument, caret.getDot());
        return nArray;
    }

    public static int[] getSelectionOrIdentifierBlock(JTextComponent jTextComponent) {
        try {
            return Utilities.getSelectionOrIdentifierBlock(jTextComponent, jTextComponent.getCaret().getDot());
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    public static String getIdentifierBefore(BaseDocument baseDocument, int n) throws BadLocationException {
        int n2 = Utilities.getWordStart(baseDocument, n);
        if (n2 != -1) {
            String string = new String(baseDocument.getChars(n2, n - n2), 0, n - n2);
            if (baseDocument.getSyntaxSupport().isIdentifier(string)) {
                return string;
            }
        }
        return null;
    }

    public static String getSelectionOrIdentifier(JTextComponent jTextComponent, int n) throws BadLocationException {
        String string;
        Document document = jTextComponent.getDocument();
        Caret caret = jTextComponent.getCaret();
        if (caret.isSelectionVisible() && (string = jTextComponent.getSelectedText()) != null) {
            return string;
        }
        string = document instanceof BaseDocument ? Utilities.getIdentifier((BaseDocument)document, caret.getDot()) : Utilities.getWord(jTextComponent, n);
        return string;
    }

    public static String getSelectionOrIdentifier(JTextComponent jTextComponent) {
        try {
            return Utilities.getSelectionOrIdentifier(jTextComponent, jTextComponent.getCaret().getDot());
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    public static String getWord(BaseDocument baseDocument, int n) throws BadLocationException {
        int n2 = Utilities.getWordEnd(baseDocument, n);
        if (n2 != -1) {
            return new String(baseDocument.getChars(n, n2 - n), 0, n2 - n);
        }
        return null;
    }

    public static boolean changeCase(BaseDocument baseDocument, int n, int n2, int n3) throws BadLocationException {
        char[] cArray = baseDocument.getChars(n, n2);
        char[] cArray2 = (char[])cArray.clone();
        int n4 = 0;
        while (n4 < cArray.length) {
            switch (n3) {
                case 0: {
                    cArray2[n4] = Character.toUpperCase(cArray[n4]);
                    break;
                }
                case 1: {
                    cArray2[n4] = Character.toLowerCase(cArray[n4]);
                    break;
                }
                case 2: {
                    if (Character.isUpperCase(cArray[n4])) {
                        cArray2[n4] = Character.toLowerCase(cArray[n4]);
                        break;
                    }
                    if (!Character.isLowerCase(cArray[n4])) break;
                    cArray2[n4] = Character.toUpperCase(cArray[n4]);
                }
            }
            ++n4;
        }
        int n5 = 0;
        while (n5 < cArray.length) {
            if (cArray[n5] != cArray2[n5]) {
                baseDocument.atomicLock();
                try {
                    baseDocument.remove(n, cArray.length);
                    baseDocument.insertString(n, new String(cArray2), null);
                    Object var9_8 = null;
                    baseDocument.atomicUnlock();
                }
                catch (Throwable throwable) {
                    Object var9_9 = null;
                    baseDocument.atomicUnlock();
                    throw throwable;
                }
                return true;
            }
            ++n5;
        }
        return false;
    }

    public static boolean isRowEmpty(BaseDocument baseDocument, int n) throws BadLocationException {
        return baseDocument.op.getBOL(n) == baseDocument.op.getEOL(n);
    }

    public static int getFirstNonEmptyRow(BaseDocument baseDocument, int n, boolean bl) throws BadLocationException {
        while (n != -1 && Utilities.isRowEmpty(baseDocument, n)) {
            n = Utilities.getRowStart(baseDocument, n, bl ? 1 : -1);
        }
        return n;
    }

    public static boolean isRowWhite(BaseDocument baseDocument, int n) throws BadLocationException {
        return (n = baseDocument.find(new FinderFactory.NonWhiteFwdFinder(baseDocument), baseDocument.op.getBOL(n), baseDocument.op.getEOL(n))) == -1;
    }

    public static int getFirstNonWhiteRow(BaseDocument baseDocument, int n, boolean bl) throws BadLocationException {
        if (Utilities.isRowWhite(baseDocument, n)) {
            n = bl ? Utilities.getFirstNonWhiteFwd(baseDocument, n) : Utilities.getFirstNonWhiteBwd(baseDocument, n);
        }
        return n;
    }

    public static int reformat(BaseDocument baseDocument, int n, int n2) throws BadLocationException {
        return baseDocument.getFormatter().reformat(baseDocument, n, n2);
    }

    public static void reformatLine(BaseDocument baseDocument, int n) throws BadLocationException {
        int n2 = Utilities.getRowStart(baseDocument, n);
        int n3 = Utilities.getRowEnd(baseDocument, n);
        Utilities.reformat(baseDocument, n2, n3);
    }

    public static int getRowCount(BaseDocument baseDocument, int n, int n2) throws BadLocationException {
        if (n > n2) {
            return 0;
        }
        return baseDocument.op.getLine(n2) - baseDocument.op.getLine(n) + 1;
    }

    public static int getRowCount(BaseDocument baseDocument) {
        return baseDocument.op.getLineCount();
    }

    public static String getTabInsertString(BaseDocument baseDocument, int n) throws BadLocationException {
        int n2 = Utilities.getVisualColumn(baseDocument, n);
        Formatter formatter = baseDocument.getFormatter();
        boolean bl = formatter.expandTabs();
        if (bl) {
            int n3 = formatter.getSpacesPerTab();
            int n4 = (n2 + n3) / n3 * n3 - n2;
            return new String(Analyzer.getSpacesBuffer(n4), 0, n4);
        }
        return "\t";
    }

    public static int getNextTabColumn(BaseDocument baseDocument, int n) throws BadLocationException {
        int n2 = Utilities.getVisualColumn(baseDocument, n);
        int n3 = baseDocument.getFormatter().getSpacesPerTab();
        return (n2 + n3) / n3 * n3;
    }

    public static void setStatusText(JTextComponent jTextComponent, String string) {
        StatusBar statusBar = Utilities.getEditorUI(jTextComponent).getStatusBar();
        if (statusBar != null) {
            statusBar.setText("main", string);
        }
    }

    public static void setStatusText(JTextComponent jTextComponent, String string, Coloring coloring) {
        StatusBar statusBar = Utilities.getEditorUI(jTextComponent).getStatusBar();
        if (statusBar != null) {
            statusBar.setText("main", string, coloring);
        }
    }

    public static void setStatusBoldText(JTextComponent jTextComponent, String string) {
        StatusBar statusBar = Utilities.getEditorUI(jTextComponent).getStatusBar();
        if (statusBar != null) {
            statusBar.setBoldText("main", string);
        }
    }

    public static String getStatusText(JTextComponent jTextComponent) {
        StatusBar statusBar = Utilities.getEditorUI(jTextComponent).getStatusBar();
        return statusBar != null ? statusBar.getText("main") : null;
    }

    public static void clearStatusText(JTextComponent jTextComponent) {
        Utilities.setStatusText(jTextComponent, "");
    }

    public static void insertMark(BaseDocument baseDocument, Mark mark, int n) throws BadLocationException, InvalidMarkException {
        baseDocument.op.insertMark(mark, n);
    }

    public static void moveMark(BaseDocument baseDocument, Mark mark, int n) throws BadLocationException, InvalidMarkException {
        baseDocument.op.moveMark(mark, n);
    }

    public static void returnFocus() {
        JTextComponent jTextComponent = Utilities.getLastActiveComponent();
        if (jTextComponent != null) {
            Utilities.requestFocus(jTextComponent);
        }
    }

    public static void requestFocus(JTextComponent jTextComponent) {
        if (jTextComponent != null) {
            Container container;
            Serializable serializable;
            boolean bl = false;
            BaseKit baseKit = Utilities.getKit(jTextComponent);
            if (baseKit != null && (serializable = baseKit.getFocusableComponentClass(jTextComponent)) != null && (container = SwingUtilities.getAncestorOfClass(serializable, jTextComponent)) != null) {
                container.requestFocus();
                bl = true;
            }
            if (!bl) {
                serializable = EditorUI.getParentFrame(jTextComponent);
                if (serializable != null) {
                    ((Component)serializable).requestFocus();
                }
                jTextComponent.requestFocus();
            }
        }
    }

    public static void runInEventDispatchThread(Runnable runnable) {
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    public static String debugPosition(BaseDocument baseDocument, int n) {
        String string;
        if (n >= 0) {
            try {
                int n2 = Utilities.getLineOffset(baseDocument, n) + 1;
                int n3 = Utilities.getVisualColumn(baseDocument, n) + 1;
                string = String.valueOf(n2) + ":" + String.valueOf(n3);
            }
            catch (BadLocationException badLocationException) {
                string = LocaleSupport.getString(WRONG_POSITION_LOCALE) + ' ' + n + " > " + baseDocument.getLength();
            }
        } else {
            string = String.valueOf(n);
        }
        return string;
    }

    public static String debugDocument(Document document) {
        return "<" + System.identityHashCode(document) + ", title='" + document.getProperty("title") + "', stream='" + document.getProperty("stream") + ", " + document.toString() + ">";
    }

    public static void performAction(Action action, ActionEvent actionEvent, JTextComponent jTextComponent) {
        if (action instanceof BaseAction) {
            ((BaseAction)action).actionPerformed(actionEvent, jTextComponent);
        } else {
            action.actionPerformed(actionEvent);
        }
    }

    public static JTextComponent getLastActiveComponent() {
        return Registry.getMostActiveComponent();
    }

    public static EditorUI getEditorUI(JTextComponent jTextComponent) {
        TextUI textUI = jTextComponent.getUI();
        return textUI instanceof BaseTextUI ? ((BaseTextUI)textUI).getEditorUI() : null;
    }

    public static BaseKit getKit(JTextComponent jTextComponent) {
        EditorKit editorKit = jTextComponent.getUI().getEditorKit(jTextComponent);
        return editorKit instanceof BaseKit ? (BaseKit)editorKit : null;
    }

    public static Class getKitClass(JTextComponent jTextComponent) {
        return jTextComponent != null ? jTextComponent.getUI().getEditorKit(jTextComponent).getClass() : null;
    }

    public static BaseDocument getDocument(JTextComponent jTextComponent) {
        Document document = jTextComponent.getDocument();
        return document instanceof BaseDocument ? (BaseDocument)document : null;
    }

    public static SyntaxSupport getSyntaxSupport(JTextComponent jTextComponent) {
        Document document = jTextComponent.getDocument();
        return document instanceof BaseDocument ? ((BaseDocument)document).getSyntaxSupport() : null;
    }

    public static String keySequenceToString(KeyStroke[] keyStrokeArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < keyStrokeArray.length) {
            if (n > 0) {
                stringBuffer.append(' ');
            }
            stringBuffer.append(Utilities.keyStrokeToString(keyStrokeArray[n]));
            ++n;
        }
        return stringBuffer.toString();
    }

    public static String keyStrokeToString(KeyStroke keyStroke) {
        String string;
        String string2 = KeyEvent.getKeyModifiersText(keyStroke.getModifiers());
        String string3 = string = keyStroke.getKeyCode() == 0 ? String.valueOf(keyStroke.getKeyChar()) : Utilities.getKeyText(keyStroke.getKeyCode());
        if (string2.length() > 0) {
            return string2 + '+' + string;
        }
        return string;
    }

    private static String getKeyText(int n) {
        String string = KeyEvent.getKeyText(n);
        if (string != null) {
            switch (n) {
                case 225: {
                    string = Utilities.prefixNumpad(string, 40);
                    break;
                }
                case 226: {
                    string = Utilities.prefixNumpad(string, 37);
                    break;
                }
                case 227: {
                    string = Utilities.prefixNumpad(string, 39);
                    break;
                }
                case 224: {
                    string = Utilities.prefixNumpad(string, 38);
                }
            }
        }
        return string;
    }

    private static String prefixNumpad(String string, int n) {
        if (string.equals(KeyEvent.getKeyText(n))) {
            string = LocaleSupport.getString("key-prefix-numpad") + string;
        }
        return string;
    }
}

