/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor.ext.java;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.netbeans.editor.ext.java.JCClass;
import org.netbeans.editor.ext.java.JCConstructor;
import org.netbeans.editor.ext.java.JCField;
import org.netbeans.editor.ext.java.JCMethod;
import org.netbeans.editor.ext.java.JCPackage;
import org.netbeans.editor.ext.java.JCParameter;
import org.netbeans.editor.ext.java.JCType;
import org.netbeans.editor.ext.java.JavaCompletion;

public class JCCellRenderer
extends JPanel
implements ListCellRenderer {
    public static final int CLASS_ICON = 0;
    public static final int INTERFACE_ICON = 4;
    public static final int FIELD_ICON = 8;
    public static final int FIELD_STATIC_ICON = 12;
    public static final int CONSTRUCTOR_ICON = 16;
    public static final int METHOD_ICON = 20;
    public static final int METHOD_STATIC_ICON = 24;
    public static final int PACKAGE_ICON = 28;
    private static final int END_ICON = 29;
    public static final int CLASS_COLOR = 0;
    public static final int INTERFACE_COLOR = 4;
    public static final int FIELD_COLOR = 8;
    public static final int FIELD_STATIC_COLOR = 12;
    public static final int CONSTRUCTOR_COLOR = 16;
    public static final int METHOD_COLOR = 20;
    public static final int METHOD_STATIC_COLOR = 24;
    public static final int PACKAGE_COLOR = 28;
    public static final int KEYWORD_COLOR = 29;
    public static final int TYPE_COLOR = 30;
    public static final int PARAMETER_NAME_COLOR = 31;
    private static final int END_COLOR = 32;
    private static final String THROWS = " throws ";
    private static final String[] frequentWords = new String[]{"", " ", "[]", "(", ")", ", ", "String", " throws "};
    static final long serialVersionUID = 4737618682220847017L;
    Map widths;
    Icon[] icons = new Icon[29];
    Color[] colors = new Color[32];
    private FontMetrics fontMetrics;
    private int fontHeight;
    private int ascent;
    private int iconTextGap = 5;
    protected JList list;
    protected Object value;
    protected boolean isSelected;
    protected boolean packageLastNameOnly;
    protected boolean displayStaticWord;
    protected int classDisplayOffset;
    protected boolean classDisplayFullName;
    protected int drawX;
    protected int drawY;
    protected int drawHeight;

    public JCCellRenderer() {
        this.setOpaque(true);
        this.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 3));
        int n = 0;
        while (n < this.colors.length) {
            this.colors[n] = Color.black;
            ++n;
        }
        this.setForeColor(Color.green.darker().darker().darker(), 28);
        this.setForeColor(Color.red.darker().darker().darker(), 0);
        this.setForeColor(Color.darkGray, 4);
        this.setForeColor(Color.blue.darker(), 8);
        this.setForeColor(Color.orange.darker(), 16);
        this.setForeColor(Color.red.darker().darker(), 20);
        this.setForeColor(Color.darkGray, 29);
        this.setForeColor(Color.magenta.darker(), 31);
        this.setPackageLastNameOnly(true);
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.fontMetrics = ((Component)this).getFontMetrics(font);
        this.fontHeight = this.fontMetrics.getHeight();
        this.ascent = this.fontMetrics.getAscent();
        if (this.widths != null) {
            this.widths.clear();
        } else {
            this.widths = new HashMap();
        }
        int n = 0;
        while (n < frequentWords.length) {
            this.storeWidth(frequentWords[n]);
            ++n;
        }
        Iterator iterator = JavaCompletion.getPrimitiveClassIterator();
        while (iterator.hasNext()) {
            this.storeWidth(((JCClass)iterator.next()).getName());
        }
    }

    public void setIconTextGap(int n) {
        this.iconTextGap = n;
    }

    public int getIconTextGap() {
        return this.iconTextGap;
    }

    private void storeWidth(String string) {
        this.fontMetrics.stringWidth(string);
    }

    public void setIcon(Icon icon, int n) {
        if (n < 28) {
            int n2 = 0;
            while (n2 < 4) {
                this.icons[n + n2] = icon;
                ++n2;
            }
        } else {
            this.icons[n] = icon;
        }
    }

    public void setIcon(Icon icon, int n, int n2) {
        this.icons[n + n2] = icon;
    }

    public void setForeColor(Color color, int n) {
        if (n < 28) {
            int n2 = 0;
            while (n2 < 4) {
                this.colors[n + n2] = color;
                ++n2;
            }
        } else {
            this.colors[n] = color;
        }
    }

    public void setForeColor(Color color, int n, int n2) {
        this.colors[n + n2] = color;
    }

    public void setPackageLastNameOnly(boolean bl) {
        this.packageLastNameOnly = bl;
    }

    public void setDisplayStaticWord(boolean bl) {
        this.displayStaticWord = bl;
    }

    public void setClassDisplayOffset(int n) {
        this.classDisplayOffset = n;
    }

    public void setClassDisplayFullName(boolean bl) {
        this.classDisplayFullName = bl;
    }

    protected Color getColor(String string, Color color) {
        return this.isSelected ? this.getForeground() : color;
    }

    protected int getWidth(String string) {
        Integer n = (Integer)this.widths.get(string);
        if (n != null) {
            return n;
        }
        return this.fontMetrics.stringWidth(string);
    }

    protected void drawString(Graphics graphics, String string) {
        if (graphics != null) {
            graphics.setColor(this.getForeground());
        }
        this.drawStringToGraphics(graphics, string);
    }

    protected void drawString(Graphics graphics, String string, int n) {
        this.drawString(graphics, string, this.colors[n]);
    }

    protected void drawString(Graphics graphics, String string, Color color) {
        if (graphics != null) {
            graphics.setColor(this.getColor(string, color));
        }
        this.drawStringToGraphics(graphics, string);
    }

    protected void drawStringToGraphics(Graphics graphics, String string) {
        if (graphics != null) {
            graphics.drawString(string, this.drawX, this.drawY);
        }
        this.drawX += this.getWidth(string);
    }

    protected void drawIcon(Graphics graphics, Icon icon) {
        Insets insets = this.getInsets();
        if (insets != null) {
            this.drawX = insets.left;
            this.drawY = insets.top;
        } else {
            this.drawX = 0;
            this.drawY = 0;
        }
        if (icon != null) {
            if (graphics != null) {
                icon.paintIcon(this, graphics, this.drawX, this.drawY);
            }
            this.drawX += icon.getIconWidth() + this.iconTextGap;
            this.drawHeight = Math.max(this.fontHeight, icon.getIconHeight());
        } else {
            this.drawHeight = this.fontHeight;
        }
        if (insets != null) {
            this.drawHeight += insets.bottom;
        }
        this.drawHeight += this.drawY;
        this.drawY += this.ascent;
    }

    protected Color getTypeColor(String string) {
        return this.colors[JavaCompletion.isPrimitiveClassName(string) ? 29 : 30];
    }

    protected void drawType(Graphics graphics, JCType jCType) {
        Color color = this.getTypeColor(jCType.getClazz().getName());
        this.drawString(graphics, jCType.format(false), color);
    }

    protected void drawParameter(Graphics graphics, JCParameter jCParameter) {
        this.drawType(graphics, jCParameter.getType());
        String string = jCParameter.getName();
        if (string.length() > 0) {
            this.drawString(graphics, " ");
            this.drawString(graphics, jCParameter.getName(), 31);
        }
    }

    protected void drawParameterList(Graphics graphics, JCConstructor jCConstructor) {
        this.drawString(graphics, "(");
        JCParameter[] jCParameterArray = jCConstructor.getParameters();
        int n = 0;
        while (n < jCParameterArray.length) {
            this.drawParameter(graphics, jCParameterArray[n]);
            if (n != jCParameterArray.length - 1) {
                this.drawString(graphics, ", ");
            }
            ++n;
        }
        this.drawString(graphics, ")");
    }

    protected void drawExceptions(Graphics graphics, JCConstructor jCConstructor) {
        JCClass[] jCClassArray = jCConstructor.getExceptions();
        if (jCClassArray.length > 0) {
            this.drawString(graphics, THROWS, 29);
            int n = 0;
            while (n < jCClassArray.length) {
                String string = jCClassArray[n].getName();
                Color color = this.getTypeColor(string);
                this.drawString(graphics, string, color);
                if (n != jCClassArray.length - 1) {
                    this.drawString(graphics, ", ");
                }
                ++n;
            }
        }
    }

    protected void drawPackage(Graphics graphics, JCPackage jCPackage) {
        this.drawIcon(graphics, this.icons[28]);
        String string = jCPackage.getName();
        if (this.packageLastNameOnly) {
            string = jCPackage.getLastName();
        }
        this.drawString(graphics, string, 28);
    }

    protected void drawClass(Graphics graphics, JCClass jCClass) {
        boolean bl = jCClass.isInterface();
        int n = JavaCompletion.getLevel(jCClass.getModifiers());
        String string = jCClass.getName();
        if (this.classDisplayFullName) {
            string = jCClass.getFullName();
        } else if (this.classDisplayOffset > 0 && this.classDisplayOffset < string.length()) {
            string = string.substring(this.classDisplayOffset);
        }
        this.drawIcon(graphics, this.icons[(bl ? 4 : 0) + n]);
        this.drawString(graphics, string, bl ? 4 : 0);
    }

    protected void drawField(Graphics graphics, JCField jCField) {
        int n = JavaCompletion.getLevel(jCField.getModifiers());
        this.drawIcon(graphics, (jCField.getModifiers() & 8) == 0 ? this.icons[8 + n] : this.icons[12 + n]);
        if (this.displayStaticWord && (jCField.getModifiers() & 8) != 0) {
            this.drawString(graphics, "static ", 29);
        }
        this.drawType(graphics, jCField.getType());
        this.drawString(graphics, " ");
        this.drawString(graphics, jCField.getName(), 8 + n);
    }

    protected void drawConstructor(Graphics graphics, JCConstructor jCConstructor) {
        int n = JavaCompletion.getLevel(jCConstructor.getModifiers());
        this.drawIcon(graphics, this.icons[16 + n]);
        this.drawString(graphics, jCConstructor.getClazz().getName(), 16 + n);
        this.drawParameterList(graphics, jCConstructor);
        this.drawExceptions(graphics, jCConstructor);
    }

    protected void drawMethod(Graphics graphics, JCMethod jCMethod) {
        int n = JavaCompletion.getLevel(jCMethod.getModifiers());
        this.drawIcon(graphics, (jCMethod.getModifiers() & 8) == 0 ? this.icons[20 + n] : this.icons[24 + n]);
        if (this.displayStaticWord && (jCMethod.getModifiers() & 8) != 0) {
            this.drawString(graphics, "static ", 29);
        }
        this.drawType(graphics, jCMethod.getReturnType());
        this.drawString(graphics, " ");
        this.drawString(graphics, jCMethod.getName(), 20 + n);
        this.drawParameterList(graphics, jCMethod);
        this.drawExceptions(graphics, jCMethod);
    }

    protected void draw(Graphics graphics) {
        if (this.value instanceof JCPackage) {
            this.drawPackage(graphics, (JCPackage)this.value);
        } else if (this.value instanceof JCClass) {
            this.drawClass(graphics, (JCClass)this.value);
        } else if (this.value instanceof JCField) {
            this.drawField(graphics, (JCField)this.value);
        } else if (this.value instanceof JCMethod) {
            this.drawMethod(graphics, (JCMethod)this.value);
        } else if (this.value instanceof JCConstructor) {
            this.drawConstructor(graphics, (JCConstructor)this.value);
        } else if (this.value instanceof JCParameter) {
            this.drawParameter(graphics, (JCParameter)this.value);
        } else {
            this.drawString(graphics, this.value.toString());
        }
    }

    public Dimension getPreferredSize() {
        this.draw(null);
        Insets insets = this.getInsets();
        if (insets != null) {
            this.drawX += insets.right;
        }
        return new Dimension(this.drawX, this.drawHeight);
    }

    public void paintComponent(Graphics graphics) {
        graphics.setColor(this.getBackground());
        Rectangle rectangle = graphics.getClipBounds();
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        this.draw(graphics);
    }

    public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
        if (bl) {
            this.setBackground(jList.getSelectionBackground());
            this.setForeground(jList.getSelectionForeground());
        } else {
            this.setBackground(jList.getBackground());
            this.setForeground(jList.getForeground());
        }
        this.list = jList;
        this.value = object;
        this.isSelected = bl;
        this.getAccessibleContext().setAccessibleName(this.value.toString());
        this.getAccessibleContext().setAccessibleDescription(this.value.toString());
        return this;
    }
}

