/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove;

import gnu.trove.SerializationProcedure;
import gnu.trove.TByteFunction;
import gnu.trove.TByteProcedure;
import gnu.trove.TObjectByteIterator;
import gnu.trove.TObjectByteProcedure;
import gnu.trove.TObjectHash;
import gnu.trove.TObjectHashingStrategy;
import gnu.trove.TObjectProcedure;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;

public class TObjectByteHashMap
extends TObjectHash
implements Serializable {
    static final long serialVersionUID = 1L;
    protected transient byte[] _values;

    public TObjectByteHashMap() {
    }

    public TObjectByteHashMap(int initialCapacity) {
        super(initialCapacity);
    }

    public TObjectByteHashMap(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    public TObjectByteHashMap(TObjectHashingStrategy strategy) {
        super(strategy);
    }

    public TObjectByteHashMap(int initialCapacity, TObjectHashingStrategy strategy) {
        super(initialCapacity, strategy);
    }

    public TObjectByteHashMap(int initialCapacity, float loadFactor, TObjectHashingStrategy strategy) {
        super(initialCapacity, loadFactor, strategy);
    }

    public TObjectByteIterator iterator() {
        return new TObjectByteIterator(this);
    }

    protected int setUp(int initialCapacity) {
        int capacity = super.setUp(initialCapacity);
        this._values = new byte[capacity];
        return capacity;
    }

    public byte put(Object key, byte value) {
        byte previous = 0;
        int index = this.insertionIndex(key);
        boolean isNewMapping = true;
        if (index < 0) {
            index = -index - 1;
            previous = this._values[index];
            isNewMapping = false;
        }
        Object oldKey = this._set[index];
        this._set[index] = key;
        this._values[index] = value;
        if (isNewMapping) {
            this.postInsertHook(oldKey == TObjectHash.FREE);
        }
        return previous;
    }

    protected void rehash(int newCapacity) {
        int oldCapacity = this._set.length;
        Object[] oldKeys = this._set;
        byte[] oldVals = this._values;
        this._set = new Object[newCapacity];
        Arrays.fill(this._set, TObjectHash.FREE);
        this._values = new byte[newCapacity];
        int i = oldCapacity;
        while (i-- > 0) {
            if (oldKeys[i] == TObjectHash.FREE || oldKeys[i] == TObjectHash.REMOVED) continue;
            Object o = oldKeys[i];
            int index = this.insertionIndex(o);
            if (index < 0) {
                this.throwObjectContractViolation(this._set[-index - 1], o);
            }
            this._set[index] = o;
            this._values[index] = oldVals[i];
        }
    }

    public byte get(Object key) {
        int index = this.index(key);
        return index < 0 ? (byte)0 : this._values[index];
    }

    public void clear() {
        super.clear();
        Object[] keys = this._set;
        byte[] vals = this._values;
        int i = keys.length;
        while (i-- > 0) {
            keys[i] = TObjectHash.FREE;
            vals[i] = 0;
        }
    }

    public byte remove(Object key) {
        byte prev = 0;
        int index = this.index(key);
        if (index >= 0) {
            prev = this._values[index];
            this.removeAt(index);
        }
        return prev;
    }

    public boolean equals(Object other) {
        if (!(other instanceof TObjectByteHashMap)) {
            return false;
        }
        TObjectByteHashMap that = (TObjectByteHashMap)other;
        if (that.size() != this.size()) {
            return false;
        }
        return this.forEachEntry(new EqProcedure(that));
    }

    protected void removeAt(int index) {
        super.removeAt(index);
        this._values[index] = 0;
    }

    public byte[] getValues() {
        byte[] vals = new byte[this.size()];
        byte[] v = this._values;
        Object[] keys = this._set;
        int i = v.length;
        int j = 0;
        while (i-- > 0) {
            if (keys[i] == TObjectHash.FREE || keys[i] == TObjectHash.REMOVED) continue;
            vals[j++] = v[i];
        }
        return vals;
    }

    public Object[] keys() {
        Object[] keys = new Object[this.size()];
        Object[] k = this._set;
        int i = k.length;
        int j = 0;
        while (i-- > 0) {
            if (k[i] == TObjectHash.FREE || k[i] == TObjectHash.REMOVED) continue;
            keys[j++] = k[i];
        }
        return keys;
    }

    public boolean containsValue(byte val) {
        Object[] keys = this._set;
        byte[] vals = this._values;
        int i = vals.length;
        while (i-- > 0) {
            if (keys[i] == TObjectHash.FREE || keys[i] == TObjectHash.REMOVED || val != vals[i]) continue;
            return true;
        }
        return false;
    }

    public boolean containsKey(Object key) {
        return this.contains(key);
    }

    public boolean forEachKey(TObjectProcedure procedure) {
        return this.forEach(procedure);
    }

    public boolean forEachValue(TByteProcedure procedure) {
        Object[] keys = this._set;
        byte[] values = this._values;
        int i = values.length;
        while (i-- > 0) {
            if (keys[i] == TObjectHash.FREE || keys[i] == TObjectHash.REMOVED || procedure.execute(values[i])) continue;
            return false;
        }
        return true;
    }

    public boolean forEachEntry(TObjectByteProcedure procedure) {
        Object[] keys = this._set;
        byte[] values = this._values;
        int i = keys.length;
        while (i-- > 0) {
            if (keys[i] == TObjectHash.FREE || keys[i] == TObjectHash.REMOVED || procedure.execute(keys[i], values[i])) continue;
            return false;
        }
        return true;
    }

    public boolean retainEntries(TObjectByteProcedure procedure) {
        boolean modified = false;
        Object[] keys = this._set;
        byte[] values = this._values;
        int i = keys.length;
        while (i-- > 0) {
            if (keys[i] == TObjectHash.FREE || keys[i] == TObjectHash.REMOVED || procedure.execute(keys[i], values[i])) continue;
            this.removeAt(i);
            modified = true;
        }
        return modified;
    }

    public void transformValues(TByteFunction function) {
        Object[] keys = this._set;
        byte[] values = this._values;
        int i = values.length;
        while (i-- > 0) {
            if (keys[i] == TObjectHash.FREE || keys[i] == TObjectHash.REMOVED) continue;
            values[i] = function.execute(values[i]);
        }
    }

    public boolean increment(Object key) {
        return this.adjustValue(key, (byte)1);
    }

    public boolean adjustValue(Object key, byte amount) {
        int index = this.index(key);
        if (index < 0) {
            return false;
        }
        int n = index;
        this._values[n] = (byte)(this._values[n] + amount);
        return true;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        stream.writeInt(this._size);
        SerializationProcedure writeProcedure = new SerializationProcedure(stream);
        if (!this.forEachEntry(writeProcedure)) {
            throw writeProcedure.exception;
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        int size = stream.readInt();
        this.setUp(size);
        while (size-- > 0) {
            Object key = stream.readObject();
            byte val = stream.readByte();
            this.put(key, val);
        }
    }

    private static final class EqProcedure
    implements TObjectByteProcedure {
        private final TObjectByteHashMap _otherMap;

        EqProcedure(TObjectByteHashMap otherMap) {
            this._otherMap = otherMap;
        }

        public final boolean execute(Object key, byte value) {
            int index = this._otherMap.index(key);
            return index >= 0 && this.eq(value, this._otherMap.get(key));
        }

        private final boolean eq(byte v1, byte v2) {
            return v1 == v2;
        }
    }
}

