/*
 * Decompiled with CFR 0.152.
 */
package com.gentleware.anvil.concurrent;

import com.gentleware.anvil.concurrent.ConcurrentLicenseCipherClient;
import com.gentleware.anvil.concurrent.ConcurrentLicenseCipherServer;
import com.gentleware.anvil.kernel.KeyManagerImpl;
import com.gentleware.anvil.kernel.keymodel.C;
import com.gentleware.anvil.kernel.keymodel.KeyType;
import com.gentleware.anvil.kernel.keymodel.LicenseKey;
import com.gentleware.anvil.kernel.keymodel.TagConcurrentKey;
import com.gentleware.anvil.kernel.utils.LicenseCipherClient;
import com.gentleware.anvil.kernel.utils.LicenseException;
import com.gentleware.anvil.kernel.utils.LicenseUtils;
import com.gentleware.openapi.util.CollectionFactory;
import com.gentleware.openapi.util.Strings;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.log4j.Logger;

public class ConcurrentKeyManagerImpl
extends KeyManagerImpl {
    private static final Logger C = Logger.getLogger((String)"com.gentleware.anvil.concurrent.ConcurrentKeyManagerImpl");
    public static final int INVALID_LEASE_LICENSE_ID = -1;
    private final Map D;
    private LicenseKey F;
    private static final long E = Long.MAX_VALUE;
    private boolean H;
    private static Class class$com$gentleware$anvil$concurrent$ConcurrentKeyManagerImpl;

    public ConcurrentKeyManagerImpl(String string) throws LicenseException {
        this(string, false);
    }

    public ConcurrentKeyManagerImpl(String string, boolean bl) throws LicenseException {
        super(string, ConcurrentLicenseCipherClient.getInstance());
        this.H = bl;
        this.D = CollectionFactory.createHashMap();
        this.readAndAddKeysFromDirectory();
        this.B();
    }

    public String getLicenseKeyRingFileName() {
        return "floating-license-keys2.txt";
    }

    public String getLogPrefix() {
        return "[ConcurrentKeyManager " + this._randomDebugId + " is connected with rmi port:" + this.H + "] ";
    }

    protected boolean isSerialNumber(LicenseKey licenseKey) {
        if (licenseKey.getType().equals(KeyType.LICENSE_KEY_CONTAINER)) {
            licenseKey = LicenseUtils.getConcurrentKey(licenseKey);
        }
        return super.isSerialNumber(licenseKey);
    }

    public void addKeys(LicenseKey[] licenseKeyArray) throws LicenseException {
        for (int i = 0; i < licenseKeyArray.length; ++i) {
            LicenseKey licenseKey = licenseKeyArray[i];
            this.addKey(licenseKey);
        }
    }

    public int getServerLeaseLicenseToLicenseContainerMapSize_TEST_ONLY() {
        return this.D.size();
    }

    private void B() {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            LicenseKey licenseKey = (LicenseKey)iterator.next();
            try {
                this.F(licenseKey);
            }
            catch (LicenseException licenseException) {
                C.error((Object)(this.getLogPrefix() + "Unexpected exception while filling lease-license-map."), (Throwable)licenseException);
            }
        }
    }

    public LicenseKey[] concatArrays(LicenseKey[] licenseKeyArray, LicenseKey[] licenseKeyArray2) {
        LicenseKey[] licenseKeyArray3 = new LicenseKey[licenseKeyArray.length + licenseKeyArray2.length];
        System.arraycopy(licenseKeyArray, 0, licenseKeyArray3, 0, licenseKeyArray.length);
        System.arraycopy(licenseKeyArray2, 0, licenseKeyArray3, licenseKeyArray.length, licenseKeyArray2.length);
        return licenseKeyArray3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LicenseKey getKey(long l) {
        Class clazz = class$com$gentleware$anvil$concurrent$ConcurrentKeyManagerImpl == null ? (class$com$gentleware$anvil$concurrent$ConcurrentKeyManagerImpl = ConcurrentKeyManagerImpl.A("com.gentleware.anvil.concurrent.ConcurrentKeyManagerImpl")) : class$com$gentleware$anvil$concurrent$ConcurrentKeyManagerImpl;
        synchronized (clazz) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                LicenseKey licenseKey = (LicenseKey)iterator.next();
                LicenseKey licenseKey2 = LicenseUtils.getConcurrentKey(licenseKey);
                long l2 = licenseKey2.getDbId();
                if (l != l2) continue;
                return licenseKey;
            }
        }
        return null;
    }

    public void removeKey(LicenseKey licenseKey) throws IOException {
        this.A(licenseKey);
        try {
            this.C(licenseKey);
        }
        catch (LicenseException licenseException) {
            C.error((Object)(this.getLogPrefix() + "Exception caught while removing lease-license-key."), (Throwable)licenseException);
        }
    }

    public void removeKeys(LicenseKey[] licenseKeyArray) throws IOException {
        for (int i = 0; i < licenseKeyArray.length; ++i) {
            LicenseKey licenseKey = licenseKeyArray[i];
            this.removeKey(licenseKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long lockLeaseLicense(LicenseKey licenseKey, long l) {
        LicenseKey licenseKey2;
        if (licenseKey == null) {
            C.error((Object)(this.getLogPrefix() + "Cannot lock license for invalid key."));
            return -1L;
        }
        KeyType keyType = licenseKey.getType();
        if (KeyType.LICENSE_KEY_CONTAINER.equals(keyType)) {
            licenseKey = LicenseUtils.getConcurrentKey(licenseKey);
        }
        if ((licenseKey2 = this.getLicenseKeyContainer(licenseKey)) == null) {
            C.error((Object)(this.getLogPrefix() + "Cannot lock license because container isn't valid."));
            return -1L;
        }
        String string = LicenseUtils.getApplicationName(licenseKey);
        String string2 = LicenseUtils.getModuleName(licenseKey);
        C.info((Object)(this.getLogPrefix() + "Trying to lock license for " + string + "/" + string2 + "..."));
        Class clazz = class$com$gentleware$anvil$concurrent$ConcurrentKeyManagerImpl == null ? (class$com$gentleware$anvil$concurrent$ConcurrentKeyManagerImpl = ConcurrentKeyManagerImpl.A("com.gentleware.anvil.concurrent.ConcurrentKeyManagerImpl")) : class$com$gentleware$anvil$concurrent$ConcurrentKeyManagerImpl;
        synchronized (clazz) {
            TreeMap treeMap = (TreeMap)LicenseUtils.getLentLeaseLicenseMap(licenseKey2);
            int n = treeMap.size();
            Long l2 = LicenseUtils.getConcurrentLicenseClientKeyCount(licenseKey);
            long l3 = l2;
            if ((long)n == l3) {
                C.info((Object)(this.getLogPrefix() + "Denied retrieval and locking of license because all available are used up."));
                return -1L;
            }
            long l4 = ConcurrentKeyManagerImpl.C(treeMap);
            if (-1L != l4) {
                treeMap.put(new Long(l4), new Long(l));
                try {
                    ConcurrentKeyManagerImpl.encryptFloatingLicenseKey(licenseKey2);
                }
                catch (LicenseException licenseException) {
                    C.error((Object)(this.getLogPrefix() + licenseException));
                }
                try {
                    this.saveKeys();
                }
                catch (IOException iOException) {
                    C.error((Object)(this.getLogPrefix() + "Unable to save keys."), (Throwable)iOException);
                }
                C.info((Object)(this.getLogPrefix() + "Successfully locked license with id: " + l4));
            } else {
                C.error((Object)(this.getLogPrefix() + "All possible lease-license-ids used up. Cannot generate further lease-licenses."));
            }
            return l4;
        }
    }

    private static long C(TreeMap treeMap) {
        long l;
        if (treeMap.isEmpty()) {
            l = 0L;
            C.info((Object)("All licenses returned. Resetting lease-license-id to " + l));
        } else {
            Long l2 = (Long)treeMap.lastKey();
            long l3 = l2;
            if (Long.MAX_VALUE == l3) {
                l = ConcurrentKeyManagerImpl.A(treeMap);
            } else {
                l = l3 + 1L;
                C.info((Object)("Retrieved next free lease-license-id: " + l));
            }
        }
        return l;
    }

    private static long A(TreeMap treeMap) {
        Long l = (Long)treeMap.firstKey();
        long l2 = l;
        long l3 = l2 == 0L ? ConcurrentKeyManagerImpl.B(treeMap) : l2 - 1L;
        return l3;
    }

    private static long B(TreeMap treeMap) {
        C.warn((Object)"Simple algorithm to create new lease-license-id failed. New calculation will be time-consuming. Restart server to avoid further problems.");
        long l = -1L;
        for (long i = 0L; i < Long.MAX_VALUE && l == -1L; ++i) {
            Long l2 = new Long(i);
            if (treeMap.containsKey(l2)) continue;
            l = i;
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unlockLicense(LicenseKey licenseKey, long l) {
        if (l == -1L) {
            C.info((Object)(this.getLogPrefix() + "Can't unlock license with leaseLicenseId: " + l));
            return false;
        }
        Class clazz = class$com$gentleware$anvil$concurrent$ConcurrentKeyManagerImpl == null ? (class$com$gentleware$anvil$concurrent$ConcurrentKeyManagerImpl = ConcurrentKeyManagerImpl.A("com.gentleware.anvil.concurrent.ConcurrentKeyManagerImpl")) : class$com$gentleware$anvil$concurrent$ConcurrentKeyManagerImpl;
        synchronized (clazz) {
            Long l2;
            LicenseKey licenseKey2 = this.getLicenseKeyContainer(licenseKey);
            if (licenseKey2 == null) {
                C.error((Object)(this.getLogPrefix() + "Can't unlock license, because key container is null"));
                return false;
            }
            TreeMap treeMap = (TreeMap)LicenseUtils.getLentLeaseLicenseMap(licenseKey2);
            Long l3 = (Long)treeMap.remove(l2 = new Long(l));
            if (l3 == null) {
                C.info((Object)(this.getLogPrefix() + "Can't unlock license with leaseLicenseId: " + l));
                return false;
            }
            try {
                ConcurrentKeyManagerImpl.encryptFloatingLicenseKey(licenseKey2);
                C.info((Object)(this.getLogPrefix() + "Successfully unlocked (returned) license with id: " + l));
            }
            catch (LicenseException licenseException) {
                C.error((Object)(this.getLogPrefix() + licenseException));
            }
            try {
                this.saveKeys();
            }
            catch (IOException iOException) {
                C.error((Object)(this.getLogPrefix() + "Unable to save keys."), (Throwable)iOException);
            }
            return true;
        }
    }

    private static LicenseKey E(LicenseKey licenseKey) {
        if (licenseKey == null) {
            return null;
        }
        KeyType keyType = licenseKey.getType();
        LicenseKey licenseKey2 = KeyType.LICENSE_KEY_CONTAINER.equals(keyType) ? LicenseUtils.getConcurrentKey(licenseKey) : licenseKey;
        return licenseKey2;
    }

    private static LicenseKey I(LicenseKey licenseKey) throws LicenseException {
        return LicenseUtils.getOrCreateLicenseKeyContainer(licenseKey);
    }

    private static LicenseKey H(LicenseKey licenseKey) throws LicenseException {
        return LicenseUtils.getOrCreateLicenseKeyContainer(licenseKey);
    }

    public LicenseKey getLicenseKeyContainer(LicenseKey licenseKey) {
        LicenseKey licenseKey2 = ConcurrentKeyManagerImpl.E(licenseKey);
        LicenseKey licenseKey3 = (LicenseKey)this.D.get(licenseKey2);
        return licenseKey3;
    }

    private LicenseKey A(LicenseKey licenseKey) {
        LicenseKey licenseKey2 = ConcurrentKeyManagerImpl.E(licenseKey);
        LicenseKey licenseKey3 = (LicenseKey)this.D.remove(licenseKey2);
        return licenseKey3;
    }

    private void F(LicenseKey licenseKey) throws LicenseException {
        if (null != licenseKey) {
            LicenseKey licenseKey2 = ConcurrentKeyManagerImpl.E(licenseKey);
            LicenseKey licenseKey3 = ConcurrentKeyManagerImpl.I(licenseKey);
            this.D.put(licenseKey2, licenseKey3);
            this.F = licenseKey2;
        }
    }

    private boolean D(LicenseKey licenseKey) throws IllegalStateException {
        boolean bl = false;
        if (licenseKey == null) {
            return false;
        }
        KeyType keyType = licenseKey.getType();
        ConcurrentKeyManagerImpl.A(keyType);
        try {
            boolean bl2 = this.B(licenseKey);
            if (bl2) {
                C.error((Object)(this.getLogPrefix() + "Cannot add key because key with same Id already exists."));
                return false;
            }
        }
        catch (IOException iOException) {
            C.error((Object)(this.getLogPrefix() + "Unable to replace serial key with final key. Perhaps the license-key-file is write-protected?"), (Throwable)iOException);
            return false;
        }
        super.addKeyImpl(licenseKey);
        try {
            this.saveKeys();
        }
        catch (IOException iOException) {
            C.error((Object)(this.getLogPrefix() + "Unable to save keys."), (Throwable)iOException);
            return false;
        }
        return true;
    }

    private static void A(KeyType keyType) {
        if (!keyType.equals(KeyType.LICENSE_KEY_CONTAINER)) {
            throw new IllegalArgumentException("LicenseKey is not of type LICENSE_KEY_CONTAINER");
        }
    }

    private boolean B(LicenseKey licenseKey) throws IOException {
        boolean bl;
        LicenseKey[] licenseKeyArray;
        LicenseKey licenseKey2 = LicenseUtils.getConcurrentKey(licenseKey);
        KeyType keyType = licenseKey2.getType();
        List list = CollectionFactory.createArrayList();
        Iterator iterator = this._keys.iterator();
        long l = licenseKey2.getSerialNoDbId();
        long l2 = licenseKey2.getDbId();
        boolean bl2 = false;
        while (iterator.hasNext() && !bl2) {
            String string;
            TagConcurrentKey tagConcurrentKey;
            LicenseKey licenseKey3 = (LicenseKey)iterator.next();
            licenseKeyArray = LicenseUtils.getConcurrentKey(licenseKey3);
            if (licenseKeyArray == null) {
                throw new IllegalStateException("LicenseKeyContainer should contain a license key.");
            }
            long l3 = licenseKeyArray.getDbId();
            long l4 = licenseKeyArray.getSerialNoDbId();
            if (KeyType.SERIAL_NUMBER.equals(keyType) && (tagConcurrentKey = (TagConcurrentKey)licenseKey2.getTag(com.gentleware.anvil.kernel.keymodel.C.d)) != null && !Strings.isEmpty((String)(string = LicenseUtils.getConcurrentClientKeyAsString(tagConcurrentKey)))) {
                try {
                    LicenseKey licenseKey4 = LicenseCipherClient.getInstance().decryptKeyFromServer(string);
                    if (licenseKey4 != null) {
                        long l5 = licenseKey4.getDbId();
                        if (l4 != 0L) {
                            bl2 |= l4 == l5;
                        }
                    }
                }
                catch (LicenseException licenseException) {
                    C.error((Object)(this.getLogPrefix() + "The serial does not contain a valid ConcurrentKey "), (Throwable)licenseException);
                }
            }
            if ((bl2 |= l3 == l2) || !KeyType.SERVER_CONCURRENT.equals(keyType)) continue;
            ConcurrentKeyManagerImpl.A(list, l, licenseKey3);
        }
        boolean bl3 = bl = !list.isEmpty();
        if (bl) {
            licenseKeyArray = list.toArray(new LicenseKey[0]);
            this.removeKeys(licenseKeyArray);
        }
        return bl2;
    }

    private static void A(List list, long l, LicenseKey licenseKey) {
        LicenseKey licenseKey2 = LicenseUtils.getConcurrentKey(licenseKey);
        KeyType keyType = licenseKey2.getType();
        boolean bl = KeyType.SERIAL_NUMBER.equals(keyType);
        if (bl) {
            boolean bl2;
            long l2 = ConcurrentKeyManagerImpl.G(licenseKey2);
            boolean bl3 = bl2 = l2 == l;
            if (bl2) {
                list.add(licenseKey);
            }
        }
    }

    private static long G(LicenseKey licenseKey) {
        long l;
        if (LicenseUtils.isConcurrentLicense(licenseKey)) {
            LicenseKey licenseKey2 = LicenseUtils.getConcurrentKey(licenseKey);
            l = licenseKey2.getDbId();
        } else {
            l = licenseKey.getDbId();
        }
        return l;
    }

    private void C(LicenseKey licenseKey) throws LicenseException, IOException {
        if (licenseKey != null) {
            LicenseKey licenseKey2 = ConcurrentKeyManagerImpl.H(licenseKey);
            super.removeKey(licenseKey2);
        }
    }

    public static void encryptFloatingLicenseKey(LicenseKey licenseKey) throws LicenseException {
        String string = ConcurrentLicenseCipherServer.getInstance().encryptLeaseLicense(licenseKey);
        licenseKey.setRsaAscii(string);
    }

    public boolean addKey(LicenseKey licenseKey) throws LicenseException {
        if (licenseKey == null) {
            return false;
        }
        LicenseKey licenseKey2 = LicenseUtils.getOrCreateLicenseKeyContainer(licenseKey);
        boolean bl = this.D(licenseKey2);
        if (bl) {
            this.F(licenseKey2);
        }
        return bl;
    }

    public boolean containsKey(LicenseKey licenseKey) {
        boolean bl = false;
        try {
            LicenseKey licenseKey2 = LicenseUtils.getOrCreateLicenseKeyContainer(licenseKey);
            bl = super.containsKey(licenseKey2);
        }
        catch (LicenseException licenseException) {
            C.error((Object)(this.getLogPrefix() + "Exception caught while checking existance of license key."), (Throwable)licenseException);
        }
        return bl;
    }

    public void removeAllKeys() throws IOException {
        super.removeAllKeys();
        this.saveKeys();
        this.D.clear();
    }

    public LicenseKey getLastAddedLicenseKey() {
        return this.F;
    }

    int availableLeaseLicenseCount(LicenseKey licenseKey) {
        LicenseKey licenseKey2 = this.getLicenseKeyContainer(licenseKey);
        int n = LicenseUtils.getAvailableLeaseLicenseCountFromContainer(licenseKey2);
        return n;
    }

    public String[] getLicenseDescriptions() {
        String[] stringArray;
        boolean bl = this._keys.isEmpty();
        if (bl) {
            return new String[]{"No licenses available."};
        }
        Iterator iterator = this._keys.iterator();
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>(this._keys.size());
        int n = 0;
        while (iterator.hasNext()) {
            String string;
            stringArray = (String[])iterator.next();
            String string2 = string = LicenseUtils.getLicenseKeyDescription((LicenseKey)stringArray);
            String string3 = LicenseUtils.getConcurrentLicenseKeyCountInformation((LicenseKey)stringArray);
            linkedHashMap.put(++n + ". " + string2, string3);
        }
        stringArray = Strings.getPaddedKeyValueList(linkedHashMap, (char)'.', (boolean)false, (boolean)false);
        return stringArray;
    }

    private static Class A(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }
}

