/*
 * Decompiled with CFR 0.152.
 */
package com.gentleware.anvil.kernel;

import com.gentleware.anvil.kernel.F;
import com.gentleware.anvil.kernel.KeyManager;
import com.gentleware.anvil.kernel.LicenseData;
import com.gentleware.anvil.kernel.ProductEditionImpl;
import com.gentleware.anvil.kernel.ProductImpl;
import com.gentleware.anvil.kernel.keymodel.KeyType;
import com.gentleware.anvil.kernel.keymodel.LicenseKey;
import com.gentleware.anvil.kernel.utils.LicenseCipher;
import com.gentleware.anvil.kernel.utils.LicenseException;
import com.gentleware.anvil.kernel.utils.LicenseUtils;
import com.gentleware.openapi.util.CollectionFactory;
import com.gentleware.openapi.util.Files;
import com.gentleware.openapi.util.ProductVersion;
import com.gentleware.openapi.util.Strings;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public abstract class KeyManagerImpl
implements KeyManager {
    private static final Logger B = Logger.getLogger((String)"com.gentleware.anvil.kernel.KeyManagerImpl");
    protected static final String SINGLE_USER_LICENSE_FILE_NAME = "license-keys.txt";
    protected static final String CONCURRENT_LICENSE_RING_FILE_NAME = "floating-license-keys2.txt";
    protected String _configurationDirectory;
    protected List _keys = CollectionFactory.createArrayList();
    protected List _listeners = CollectionFactory.createArrayList();
    protected LicenseCipher _licenseCipher;
    private static final String A = Strings.repeat((char)'-', (int)60);
    protected int _randomDebugId = new Double(Math.random() * 1000.0).intValue();

    public abstract String getLicenseKeyRingFileName();

    public abstract String getLogPrefix();

    public KeyManagerImpl() {
    }

    public KeyManagerImpl(String string, LicenseCipher licenseCipher) {
        this._configurationDirectory = string;
        B.debug((Object)"");
        B.debug((Object)(this.getLogPrefix() + "Configuration directory of Key Manager is " + this._configurationDirectory));
        B.debug((Object)"");
        this._licenseCipher = licenseCipher;
    }

    public void restoreCeKey() throws IOException, LicenseException {
    }

    public String getConfigurationDirectory() {
        return this._configurationDirectory;
    }

    public static String[] getAllLicensesFileNames() {
        return new String[]{SINGLE_USER_LICENSE_FILE_NAME, CONCURRENT_LICENSE_RING_FILE_NAME};
    }

    public static String getSingleUserLicenseFileName() {
        return SINGLE_USER_LICENSE_FILE_NAME;
    }

    public static LicenseKey[] readKeyRing(LicenseCipher licenseCipher, File file) throws IOException, LicenseException {
        Object[] objectArray;
        List list = CollectionFactory.createArrayList();
        if (file.exists()) {
            objectArray = Files.readFile((File)file);
            String string = Strings.createStringFromAsciiBytes((byte[])objectArray);
            list = KeyManagerImpl.tokenizeKeyStringToKeys(licenseCipher, string);
        }
        objectArray = list.toArray(new LicenseKey[list.size()]);
        return objectArray;
    }

    protected static List tokenizeKeyStringToKeys(LicenseCipher licenseCipher, String string) throws LicenseException {
        List list = CollectionFactory.createArrayList();
        StringTokenizer stringTokenizer = new StringTokenizer(string, A);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            if (Strings.isEmpty((String)string2)) continue;
            LicenseKey licenseKey = licenseCipher.decryptRsa(string2);
            list.add(licenseKey);
        }
        return list;
    }

    private void A(File file, LicenseKey[] licenseKeyArray) throws IOException {
        File file2 = file.getParentFile();
        String string = KeyManagerImpl.A(licenseKeyArray);
        if (!file.exists()) {
            file2.mkdirs();
            B.info((Object)(this.getLogPrefix() + " Creating new license-key-file at " + file.getAbsolutePath()));
            file.createNewFile();
        }
        byte[] byArray = Strings.getAsciiBytes((String)string);
        try {
            Files.writeFile((File)file, (byte[])byArray);
        }
        catch (IOException iOException) {
            B.error((Object)(this.getLogPrefix() + " Error while saving license-keys to " + file.getAbsolutePath()), (Throwable)iOException);
            throw iOException;
        }
    }

    private static String A(LicenseKey[] licenseKeyArray) {
        String string = "";
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < licenseKeyArray.length; ++i) {
            stringBuffer.append(string);
            LicenseKey licenseKey = licenseKeyArray[i];
            String string2 = licenseKey.getRsaAscii();
            if (Strings.isEmpty((String)string2)) {
                B.error((Object)" Cannot save key that is not encrypted by server!");
                continue;
            }
            stringBuffer.append(string2);
            string = A;
        }
        String string3 = new String(stringBuffer);
        return string3;
    }

    public LicenseKey getKey(int n) {
        int n2 = this._keys.size();
        if (n < 0 || n >= n2) {
            return null;
        }
        return (LicenseKey)this._keys.get(n);
    }

    public void removeKey(LicenseKey licenseKey) throws IOException {
        this.removeKeyImpl(licenseKey);
        this.saveKeys();
    }

    public void removeKeys(LicenseKey[] licenseKeyArray) throws IOException {
        for (int i = 0; i < licenseKeyArray.length; ++i) {
            this.removeKeyImpl(licenseKeyArray[i]);
        }
        this.saveKeys();
    }

    protected void removeKeyImpl(LicenseKey licenseKey) {
        int n = this._keys.size();
        int n2 = this._keys.indexOf(licenseKey);
        boolean bl = false;
        if (n2 >= 0) {
            this.A(n2, false);
            bl = this._keys.remove(licenseKey);
        }
        B.debug((Object)"");
        B.debug((Object)(this.getLogPrefix() + " Key Manager removes key: " + licenseKey + " from index: " + n2 + " internal list with size before: " + n + ". Sucessful? " + bl));
        B.debug((Object)"");
    }

    private void A(int n, boolean bl) {
        Iterator iterator = this._listeners.iterator();
        while (iterator.hasNext()) {
            KeyManager.KeyManagerListener keyManagerListener = (KeyManager.KeyManagerListener)iterator.next();
            if (bl) {
                keyManagerListener.keyAdded(n);
                continue;
            }
            keyManagerListener.keyWillBeRemoved(n);
        }
    }

    protected void saveKeysImpl() throws IOException {
        String string = this.getLicenseKeyRingFileName();
        File file = new File(this._configurationDirectory, string);
        int n = this._keys.size();
        LicenseKey[] licenseKeyArray = this._keys.toArray(new LicenseKey[n]);
        this.A(file, licenseKeyArray);
    }

    public synchronized void saveKeys() throws IOException {
        try {
            this.saveKeysImpl();
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            B.fatal((Object)(this.getLogPrefix() + " Illegal Key operation: save keys stopped"), (Throwable)exception);
            System.exit(0);
        }
    }

    public boolean containsKey(LicenseKey licenseKey) {
        boolean bl = this._keys.contains(licenseKey);
        return bl;
    }

    public boolean isLicensed(LicenseData licenseData) {
        for (int i = 0; i < this._keys.size(); ++i) {
            LicenseKey licenseKey = (LicenseKey)this._keys.get(i);
            if (!licenseKey.isValidFor(licenseData)) continue;
            return true;
        }
        return false;
    }

    private LicenseKey[] A() {
        List list = CollectionFactory.createArrayList();
        for (int i = 0; i < this._keys.size(); ++i) {
            LicenseKey licenseKey = (LicenseKey)this._keys.get(i);
            if (!this.isSerialNumber(licenseKey)) continue;
            list.add(licenseKey);
        }
        return list.toArray(new LicenseKey[list.size()]);
    }

    protected boolean isSerialNumber(LicenseKey licenseKey) {
        return licenseKey.getType() == KeyType.SERIAL_NUMBER;
    }

    public LicenseKey[] getEvaluationKeys() {
        List list = CollectionFactory.createArrayList();
        for (int i = 0; i < this._keys.size(); ++i) {
            LicenseKey licenseKey = (LicenseKey)this._keys.get(i);
            if (licenseKey.getType() != KeyType.EVALUATION) continue;
            list.add(licenseKey);
        }
        return list.toArray(new LicenseKey[list.size()]);
    }

    public boolean hasAnySerialNumber() {
        return this.A().length > 0;
    }

    protected boolean addKeyImpl(LicenseKey licenseKey) {
        int n = this._keys.size();
        boolean bl = true;
        try {
            this._keys.add(0, licenseKey);
            this.A(0, true);
        }
        catch (Exception exception) {
            bl = false;
        }
        B.debug((Object)"");
        B.debug((Object)(this.getLogPrefix() + " Key Manager adds key: " + licenseKey + " to internal list with size before: " + n + ". Successful? " + bl));
        B.debug((Object)"");
        return bl;
    }

    public int size() {
        return this._keys.size();
    }

    public void removeAllKeys() throws IOException {
        this._keys.clear();
        B.debug((Object)"");
        B.debug((Object)(this.getLogPrefix() + " Key Manager clears all keys"));
        B.debug((Object)"");
        this.saveKeys();
    }

    public Iterator iterator() {
        return this._keys.iterator();
    }

    public Collection getKeys() {
        return Collections.unmodifiableCollection(this._keys);
    }

    protected void readAndAddKeysFromDirectory() {
        String string = this.getLicenseKeyRingFileName();
        File file = new File(this._configurationDirectory, string);
        try {
            LicenseKey[] licenseKeyArray = KeyManagerImpl.readKeyRing(this._licenseCipher, file);
            B.info((Object)(this.getLogPrefix() + " " + this.getLogPrefix() + "Read license-keys from: " + file.getAbsolutePath()));
            this.addKeys(licenseKeyArray);
        }
        catch (Exception exception) {
            B.error((Object)(this.getLogPrefix() + " Error while adding keys from license-key file: " + file.getAbsolutePath()), (Throwable)exception);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this._keys.iterator();
        while (iterator.hasNext()) {
            LicenseKey licenseKey = (LicenseKey)iterator.next();
            this.appendLicenseKeyStringToBuffer(licenseKey, stringBuffer);
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    protected void appendLicenseKeyStringToBuffer(LicenseKey licenseKey, StringBuffer stringBuffer) {
        String string = LicenseUtils.getLicenseKeyDescription(licenseKey);
        stringBuffer.append(string);
    }

    public void addListener(KeyManager.KeyManagerListener keyManagerListener) {
        if (!this._listeners.contains(keyManagerListener)) {
            this._listeners.add(keyManagerListener);
        }
    }

    public boolean removeListener(KeyManager.KeyManagerListener keyManagerListener) {
        return this._listeners.remove(keyManagerListener);
    }

    public static boolean areKeysAchievingUpdateRequirements(LicenseKey[] licenseKeyArray, F f) {
        boolean bl = false;
        for (int i = 0; i < licenseKeyArray.length; ++i) {
            LicenseKey licenseKey = licenseKeyArray[i];
            bl = KeyManagerImpl.isKeyAchievingUpdateRequirements(licenseKey, f);
            if (!bl) continue;
            return bl;
        }
        return bl;
    }

    public static boolean isKeyAchievingUpdateRequirements(LicenseKey licenseKey, F f) {
        boolean bl;
        String string;
        if (licenseKey.getType().equals(KeyType.LICENSE_KEY_CONTAINER)) {
            LicenseKey licenseKey2 = LicenseUtils.getConcurrentKey(licenseKey);
            return KeyManagerImpl.isKeyAchievingUpdateRequirements(licenseKey2, f);
        }
        boolean bl2 = f.B();
        if (bl2 && !LicenseUtils.isConcurrentLicense(licenseKey) || !bl2 && LicenseUtils.isConcurrentLicense(licenseKey)) {
            return false;
        }
        if (LicenseUtils.isConcurrentLicense(licenseKey)) {
            licenseKey = LicenseUtils.getConcurrentKey(licenseKey);
        }
        if (ProductImpl.isModule(string = LicenseUtils.getModuleName(licenseKey))) {
            return false;
        }
        String string2 = f.C();
        String string3 = f.D();
        Integer n = f.A();
        ProductImpl productImpl = new ProductImpl(string2, ProductEditionImpl.get(string3), ProductVersion.createProductVersion((Integer)n, null, null, null));
        boolean bl3 = licenseKey.isValidForApplication(productImpl);
        boolean bl4 = bl = licenseKey.getType() == KeyType.SERIAL_NUMBER || licenseKey.getType() == KeyType.FINAL || licenseKey.getType() == KeyType.SERVER_CONCURRENT || licenseKey.getType() == KeyType.CLIENT_FLOATING;
        if (!bl3 || !bl) {
            return false;
        }
        boolean bl5 = LicenseUtils.applicationEditionContainsEditionShort(licenseKey, string3);
        return bl5;
    }

    public boolean hasExpiredFinalKey() {
        boolean bl = false;
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            boolean bl2;
            LicenseKey licenseKey = (LicenseKey)iterator.next();
            Date date = LicenseUtils.getExpirationDate(licenseKey);
            if (date == null || !(bl2 = new Date().after(date))) continue;
            bl = true;
            break;
        }
        return bl;
    }
}

