/*
 * Decompiled with CFR 0.152.
 */
package com.gentleware.anvil.kernel.keymodel;

import com.gentleware.anvil.kernel.utils.LicenseUtils;
import java.net.InetAddress;

public class IpRange {
    private Long B;
    private InetAddress A;
    private InetAddress C;

    public IpRange() {
    }

    public IpRange(InetAddress inetAddress) {
        this.A = inetAddress;
        this.C = null;
    }

    public IpRange(InetAddress inetAddress, InetAddress inetAddress2) {
        this.A = inetAddress;
        this.C = inetAddress2;
    }

    public Long getId() {
        return this.B;
    }

    private void A(Long l) {
        this.B = l;
    }

    public InetAddress getIp() {
        return this.A;
    }

    public void setIp(InetAddress inetAddress) {
        this.A = inetAddress;
    }

    public InetAddress getMask() {
        return this.C;
    }

    public void setMask(InetAddress inetAddress) {
        this.C = inetAddress;
    }

    public String getIpText() {
        return this.A != null ? this.A.getHostAddress() : null;
    }

    public void setIpText(String string) {
        this.A = string != null ? LicenseUtils.text2Ip(string) : null;
    }

    public String getMaskText() {
        return this.C != null ? this.C.getHostAddress() : null;
    }

    public void setMaskText(String string) {
        this.C = string != null ? LicenseUtils.text2Ip(string) : null;
    }

    public boolean match(InetAddress inetAddress) {
        byte[] byArray = this.A.getAddress();
        byte[] byArray2 = this.C != null ? this.C.getAddress() : null;
        byte[] byArray3 = inetAddress.getAddress();
        if (byArray.length != byArray3.length) {
            return false;
        }
        for (int i = 0; i < byArray3.length; ++i) {
            int n;
            byte by = byArray3[i];
            byte by2 = byArray[i];
            int n2 = n = byArray2 != null ? byArray2[i] : -1;
            if ((by & n) == (by2 & n)) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof IpRange)) {
            return false;
        }
        IpRange ipRange = (IpRange)object;
        if (!this.A.equals(ipRange.A)) {
            return false;
        }
        return !(this.C != null ? !this.C.equals(ipRange.C) : ipRange.C != null);
    }

    public int hashCode() {
        int n = this.A.hashCode();
        n = 29 * n + (this.C != null ? this.C.hashCode() : 0);
        return n;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.A.getHostAddress());
        if (this.C != null) {
            stringBuffer.append('(');
            stringBuffer.append(this.C.getHostAddress());
            stringBuffer.append(')');
        }
        return new String(stringBuffer);
    }

    public static String toString(IpRange[] ipRangeArray) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = "";
        for (int i = 0; i < ipRangeArray.length; ++i) {
            IpRange ipRange = ipRangeArray[i];
            stringBuffer.append(string);
            stringBuffer.append(ipRange);
            string = ", ";
        }
        return new String(stringBuffer);
    }
}

