/*
 * Decompiled with CFR 0.152.
 */
package com.gentleware.anvil.kernel.keymodel;

import com.gentleware.anvil.kernel.Machine;
import com.gentleware.anvil.kernel.keymodel.C;
import com.gentleware.anvil.kernel.keymodel.IpRange;
import com.gentleware.anvil.kernel.keymodel.LicenseTag;
import com.gentleware.anvil.kernel.utils.B;
import com.gentleware.anvil.kernel.utils.LicenseUtils;
import java.net.InetAddress;

public class TagMachineIp
extends LicenseTag {
    final IpRange[] _ipRanges;

    public TagMachineIp(String string) {
        this(0L, string);
    }

    public TagMachineIp(long l, String string) {
        super(C.D, l);
        InetAddress inetAddress = LicenseUtils.text2Ip(string);
        this._ipRanges = new IpRange[]{new IpRange(inetAddress)};
    }

    public TagMachineIp(IpRange[] ipRangeArray) {
        this(0L, ipRangeArray);
    }

    public TagMachineIp(long l, IpRange[] ipRangeArray) {
        super(C.D, l);
        this._ipRanges = ipRangeArray;
    }

    public IpRange[] getIpRanges() {
        return this._ipRanges;
    }

    public String getFirstIp() {
        InetAddress inetAddress = this._ipRanges[0].getIp();
        String string = inetAddress.getHostAddress();
        return string;
    }

    public void addData(B b) {
        b.A((long)this._ipRanges.length);
        for (int i = 0; i < this._ipRanges.length; ++i) {
            IpRange ipRange = this._ipRanges[i];
            InetAddress inetAddress = ipRange.getIp();
            b.B(inetAddress.getAddress());
            InetAddress inetAddress2 = ipRange.getMask();
            b.B(inetAddress2 != null ? inetAddress2.getAddress() : new byte[]{});
        }
    }

    public boolean isValidForMachine(Machine machine) {
        String string = machine.getIp();
        InetAddress inetAddress = LicenseUtils.text2Ip(string);
        for (int i = 0; i < this._ipRanges.length; ++i) {
            IpRange ipRange = this._ipRanges[i];
            if (!ipRange.match(inetAddress)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Tag: " + this.getClass().getName() + "\n");
        stringBuffer.append("IpRanges:\n" + IpRange.toString(this._ipRanges));
        return stringBuffer.toString();
    }

    protected void fillHtmlWithValue(StringBuffer stringBuffer, String string) {
        stringBuffer.append("\n");
        stringBuffer.append(string);
        stringBuffer.append("<dl>\n");
        stringBuffer.append(string);
        stringBuffer.append("\t<dt>IpRanges:</dt>\n");
        stringBuffer.append(string);
        stringBuffer.append("\t<dd>");
        stringBuffer.append(IpRange.toString(this._ipRanges));
        stringBuffer.append("</dd>\n");
        stringBuffer.append(string);
        stringBuffer.append("</dl>\n");
    }

    public static class _A
    extends LicenseTag._A {
        public LicenseTag A(long l, B b) {
            B._A _A2 = b.A(4096);
            int n = (int)_A2.G();
            if (n > 1000) {
                throw new IllegalStateException();
            }
            IpRange[] ipRangeArray = new IpRange[n];
            for (int i = 0; i < ipRangeArray.length; ++i) {
                IpRange ipRange;
                byte[] byArray = _A2.F();
                InetAddress inetAddress = LicenseUtils.address2Ip(byArray);
                byte[] byArray2 = _A2.F();
                InetAddress inetAddress2 = byArray2.length == 0 ? null : LicenseUtils.address2Ip(byArray2);
                ipRangeArray[i] = ipRange = new IpRange(inetAddress, inetAddress2);
            }
            TagMachineIp tagMachineIp = new TagMachineIp(l, ipRangeArray);
            return tagMachineIp;
        }
    }
}

