/*
 * Decompiled with CFR 0.152.
 */
package com.gentleware.anvil.kernel.utils;

import com.gentleware.anvil.concurrent.ConcurrentKeyManagerImpl;
import com.gentleware.anvil.kernel.Customer;
import com.gentleware.anvil.kernel.F;
import com.gentleware.anvil.kernel.Machine;
import com.gentleware.anvil.kernel.PostalAddress;
import com.gentleware.anvil.kernel.ProductEditionImpl;
import com.gentleware.anvil.kernel.ProductImpl;
import com.gentleware.anvil.kernel.keymodel.C;
import com.gentleware.anvil.kernel.keymodel.D;
import com.gentleware.anvil.kernel.keymodel.G;
import com.gentleware.anvil.kernel.keymodel.I;
import com.gentleware.anvil.kernel.keymodel.IpRange;
import com.gentleware.anvil.kernel.keymodel.KeyType;
import com.gentleware.anvil.kernel.keymodel.LicenseKey;
import com.gentleware.anvil.kernel.keymodel.LicenseTag;
import com.gentleware.anvil.kernel.keymodel.TagAdditionalConcurrentLicenseInformation;
import com.gentleware.anvil.kernel.keymodel.TagApplicationBetaVersion;
import com.gentleware.anvil.kernel.keymodel.TagApplicationEdition;
import com.gentleware.anvil.kernel.keymodel.TagApplicationMajorVersion;
import com.gentleware.anvil.kernel.keymodel.TagApplicationMicroVersion;
import com.gentleware.anvil.kernel.keymodel.TagApplicationMinorVersion;
import com.gentleware.anvil.kernel.keymodel.TagApplicationName;
import com.gentleware.anvil.kernel.keymodel.TagConcurrentKey;
import com.gentleware.anvil.kernel.keymodel.TagConcurrentLicenseCount;
import com.gentleware.anvil.kernel.keymodel.TagConcurrentServerKeyId;
import com.gentleware.anvil.kernel.keymodel.TagCreationDate;
import com.gentleware.anvil.kernel.keymodel.TagExpirationDate;
import com.gentleware.anvil.kernel.keymodel.TagLeaseLicenseMaxPeriodInMs;
import com.gentleware.anvil.kernel.keymodel.TagMachineDomain;
import com.gentleware.anvil.kernel.keymodel.TagMachineHostName;
import com.gentleware.anvil.kernel.keymodel.TagMachineIp;
import com.gentleware.anvil.kernel.keymodel.TagMachineOsName;
import com.gentleware.anvil.kernel.keymodel.TagMachineOsVersion;
import com.gentleware.anvil.kernel.keymodel.TagModuleBetaVersion;
import com.gentleware.anvil.kernel.keymodel.TagModuleEdition;
import com.gentleware.anvil.kernel.keymodel.TagModuleMajorVersion;
import com.gentleware.anvil.kernel.keymodel.TagModuleMicroVersion;
import com.gentleware.anvil.kernel.keymodel.TagModuleMinorVersion;
import com.gentleware.anvil.kernel.keymodel.TagModuleName;
import com.gentleware.anvil.kernel.keymodel.TagSubscribe;
import com.gentleware.anvil.kernel.keymodel.TagUpdateMajorVersion;
import com.gentleware.anvil.kernel.keymodel.TagUpdateRequirements;
import com.gentleware.anvil.kernel.keymodel.TagUserCompany;
import com.gentleware.anvil.kernel.keymodel.TagUserCountry;
import com.gentleware.anvil.kernel.keymodel.TagUserEmail;
import com.gentleware.anvil.kernel.keymodel.TagUserFirstName;
import com.gentleware.anvil.kernel.keymodel.TagUserLastName;
import com.gentleware.anvil.kernel.keymodel.TagUserSalutation;
import com.gentleware.anvil.kernel.utils.LicenseCipherClient;
import com.gentleware.anvil.kernel.utils.LicenseException;
import com.gentleware.openapi.util.Base64Codec;
import com.gentleware.openapi.util.CollectionFactory;
import com.gentleware.openapi.util.Product;
import com.gentleware.openapi.util.ProductEdition;
import com.gentleware.openapi.util.ProductVersion;
import com.gentleware.openapi.util.Strings;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.log4j.Logger;

public class LicenseUtils {
    private static final Logger C = Logger.getLogger((String)"com.gentleware.anvil.kernel.utils.LicenseUtils");
    private static final int E = 12282;
    private static int B = 86400000;
    public static final int CUSTOMER_DATA_FULL = 1;
    public static final int CUSTOMER_DATA_NAME_EMAIL = 2;
    public static final int CUSTOMER_DATA_NONE = 3;
    private static Class A;
    private static Class D;

    private LicenseUtils() {
    }

    public static InetAddress getLocalInetAddress() {
        try {
            return InetAddress.getLocalHost();
        }
        catch (UnknownHostException unknownHostException) {
            C.error((Object)unknownHostException);
            InetAddress inetAddress = null;
            InetAddress inetAddress2 = null;
            try {
                inetAddress2 = InetAddress.getByAddress(new byte[]{127, 0, 0, 1});
            }
            catch (UnknownHostException unknownHostException2) {
                C.error((Object)unknownHostException2);
            }
            InetAddress[] inetAddressArray = LicenseUtils.getAllLocalInetAdresses();
            for (int i = 0; i < inetAddressArray.length; ++i) {
                InetAddress inetAddress3 = inetAddressArray[i];
                if (inetAddress3.equals(inetAddress2)) continue;
                if (inetAddress3.getAddress().length == 16) {
                    if (inetAddress != null) continue;
                    inetAddress = inetAddress3;
                    continue;
                }
                return inetAddress3;
            }
            if (inetAddress != null) {
                return inetAddress;
            }
            return inetAddress2;
        }
    }

    public static InetAddress[] getAllLocalInetAdresses() {
        InetAddress[] inetAddressArray;
        Set set = CollectionFactory.createHashSet();
        try {
            inetAddressArray = NetworkInterface.getNetworkInterfaces();
            while (inetAddressArray.hasMoreElements()) {
                NetworkInterface networkInterface = inetAddressArray.nextElement();
                Enumeration<InetAddress> enumeration = networkInterface.getInetAddresses();
                while (enumeration.hasMoreElements()) {
                    InetAddress inetAddress = enumeration.nextElement();
                    set.add(inetAddress);
                }
            }
        }
        catch (SocketException socketException) {
            C.error((Object)socketException);
        }
        inetAddressArray = set.toArray(new InetAddress[set.size()]);
        return inetAddressArray;
    }

    public static InetAddress text2Ip(String string) {
        InetAddress inetAddress = null;
        try {
            inetAddress = InetAddress.getByName(string);
        }
        catch (UnknownHostException unknownHostException) {
            C.error((Object)unknownHostException);
        }
        return inetAddress;
    }

    public static boolean isModule(LicenseKey licenseKey) {
        String string = LicenseUtils.getModuleName(licenseKey);
        boolean bl = ProductImpl.isModule(string);
        return bl;
    }

    public static InetAddress address2Ip(byte[] byArray) {
        InetAddress inetAddress = null;
        try {
            inetAddress = InetAddress.getByAddress(byArray);
        }
        catch (UnknownHostException unknownHostException) {
            C.error((Object)unknownHostException);
        }
        return inetAddress;
    }

    public static String getHostName(InetAddress inetAddress) {
        int n;
        String string;
        String string2;
        String string3 = inetAddress.getHostAddress();
        if (Strings.equals((String)string3, (String)(string2 = inetAddress.getHostName()))) {
            string2 = "";
        }
        if (Strings.isEmpty((String)string2) && Strings.equals((String)string3, (String)(string = inetAddress.getCanonicalHostName()))) {
            string2 = "";
        }
        if (Strings.isEmpty((String)string2)) {
            string2 = LicenseUtils.getFullyQualifiedHostnameFromNameService(inetAddress);
        }
        if (!Strings.isEmpty((String)string2) && (n = string2.indexOf(46)) > 0) {
            string2 = Strings.left((String)string2, (int)n);
        }
        return string2;
    }

    public static String getHostName() {
        InetAddress inetAddress = LicenseUtils.getLocalInetAddress();
        String string = LicenseUtils.getHostName(inetAddress);
        return string;
    }

    public static String getDomain(InetAddress inetAddress) {
        int n;
        String string;
        int n2;
        String string2;
        String string3 = LicenseUtils.getHostName(inetAddress);
        String string4 = inetAddress.getHostAddress();
        String string5 = Strings.equals((String)string4, (String)(string2 = inetAddress.getCanonicalHostName())) || string3.equals(string2) ? "" : ((n2 = string2.indexOf(46)) > 0 ? string2.substring(n2 + 1) : string2);
        if (Strings.isEmpty((String)string5) && !Strings.isEmpty((String)(string = LicenseUtils.getFullyQualifiedHostnameFromNameService(inetAddress))) && (n = string.indexOf(46)) >= 0) {
            string5 = string.substring(n + 1);
        }
        return string5;
    }

    public static String getDomain() {
        InetAddress inetAddress = LicenseUtils.getLocalInetAddress();
        String string = LicenseUtils.getDomain(inetAddress);
        return string;
    }

    public static String getFullyQualifiedHostnameFromNameService(InetAddress inetAddress) {
        try {
            Field field = (A == null ? (A = LicenseUtils.A("java.net.InetAddress")) : A).getDeclaredField("nameService");
            field.setAccessible(true);
            Object object = field.get(null);
            byte[] byArray = inetAddress.getAddress();
            Method method = object.getClass().getDeclaredMethod("getHostByAddr", D == null ? (D = LicenseUtils.A("[B")) : D);
            method.setAccessible(true);
            String string = (String)method.invoke(object, new Object[]{byArray});
            return string;
        }
        catch (NoSuchFieldException noSuchFieldException) {
            C.debug((Object)noSuchFieldException);
        }
        catch (IllegalAccessException illegalAccessException) {
            C.debug((Object)illegalAccessException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            C.debug((Object)noSuchMethodException);
        }
        catch (InvocationTargetException invocationTargetException) {
            C.debug((Object)invocationTargetException);
        }
        return "";
    }

    public static long encodeDate(Date date) {
        long l = date == null ? 0L : date.getTime() / (long)B - 12282L;
        return l;
    }

    public static Date decodeDate(long l) {
        long l2 = (l + 12282L) * (long)B;
        Date date = new Date(l2);
        return date;
    }

    public static long getApplicationEditionMask(LicenseKey licenseKey) {
        ProductEditionImpl[] productEditionImplArray = LicenseUtils.getApplicationEditions(licenseKey);
        long l = 0L;
        for (int i = 0; i < productEditionImplArray.length; ++i) {
            ProductEditionImpl productEditionImpl = productEditionImplArray[i];
            l |= productEditionImpl.getBitMask();
        }
        return l;
    }

    public static ProductEditionImpl[] getApplicationEditions(LicenseKey licenseKey) {
        TagApplicationEdition tagApplicationEdition = (TagApplicationEdition)licenseKey.getTag(com.gentleware.anvil.kernel.keymodel.C.Z);
        if (tagApplicationEdition == null) {
            return new ProductEditionImpl[0];
        }
        long l = tagApplicationEdition.getEditionsMask();
        ProductEditionImpl[] productEditionImplArray = ProductEditionImpl.get(l);
        return productEditionImplArray;
    }

    public static List getApplicationEditionsAsList(LicenseKey licenseKey) {
        ProductEditionImpl[] productEditionImplArray = LicenseUtils.getApplicationEditions(licenseKey);
        return Arrays.asList(productEditionImplArray);
    }

    public static ProductEdition[] getModuleEditions(LicenseKey licenseKey) {
        TagModuleEdition tagModuleEdition = (TagModuleEdition)licenseKey.getTag(com.gentleware.anvil.kernel.keymodel.C.W);
        if (tagModuleEdition == null) {
            return new ProductEdition[0];
        }
        long l = tagModuleEdition.getEditionsMask();
        ProductEdition[] productEditionArray = ProductEditionImpl.get(l);
        return productEditionArray;
    }

    public static String getApplicationName(LicenseKey licenseKey) {
        TagApplicationName tagApplicationName = (TagApplicationName)licenseKey.getTag(com.gentleware.anvil.kernel.keymodel.C._);
        return tagApplicationName != null ? tagApplicationName.getValue() : null;
    }

    public static String getModuleName(LicenseKey licenseKey) {
        TagModuleName tagModuleName = (TagModuleName)licenseKey.getTag(com.gentleware.anvil.kernel.keymodel.C.E);
        return tagModuleName != null ? tagModuleName.getValue() : null;
    }

    public static String getProductName(LicenseKey licenseKey) {
        String string = LicenseUtils.getModuleName(licenseKey);
        String string2 = string != null ? string : LicenseUtils.getApplicationName(licenseKey);
        return string2;
    }

    public static String getProductMajorReleaseAsText(LicenseKey licenseKey) {
        Integer n = LicenseUtils.getModuleMajorRelease(licenseKey);
        Integer n2 = LicenseUtils.getApplicationMajorRelease(licenseKey);
        Integer n3 = n != null ? n : n2;
        String string = n3 != null ? n3.toString() + ".x" : "";
        return string;
    }

    public static ProductVersion getProductVersion(LicenseKey licenseKey) {
        ProductVersion productVersion = ProductVersion.createProductVersion((Integer)LicenseUtils.getApplicationMajorRelease(licenseKey), (Integer)LicenseUtils.getApplicationMinorRelease(licenseKey), (Integer)LicenseUtils.getApplicationMicroRelease(licenseKey), (String)LicenseUtils.getApplicationBetaRelease(licenseKey));
        return productVersion;
    }

    public static Integer getApplicationMajorRelease(LicenseKey licenseKey) {
        TagApplicationMajorVersion tagApplicationMajorVersion = (TagApplicationMajorVersion)licenseKey.getTag(com.gentleware.anvil.kernel.keymodel.C.K);
        Integer n = LicenseUtils.A(tagApplicationMajorVersion);
        return n;
    }

    public static Integer getUpdateMajorRelease(LicenseKey licenseKey) {
        TagUpdateMajorVersion tagUpdateMajorVersion;
        TagUpdateMajorVersion tagUpdateMajorVersion2 = tagUpdateMajorVersion = (TagUpdateMajorVersion)licenseKey.getTag(com.gentleware.anvil.kernel.keymodel.C.C);
        Integer n = LicenseUtils.A(tagUpdateMajorVersion2);
        return n;
    }

    private static Integer A(I i) {
        Integer n = i != null ? new Integer((int)i.getValue()) : null;
        return n;
    }

    public static Integer getMajorRelease(LicenseKey licenseKey) {
        return LicenseUtils.isModule(licenseKey) ? LicenseUtils.getModuleMajorRelease(licenseKey) : LicenseUtils.getApplicationMajorRelease(licenseKey);
    }

    public static Integer getModuleMajorRelease(LicenseKey licenseKey) {
        TagModuleMajorVersion tagModuleMajorVersion = (TagModuleMajorVersion)licenseKey.getTag(com.gentleware.anvil.kernel.keymodel.C.P);
        Integer n = LicenseUtils.A(tagModuleMajorVersion);
        return n;
    }

    public static Integer getModuleMinorRelease(LicenseKey licenseKey) {
        TagModuleMinorVersion tagModuleMinorVersion = (TagModuleMinorVersion)licenseKey.getTag(com.gentleware.anvil.kernel.keymodel.C.Q);
        Integer n = LicenseUtils.A(tagModuleMinorVersion);
        return n;
    }

    public static Integer getModuleMicroRelease(LicenseKey licenseKey) {
        TagModuleMicroVersion tagModuleMicroVersion = (TagModuleMicroVersion)licenseKey.getTag(com.gentleware.anvil.kernel.keymodel.C.B);
        Integer n = LicenseUtils.A(tagModuleMicroVersion);
        return n;
    }

    public static String getModuleBetaRelease(LicenseKey licenseKey) {
        TagModuleBetaVersion tagModuleBetaVersion = (TagModuleBetaVersion)licenseKey.getTag(com.gentleware.anvil.kernel.keymodel.C.j);
        String string = tagModuleBetaVersion != null ? tagModuleBetaVersion.getValue() : null;
        return string;
    }

    public static boolean[] getSubscribeStatus(LicenseKey licenseKey) {
        TagSubscribe tagSubscribe = (TagSubscribe)licenseKey.getTag(com.gentleware.anvil.kernel.keymodel.C.X);
        if (tagSubscribe == null) {
            return null;
        }
        boolean bl = tagSubscribe.getSubscribe();
        boolean bl2 = tagSubscribe.getHtml();
        return new boolean[]{bl, bl2};
    }

    public static String getUserFirstName(LicenseKey licenseKey) {
        TagUserFirstName tagUserFirstName = (TagUserFirstName)licenseKey.getTag(com.gentleware.anvil.kernel.keymodel.C.c);
        String string = tagUserFirstName != null ? tagUserFirstName.getValue() : null;
        return string;
    }

    public static String getUserLastName(LicenseKey licenseKey) {
        TagUserLastName tagUserLastName = (TagUserLastName)licenseKey.getTag(com.gentleware.anvil.kernel.keymodel.C.U);
        String string = tagUserLastName != null ? tagUserLastName.getValue() : null;
        return string;
    }

    public static String getUserEmail(LicenseKey licenseKey) {
        TagUserEmail tagUserEmail = (TagUserEmail)licenseKey.getTag(com.gentleware.anvil.kernel.keymodel.C.I);
        String string = tagUserEmail != null ? tagUserEmail.getValue() : null;
        return string;
    }

    public static String getLicenseType(LicenseKey licenseKey) {
        KeyType keyType = licenseKey.getType();
        return keyType.getName();
    }

    public static Date getCreationDate(LicenseKey licenseKey) {
        TagCreationDate tagCreationDate = (TagCreationDate)licenseKey.getTag(com.gentleware.anvil.kernel.keymodel.C.k);
        Date date = tagCreationDate != null ? tagCreationDate.getValue() : null;
        return date;
    }

    public static Date getExpirationDate(LicenseKey licenseKey) {
        TagExpirationDate tagExpirationDate = (TagExpirationDate)licenseKey.getTag(com.gentleware.anvil.kernel.keymodel.C.L);
        Date date = tagExpirationDate != null ? tagExpirationDate.getValue() : null;
        return date;
    }

    public static String getHostName(LicenseKey licenseKey) {
        TagMachineHostName tagMachineHostName = (TagMachineHostName)licenseKey.getTag(com.gentleware.anvil.kernel.keymodel.C.b);
        String string = tagMachineHostName != null ? tagMachineHostName.getValue() : null;
        return string;
    }

    public static String getOsName(LicenseKey licenseKey) {
        TagMachineOsName tagMachineOsName = (TagMachineOsName)licenseKey.getTag(com.gentleware.anvil.kernel.keymodel.C.f);
        String string = tagMachineOsName != null ? tagMachineOsName.getValue() : null;
        return string;
    }

    public static LicenseTag[] getModuleTags(Product product, boolean bl) {
        LicenseTag[] licenseTagArray;
        ProductVersion productVersion;
        Integer n;
        List list = CollectionFactory.createArrayList();
        list.add(new TagModuleName(product.getName()));
        ProductEditionImpl productEditionImpl = (ProductEditionImpl)product.getEdition();
        if (productEditionImpl != null) {
            list.add(new TagModuleEdition(productEditionImpl.getBitMask()));
        }
        if ((n = (productVersion = product.getVersion()).getMajor()) != null) {
            list.add(new TagModuleMajorVersion(n.intValue()));
        }
        if (bl) {
            String string;
            Integer n2;
            licenseTagArray = productVersion.getMinor();
            if (licenseTagArray != null) {
                int n3 = licenseTagArray.intValue();
                list.add(new TagModuleMinorVersion(n3));
            }
            if ((n2 = productVersion.getMicro()) != null) {
                int n4 = n2;
                list.add(new TagModuleMicroVersion(n4));
            }
            if (!Strings.isEmpty((String)(string = productVersion.getBeta()))) {
                list.add(new TagModuleBetaVersion(string));
            }
        }
        licenseTagArray = list.toArray(new LicenseTag[list.size()]);
        return licenseTagArray;
    }

    public static LicenseTag[] getApplicationTags(Product product, boolean bl) {
        LicenseTag[] licenseTagArray;
        List list = CollectionFactory.createArrayList();
        list.add(new TagApplicationName(product.getName()));
        ProductEditionImpl productEditionImpl = (ProductEditionImpl)product.getEdition();
        if (productEditionImpl != null) {
            list.add(new TagApplicationEdition(productEditionImpl.getBitMask()));
        }
        ProductVersion productVersion = product.getVersion();
        list.add(new TagApplicationMajorVersion(productVersion.getMajor().intValue()));
        if (bl) {
            String string;
            Integer n;
            licenseTagArray = productVersion.getMinor();
            if (licenseTagArray != null) {
                int n2 = licenseTagArray.intValue();
                list.add(new TagApplicationMinorVersion(n2));
            }
            if ((n = productVersion.getMicro()) != null) {
                int n3 = n;
                list.add(new TagApplicationMicroVersion(n3));
            }
            if ((string = productVersion.getBeta()) != null) {
                list.add(new TagApplicationBetaVersion(string));
            }
        }
        licenseTagArray = list.toArray(new LicenseTag[list.size()]);
        return licenseTagArray;
    }

    public static LicenseTag[] getCustomerTags(Customer customer, int n) {
        LicenseTag[] licenseTagArray;
        List list = CollectionFactory.createArrayList();
        if (n != 3) {
            String string;
            String string2;
            licenseTagArray = customer.getFirstName();
            if (!Strings.isEmpty((String)licenseTagArray)) {
                list.add(new TagUserFirstName((String)licenseTagArray));
            }
            if (!Strings.isEmpty((String)(string2 = customer.getLastName()))) {
                list.add(new TagUserLastName(string2));
            }
            if (!Strings.isEmpty((String)(string = customer.getEmail()))) {
                list.add(new TagUserEmail(string));
            }
            if (n != 2) {
                PostalAddress postalAddress;
                String string3;
                String string4;
                String string5 = customer.getCompany();
                if (!Strings.isEmpty((String)string5)) {
                    list.add(new TagUserCompany(string5));
                }
                if (!Strings.isEmpty((String)(string4 = customer.getSalutation()))) {
                    list.add(new TagUserSalutation(string4));
                }
                String string6 = string3 = (postalAddress = customer.getPostalAddress()) != null ? postalAddress.getCountryCode() : null;
                if (string3 != null) {
                    list.add(new TagUserCountry(string3));
                }
            }
        }
        licenseTagArray = list.toArray(new LicenseTag[list.size()]);
        return licenseTagArray;
    }

    public static LicenseTag[] getMachineTags(Machine machine, boolean bl) {
        List list = CollectionFactory.createArrayList();
        list.add(new TagMachineHostName(machine.getHostName()));
        list.add(new TagMachineOsName(machine.getOsName()));
        if (!bl) {
            list.add(new TagMachineDomain(machine.getDomain()));
            list.add(new TagMachineIp(machine.getIp()));
            list.add(new TagMachineOsVersion(machine.getOsVersion()));
        }
        LicenseTag[] licenseTagArray = list.toArray(new LicenseTag[list.size()]);
        return licenseTagArray;
    }

    public static InetAddress getIpAllMask() {
        InetAddress inetAddress = LicenseUtils.getLocalInetAddress();
        byte[] byArray = inetAddress.getAddress();
        byte[] byArray2 = new byte[byArray.length];
        Arrays.fill(byArray2, (byte)-1);
        InetAddress inetAddress2 = null;
        try {
            inetAddress2 = InetAddress.getByAddress(byArray2);
        }
        catch (UnknownHostException unknownHostException) {
            C.error(null);
        }
        return inetAddress2;
    }

    public static String getUserCompany(LicenseKey licenseKey) {
        TagUserCompany tagUserCompany = (TagUserCompany)licenseKey.getTag(com.gentleware.anvil.kernel.keymodel.C.S);
        String string = tagUserCompany != null ? tagUserCompany.getValue() : null;
        return string;
    }

    public static String getUserCountry(LicenseKey licenseKey) {
        TagUserCountry tagUserCountry = (TagUserCountry)licenseKey.getTag(com.gentleware.anvil.kernel.keymodel.C.A);
        String string = tagUserCountry != null ? tagUserCountry.getValue() : null;
        return string;
    }

    public static String getUserSalutation(LicenseKey licenseKey) {
        TagUserSalutation tagUserSalutation = (TagUserSalutation)licenseKey.getTag(com.gentleware.anvil.kernel.keymodel.C.Y);
        String string = tagUserSalutation != null ? tagUserSalutation.getValue() : null;
        return string;
    }

    public static String getMachineDomain(LicenseKey licenseKey) {
        TagMachineDomain tagMachineDomain = (TagMachineDomain)licenseKey.getTag(com.gentleware.anvil.kernel.keymodel.C.H);
        String string = tagMachineDomain != null ? tagMachineDomain.getValue() : null;
        return string;
    }

    public static String getMachineOsVersion(LicenseKey licenseKey) {
        TagMachineOsVersion tagMachineOsVersion = (TagMachineOsVersion)licenseKey.getTag(com.gentleware.anvil.kernel.keymodel.C.V);
        String string = tagMachineOsVersion != null ? tagMachineOsVersion.getValue() : null;
        return string;
    }

    public static String getMachineIp(LicenseKey licenseKey) {
        TagMachineIp tagMachineIp = (TagMachineIp)licenseKey.getTag(com.gentleware.anvil.kernel.keymodel.C.D);
        String string = tagMachineIp != null ? tagMachineIp.getFirstIp() : null;
        return string;
    }

    public static IpRange[] getIpRanges(LicenseKey licenseKey) {
        TagMachineIp tagMachineIp = (TagMachineIp)licenseKey.getTag(com.gentleware.anvil.kernel.keymodel.C.D);
        if (tagMachineIp == null) {
            return null;
        }
        IpRange[] ipRangeArray = tagMachineIp.getIpRanges();
        return ipRangeArray;
    }

    public static Integer getApplicationMinorRelease(LicenseKey licenseKey) {
        TagApplicationMinorVersion tagApplicationMinorVersion = (TagApplicationMinorVersion)licenseKey.getTag(com.gentleware.anvil.kernel.keymodel.C.M);
        Integer n = LicenseUtils.A(tagApplicationMinorVersion);
        return n;
    }

    public static Integer getApplicationMicroRelease(LicenseKey licenseKey) {
        TagApplicationMicroVersion tagApplicationMicroVersion = (TagApplicationMicroVersion)licenseKey.getTag(com.gentleware.anvil.kernel.keymodel.C.i);
        Integer n = LicenseUtils.A(tagApplicationMicroVersion);
        return n;
    }

    public static String getApplicationBetaRelease(LicenseKey licenseKey) {
        TagApplicationBetaVersion tagApplicationBetaVersion = (TagApplicationBetaVersion)licenseKey.getTag(com.gentleware.anvil.kernel.keymodel.C.a);
        String string = tagApplicationBetaVersion != null ? tagApplicationBetaVersion.getValue() : null;
        return string;
    }

    public static String getUpgradeProductName(LicenseKey licenseKey) {
        TagUpdateRequirements tagUpdateRequirements = (TagUpdateRequirements)licenseKey.getTag(com.gentleware.anvil.kernel.keymodel.C.J);
        String string = tagUpdateRequirements != null ? tagUpdateRequirements.getProductName() : null;
        return string;
    }

    public static String getUpgradeProductEditionShortName(LicenseKey licenseKey) {
        TagUpdateRequirements tagUpdateRequirements = (TagUpdateRequirements)licenseKey.getTag(com.gentleware.anvil.kernel.keymodel.C.J);
        String string = tagUpdateRequirements != null ? tagUpdateRequirements.getEditionShortName() : null;
        return string;
    }

    public static String getProductEditionsAsText(LicenseKey licenseKey) {
        ProductEdition[] productEditionArray = LicenseUtils.getApplicationEditions(licenseKey);
        return LicenseUtils.getProductEditionsAsText(productEditionArray);
    }

    public static String getProductEditionsAsText(ProductEdition[] productEditionArray) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = "";
        for (int i = 0; i < productEditionArray.length; ++i) {
            ProductEdition productEdition = productEditionArray[i];
            stringBuffer.append(string);
            stringBuffer.append(productEdition.getShortName());
            string = ", ";
        }
        String string2 = new String(stringBuffer);
        return string2;
    }

    public static LicenseKey getConcurrentKey(LicenseKey licenseKey) {
        String string = LicenseUtils.getConcurrentClientKeyAsString(licenseKey);
        LicenseKey licenseKey2 = null;
        if (string != null) {
            try {
                licenseKey2 = LicenseCipherClient.getInstance().decryptKeyFromServer(string);
            }
            catch (LicenseException licenseException) {
                C.error((Object)licenseException);
            }
        }
        return licenseKey2;
    }

    public static String getConcurrentClientKeyAsString(LicenseKey licenseKey) {
        TagConcurrentKey tagConcurrentKey = (TagConcurrentKey)licenseKey.getTag(com.gentleware.anvil.kernel.keymodel.C.d);
        return LicenseUtils.getConcurrentClientKeyAsString(tagConcurrentKey);
    }

    public static String getConcurrentClientKeyAsString(TagConcurrentKey tagConcurrentKey) {
        byte[] byArray = tagConcurrentKey != null ? tagConcurrentKey.getEncryptedFloatingKey() : null;
        String string = null;
        if (byArray != null) {
            string = Base64Codec.encode((byte[])byArray);
        }
        return string;
    }

    public static Long getLeaseLicenseMaxDurationInMs(LicenseKey licenseKey) {
        LicenseTag licenseTag = licenseKey.getTag(com.gentleware.anvil.kernel.keymodel.C.O);
        if (licenseTag == null) {
            return null;
        }
        return new Long(((TagLeaseLicenseMaxPeriodInMs)licenseTag).getValue());
    }

    public static boolean comparable(LicenseKey licenseKey, LicenseKey licenseKey2) {
        String string = LicenseUtils.getApplicationName(licenseKey);
        String string2 = LicenseUtils.getApplicationName(licenseKey2);
        String string3 = LicenseUtils.getModuleName(licenseKey);
        String string4 = LicenseUtils.getModuleName(licenseKey2);
        boolean bl = Strings.equals((String)string, (String)string2) && Strings.equals((String)string3, (String)string4);
        return bl;
    }

    private static LicenseKey A(long l, Customer customer, Product product, Product product2, Machine machine) {
        LicenseTag[] licenseTagArray;
        LicenseKey licenseKey = LicenseUtils.A(l, customer, machine);
        if (product != null) {
            licenseTagArray = LicenseUtils.getModuleTags(product, true);
            licenseKey.addTags(licenseTagArray);
        }
        licenseTagArray = LicenseUtils.getApplicationTags(product2, true);
        licenseKey.addTags(licenseTagArray);
        return licenseKey;
    }

    private static LicenseKey A(long l, Customer customer, Machine machine) {
        if (machine == null) {
            machine = new Machine();
        }
        LicenseKey licenseKey = new LicenseKey(KeyType.REGISTRATION, false, false, 0L, l);
        LicenseTag[] licenseTagArray = LicenseUtils.getCustomerTags(customer, 1);
        licenseKey.addTags(licenseTagArray);
        LicenseTag[] licenseTagArray2 = LicenseUtils.getMachineTags(machine, false);
        licenseKey.addTags(licenseTagArray2);
        licenseKey.addTag(new TagCreationDate());
        return licenseKey;
    }

    public static Long getConcurrentLicenseClientKeyCount(LicenseKey licenseKey) {
        TagConcurrentLicenseCount tagConcurrentLicenseCount = (TagConcurrentLicenseCount)licenseKey.getTag(com.gentleware.anvil.kernel.keymodel.C.R);
        Long l = tagConcurrentLicenseCount != null ? new Long(tagConcurrentLicenseCount.getValue()) : null;
        return l;
    }

    public static Long getConcurrentServerKeyId(LicenseKey licenseKey) {
        TagConcurrentServerKeyId tagConcurrentServerKeyId = (TagConcurrentServerKeyId)licenseKey.getTag(com.gentleware.anvil.kernel.keymodel.C.N);
        Long l = tagConcurrentServerKeyId != null ? new Long(tagConcurrentServerKeyId.getConcurrentServerKeyId()) : null;
        return l;
    }

    public static Map getLentLeaseLicenseMap(LicenseKey licenseKey) {
        D d = (D)licenseKey.getTag(com.gentleware.anvil.kernel.keymodel.C.g);
        Map map = d != null ? d.A() : null;
        return map;
    }

    public static boolean checkForConcurrentEvaluationLicense(LicenseKey licenseKey) {
        KeyType keyType = licenseKey.getType();
        if (KeyType.EVALUATION.equals(keyType)) {
            LicenseKey licenseKey2 = LicenseUtils.getConcurrentKey(licenseKey);
            return licenseKey2 != null;
        }
        return false;
    }

    public static Long getAvailableLeaseLicenseCount(LicenseKey licenseKey) {
        G g = (G)licenseKey.getTag(com.gentleware.anvil.kernel.keymodel.C.T);
        Long l = g != null ? new Long(g.getValue()) : null;
        return l;
    }

    public static TagAdditionalConcurrentLicenseInformation getAdditionalConcurrentLicenseInformation(LicenseKey licenseKey) {
        TagAdditionalConcurrentLicenseInformation tagAdditionalConcurrentLicenseInformation = (TagAdditionalConcurrentLicenseInformation)licenseKey.getTag(com.gentleware.anvil.kernel.keymodel.C.F);
        return tagAdditionalConcurrentLicenseInformation;
    }

    public static int getAvailableLeaseLicenseCountFromContainer(LicenseKey licenseKey) {
        if (licenseKey == null) {
            return -1;
        }
        int n = LicenseUtils.getConcurrentClientKeyCountFromContainer(licenseKey);
        Map map = LicenseUtils.getLentLeaseLicenseMap(licenseKey);
        int n2 = map.size();
        int n3 = n - n2;
        return n3;
    }

    public static int getConcurrentClientKeyCountFromContainer(LicenseKey licenseKey) {
        LicenseKey licenseKey2 = LicenseUtils.getConcurrentKey(licenseKey);
        Long l = LicenseUtils.getConcurrentLicenseClientKeyCount(licenseKey2);
        if (l == null) {
            return -1;
        }
        int n = l.intValue();
        return n;
    }

    public static LicenseKey createConcurrentKeyContainer(LicenseKey licenseKey) {
        String string = licenseKey.getRsaAscii();
        TagConcurrentKey tagConcurrentKey = new TagConcurrentKey(Base64Codec.decode((String)string));
        LicenseKey licenseKey2 = new LicenseKey(KeyType.LICENSE_KEY_CONTAINER);
        licenseKey2.addTag(tagConcurrentKey);
        return licenseKey2;
    }

    public static boolean isConcurrentLicense(LicenseKey licenseKey) {
        Long l = LicenseUtils.getConcurrentLicenseClientKeyCount(licenseKey);
        return l != null;
    }

    public static LicenseKey getOrCreateLicenseKeyContainer(LicenseKey licenseKey) throws LicenseException {
        LicenseKey licenseKey2;
        if (licenseKey == null) {
            return null;
        }
        KeyType keyType = licenseKey.getType();
        if (KeyType.LICENSE_KEY_CONTAINER.equals(keyType)) {
            licenseKey2 = licenseKey;
        } else {
            licenseKey2 = LicenseUtils.createConcurrentKeyContainer(licenseKey);
            D d = new D(new TreeMap());
            licenseKey2.addTag(d);
            ConcurrentKeyManagerImpl.encryptFloatingLicenseKey(licenseKey2);
        }
        return licenseKey2;
    }

    public static Integer getUpdateApplicationMajorVersion(LicenseKey licenseKey) {
        Integer n = LicenseUtils.getApplicationMajorRelease(licenseKey);
        Integer n2 = LicenseUtils.getUpdateMajorRelease(licenseKey);
        if (n2 != null) {
            return n2;
        }
        boolean bl = LicenseUtils.B(licenseKey);
        if (bl) {
            n = new Integer(n - 1);
        }
        return n;
    }

    private static boolean B(LicenseKey licenseKey) {
        Integer n;
        String string = LicenseUtils.getUpgradeProductEditionShortName(licenseKey);
        ProductEditionImpl[] productEditionImplArray = LicenseUtils.getApplicationEditions(licenseKey);
        List<ProductEditionImpl> list = Arrays.asList(productEditionImplArray);
        boolean bl = list.contains(ProductEditionImpl.get(string));
        Integer n2 = LicenseUtils.getUpdateMajorRelease(licenseKey);
        if (n2 != null && n2.equals(n = LicenseUtils.getApplicationMajorRelease(licenseKey)) && bl) {
            return false;
        }
        return bl;
    }

    public static boolean isUpdateOrUpgradeKey(LicenseKey licenseKey) {
        if (licenseKey == null) {
            return false;
        }
        boolean bl = false;
        String string = LicenseUtils.getUpgradeProductName(licenseKey);
        if (!Strings.isEmpty((String)string)) {
            bl = true;
        }
        return bl;
    }

    public static F getUpgradeRequirements(LicenseKey licenseKey) {
        if (licenseKey == null) {
            return null;
        }
        boolean bl = LicenseUtils.isUpdateOrUpgradeKey(licenseKey);
        if (!bl) {
            return null;
        }
        boolean bl2 = LicenseUtils.isConcurrentLicense(licenseKey);
        String string = LicenseUtils.getUpgradeProductName(licenseKey);
        String string2 = LicenseUtils.getUpgradeProductEditionShortName(licenseKey);
        Integer n = LicenseUtils.getUpdateApplicationMajorVersion(licenseKey);
        if (bl2) {
            boolean bl3 = LicenseUtils.applicationEditionContainsEditionShort(licenseKey, string2);
            Integer n2 = LicenseUtils.getApplicationMajorRelease(licenseKey);
            boolean bl4 = n2.equals(n);
            LicenseKey licenseKey2 = LicenseUtils.getConcurrentKey(licenseKey);
            String string3 = LicenseUtils.getApplicationName(licenseKey2);
            ProductEditionImpl productEditionImpl = ProductEditionImpl.get(string2);
            boolean bl5 = LicenseUtils.A(licenseKey);
            boolean bl6 = string3.equals(string);
            if (bl3 && bl4 && bl6 && bl2) {
                bl2 = false;
            } else if (productEditionImpl != null && !productEditionImpl.isConcurrentLicenseEnabled()) {
                bl2 = false;
            }
            if (!bl5) {
                bl2 = false;
            }
        }
        return new F(string, string2, n, bl2);
    }

    private static boolean A(LicenseKey licenseKey) {
        TagUpdateRequirements tagUpdateRequirements = (TagUpdateRequirements)licenseKey.getTag(com.gentleware.anvil.kernel.keymodel.C.J);
        return tagUpdateRequirements != null && tagUpdateRequirements.isRequiresConcurrentKey();
    }

    public static boolean applicationEditionContainsEditionShort(LicenseKey licenseKey, String string) {
        List list = LicenseUtils.getApplicationEditionsAsList(licenseKey);
        ProductEditionImpl productEditionImpl = ProductEditionImpl.get(string);
        boolean bl = list.contains(productEditionImpl);
        return bl;
    }

    public static LicenseKey getRegistrationData(LicenseKey licenseKey, Customer customer, Product product) {
        Serializable serializable;
        ProductImpl productImpl;
        String string = LicenseUtils.getModuleName(licenseKey);
        if (LicenseUtils.isConcurrentLicense(licenseKey)) {
            licenseKey = LicenseUtils.getConcurrentKey(licenseKey);
        }
        if (string == null || string.equalsIgnoreCase(LicenseUtils.getApplicationName(licenseKey))) {
            productImpl = null;
        } else {
            Integer n = LicenseUtils.getModuleMajorRelease(licenseKey);
            Integer n2 = LicenseUtils.getModuleMinorRelease(licenseKey);
            serializable = LicenseUtils.getModuleMicroRelease(licenseKey);
            String string2 = LicenseUtils.getModuleBetaRelease(licenseKey);
            ProductVersion productVersion = ProductVersion.createProductVersion((Integer)n, (Integer)n2, (Integer)serializable, (String)string2);
            productImpl = new ProductImpl(string, null, productVersion);
        }
        long l = licenseKey.getDbId();
        serializable = LicenseUtils.A(l, customer, productImpl, product, null);
        return serializable;
    }

    public static String getLicenseKeyDescription(LicenseKey licenseKey) {
        String string;
        String string2;
        KeyType keyType = licenseKey.getType();
        if (KeyType.LICENSE_KEY_CONTAINER.equals(keyType)) {
            licenseKey = LicenseUtils.getConcurrentKey(licenseKey);
        }
        StringBuffer stringBuffer = new StringBuffer();
        LicenseKey licenseKey2 = LicenseUtils.getConcurrentKey(licenseKey);
        if (licenseKey2 != null) {
            string2 = LicenseUtils.getApplicationName(licenseKey2);
            string = LicenseUtils.getModuleName(licenseKey2);
        } else {
            string2 = LicenseUtils.getApplicationName(licenseKey);
            string = LicenseUtils.getModuleName(licenseKey);
        }
        if (string2 != null) {
            stringBuffer.append("Application: " + string2);
        } else if (string != null) {
            stringBuffer.append("Plug-in: " + string);
        }
        LicenseUtils.A(licenseKey, stringBuffer);
        return stringBuffer.toString();
    }

    private static void A(LicenseKey licenseKey, StringBuffer stringBuffer) {
        StringBuffer stringBuffer2 = new StringBuffer();
        stringBuffer2.append(" (");
        stringBuffer2.append(LicenseUtils.getLicenseType(licenseKey));
        Date date = LicenseUtils.getExpirationDate(licenseKey);
        if (date != null) {
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            gregorianCalendar.setTime(date);
            boolean bl = GregorianCalendar.getInstance().after(gregorianCalendar);
            stringBuffer2.append(", ");
            if (bl) {
                stringBuffer2.append("expired: ");
            } else {
                stringBuffer2.append("expires: ");
            }
            stringBuffer2.append(date);
        }
        stringBuffer2.append(")");
        stringBuffer.append(stringBuffer2);
    }

    public static String getConcurrentLicenseKeyCountInformation(LicenseKey licenseKey) {
        StringBuffer stringBuffer = new StringBuffer();
        LicenseKey licenseKey2 = LicenseUtils.getConcurrentKey(licenseKey);
        Long l = LicenseUtils.getConcurrentLicenseClientKeyCount(licenseKey2);
        int n = LicenseUtils.getAvailableLeaseLicenseCountFromContainer(licenseKey);
        if (n != -1) {
            stringBuffer.append(n);
            stringBuffer.append('/');
            if (l != null) {
                stringBuffer.append(l.toString());
            } else {
                stringBuffer.append("?");
            }
            stringBuffer.append(" Licenses available");
        } else {
            stringBuffer.append("Number of available licenses could not be determined");
        }
        return stringBuffer.toString();
    }

    private static Class A(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }
}

