/*
 * Decompiled with CFR 0.152.
 */
package com.gentleware.locksmith.client;

import com.gentleware.anvil.kernel.KeyManager;
import com.gentleware.anvil.kernel.LicenseData;
import com.gentleware.anvil.kernel.LicenseManagerDialog;
import com.gentleware.anvil.kernel.ProductImpl;
import com.gentleware.anvil.kernel.utils.LicenseException;
import com.gentleware.locksmith.client.LicenseKeys;
import com.gentleware.openapi.util.Utils;
import java.awt.Frame;
import java.awt.HeadlessException;

public abstract class LicenseChecker {
    protected static LicenseChecker _instance;
    protected boolean _guiMode;
    protected KeyManager _keyManager;
    protected ProductImpl _poseidonProduct;
    private boolean A = true;

    public abstract boolean licensedAtRuntime();

    public abstract boolean isLicensed(LicenseData var1);

    public abstract void checkLicenseKeys() throws LicenseException;

    public abstract boolean runsAsEvaluation(LicenseData var1);

    public abstract KeyManager getKeyManager();

    public abstract void addTabToLicenseManagerDialog(LicenseManagerDialog var1);

    protected LicenseChecker() {
        this(true, null);
    }

    private LicenseChecker(boolean bl, KeyManager keyManager) {
        this._guiMode = bl;
        this._keyManager = keyManager;
        if (_instance != null) {
            throw new IllegalStateException("License Checker already initialized!");
        }
        _instance = this;
    }

    protected LicenseChecker(boolean bl, KeyManager keyManager, ProductImpl productImpl) {
        this(bl, keyManager);
        this._poseidonProduct = productImpl;
    }

    public static LicenseChecker getInstance() {
        if (_instance == null) {
            throw new IllegalStateException("License Checker not yet initialized!");
        }
        return _instance;
    }

    public static void setInstance(LicenseChecker licenseChecker) {
        _instance = licenseChecker;
    }

    public void enableLicenseCheck() {
        this.A = true;
    }

    public void disableLicenseCheck() {
        this.A = false;
    }

    public boolean isLicenseCheckEnabled() {
        return this.A;
    }

    public boolean hasValidApplicationKey(ProductImpl productImpl) {
        LicenseKeys licenseKeys = LicenseKeys.getInstance();
        LicenseData licenseData = licenseKeys.getPoseidonLicenseData(productImpl);
        boolean bl = this.isLicensed(licenseData);
        return bl;
    }

    public void checkLicenseKeys(LicenseManagerDialog licenseManagerDialog) {
        try {
            Utils.setupWebstartDesktopIntegrationFix();
            licenseManagerDialog.show();
            Utils.shutdownWebstartDesktopIntegrationFix();
            licenseManagerDialog.dispose();
            if (licenseManagerDialog.wasCanceled()) {
                System.exit(0);
            }
        }
        catch (HeadlessException headlessException) {
            throw new IllegalStateException("Trying to open a JFrame while in headless state...");
        }
    }

    public void showKeymanager(Frame frame) {
        boolean bl = true;
        LicenseManagerDialog licenseManagerDialog = new LicenseManagerDialog(frame, false, _instance, true, this._keyManager, this._poseidonProduct);
        this.addTabToLicenseManagerDialog(licenseManagerDialog);
        licenseManagerDialog.show();
    }

    protected void openLicenseManagerDialog(KeyManager keyManager) {
        boolean bl = keyManager.hasAnySerialNumber();
        if (this._guiMode && (!this.hasValidApplicationKey(this._poseidonProduct) || bl)) {
            boolean bl2 = true;
            LicenseManagerDialog licenseManagerDialog = new LicenseManagerDialog(null, true, _instance, true, keyManager, this._poseidonProduct);
            this.addTabToLicenseManagerDialog(licenseManagerDialog);
            this.checkLicenseKeys(licenseManagerDialog);
        }
    }
}

