/*
 * Decompiled with CFR 0.152.
 */
package com.gentleware.locksmith.client;

import com.gentleware.anvil.kernel.Customer;
import com.gentleware.anvil.kernel.LicenseData;
import com.gentleware.anvil.kernel.Machine;
import com.gentleware.anvil.kernel.PostalAddress;
import com.gentleware.anvil.kernel.ProductImpl;
import com.gentleware.anvil.kernel.keymodel.LicenseKey;
import com.gentleware.anvil.kernel.utils.LicenseUtils;
import com.gentleware.openapi.configuration.Configuration;
import com.gentleware.openapi.configuration.Services;
import com.gentleware.openapi.util.Product;
import com.gentleware.openapi.util.Utils;
import java.util.Date;

public class LicenseKeys {
    private static final LicenseKeys A = new LicenseKeys();

    public static synchronized LicenseKeys getInstance() {
        return A;
    }

    private LicenseKeys() {
    }

    public boolean comparable(LicenseKey licenseKey, LicenseKey licenseKey2) {
        return LicenseUtils.comparable(licenseKey, licenseKey2);
    }

    public LicenseData getPoseidonLicenseData(ProductImpl productImpl) {
        Customer customer = LicenseKeys.getPoseidonUser();
        LicenseData licenseData = new LicenseData(productImpl, productImpl, new Machine(), customer, new Date());
        return licenseData;
    }

    public LicenseData getModuleLicenseData(Product product, ProductImpl productImpl) {
        Customer customer = LicenseKeys.getPoseidonUser();
        Machine machine = new Machine();
        LicenseData licenseData = new LicenseData(productImpl, product, machine, customer, new Date());
        return licenseData;
    }

    public LicenseKey getRegistrationData(LicenseKey licenseKey, Product product) {
        Customer customer = LicenseKeys.getPoseidonUser();
        return LicenseUtils.getRegistrationData(licenseKey, customer, product);
    }

    public int compare(LicenseKey licenseKey, LicenseKey licenseKey2, ProductImpl productImpl, boolean bl) {
        int n;
        if (!this.comparable(licenseKey, licenseKey2)) {
            throw new IllegalArgumentException();
        }
        LicenseData licenseData = this.getPoseidonLicenseData(productImpl);
        boolean bl2 = this.isValidForAnyModule(licenseKey, licenseData, bl);
        boolean bl3 = this.isValidForAnyModule(licenseKey2, licenseData, bl);
        if (bl2 && !bl3) {
            n = 1;
        } else if (bl3 && !bl2) {
            n = -1;
        } else {
            n = Utils.compare((long)LicenseUtils.getApplicationEditionMask(licenseKey), (long)LicenseUtils.getApplicationEditionMask(licenseKey2));
            if (n == 0) {
                n = licenseKey.getType().compareTo(licenseKey2.getType());
            }
        }
        return n;
    }

    public boolean isValidForAnyModule(LicenseKey licenseKey, LicenseData licenseData, boolean bl) {
        boolean bl2 = bl ? licenseKey.isValidForApplication(licenseData.getApplication(), bl) : licenseKey.isValidForApplication(licenseData.getApplication());
        boolean bl3 = licenseKey.isValidForCustomer(licenseData.getCustomer());
        boolean bl4 = licenseKey.isValidForDate(licenseData.getDate());
        boolean bl5 = licenseKey.isValidForMachine(licenseData.getMachine());
        boolean bl6 = bl2 && bl3 && bl4 && bl5;
        return bl6;
    }

    public boolean isValidForAnyModule(LicenseKey licenseKey, LicenseData licenseData) {
        return this.isValidForAnyModule(licenseKey, licenseData, false);
    }

    public boolean isValidForCurrentDate(LicenseKey licenseKey) {
        boolean bl = licenseKey.isValidForDate(new Date());
        return bl;
    }

    public boolean isValidForCurrentUser(LicenseKey licenseKey) {
        boolean bl = licenseKey.isValidForCustomer(LicenseKeys.getPoseidonUser());
        return bl;
    }

    public boolean isValidForCurrentMachine(LicenseKey licenseKey) {
        boolean bl = licenseKey.isValidForMachine(new Machine());
        return bl;
    }

    public static Customer getPoseidonUser() {
        Configuration configuration = Services.getInstance().getConfiguration();
        String string = configuration.getString("poseidon/user/salutation");
        String string2 = configuration.getString("poseidon/user/firstname");
        String string3 = configuration.getString("poseidon/user/lastname");
        String string4 = configuration.getString("poseidon/user/email");
        String string5 = configuration.getString("poseidon/user/company");
        String string6 = configuration.getString("poseidon/user/country");
        PostalAddress postalAddress = new PostalAddress(string6);
        Customer customer = new Customer(string, string5, string2, string3, null, null, string4, postalAddress);
        return customer;
    }

    public static void savePoseidonUser(Customer customer) {
        Configuration configuration = Services.getInstance().getConfiguration();
        configuration.putString("poseidon/user/salutation", customer.getSalutation());
        configuration.putString("poseidon/user/firstname", customer.getFirstName());
        configuration.putString("poseidon/user/lastname", customer.getLastName());
        configuration.putString("poseidon/user/email", customer.getEmail());
        configuration.putString("poseidon/user/company", customer.getCompany());
        PostalAddress postalAddress = customer.getPostalAddress();
        String string = postalAddress == null ? "" : postalAddress.getCountryCode();
        configuration.putString("poseidon/user/country", string);
    }
}

