/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.generators;

import java.math.BigInteger;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import org.bouncycastle.crypto.KeyGenerationParameters;
import org.bouncycastle.crypto.params.RSAKeyGenerationParameters;
import org.bouncycastle.crypto.params.RSAKeyParameters;
import org.bouncycastle.crypto.params.RSAPrivateCrtKeyParameters;

public class RSAKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private static BigInteger A = BigInteger.valueOf(1L);
    private RSAKeyGenerationParameters B;

    public void init(KeyGenerationParameters keyGenerationParameters) {
        this.B = (RSAKeyGenerationParameters)keyGenerationParameters;
    }

    public AsymmetricCipherKeyPair generateKeyPair() {
        BigInteger bigInteger;
        BigInteger bigInteger2;
        BigInteger bigInteger3;
        int n = (this.B.getStrength() + 1) / 2;
        int n2 = this.B.getStrength() - n;
        BigInteger bigInteger4 = this.B.getPublicExponent();
        while (!bigInteger4.gcd((bigInteger3 = new BigInteger(n, this.B.getCertainty(), this.B.getRandom())).subtract(A)).equals(A)) {
        }
        while (true) {
            if (!bigInteger4.gcd((bigInteger2 = new BigInteger(n2, this.B.getCertainty(), this.B.getRandom())).subtract(A)).equals(A) || bigInteger3.equals(bigInteger2)) {
                continue;
            }
            bigInteger = bigInteger3.multiply(bigInteger2);
            if (bigInteger.bitLength() == this.B.getStrength()) break;
            bigInteger3 = bigInteger3.max(bigInteger2);
        }
        BigInteger bigInteger5 = bigInteger3.subtract(A);
        BigInteger bigInteger6 = bigInteger2.subtract(A);
        BigInteger bigInteger7 = bigInteger5.multiply(bigInteger6);
        BigInteger bigInteger8 = bigInteger4.modInverse(bigInteger7);
        BigInteger bigInteger9 = bigInteger8.remainder(bigInteger5);
        BigInteger bigInteger10 = bigInteger8.remainder(bigInteger6);
        BigInteger bigInteger11 = bigInteger2.modInverse(bigInteger3);
        return new AsymmetricCipherKeyPair(new RSAKeyParameters(false, bigInteger, bigInteger4), new RSAPrivateCrtKeyParameters(bigInteger, bigInteger4, bigInteger8, bigInteger3, bigInteger2, bigInteger9, bigInteger10, bigInteger11));
    }
}

