/*
 * Decompiled with CFR 0.152.
 */
package com.gentleware.openapi.swingx;

import java.util.StringTokenizer;

public class XTableConstraints {
    public static final int LEFT = 1;
    public static final int CENTER = 2;
    public static final int RIGHT = 3;
    public static final int TOP = 4;
    public static final int BOTTOM = 5;
    public static final int FILL = 6;
    public static final int SAME = -2147483637;
    public static final int NEXT = -2147483636;
    public final int _x;
    public final int _y;
    public final int _width;
    public final int _height;
    public final int _xAlign;
    public final int _yAlign;
    public final double _xWeight;
    public final double _yWeight;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public XTableConstraints(String string) throws IllegalArgumentException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ", ");
        int n = stringTokenizer.countTokens();
        if (n != 2 && n != 4 && n != 6 && n != 8) {
            throw new IllegalArgumentException("XTableConstraints are invalid" + string);
        }
        String string2 = stringTokenizer.nextToken();
        String string3 = stringTokenizer.nextToken();
        this._x = ".".equals(string2) ? -2147483637 : ("+".equals(string2) ? -2147483636 : Integer.parseInt(string2));
        this._y = ".".equals(string3) ? -2147483637 : ("+".equals(string3) ? -2147483636 : Integer.parseInt(string3));
        if (n >= 4) {
            this._width = Integer.parseInt(stringTokenizer.nextToken());
            this._height = Integer.parseInt(stringTokenizer.nextToken());
        } else {
            this._width = 1;
            this._height = 1;
        }
        if (n >= 6) {
            String string4 = stringTokenizer.nextToken();
            if ("left".equals(string4)) {
                this._xAlign = 1;
            } else if ("center".equals(string4)) {
                this._xAlign = 2;
            } else if ("right".equals(string4)) {
                this._xAlign = 3;
            } else {
                if (!"fill".equals(string4)) throw new IllegalArgumentException("xAlign must be one of left, center, right or fill, but was " + string4);
                this._xAlign = 6;
            }
            String string5 = stringTokenizer.nextToken();
            if ("top".equals(string5)) {
                this._yAlign = 4;
            } else if ("center".equals(string5)) {
                this._yAlign = 2;
            } else if ("bottom".equals(string5)) {
                this._yAlign = 5;
            } else {
                if (!"fill".equals(string5)) throw new IllegalArgumentException("yAlign must be one of top, center, bottom or fill, but was " + string5);
                this._yAlign = 6;
            }
        } else {
            this._xAlign = 1;
            this._yAlign = 2;
        }
        if (n == 8) {
            this._xWeight = Double.parseDouble(stringTokenizer.nextToken());
            this._yWeight = Double.parseDouble(stringTokenizer.nextToken());
        } else {
            this._xWeight = 0.0;
            this._yWeight = 0.0;
        }
        if (this._x < 0 && this._x != -2147483637 && this._x != -2147483636) {
            throw new IllegalArgumentException("x must not be negative: " + this._x);
        }
        if (this._y < 0 && this._y != -2147483637 && this._y != -2147483636) {
            throw new IllegalArgumentException("y must not be negative: " + this._y);
        }
        if (this._width <= 0) {
            throw new IllegalArgumentException("width must be positiv: " + this._width);
        }
        if (this._height <= 0) {
            throw new IllegalArgumentException("height must be positiv: " + this._height);
        }
        if (this._xAlign != 1 && this._xAlign != 2 && this._xAlign != 3 && this._xAlign != 6) {
            throw new IllegalArgumentException("xAlign must be one of LEFT, CENTER, RIGHT or FILL: " + this._xAlign);
        }
        if (this._yAlign != 4 && this._yAlign != 2 && this._yAlign != 5 && this._yAlign != 6) {
            throw new IllegalArgumentException("yAlign must be one of TOP, CENTER, BOTTOM or FILL: " + this._yAlign);
        }
        if (this._xWeight < 0.0) {
            throw new IllegalArgumentException("xWeight must not be negative: " + this._xWeight);
        }
        if (!(this._yWeight < 0.0)) return;
        throw new IllegalArgumentException("yWeight must not be negative: " + this._yWeight);
    }

    public XTableConstraints(int n, int n2) {
        this(n, n2, 1, 1, 1, 2, 0.0, 0.0);
    }

    public XTableConstraints(int n, int n2, int n3, int n4) {
        this(n, n2, n3, n4, 1, 2, 0.0, 0.0);
    }

    public XTableConstraints(int n, int n2, int n3, int n4, int n5, int n6) {
        this(n, n2, n3, n4, n5, n6, 0.0, 0.0);
    }

    public XTableConstraints(int n, int n2, int n3, int n4, int n5, int n6, double d, double d2) {
        if (n < 0 && n != -2147483637 && n != -2147483636) {
            throw new IllegalArgumentException("x must not be negative: " + n);
        }
        if (n2 < 0 && n2 != -2147483637 && n2 != -2147483636) {
            throw new IllegalArgumentException("y must not be negative: " + n2);
        }
        if (n3 <= 0) {
            throw new IllegalArgumentException("width must be positiv: " + n3);
        }
        if (n4 <= 0) {
            throw new IllegalArgumentException("height must be positiv: " + n4);
        }
        if (n5 != 1 && n5 != 2 && n5 != 3 && n5 != 6) {
            throw new IllegalArgumentException("xAlign must be one of LEFT, CENTER, RIGHT or FILL: " + n5);
        }
        if (n6 != 4 && n6 != 2 && n6 != 5 && n6 != 6) {
            throw new IllegalArgumentException("yAlign must be one of TOP, CENTER, BOTTOM or FILL: " + n6);
        }
        if (d < 0.0) {
            throw new IllegalArgumentException("xWeight must not be negative: " + d);
        }
        if (d2 < 0.0) {
            throw new IllegalArgumentException("yWeight must not be negative: " + d2);
        }
        this._x = n;
        this._y = n2;
        this._width = n3;
        this._height = n4;
        this._xAlign = n5;
        this._yAlign = n6;
        this._xWeight = d;
        this._yWeight = d2;
    }

    public boolean equals(Object object) {
        if (!(object instanceof XTableConstraints)) {
            return false;
        }
        XTableConstraints xTableConstraints = (XTableConstraints)object;
        if (this._height != xTableConstraints._height) {
            return false;
        }
        if (this._width != xTableConstraints._width) {
            return false;
        }
        if (this._x != xTableConstraints._x) {
            return false;
        }
        if (this._xAlign != xTableConstraints._xAlign) {
            return false;
        }
        if (this._xWeight != xTableConstraints._xWeight) {
            return false;
        }
        if (this._y != xTableConstraints._y) {
            return false;
        }
        if (this._yAlign != xTableConstraints._yAlign) {
            return false;
        }
        return this._yWeight == xTableConstraints._yWeight;
    }

    public int hashCode() {
        int n = this._x;
        n = 29 * n + this._y;
        n = 29 * n + this._width;
        n = 29 * n + this._height;
        n = 29 * n + this._xAlign;
        n = 29 * n + this._yAlign;
        long l = Double.doubleToLongBits(this._xWeight);
        n = 29 * n + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this._yWeight);
        n = 29 * n + (int)(l ^ l >>> 32);
        return n;
    }

    public XTableConstraints resolveRelativePositions(int n, int n2, int n3, int n4) {
        int n5;
        if (this._x != -2147483637 && this._x != -2147483636 && this._y != -2147483637 && this._y != -2147483636) {
            return this;
        }
        int n6 = this._x == -2147483637 ? n : (n5 = this._x == -2147483636 ? n + n3 : this._x);
        int n7 = this._y == -2147483637 ? n2 : (this._y == -2147483636 ? n2 + n4 : this._y);
        XTableConstraints xTableConstraints = new XTableConstraints(n5, n7, this._width, this._height, this._xAlign, this._yAlign, this._xWeight, this._yWeight);
        return xTableConstraints;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("XTableConstraints@");
        stringBuffer.append(Integer.toHexString(System.identityHashCode(this)));
        stringBuffer.append("[x=");
        stringBuffer.append(this.B(this._x));
        stringBuffer.append(",y=");
        stringBuffer.append(this.B(this._y));
        stringBuffer.append(",width=");
        stringBuffer.append(this._width);
        stringBuffer.append(",height=");
        stringBuffer.append(this._height);
        stringBuffer.append(",xAlign=");
        stringBuffer.append(this.A(this._xAlign));
        stringBuffer.append(",yAlign=");
        stringBuffer.append(this.A(this._yAlign));
        stringBuffer.append("]");
        return new String(stringBuffer);
    }

    private String B(int n) {
        switch (n) {
            case -2147483637: {
                return "SAME";
            }
            case -2147483636: {
                return "NEXT";
            }
        }
        return Integer.toString(n);
    }

    private String A(int n) {
        switch (n) {
            case 1: {
                return "LEFT";
            }
            case 2: {
                return "CENTER";
            }
            case 3: {
                return "RIGHT";
            }
            case 4: {
                return "TOP";
            }
            case 5: {
                return "BOTTOM";
            }
            case 6: {
                return "FILL";
            }
        }
        return Integer.toString(n) + "?";
    }
}

