/*
 * Decompiled with CFR 0.152.
 */
package com.gentleware.swingx;

import com.gentleware.openapi.util.CollectionFactory;
import com.gentleware.openapi.util.Files;
import com.gentleware.openapi.util.Pile;
import com.gentleware.swingx.I;
import com.gentleware.swingx.P;
import com.gentleware.swingx.UiConstants;
import com.xduke.datatips.DataTipManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Toolkit;
import java.io.File;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.filechooser.FileSystemView;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellEditor;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class FileSystemPanel
extends JPanel {
    private final FileSystemView A = FileSystemView.getFileSystemView();
    private static _C B;
    protected final I _treeModel = new I(this.A);
    final CellEditorListener _cellEditorListener;
    private final JTree C = new JTree(this._treeModel);

    public FileSystemPanel() {
        super(new BorderLayout());
        this._cellEditorListener = new CellEditorListener(){

            public void editingStopped(ChangeEvent changeEvent) {
                TreeCellEditor treeCellEditor = FileSystemPanel.this.C.getCellEditor();
                Object object = treeCellEditor.getCellEditorValue();
                String string = object.toString();
                treeCellEditor.cancelCellEditing();
                P p = (P)FileSystemPanel.this.C.getSelectionPath().getLastPathComponent();
                File file = p.F();
                File file2 = new File(file.getParentFile(), string);
                if (file.renameTo(file2)) {
                    p.A(file2);
                    FileSystemPanel.this.A();
                }
            }

            public void editingCanceled(ChangeEvent changeEvent) {
            }
        };
        DefaultTreeCellEditor defaultTreeCellEditor = new DefaultTreeCellEditor(this.C, null);
        this.C.setCellEditor(defaultTreeCellEditor);
        DataTipManager.get().register(this.C);
        this.C.setCellRenderer(new _A());
        this.C.setRootVisible(false);
        this.C.expandRow(0);
        this.C.setEditable(true);
        this.C.setScrollsOnExpand(true);
        this.C.addTreeExpansionListener(new _B());
        defaultTreeCellEditor.addCellEditorListener(this._cellEditorListener);
        this.add((Component)new JScrollPane(this.C), "Center");
        this.C.setBorder(UiConstants.PANEL_OUTER_BORDER);
    }

    public String getHistoryDirectoryPath(TreePath treePath) {
        Object object = treePath.getLastPathComponent();
        P p = (P)object;
        return p.F().getAbsolutePath();
    }

    private void A() {
        TreeCellEditor treeCellEditor = this.C.getCellEditor();
        this.C.updateUI();
        treeCellEditor.addCellEditorListener(this._cellEditorListener);
    }

    public void selectFile(File file) {
        Serializable serializable;
        while (file != null && !file.isDirectory() && (serializable = file.getParentFile()) != file) {
            file = serializable;
        }
        if (file == null) {
            return;
        }
        file = Files.getCanonicalFile((File)file);
        serializable = new ArrayList();
        serializable.add(file);
        while ((file = this.A.getParentDirectory(file)) != null) {
            serializable.add(0, file);
        }
        ArrayList<DefaultMutableTreeNode> arrayList = new ArrayList<DefaultMutableTreeNode>();
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.C.getModel().getRoot();
        arrayList.add(defaultMutableTreeNode);
        boolean bl = true;
        block2: while (serializable.size() > 0 && bl) {
            bl = false;
            int n = defaultMutableTreeNode.getChildCount();
            for (int i = 0; i < n; ++i) {
                DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i);
                File file2 = ((P)defaultMutableTreeNode2).F();
                if (!serializable.get(0).equals(file2)) continue;
                arrayList.add(defaultMutableTreeNode2);
                serializable.remove(0);
                defaultMutableTreeNode = defaultMutableTreeNode2;
                bl = true;
                continue block2;
            }
        }
        TreePath treePath = new TreePath(arrayList.toArray());
        this.C.expandPath(treePath);
        this.C.setSelectionPath(treePath);
        this.C.scrollPathToVisible(treePath);
    }

    public File getDirectory() {
        TreePath treePath = this.C.getLeadSelectionPath();
        Object object = treePath.getLastPathComponent();
        if (object instanceof P) {
            P p = (P)object;
            return p.F();
        }
        return null;
    }

    public String getDirectoryName() {
        TreePath treePath = this.C.getLeadSelectionPath();
        Object object = treePath.getLastPathComponent();
        if (object instanceof P) {
            P p = (P)object;
            return p.toString();
        }
        return null;
    }

    public void update(boolean bl) {
        TreePath treePath = this.C.getSelectionPath();
        I i = new I(FileSystemView.getFileSystemView(), bl);
        this.C.setModel(i);
        if (treePath != null) {
            P p = (P)treePath.getLastPathComponent();
            File file = p.F();
            while (!file.exists()) {
                file = file.getParentFile();
            }
            this.selectFile(file);
        } else {
            this.C.expandRow(0);
        }
    }

    public void startEditing() {
        TreePath treePath = this.C.getSelectionPath();
        if (treePath == null) {
            return;
        }
        this.C.scrollPathToVisible(treePath);
        this.C.startEditingAtPath(treePath);
    }

    public boolean createSpecifiedDir(String string) {
        File file;
        if (this.C.getSelectionPath() == null) {
            return false;
        }
        String string2 = this.getHistoryDirectoryPath(this.C.getSelectionPath());
        if (!(string = string.replace('\\', '/')).startsWith(string2 = string2.replace('\\', '/'))) {
            string = string2 + "/" + string;
        }
        if (!(file = new File(string)).exists() && file.mkdirs()) {
            String string3 = string.substring(string2.length() + 1);
            String[] stringArray = string3.split("[\\\\/]");
            TreePath treePath = this.C.getSelectionPath();
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            String string4 = string2 + "/" + stringArray[0];
            File file2 = new File(string4);
            P p = new P(file2);
            p.A(file2);
            defaultMutableTreeNode.add(p);
            this._treeModel.nodeStructureChanged(defaultMutableTreeNode);
            for (int i = 1; i < stringArray.length; ++i) {
                string4 = string4 + "/" + stringArray[i];
            }
            this.selectFile(new File(string4));
            return true;
        }
        return false;
    }

    public String createDirectory() {
        TreePath treePath = this.C.getSelectionPath();
        String string = "New Folder";
        if (treePath == null || treePath.getPathCount() < 2) {
            return string;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        P p = (P)defaultMutableTreeNode;
        if (p == null) {
            return string;
        }
        File file = p.F();
        int n = 0;
        File file2 = new File(file, string);
        while (file2.exists()) {
            file2 = new File(file, string + ++n);
        }
        if (!file2.mkdirs()) {
            return file2.getName();
        }
        P p2 = new P(file2);
        p2.A(file2);
        defaultMutableTreeNode.add(p2);
        this._treeModel.nodeStructureChanged(defaultMutableTreeNode);
        treePath = treePath.pathByAddingChild(p2);
        this.C.scrollPathToVisible(treePath);
        this.C.expandPath(treePath);
        this.A();
        this.C.setSelectionPath(treePath);
        this.startEditing();
        return null;
    }

    public boolean deleteDirectory() {
        TreePath treePath = this.C.getSelectionPath();
        if (treePath == null || treePath.getPathCount() < 3) {
            return false;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        P p = (P)defaultMutableTreeNode;
        if (p == null) {
            return false;
        }
        File file = p.F();
        if (file == null) {
            return false;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        Files.clearDirectory((File)file, (boolean)true);
        if (!file.delete()) {
            return false;
        }
        this.setCursor(Cursor.getPredefinedCursor(0));
        TreeNode treeNode = defaultMutableTreeNode.getParent();
        defaultMutableTreeNode.removeFromParent();
        this._treeModel.nodeStructureChanged(treeNode);
        treePath = treePath.getParentPath();
        this.C.expandPath(treePath);
        this.A();
        this.C.setSelectionPath(treePath);
        return true;
    }

    private static synchronized void A(P p, JTree jTree) {
        if (p.E()) {
            if (B == null || !B.isAlive()) {
                B = new _C();
                B.start();
            }
            B.A(p, jTree);
        }
    }

    public JTree getTree() {
        return this.C;
    }

    public static void main(String[] stringArray) {
        Toolkit.getDefaultToolkit().setDynamicLayout(true);
        FileSystemPanel fileSystemPanel = new FileSystemPanel();
        fileSystemPanel.selectFile(new File("H:\\daten\\Development\\documentation\\UML"));
        JFrame jFrame = new JFrame();
        jFrame.getContentPane().add(fileSystemPanel);
        jFrame.setBounds(100, 100, 300, 300);
        jFrame.setDefaultCloseOperation(3);
        jFrame.setVisible(true);
    }

    private static final class _C
    extends Thread {
        private volatile Pile C = CollectionFactory.createPile();
        private Object A = new Object();
        private volatile boolean B = true;

        public _C() {
            super("NodeBackgroundLoader");
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void A(P p, JTree jTree) {
            if (this.isAlive()) {
                Object object = this.A;
                synchronized (object) {
                    if (this.B) {
                        this.C.push((Object)new _A(p, jTree));
                        this.A.notifyAll();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (this.B) {
                Object object;
                while (this.C.size() > 0) {
                    object = (_A)this.C.pop();
                    final P p = ((_A)object).A;
                    final JTree jTree = ((_A)object).B;
                    p.getChildCount();
                    Runnable runnable = new Runnable(){

                        public void run() {
                            DefaultTreeModel defaultTreeModel = (DefaultTreeModel)jTree.getModel();
                            defaultTreeModel.nodeChanged(p);
                            jTree.repaint();
                        }
                    };
                    try {
                        SwingUtilities.invokeAndWait(runnable);
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        invocationTargetException.printStackTrace();
                    }
                }
                try {
                    object = this.A;
                    synchronized (object) {
                        this.A.wait(10000L);
                    }
                    if (this.C.size() != 0) continue;
                    this.B = false;
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            }
        }

        private static final class _A {
            private P A;
            private JTree B;

            public _A(P p, JTree jTree) {
                this.A = p;
                this.B = jTree;
            }
        }
    }

    private class _A
    extends DefaultTreeCellRenderer {
        private _A() {
        }

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            DefaultTreeCellRenderer defaultTreeCellRenderer = (DefaultTreeCellRenderer)super.getTreeCellRendererComponent(jTree, object, bl, bl2, false, n, bl4);
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
            Object object2 = defaultMutableTreeNode.getUserObject();
            if (object2 instanceof File) {
                File file = (File)object2;
                defaultTreeCellRenderer.setText(FileSystemPanel.this.A.getSystemDisplayName(file));
                defaultTreeCellRenderer.setIcon(FileSystemPanel.this.A.getSystemIcon(file));
            }
            return defaultTreeCellRenderer;
        }
    }

    private class _B
    implements TreeExpansionListener {
        private _B() {
        }

        public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
        }

        public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
            P p;
            Object object;
            if (treeExpansionEvent.getPath() != null && (object = treeExpansionEvent.getPath().getLastPathComponent()) instanceof P && (p = (P)object).C()) {
                Enumeration<TreeNode> enumeration = p.children();
                while (enumeration.hasMoreElements()) {
                    P p2 = (P)enumeration.nextElement();
                    FileSystemPanel.A(p2, (JTree)treeExpansionEvent.getSource());
                }
            }
        }
    }
}

