/*
 * Decompiled with CFR 0.152.
 */
package com.gentleware.swingx;

import com.gentleware.openapi.swingx.Localizer;
import com.gentleware.openapi.swingx.ResourceId;
import com.gentleware.openapi.swingx.SwingFactory;
import com.gentleware.openapi.swingx.SwingUtil;
import com.gentleware.openapi.swingx.XTableLayout;
import com.gentleware.swingx.UiConstants;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class ProgressDialog
extends JDialog {
    private boolean D;
    private JLabel E;
    private JTextArea I;
    private JTextArea A;
    private JProgressBar G;
    private AbstractButton C;
    private JPanel H;
    private Font J = new Font("dialog", 1, 10);
    private JScrollPane F;
    private boolean B;

    public ProgressDialog(Frame frame, ResourceId resourceId) {
        this(frame, resourceId, false);
    }

    public ProgressDialog(Frame frame, ResourceId resourceId, boolean bl) {
        super(frame, Localizer.localize(resourceId));
        this.D = bl;
        this.I = new JTextArea();
        this.I.setBackground(this.getBackground());
        this.I.setFont(this.J);
        this.A = new JTextArea(8, 80);
        this.I.setBackground(this.getBackground());
        this.I.setFont(this.J);
        JPanel jPanel = new JPanel(new XTableLayout(5, 5));
        jPanel.setBorder(UiConstants.PANEL_OUTER_BORDER);
        this.setContentPane(jPanel);
        this.C = SwingFactory.makeButton(new ResourceId("Menu", "Cancel"));
        this.H = new JPanel(new FlowLayout());
        this.H.setMinimumSize(new Dimension(40, 110));
        this.G = new JProgressBar();
        this.G.setMinimum(0);
        this.G.setMinimumSize(new Dimension(100, 30));
        this.G.setSize(new Dimension(100, 30));
    }

    public void addActionListener(ActionListener actionListener) {
        if (this.D) {
            this.C.addActionListener(actionListener);
        }
    }

    public void setMaximum(int n) {
        this.G.setMaximum(n);
    }

    public void initDialog(String string, int n) {
        this.A(n, new JLabel(string));
    }

    public void initDialog(ResourceId resourceId, int n) {
        this.A(n, SwingFactory.makeLabel(resourceId, null));
    }

    private void A(int n, JLabel jLabel) {
        this.E = jLabel;
        this.G.setMaximum(n);
        this.I.setEditable(false);
        if (!this.B) {
            Container container = this.getContentPane();
            container.add((Component)this.E, "0 0");
            container.add((Component)this.I, "0 1 1 1 center fill 1 0");
            container.add((Component)this.G, "0 2 1 1 center center 1 0");
            if (this.D) {
                container.add((Component)this.C, "0 3 1 1 right center 1 0");
            }
            this.F = new JScrollPane(this.A);
            container.add((Component)this.F, "0 4 1 1 fill fill 1 1");
            this.B = true;
        }
        this.C.requestFocus();
        this.F.setVisible(false);
        this.pack();
        if (this.getWidth() < 400) {
            this.setSize(400, this.getHeight());
        }
        if (this.getHeight() < 150) {
            this.setSize(this.getWidth(), 150);
        }
    }

    public String getLogText() {
        return this.A.getText();
    }

    public void addLogText(String string) {
        this.A.append(string + '\n');
        this.A.setCaretPosition(this.A.getText().length());
        if (!this.F.isVisible()) {
            this.F.setVisible(true);
            Dimension dimension = this.getPreferredSize();
            Dimension dimension2 = this.getSize();
            Point point = this.getLocation();
            Rectangle rectangle = SwingUtil.getScreenBounds(point.x, point.y, false);
            int n = Math.max(0, dimension.width - dimension2.width) / 2;
            int n2 = Math.max(0, dimension.height - dimension2.height) / 2;
            dimension2.width = Math.max(dimension2.width, dimension.width);
            dimension2.height = Math.max(dimension2.height, dimension.height);
            int n3 = Math.max(rectangle.x, point.x - n);
            int n4 = Math.max(rectangle.y, point.y - n2);
            this.setLocation(n3, n4);
            this.setSize(dimension2);
            this.F.invalidate();
            this.invalidate();
            this.validate();
            this.repaint();
        }
    }

    public void showProgressDialog(ResourceId resourceId, Component component, int n) {
        this.initDialog(resourceId, n);
        this.showProgressDialog(component);
    }

    public void showProgressDialog(String string, Component component, int n) {
        this.initDialog(string, n);
        this.showProgressDialog(component);
    }

    public void showProgressDialog(Component component) {
        SwingUtil.centerOnScreen(this, 0.5f, 0.25f);
        this.setVisible(true);
    }

    public void hideProgressDialog() {
        this.setVisible(false);
        this.dispose();
    }

    public void setConcreteText(String string) {
        this.I.setText(string);
        this.repaint();
    }

    public void showProgress(int n) {
        this.G.setValue(n);
    }

    public void incProgress(int n) {
        if (!this.G.isIndeterminate()) {
            this.G.setValue(this.G.getValue() + n);
        }
    }

    public void setProgressValue(int n) {
        if (!this.G.isIndeterminate()) {
            this.G.setValue(n);
        }
    }

    public boolean isCancelable() {
        return this.D;
    }

    public void resetProgress() {
        this.G.setValue(0);
    }

    public void setCancelable(boolean bl) {
        this.D = bl;
    }

    public void setIndeterminate(boolean bl) {
        this.G.setIndeterminate(bl);
    }
}

