/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.piccolo;

import edu.umd.cs.piccolo.PCamera;
import edu.umd.cs.piccolo.PComponent;
import edu.umd.cs.piccolo.PLayer;
import edu.umd.cs.piccolo.PRoot;
import edu.umd.cs.piccolo.event.PInputEventListener;
import edu.umd.cs.piccolo.event.PPanEventHandler;
import edu.umd.cs.piccolo.event.PZoomEventHandler;
import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolo.util.PDebug;
import edu.umd.cs.piccolo.util.PPaintContext;
import edu.umd.cs.piccolo.util.PStack;
import edu.umd.cs.piccolo.util.PUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.JComponent;
import javax.swing.RepaintManager;
import javax.swing.Timer;

public class PCanvas
extends JComponent
implements PComponent {
    public static PCanvas CURRENT_ZCANVAS = null;
    private PCamera camera;
    private PStack cursorStack;
    private int interacting;
    private int defaultRenderQuality;
    private int animatingRenderQuality;
    private int interactingRenderQuality;
    private PPanEventHandler panEventHandler;
    private PZoomEventHandler zoomEventHandler;
    private boolean paintingImmediately;
    private boolean animatingOnLastPaint;
    private boolean isButton1Pressed;
    private boolean isButton2Pressed;
    private boolean isButton3Pressed;
    private boolean lastModifiers;

    public PCanvas() {
        CURRENT_ZCANVAS = this;
        this.cursorStack = new PStack();
        this.setCamera(PUtil.createBasicScenegraph());
        this.installInputSources();
        this.setDefaultRenderQuality(1);
        this.setAnimatingRenderQuality(0);
        this.setInteractingRenderQuality(0);
        this.setPanEventHandler(new PPanEventHandler());
        this.setZoomEventHandler(new PZoomEventHandler());
        this.setBackground(Color.WHITE);
    }

    public PPanEventHandler getPanEventHandler() {
        return this.panEventHandler;
    }

    public void setPanEventHandler(PPanEventHandler handler) {
        if (this.panEventHandler != null) {
            this.removeInputEventListener(this.panEventHandler);
        }
        this.panEventHandler = handler;
        if (this.panEventHandler != null) {
            this.addInputEventListener(this.panEventHandler);
        }
    }

    public PZoomEventHandler getZoomEventHandler() {
        return this.zoomEventHandler;
    }

    public void setZoomEventHandler(PZoomEventHandler handler) {
        if (this.zoomEventHandler != null) {
            this.removeInputEventListener(this.zoomEventHandler);
        }
        this.zoomEventHandler = handler;
        if (this.zoomEventHandler != null) {
            this.addInputEventListener(this.zoomEventHandler);
        }
    }

    public PCamera getCamera() {
        return this.camera;
    }

    public void setCamera(PCamera newCamera) {
        if (this.camera != null) {
            this.camera.setComponent(null);
        }
        this.camera = newCamera;
        if (this.camera != null) {
            this.camera.setComponent(this);
            this.camera.setBounds(this.getBounds());
        }
    }

    public PRoot getRoot() {
        return this.camera.getRoot();
    }

    public PLayer getLayer() {
        return this.camera.getLayer(0);
    }

    public void addInputEventListener(PInputEventListener listener) {
        this.getCamera().addInputEventListener(listener);
    }

    public void removeInputEventListener(PInputEventListener listener) {
        this.getCamera().removeInputEventListener(listener);
    }

    public boolean getInteracting() {
        return this.interacting > 0;
    }

    public boolean getAnimating() {
        return this.getRoot().getActivityScheduler().getAnimating();
    }

    public void setInteracting(boolean isInteracting) {
        this.interacting = isInteracting ? ++this.interacting : --this.interacting;
        if (!this.getInteracting()) {
            int nextRenderQuality = this.defaultRenderQuality;
            if (this.getAnimating()) {
                nextRenderQuality = this.animatingRenderQuality;
            }
            if (nextRenderQuality > this.interactingRenderQuality) {
                this.repaint();
            }
        }
    }

    public void setDefaultRenderQuality(int requestedQuality) {
        this.defaultRenderQuality = requestedQuality;
        this.repaint();
    }

    public void setAnimatingRenderQuality(int requestedQuality) {
        this.animatingRenderQuality = requestedQuality;
        if (this.getAnimating()) {
            this.repaint();
        }
    }

    public void setInteractingRenderQuality(int requestedQuality) {
        this.interactingRenderQuality = requestedQuality;
        if (this.getInteracting()) {
            this.repaint();
        }
    }

    public void pushCursor(Cursor cursor) {
        this.cursorStack.push(this.getCursor());
        this.setCursor(cursor);
    }

    public void popCursor() {
        this.setCursor((Cursor)this.cursorStack.pop());
    }

    protected void installInputSources() {
        this.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent e) {
                PCanvas.this.sendInputEventToInputManager(e, 500);
            }

            public void mouseEntered(MouseEvent e) {
                MouseEvent simulated = null;
                simulated = (e.getModifiersEx() & 0x1C00) != 0 ? new MouseEvent((Component)e.getSource(), 506, e.getWhen(), e.getModifiers(), e.getX(), e.getY(), e.getClickCount(), e.isPopupTrigger(), e.getButton()) : new MouseEvent((Component)e.getSource(), 503, e.getWhen(), e.getModifiers(), e.getX(), e.getY(), e.getClickCount(), e.isPopupTrigger(), e.getButton());
                PCanvas.this.sendInputEventToInputManager(simulated, simulated.getID());
                PCanvas.this.sendInputEventToInputManager(e, 504);
            }

            public void mouseExited(MouseEvent e) {
                MouseEvent simulated = null;
                simulated = (e.getModifiersEx() & 0x1C00) != 0 ? new MouseEvent((Component)e.getSource(), 506, e.getWhen(), e.getModifiers(), e.getX(), e.getY(), e.getClickCount(), e.isPopupTrigger(), e.getButton()) : new MouseEvent((Component)e.getSource(), 503, e.getWhen(), e.getModifiers(), e.getX(), e.getY(), e.getClickCount(), e.isPopupTrigger(), e.getButton());
                PCanvas.this.sendInputEventToInputManager(simulated, simulated.getID());
                PCanvas.this.sendInputEventToInputManager(e, 505);
            }

            public void mousePressed(MouseEvent e) {
                PCanvas.this.requestFocus();
                boolean shouldBalanceEvent = false;
                if (e.getButton() == 0) {
                    if ((e.getModifiers() & 0x10) == 16) {
                        e = new MouseEvent((Component)e.getSource(), 501, e.getWhen(), e.getModifiers(), e.getX(), e.getY(), e.getClickCount(), e.isPopupTrigger(), 1);
                    } else if ((e.getModifiers() & 8) == 8) {
                        e = new MouseEvent((Component)e.getSource(), 501, e.getWhen(), e.getModifiers(), e.getX(), e.getY(), e.getClickCount(), e.isPopupTrigger(), 2);
                    } else if ((e.getModifiers() & 4) == 4) {
                        e = new MouseEvent((Component)e.getSource(), 501, e.getWhen(), e.getModifiers(), e.getX(), e.getY(), e.getClickCount(), e.isPopupTrigger(), 3);
                    }
                }
                switch (e.getButton()) {
                    case 1: {
                        if (PCanvas.this.isButton1Pressed) {
                            shouldBalanceEvent = true;
                        }
                        PCanvas.this.isButton1Pressed = true;
                        break;
                    }
                    case 2: {
                        if (PCanvas.this.isButton2Pressed) {
                            shouldBalanceEvent = true;
                        }
                        PCanvas.this.isButton2Pressed = true;
                        break;
                    }
                    case 3: {
                        if (PCanvas.this.isButton3Pressed) {
                            shouldBalanceEvent = true;
                        }
                        PCanvas.this.isButton3Pressed = true;
                    }
                }
                if (shouldBalanceEvent) {
                    MouseEvent balanceEvent = new MouseEvent((Component)e.getSource(), 502, e.getWhen(), e.getModifiers(), e.getX(), e.getY(), e.getClickCount(), e.isPopupTrigger(), e.getButton());
                    PCanvas.this.sendInputEventToInputManager(balanceEvent, 502);
                }
                PCanvas.this.sendInputEventToInputManager(e, 501);
            }

            public void mouseReleased(MouseEvent e) {
                boolean shouldBalanceEvent = false;
                if (e.getButton() == 0) {
                    if ((e.getModifiers() & 0x10) == 16) {
                        e = new MouseEvent((Component)e.getSource(), 502, e.getWhen(), e.getModifiers(), e.getX(), e.getY(), e.getClickCount(), e.isPopupTrigger(), 1);
                    } else if ((e.getModifiers() & 8) == 8) {
                        e = new MouseEvent((Component)e.getSource(), 502, e.getWhen(), e.getModifiers(), e.getX(), e.getY(), e.getClickCount(), e.isPopupTrigger(), 2);
                    } else if ((e.getModifiers() & 4) == 4) {
                        e = new MouseEvent((Component)e.getSource(), 502, e.getWhen(), e.getModifiers(), e.getX(), e.getY(), e.getClickCount(), e.isPopupTrigger(), 3);
                    }
                }
                switch (e.getButton()) {
                    case 1: {
                        if (!PCanvas.this.isButton1Pressed) {
                            shouldBalanceEvent = true;
                        }
                        PCanvas.this.isButton1Pressed = false;
                        break;
                    }
                    case 2: {
                        if (!PCanvas.this.isButton2Pressed) {
                            shouldBalanceEvent = true;
                        }
                        PCanvas.this.isButton2Pressed = false;
                        break;
                    }
                    case 3: {
                        if (!PCanvas.this.isButton3Pressed) {
                            shouldBalanceEvent = true;
                        }
                        PCanvas.this.isButton3Pressed = false;
                    }
                }
                if (shouldBalanceEvent) {
                    MouseEvent balanceEvent = new MouseEvent((Component)e.getSource(), 501, e.getWhen(), e.getModifiers(), e.getX(), e.getY(), e.getClickCount(), e.isPopupTrigger(), e.getButton());
                    PCanvas.this.sendInputEventToInputManager(balanceEvent, 501);
                }
                PCanvas.this.sendInputEventToInputManager(e, 502);
            }
        });
        this.addMouseMotionListener(new MouseMotionListener(){

            public void mouseDragged(MouseEvent e) {
                PCanvas.this.sendInputEventToInputManager(e, 506);
            }

            public void mouseMoved(MouseEvent e) {
                PCanvas.this.sendInputEventToInputManager(e, 503);
            }
        });
        this.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                PCanvas.this.sendInputEventToInputManager(e, 401);
            }

            public void keyReleased(KeyEvent e) {
                PCanvas.this.sendInputEventToInputManager(e, 402);
            }

            public void keyTyped(KeyEvent e) {
                PCanvas.this.sendInputEventToInputManager(e, 400);
            }
        });
        this.addMouseWheelListener(new MouseWheelListener(){

            public void mouseWheelMoved(MouseWheelEvent e) {
                PCanvas.this.sendInputEventToInputManager(e, e.getScrollType());
                if (!e.isConsumed() && PCanvas.this.getParent() != null) {
                    PCanvas.this.getParent().dispatchEvent(e);
                }
            }
        });
    }

    protected void sendInputEventToInputManager(InputEvent e, int type) {
        this.getRoot().getDefaultInputManager().processEventFromCamera(e, type, this.getCamera());
    }

    public void setBounds(int x, int y, int w, int h) {
        this.camera.setBounds(this.camera.getX(), this.camera.getY(), w, h);
        super.setBounds(x, y, w, h);
    }

    public void repaint(PBounds bounds) {
        bounds.expandNearestIntegerDimensions();
        bounds.inset(-1.0, -1.0);
        this.repaint((int)bounds.x, (int)bounds.y, (int)bounds.width, (int)bounds.height);
    }

    public void paintComponent(Graphics g) {
        PDebug.startProcessingOutput();
        Graphics2D g2 = (Graphics2D)g.create();
        g2.setColor(this.getBackground());
        g2.fillRect(0, 0, this.getWidth(), this.getHeight());
        PPaintContext paintContext = new PPaintContext(g2);
        if (this.getInteracting() || this.getAnimating()) {
            if (this.interactingRenderQuality < this.animatingRenderQuality) {
                paintContext.setRenderQuality(this.interactingRenderQuality);
            } else {
                paintContext.setRenderQuality(this.animatingRenderQuality);
            }
        } else {
            paintContext.setRenderQuality(this.defaultRenderQuality);
        }
        this.camera.fullPaint(paintContext);
        if (!this.getAnimating() && this.animatingOnLastPaint) {
            this.repaint();
        }
        this.animatingOnLastPaint = this.getAnimating();
        PDebug.endProcessingOutput(g2);
    }

    public void paintImmediately() {
        if (this.paintingImmediately) {
            return;
        }
        this.paintingImmediately = true;
        RepaintManager.currentManager(this).paintDirtyRegions();
        this.paintingImmediately = false;
    }

    public Timer createTimer(int delay, ActionListener listener) {
        return new Timer(delay, listener);
    }
}

