/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.jmi.xmi;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class DefaultWriter
extends DefaultHandler {
    private static final char QUOTE = '\'';
    private static final char EOL = '\n';
    private static final String INDENT = "  ";
    private static final int INDENT_LENGTH = "  ".length();
    private static final int MAX = 70;
    private static final String XMI_VERSION = "1.2";
    private static final String EXPORTER_NAME = "Netbeans XMI Writer";
    private static final String EXPORTER_VERSION = "1.0";
    private static final String DEFAULT_ENCODING = "ISO-8859-1";
    private OutputStreamWriter writer;
    private Locator locator;
    private String encoding = null;
    private boolean hasContent = true;
    private boolean hasCharacters = false;
    private String indentSpaces = "";
    private int charsCount = 0;

    public DefaultWriter() {
    }

    public DefaultWriter(OutputStreamWriter writer, String encoding) {
        this.writer = writer;
        this.encoding = encoding;
    }

    public void init() throws SAXException {
        this.hasContent = true;
        this.hasCharacters = true;
        this.indentSpaces = "";
        this.charsCount = 0;
        if (this.writer == null) {
            try {
                OutputStream ostr = new URL(this.locator.getSystemId()).openConnection().getOutputStream();
                this.writer = new OutputStreamWriter(ostr);
            }
            catch (IOException e) {
                throw new SAXException(e);
            }
        }
        String enc = this.encoding != null ? this.encoding : DEFAULT_ENCODING;
        this.write("<?xml version = '1.0' encoding = '" + enc + "' ?>");
        this.writeln();
    }

    public Writer getWriter() {
        return this.writer;
    }

    private void write(String text) throws SAXException {
        try {
            this.writer.write(text);
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    private void writeln() throws SAXException {
        try {
            this.writer.write("\r\n");
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
        this.charsCount = 0;
    }

    private String replaceSpecialChars(String s, boolean replaceWhitechars) {
        int length = s.length();
        char[] chars = new char[6 * length];
        int n = 0;
        block12: for (int x = 0; x < length; ++x) {
            char c = s.charAt(x);
            switch (c) {
                case '&': {
                    chars[n] = 38;
                    chars[++n] = 97;
                    chars[++n] = 109;
                    chars[++n] = 112;
                    chars[++n] = 59;
                    ++n;
                    continue block12;
                }
                case '\'': {
                    chars[n] = 38;
                    chars[++n] = 97;
                    chars[++n] = 112;
                    chars[++n] = 111;
                    chars[++n] = 115;
                    chars[++n] = 59;
                    ++n;
                    continue block12;
                }
                case '\"': {
                    chars[n] = 38;
                    chars[++n] = 113;
                    chars[++n] = 117;
                    chars[++n] = 111;
                    chars[++n] = 116;
                    chars[++n] = 59;
                    ++n;
                    continue block12;
                }
                case '<': {
                    chars[n] = 38;
                    chars[++n] = 108;
                    chars[++n] = 116;
                    chars[++n] = 59;
                    ++n;
                    continue block12;
                }
                case '>': {
                    chars[n] = 38;
                    chars[++n] = 103;
                    chars[++n] = 116;
                    chars[++n] = 59;
                    ++n;
                    continue block12;
                }
                default: {
                    if (replaceWhitechars) {
                        switch (c) {
                            case '\n': {
                                chars[n] = 38;
                                chars[++n] = 35;
                                chars[++n] = 49;
                                chars[++n] = 48;
                                chars[++n] = 59;
                                ++n;
                                continue block12;
                            }
                            case '\r': {
                                chars[n] = 38;
                                chars[++n] = 35;
                                chars[++n] = 49;
                                chars[++n] = 51;
                                chars[++n] = 59;
                                ++n;
                                continue block12;
                            }
                            case '\t': {
                                chars[n] = 38;
                                chars[++n] = 35;
                                chars[++n] = 57;
                                chars[++n] = 59;
                                ++n;
                                continue block12;
                            }
                        }
                        chars[n] = c;
                        ++n;
                        continue block12;
                    }
                    chars[n] = c;
                    ++n;
                }
            }
        }
        return new String(chars, 0, n);
    }

    private void startElement(String name, Attributes attrs) throws SAXException {
        if (!this.hasContent && !this.hasCharacters) {
            this.write(">");
            this.writeln();
        }
        this.hasContent = false;
        this.hasCharacters = false;
        this.write(this.indentSpaces);
        this.write("<" + name);
        this.charsCount += name.length() + 1;
        this.indentSpaces = this.indentSpaces + INDENT;
        for (int x = 0; x < attrs.getLength(); ++x) {
            this.addAttribute(attrs.getQName(x), attrs.getValue(x));
        }
    }

    private void endElement(String name) throws SAXException {
        this.indentSpaces = this.indentSpaces.substring(0, this.indentSpaces.length() - INDENT_LENGTH);
        if (this.hasContent) {
            this.write(this.indentSpaces);
            this.write("</" + name + ">");
        } else if (this.hasCharacters) {
            this.write("</" + name + ">");
        } else {
            this.write("/>");
        }
        this.writeln();
        this.hasContent = true;
    }

    private void addAttribute(String name, String value) throws SAXException {
        value = this.replaceSpecialChars(value, true);
        if (this.charsCount > 70) {
            this.writeln();
            this.write(this.indentSpaces);
        } else {
            this.write(" ");
            ++this.charsCount;
        }
        this.write(name + " = " + '\'' + value + '\'');
        this.charsCount += name.length() + value.length() + 5;
    }

    private void characters(String text) throws SAXException {
        text = this.replaceSpecialChars(text, false);
        if (!this.hasContent) {
            this.write(">");
        }
        this.write(text);
        this.hasCharacters = true;
    }

    public void startDocument() throws SAXException {
        this.init();
    }

    public void endDocument() throws SAXException {
        try {
            this.writer.flush();
            this.writer.close();
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    public void startElement(String uri, String sName, String qName, Attributes attributes) throws SAXException {
        this.startElement(qName, attributes);
    }

    public void endElement(String uri, String sName, String qName) throws SAXException {
        this.endElement(qName);
    }

    public void characters(char[] buf, int offset, int len) throws SAXException {
        this.characters(new String(buf, offset, len));
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }
}

