/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.jmi.xmi;

import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import javax.jmi.model.AggregationKind;
import javax.jmi.model.AggregationKindEnum;
import javax.jmi.model.Attribute;
import javax.jmi.model.Classifier;
import javax.jmi.model.EnumerationType;
import javax.jmi.model.ModelElement;
import javax.jmi.model.MofClass;
import javax.jmi.model.MofPackage;
import javax.jmi.model.PrimitiveType;
import javax.jmi.model.Reference;
import javax.jmi.model.StructuralFeature;
import javax.jmi.model.StructureField;
import javax.jmi.model.StructureType;
import javax.jmi.model.TypedElement;
import javax.jmi.reflect.RefClass;
import javax.jmi.reflect.RefObject;
import javax.jmi.reflect.RefPackage;
import javax.jmi.reflect.RefStruct;
import org.netbeans.api.xmi.XMIOutputConfig;
import org.netbeans.api.xmi.XMIReferenceProvider;
import org.netbeans.lib.jmi.util.DebugException;
import org.netbeans.lib.jmi.util.Logger;
import org.netbeans.lib.jmi.xmi.WriterBase;
import org.netbeans.mdr.util.AbstractCollectionFactory;
import org.xml.sax.SAXException;

public class XMI20Writer
extends WriterBase {
    private static final String XMI_VERSION = "2.0";
    private static final String XMI_NAMESPACE = "";
    private Map nsPrefixToURI;

    public XMI20Writer() {
    }

    public XMI20Writer(XMIOutputConfig config) {
        super(config);
    }

    public void init() throws IOException {
        super.init();
        this.nsPrefixToURI = AbstractCollectionFactory.getCollectionFactory().createHashMap();
    }

    protected void findNamespaces(RefPackage pkg) {
        Iterator iter;
        if (this.processedPackages.contains(pkg)) {
            return;
        }
        MofPackage metaPackage = (MofPackage)pkg.refMetaObject();
        String name = this.getNsPrefixTag((ModelElement)metaPackage);
        if (name == null) {
            name = XMI20Writer.getTagValue((ModelElement)metaPackage, "org.omg.xmi.namespace");
        }
        if (name != null) {
            iter = metaPackage.getQualifiedName().iterator();
            String fqName = (String)iter.next();
            while (iter.hasNext()) {
                fqName = fqName.concat(".").concat((String)iter.next());
            }
            this.namespaces.put(fqName, name);
            String uri = this.getNsURITag((ModelElement)metaPackage);
            if (uri == null) {
                throw new DebugException("A tag defining namespace uri not found, package " + metaPackage.getName());
            }
            this.nsPrefixToURI.put(name, uri);
        }
        this.processedPackages.add(pkg);
        iter = pkg.refAllPackages().iterator();
        while (iter.hasNext()) {
            this.findNamespaces((RefPackage)iter.next());
        }
    }

    protected void writeDocument(RefPackage pkg) {
        try {
            this.contentHandler.startDocument();
        }
        catch (SAXException e) {
            // empty catch block
        }
        this.startElement("XMI");
        this.addAttribute("version", XMI_VERSION);
        this.writeNamespaces();
        if (!this.collectionWriting) {
            this.processedPackages.clear();
            this.writePackage(pkg);
            while (this.nonWrittenComponents.size() > 0) {
                RefObject obj;
                Iterator iter = this.nonWrittenComponents.iterator();
                while (this.nonWrittenComponents.contains((obj = (RefObject)iter.next()).refImmediateComposite())) {
                }
                this.writeInstance(obj, true);
                while (this.lightOutermosts.size() > 0) {
                    obj = (RefObject)this.lightOutermosts.remove(0);
                    this.writeInstance(obj, true);
                }
            }
            this.processedPackages.clear();
            this.writeStaticAttributes(pkg);
        } else {
            this.writeObjects();
        }
        this.processedPackages.clear();
        this.writeAssociations(pkg);
        this.endElement("XMI");
        try {
            this.contentHandler.endDocument();
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
    }

    protected void writeNamespaces() {
        String xmiNamespace = XMI_NAMESPACE.length() == 0 ? "xmlns" : "xmlns:" + XMI_NAMESPACE.substring(XMI_NAMESPACE.length() - 1);
        this.addAttribute(xmiNamespace, "http://www.omg.org/XMI");
        Map temp = AbstractCollectionFactory.getCollectionFactory().createHashMap();
        Iterator iter = this.namespaces.entrySet().iterator();
        while (iter.hasNext()) {
            String name = (String)iter.next().getValue();
            if (temp.get(name) != null) continue;
            temp.put(name, name);
            this.addAttribute("xmlns:" + name, (String)this.nsPrefixToURI.get(name));
        }
    }

    protected void writeInstance(RefObject obj, boolean isTop) {
        RefClass proxy = obj.refClass();
        ModelElement element = (ModelElement)obj.refMetaObject();
        String name = this.qualifiedName(element);
        XMIReferenceProvider.XMIReference xmiRef = this.provider.getReference(obj);
        String xmiId = xmiRef.getXmiId();
        String systemId = xmiRef.getSystemId();
        if (systemId != null && this.thisSystemId != null && this.thisSystemId.equals(systemId)) {
            systemId = null;
        }
        this.markWritten(obj);
        if (systemId != null) {
            if (!isTop) {
                this.startElement(name);
                this.addAttribute("href", systemId + '#' + xmiId);
                this.endElement(name);
            }
            this.collectLightOutermosts(obj, proxy);
            return;
        }
        this.startElement(name);
        this.addAttribute("id", xmiId);
        Iterator attrs = this.instanceAttributes((MofClass)proxy.refMetaObject()).iterator();
        LinkedList<Attribute> attrsInContent = new LinkedList<Attribute>();
        while (attrs.hasNext()) {
            Classifier type;
            Object value;
            Attribute attr = (Attribute)attrs.next();
            if (!this.isSerializeTag((ModelElement)attr)) continue;
            if (this.isElementTag((ModelElement)attr)) {
                attrsInContent.add(attr);
                continue;
            }
            boolean isMultivalued = XMI20Writer.isMultivalued((StructuralFeature)attr);
            try {
                value = obj.refGetValue((RefObject)attr);
            }
            catch (Exception e) {
                Logger.getDefault().annotate((Throwable)e, ((ModelElement)obj.refMetaObject()).getName() + " " + attr.getName());
                Logger.getDefault().notify((Throwable)e);
                value = Boolean.FALSE;
            }
            Object valueToWrite = value;
            if (value == null) continue;
            if (isMultivalued) {
                Collection col = (Collection)value;
                if (col.isEmpty()) continue;
                if (col.size() > 1) {
                    attrsInContent.add(attr);
                    continue;
                }
                valueToWrite = col.iterator().next();
            }
            if (!((type = XMI20Writer.getType((TypedElement)attr)) instanceof PrimitiveType) && !(type instanceof EnumerationType)) {
                attrsInContent.add(attr);
                continue;
            }
            this.writeValueInAttr((TypedElement)attr, valueToWrite);
        }
        Iterator iter = attrsInContent.iterator();
        while (iter.hasNext()) {
            Attribute attr = (Attribute)iter.next();
            this.writeValueInContent((TypedElement)attr, obj.refGetValue((RefObject)attr));
        }
        Iterator refs = this.references((MofClass)proxy.refMetaObject()).iterator();
        while (refs.hasNext()) {
            Reference ref = (Reference)refs.next();
            this.writeReference(obj, ref);
        }
        this.endElement(name);
    }

    protected void writeInstanceRef(RefObject obj, boolean externalOnly, boolean hrefForced) {
        String name = this.qualifiedName((ModelElement)obj.refMetaObject());
        XMIReferenceProvider.XMIReference xmiRef = this.provider.getReference(obj);
        String xmiId = xmiRef.getXmiId();
        String systemId = xmiRef.getSystemId();
        if (externalOnly && systemId == null) {
            return;
        }
        if (systemId != null && this.thisSystemId != null && this.thisSystemId.equals(systemId) && !hrefForced) {
            systemId = null;
        } else if (systemId == null && hrefForced) {
            systemId = this.thisSystemId;
        }
        this.startElement(name);
        if (systemId == null) {
            this.addAttribute("idref", xmiId);
        } else {
            this.addAttribute("href", systemId + '#' + xmiId);
        }
        this.endElement(name);
    }

    protected void writeStructure(StructureType type, RefStruct value) {
        String name = this.qualifiedName((ModelElement)type);
        this.startElement(name);
        Iterator content = this.structureFields(type).iterator();
        LinkedList<StructureField> fields = new LinkedList<StructureField>();
        while (content.hasNext()) {
            StructureField field = (StructureField)content.next();
            if (!this.isSerializeTag((ModelElement)field)) continue;
            if (this.isElementTag((ModelElement)field)) {
                fields.add(field);
                continue;
            }
            Classifier fieldType = XMI20Writer.getType((TypedElement)field);
            if (fieldType instanceof PrimitiveType || fieldType instanceof EnumerationType) {
                this.writeValueInAttr((TypedElement)field, value.refGetValue(field.getName()));
                continue;
            }
            fields.add(field);
        }
        Iterator iter = fields.iterator();
        while (iter.hasNext()) {
            StructureField field = (StructureField)iter.next();
            Object fieldValue = value.refGetValue(field.getName());
            this.writeValueInContent((TypedElement)field, fieldValue);
        }
        this.endElement(name);
    }

    protected void writeReference(RefObject obj, Reference ref) {
        Iterator iter;
        LinkedList<Object> values;
        AggregationKind kind = ref.getReferencedEnd().getAggregation();
        if (AggregationKindEnum.COMPOSITE.equals((Object)kind)) {
            return;
        }
        kind = ref.getExposedEnd().getAggregation();
        boolean isComposite = AggregationKindEnum.COMPOSITE.equals((Object)kind);
        Object temp = obj.refGetValue((RefObject)ref);
        if (temp == null) {
            return;
        }
        if (XMI20Writer.isMultivalued((StructuralFeature)ref)) {
            values = (LinkedList<Object>)temp;
        } else {
            values = new LinkedList<Object>();
            values.add(temp);
        }
        if (this.collectionWriting) {
            LinkedList<RefObject> cValues = new LinkedList<RefObject>();
            iter = values.iterator();
            while (iter.hasNext()) {
                RefObject referencedObject = (RefObject)iter.next();
                if (!this.isInClosure(referencedObject)) continue;
                cValues.add(referencedObject);
            }
            values = cValues;
        }
        if (values.isEmpty()) {
            return;
        }
        String name = this.qualifiedName((ModelElement)ref);
        this.startElement(name);
        iter = values.iterator();
        while (iter.hasNext()) {
            RefObject endValue = (RefObject)iter.next();
            if (isComposite) {
                this.writeInstance(endValue, false);
                continue;
            }
            this.writeInstanceRef(endValue, this.isRemoteOnlyTag((ModelElement)ref), this.isHrefTag((ModelElement)ref));
        }
        this.endElement(name);
    }

    public String labelPrefix(EnumerationType type) {
        return XMI_NAMESPACE;
    }

    protected String qualifiedName(ModelElement element) {
        String namespace;
        String xmiName;
        Iterator iter = element.getQualifiedName().iterator();
        String name = (String)iter.next();
        while (iter.hasNext()) {
            name = name.concat(".").concat((String)iter.next());
        }
        int index = name.lastIndexOf(46);
        String pName = name.substring(0, index);
        String sName = name.substring(index + 1, name.length());
        if (!(element instanceof MofClass) && (index = pName.lastIndexOf(46)) != -1) {
            pName = pName.substring(0, index);
            sName = name.substring(index + 1, name.length());
        }
        if ((xmiName = this.getXmiNameTag(element)) != null) {
            sName = xmiName;
        }
        if ((namespace = (String)this.namespaces.get(pName)) != null) {
            return namespace + ":" + sName;
        }
        return pName + '.' + sName;
    }

    protected String elementName(ModelElement elem) {
        String name = this.getXmiNameTag(elem);
        return name != null ? name : elem.getName();
    }

    public String getContentScopedTagValue(ModelElement elem, String tagId) {
        String value = null;
        while (value == null && elem != null) {
            value = XMI20Writer.getTagValue(elem, tagId);
            elem = elem.getContainer();
        }
        if (value != null) {
            value = value.trim();
        }
        return value;
    }

    public boolean isElementTag(ModelElement elem) {
        String value = this.getContentScopedTagValue(elem, "org.omg.xmi.element");
        return value != null && value.equals("true");
    }

    public boolean isHrefTag(ModelElement elem) {
        String value = this.getContentScopedTagValue(elem, "org.omg.xmi.href");
        return value != null && value.equals("true");
    }

    public String getXmiNameTag(ModelElement elem) {
        return XMI20Writer.getTagValue(elem, "org.omg.xmi.xmiName");
    }

    public boolean isSerializeTag(ModelElement elem) {
        String value = XMI20Writer.getTagValue(elem, "org.omg.xmi.serialize");
        return value == null || value.equals("true");
    }

    public boolean isRemoteOnlyTag(ModelElement elem) {
        String value = XMI20Writer.getTagValue(elem, "org.omg.xmi.remoteOnly");
        return value != null && value.equals("true");
    }

    public String getNsPrefixTag(ModelElement elem) {
        return this.getContentScopedTagValue(elem, "org.omg.xmi.nsPrefix");
    }

    public String getNsURITag(ModelElement elem) {
        return this.getContentScopedTagValue(elem, "org.omg.xmi.nsURI");
    }
}

