/*
 * Decompiled with CFR 0.152.
 */
package com.gentleware.poseidon.generator;

import com.gentleware.openapi.util.CollectionFactory;
import com.gentleware.poseidon.generator.C;
import com.gentleware.poseidon.generator.ElementPreparator;
import com.gentleware.poseidon.generator.PreparationCheckingException;
import com.gentleware.poseidon.generator.PreparationException;
import com.gentleware.poseidon.generator.PreparedElement;
import com.gentleware.poseidon.util.PoseidonUtils;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class ElementPreparatorImpl
implements ElementPreparator {
    private static final Logger A = Logger.getLogger((String)"com.gentleware.poseidon.generator.ElementPreparatorImpl");
    private boolean B;
    private Map F;
    private Map E;
    private Map D;
    private C C;

    public boolean checkEnabled() {
        return this.B;
    }

    public void setCheckEnabled(boolean bl) {
        this.B = bl;
    }

    public void init() {
        this.F = CollectionFactory.createHashMap();
        this.E = CollectionFactory.createHashMap();
        this.D = CollectionFactory.createHashMap();
        this.C = null;
        this.initPreparedElementClasses();
    }

    public Map getPreparedElements() {
        return this.F;
    }

    public PreparedElement getPreparedElement(Object object) {
        return (PreparedElement)this.F.get(object);
    }

    public PreparedElement getOrCreatePreparedElement(Object object) {
        PreparedElement preparedElement = (PreparedElement)this.F.get(object);
        if (preparedElement != null) {
            return preparedElement;
        }
        try {
            preparedElement = this.prepare(object);
            this.F.put(object, preparedElement);
        }
        catch (PreparationException preparationException) {
            A.error((Object)("[ElementPreparatorImpl.getOrCreatePreparedElement]: cannot create PreparedElement for " + object), (Throwable)preparationException);
        }
        return preparedElement;
    }

    public void addPreparedElement(Object object, PreparedElement preparedElement) {
        this.F.put(object, preparedElement);
    }

    public Map getPreparedElementClassMap() {
        return this.E;
    }

    public Class getPreparedElementClass(Class clazz) {
        try {
            Object t = clazz.newInstance();
            return this.getPreparedElementClass(t);
        }
        catch (Exception exception) {
            A.error((Object)"Exception when trying to simulate Poseidon V1.4.1.");
            return null;
        }
    }

    public Class getPreparedElementClass(Object object) {
        Iterator iterator = this.E.keySet().iterator();
        while (iterator.hasNext()) {
            Class clazz = (Class)iterator.next();
            if (!PoseidonUtils.isIdenticalClass(object.getClass(), clazz)) continue;
            return (Class)this.getPreparedElementClassMap().get(clazz);
        }
        return null;
    }

    public void addPreparedElementClass(Class clazz, Class clazz2) {
        this.getPreparedElementClassMap().put(clazz, clazz2);
    }

    public void addExternalElementClasses(String string, Map map) {
        this.D.put(string, map);
    }

    public void removeExternalElementClasses(String string) {
        this.D.remove(string);
    }

    public PreparedElement getPreparedElementInstance(Class clazz) {
        try {
            Object t = clazz.newInstance();
            return this.getPreparedElementInstance(t);
        }
        catch (Exception exception) {
            A.error((Object)"Exception when trying to simulate Poseidon V1.4.1.", (Throwable)exception);
            return null;
        }
    }

    public PreparedElement getPreparedElementInstance(Object object) {
        Class clazz = this.getPreparedElementClass(object);
        if (clazz == null) {
            A.debug((Object)("[ElementPreparatorImpl] No preparedElementInstance for class " + object.getClass().getName() + " available."));
            return null;
        }
        PreparedElement preparedElement = null;
        try {
            preparedElement = (PreparedElement)clazz.newInstance();
        }
        catch (Exception exception) {
            A.warn((Object)("Could not find preparator class for " + object.getClass().getName()), (Throwable)exception);
        }
        return preparedElement;
    }

    public void reloadPreparedElementClasses() {
        this.E = CollectionFactory.createHashMap();
        this.initPreparedElementClasses();
        if (this.D.size() > 0) {
            Iterator iterator = this.D.keySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                if (!this.useExternalEntries(string)) continue;
                this.E.putAll((Map)this.D.get(string));
            }
        }
    }

    protected void initPreparedElementClasses() {
    }

    protected boolean useExternalEntries(String string) {
        if (this.C == null) {
            return false;
        }
        return this.C.A(string);
    }

    public void setExternalPreparationClassStrategy(C c2) {
        this.C = c2;
    }

    public String check(Object object) throws PreparationCheckingException {
        PreparedElement preparedElement = (PreparedElement)this.getPreparedElements().get(object);
        if (preparedElement == null) {
            throw new PreparationCheckingException("prepared element of " + object + " is null", object);
        }
        return preparedElement.check();
    }
}

