/*
 * Decompiled with CFR 0.152.
 */
package com.gentleware.poseidon.integration;

import com.gentleware.openapi.configuration.Services;
import com.gentleware.openapi.util.CollectionFactory;
import com.gentleware.poseidon.BuildProperties;
import com.gentleware.poseidon.Poseidon;
import com.gentleware.poseidon.generator.GenerateException;
import com.gentleware.poseidon.generator.GeneratorController;
import com.gentleware.poseidon.generator.GeneratorFactory;
import com.gentleware.poseidon.generator.ui.DialogController;
import com.gentleware.poseidon.integration.GenerationStartParameter;
import com.gentleware.poseidon.integration.SilentGenerator;
import com.gentleware.poseidon.jboogie.PoseidonApplicationState;
import com.gentleware.poseidon.kernel.PoseidonProject;
import com.gentleware.poseidon.ui.CheckNode;
import com.gentleware.poseidon.util.I;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.File;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JTextArea;
import javax.swing.tree.TreeNode;
import org.apache.log4j.Logger;

public class HeadlessCodeGenerator {
    private static final Logger C = Logger.getLogger((String)"com.gentleware.poseidon.integration.HeadlessCodeGenerator");
    private GenerationStartParameter D;
    private static final String A = "poseidon/codeGen/language";
    private PoseidonProject E;
    private final Set B = CollectionFactory.createWeakHashSet();

    public HeadlessCodeGenerator(GenerationStartParameter generationStartParameter) {
        this.A(generationStartParameter);
    }

    public boolean startCodeGeneration() {
        this.N();
        this.C();
        this.A();
        if (!this.B()) {
            C.error((Object)"[HeadlessCodeGenerator]: Could not continue because of invalid parameter");
            return false;
        }
        return true;
    }

    private void A(int n2) {
        if (n2 > 0) {
            Timer timer = new Timer();
            timer.schedule(new TimerTask(){

                public void run() {
                    try {
                        Services.getInstance();
                        C.error((Object)"Time Out!");
                    }
                    catch (IllegalStateException illegalStateException) {
                        System.out.println("Time Out!");
                    }
                    HeadlessCodeGenerator.this.fireCodeGenerationDone(false);
                    System.exit(3);
                }
            }, n2);
        }
    }

    private void C() {
        String[] stringArray = new String[]{};
        try {
            Poseidon.initStandalone(stringArray, false, false);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            this.fireCodeGenerationDone(false);
        }
    }

    private void A() {
        C.info((Object)"Executing Poseidon's Headless integration for code generation");
        C.info((Object)("Project to read           : " + this.K().getModel()));
        C.info((Object)("Zumldoc file              : " + this.K().getZumldocFilename()));
        C.info((Object)("Settings taken from folder: " + this.K().getConfigDir() + "/poseidon/" + BuildProperties.getEditionShort()));
        C.info((Object)("Language to generate      : " + this.K().getLanguage()));
        C.info((Object)("Sublanguage to generate   : " + this.K().getSublanguage()));
        C.info((Object)("Destination Folder        : " + this.K().getTarget()));
        C.info((Object)("Clear other files there   : " + this.K().isClearDestDir()));
        C.info((Object)("Automatic Cancel Delay    : " + this.K().getAutomaticCancelDelay()));
        C.info((Object)"Init configuration folder and configuration ...");
    }

    private void N() {
        PoseidonProject.addProjectListener(new VetoableChangeListener(){
            boolean A;

            public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
                String string = propertyChangeEvent.getPropertyName();
                if ("Loaded".equals(string)) {
                    C.info((Object)"[HeadlessCodeGenerator]: project loaded/created.");
                } else if ("LoadingFailed".equals(string)) {
                    C.error((Object)"[HeadlessCodeGenerator]: project loading failed!");
                    System.exit(1);
                } else if ("Created".equals(string)) {
                    if (!this.A) {
                        this.A = true;
                        HeadlessCodeGenerator.this.J();
                        C.info((Object)"[HeadlessCodeGenerator]: creating of new project");
                    } else {
                        C.info((Object)"[HeadlessCodeGenerator]: extent created catched, but ignored");
                    }
                } else if ("Closed".equals(string)) {
                    C.warn((Object)"[HeadlessCodeGenerator]: ignore closing of project a project");
                } else if ("LoadingPrepared".equals(string)) {
                    C.warn((Object)"[HeadlessCodeGenerator]: ignore preparing of project a project");
                } else {
                    C.error((Object)("[HeadlessCodeGenerator]: Unhandled Event: " + string + ". System stopped!"));
                }
            }
        });
    }

    private boolean B() {
        boolean bl = true;
        File file = new File(this.K().getModel());
        if (!file.exists()) {
            C.error((Object)("[HeadlessCodeGenerator]: Project file '" + file.getAbsolutePath() + "' does not exist."));
            bl = false;
        }
        return bl;
    }

    private void H() {
        String string = Services.getInstance().getConfiguration().makeKey("codeGen", "language");
        String string2 = Services.getInstance().getConfiguration().getString(string);
        Services.getInstance().getConfiguration().put(string, this.K().getLanguage());
        String string3 = Services.getInstance().getConfiguration().makeKey("codeGen", string2, "generate");
        Services.getInstance().getConfiguration().putBoolean(string3, false);
        String string4 = Services.getInstance().getConfiguration().makeKey("codeGen", this.K().getLanguage(), "generate");
        Services.getInstance().getConfiguration().putBoolean(string4, true);
    }

    private void J() {
        this.A(this.D.getAutomaticCancelDelay());
        boolean bl = true;
        C.info((Object)"Generate code to files ...");
        try {
            this.I();
        }
        catch (GenerateException generateException) {
            C.error((Object)("Generation failed because of " + generateException.getMessage()), (Throwable)generateException);
            bl = false;
        }
        catch (Exception exception) {
            C.error((Object)"CodeGeneration stopped due to internal error");
            exception.printStackTrace();
            System.exit(1);
        }
        C.info((Object)"done.");
        if (this.D.isCreateZumldoc()) {
            this.M();
        }
        this.fireCodeGenerationDone(bl);
    }

    private void I() throws GenerateException {
        String string = System.getProperty("generator");
        if (string != null) {
            try {
                Class<?> clazz = Class.forName(string);
                Object obj = clazz.newInstance();
                SilentGenerator silentGenerator = (SilentGenerator)obj;
                silentGenerator.doGenerate(this.K());
            }
            catch (ClassNotFoundException classNotFoundException) {
                C.error((Object)classNotFoundException);
            }
            catch (IllegalAccessException illegalAccessException) {
                C.error((Object)illegalAccessException);
            }
            catch (InstantiationException instantiationException) {
                C.error((Object)instantiationException);
            }
        }
    }

    private void E() {
        this.A(PoseidonApplicationState.getInstance().getCurrentProject());
        this.L();
        GeneratorController generatorController = this.F();
        CheckNode checkNode = this.G();
        C.info((Object)("[HeadlessCodeGenerator]: Root CheckNode: " + checkNode));
        List list = this.A(checkNode);
        String string = generatorController.generateCode(list, (CheckNode)checkNode.getFirstChild(), new JTextArea());
        C.info((Object)string);
    }

    private void L() {
        this.D().setSourcepath(this.K().getTarget());
        this.D().setSourcepath(this.K().getTarget(), this.K().getLanguage());
    }

    private GeneratorController F() {
        Services.getInstance().getConfiguration().put(A, this.K().getLanguage());
        GeneratorController generatorController = GeneratorFactory.getInstance().getGeneratorController(this.K().getLanguage());
        C.info((Object)("[HeadlessCodeGenerator]: GeneratorController: " + generatorController));
        GeneratorFactory.getInstance().reloadMacros();
        return generatorController;
    }

    private CheckNode G() {
        CheckNode checkNode = DialogController.createTree();
        if (checkNode != null) {
            checkNode.setSelected(true);
        } else {
            C.debug((Object)"[HeadlessCodeGenerator.createCheckNodeTree]: could not create CheckNode Tree!");
        }
        return checkNode;
    }

    private List A(CheckNode checkNode) {
        Enumeration<TreeNode> enumeration = checkNode.preorderEnumeration();
        List list = CollectionFactory.createArrayList();
        while (enumeration.hasMoreElements()) {
            CheckNode checkNode2 = (CheckNode)enumeration.nextElement();
            Object object = checkNode2.getUserObject();
            if (!this.E.getTopLevelClass().isInstance(object)) continue;
            list.add(object);
        }
        return list;
    }

    private File M() {
        I i2 = new I(this.D.getTarget(), this.D.getZumldocFilename());
        return i2.A();
    }

    private GenerationStartParameter K() {
        return this.D;
    }

    private void A(GenerationStartParameter generationStartParameter) {
        this.D = generationStartParameter;
    }

    private PoseidonProject D() {
        return this.E;
    }

    private void A(PoseidonProject poseidonProject) {
        this.E = poseidonProject;
    }

    public void addCodeGenerationListener(Listener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("HeadlessCodeGenerator.Listener may not be null!");
        }
        this.B.remove(listener);
        this.B.add(listener);
    }

    public void removeCodeGenerationListener(Listener listener) {
        this.B.remove(listener);
    }

    public synchronized void fireCodeGenerationDone(boolean bl) {
        Iterator iterator = this.B.iterator();
        while (iterator.hasNext()) {
            Listener listener = (Listener)iterator.next();
            try {
                listener.handleCodeGenerationDone(bl);
            }
            catch (Exception exception) {
                C.error((Object)"[HeadlessCodeGenerator.fireCodeGenerationDone]", (Throwable)exception);
            }
        }
    }

    public static interface Listener {
        public void handleCodeGenerationDone(boolean var1);
    }
}

