/*
 * Decompiled with CFR 0.152.
 */
package com.gentleware.poseidon.jboogie;

import com.gentleware.jboogie.kernel.JBoogie;
import com.gentleware.openapi.configuration.Configuration;
import com.gentleware.openapi.configuration.Services;
import com.gentleware.openapi.jboogie.Project;
import com.gentleware.openapi.jboogie.ProjectType;
import com.gentleware.openapi.util.CollectionFactory;
import com.gentleware.poseidon.BuildProperties;
import com.gentleware.poseidon.kernel.PoseidonProject;
import com.gentleware.poseidon.ui.ProjectPanel;
import com.gentleware.poseidon.ui.ProjectPanelManager;
import com.gentleware.poseidon.util.ChildGenerator;
import com.gentleware.poseidon.util.PoseidonUtils;
import java.beans.PropertyVetoException;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.log4j.Logger;

public class PoseidonApplicationState {
    private static final Logger C = Logger.getLogger((String)"com.gentleware.poseidon.jboogie.PoseidonApplicationState");
    private Map G = CollectionFactory.createHashMap();
    private Map F = CollectionFactory.createHashMap();
    private List E = new Vector();
    private int A = 1;
    private static PoseidonApplicationState B;
    public static final String PANELMANAGER_GLOBAL = "Global";
    private static boolean D;

    private PoseidonApplicationState() {
    }

    public static PoseidonApplicationState getInstance() {
        if (B == null) {
            B = new PoseidonApplicationState();
        }
        return B;
    }

    public static boolean isCE() {
        return BuildProperties.isCe();
    }

    public void dispose() {
        File file;
        if (PoseidonApplicationState.isCE() && (file = PoseidonUtils.getInstalledModuleFile()).exists()) {
            file.delete();
        }
    }

    public int getExtentNumber() {
        return this.A++;
    }

    public void registerProjectType(ProjectType projectType) {
        String string = projectType.getName();
        this.G.put(string, projectType);
    }

    public void deregisterProjectType(ProjectType projectType) {
        this.G.remove(projectType);
    }

    public PoseidonProject getProjectOfType(String string) {
        if (!this.G.containsKey(string)) {
            C.error((Object)("Project type " + string + " not registered!"));
            return null;
        }
        ProjectType projectType = (ProjectType)this.G.get(string);
        try {
            Project project = projectType.createProject();
            if (project instanceof PoseidonProject) {
                C.debug((Object)("Find project of type " + string));
                return (PoseidonProject)project;
            }
            C.info((Object)("Project type " + string + " could not be instantiated!"));
            return null;
        }
        catch (Exception exception) {
            C.info((Object)("Exception while instantiating new Project of type " + string), (Throwable)exception);
            return null;
        }
    }

    public ProjectPanel createProjectPanel() {
        try {
            ProjectPanel projectPanel = new ProjectPanel();
            try {
                ProjectPanel.fireProjectPanelCreated(null, projectPanel);
            }
            catch (PropertyVetoException propertyVetoException) {
                C.warn((Object)"Currently ignoring vetos against Project Panel Created events.");
            }
            return projectPanel;
        }
        catch (Exception exception) {
            C.warn((Object)"Exception while instantiating ProjectPanel.", (Throwable)exception);
            return null;
        }
    }

    public List getClassLoaderList() {
        return this.E;
    }

    public void setClassLoaderList(List list) {
        this.E.clear();
        this.E.addAll(list);
    }

    public PoseidonProject getCurrentProject() {
        return (PoseidonProject)JBoogie.getInstance().getCurrentProject();
    }

    public static void setLastProjectDirectory(String string) {
        Configuration configuration = Services.getInstance().getConfiguration();
        configuration.putString("poseidon/lastProjectDir", string);
    }

    public static String getLastProjectDirectory() {
        Configuration configuration = Services.getInstance().getConfiguration();
        String string = configuration.getString("poseidon/lastProjectDir");
        return string;
    }

    public static void setLastImportDirectory(String string) {
        Configuration configuration = Services.getInstance().getConfiguration();
        configuration.putString("poseidon/lastImportDir", string);
    }

    public static String getLastImportDirectory() {
        Configuration configuration = Services.getInstance().getConfiguration();
        String string = configuration.getString("poseidon/lastImportDir");
        return string;
    }

    public static void setLastGraphicsDirectory(String string) {
        Configuration configuration = Services.getInstance().getConfiguration();
        configuration.putString("poseidon/lastGraphicsDir", string);
    }

    public static String getLastGraphicsDirectory() {
        Configuration configuration = Services.getInstance().getConfiguration();
        String string = configuration.getString("poseidon/lastGraphicsDir");
        return string;
    }

    public static void setLastPluginDirectory(String string) {
        Configuration configuration = Services.getInstance().getConfiguration();
        configuration.putString("poseidon/lastPluginDir", string);
    }

    public static String getLastPluginDirectory() {
        Configuration configuration = Services.getInstance().getConfiguration();
        String string = configuration.getString("poseidon/lastPluginDir");
        return string;
    }

    public boolean registerPanelManagerType(String string, Class clazz) {
        if (this.F.containsKey(string)) {
            return true;
        }
        this.F.put(string, clazz);
        return true;
    }

    public boolean deregisterPanelManagerType(String string) {
        if (!this.F.containsKey(string)) {
            return true;
        }
        this.F.remove(string);
        return true;
    }

    public ProjectPanelManager getPanelManagerOfType(String string) {
        C.info((Object)("Trying to instantiate new PropPanelManager of type " + string));
        if (!this.F.containsKey(string)) {
            return null;
        }
        Class clazz = (Class)this.F.get(string);
        try {
            Object t = clazz.newInstance();
            if (t instanceof ProjectPanelManager) {
                return (ProjectPanelManager)t;
            }
            return null;
        }
        catch (Exception exception) {
            C.warn((Object)("Exception while instantiating new Project of type " + string), (Throwable)exception);
            return null;
        }
    }

    public void registerChildGenerator(String string, ChildGenerator childGenerator) {
    }

    public static void setHasOwnFrame(boolean bl) {
        D = bl;
    }

    public static boolean hasOwnFrame() {
        return D;
    }

    static {
        D = true;
    }
}

