/*
 * Decompiled with CFR 0.152.
 */
package com.gentleware.poseidon.kernel.settings;

import com.gentleware.openapi.configuration.Configuration;
import com.gentleware.openapi.util.CollectionFactory;
import com.gentleware.poseidon.kernel.PoseidonProject;
import com.gentleware.poseidon.kernel.settings.CustomConfigurationSettings;
import java.io.File;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;

public class CustomJavaImportSettings
extends CustomConfigurationSettings {
    private static final String E = File.pathSeparator;
    private static final String D = "java.lang.*" + E + "java.io.*" + E + "java.util.*" + E + "java.net.*";
    private static final String C = "javaimportsettings/import_as_attributes";
    private static final String A = "javaimportsettings/import_as_datatypes";
    private static final String B = "javaimportsettings/import_as_attributes_description";

    public CustomJavaImportSettings(PoseidonProject poseidonProject, String string, String string2, String string3) {
        this.setProject(poseidonProject);
        this.setImportAsAttributes(string);
        this.setImportAsDatatypes(string2);
        this.setImportAsAttributesDescription(string3);
    }

    public CustomJavaImportSettings(CustomJavaImportSettings customJavaImportSettings) {
        this(customJavaImportSettings.getProject(), customJavaImportSettings.getImportAsAttributes(), customJavaImportSettings.getImportAsDatatypes(), customJavaImportSettings.getImportAsAttributesDescription());
    }

    public CustomJavaImportSettings(PoseidonProject poseidonProject) {
        this.setProject(poseidonProject);
        this.resetToDefaults();
    }

    public String getImportAsAttributes() {
        return this.getConfiguration().getString(C);
    }

    public void setImportAsAttributes(String string) {
        this.getConfiguration().putString(C, string);
    }

    public String getImportAsDatatypes() {
        return this.getConfiguration().getString(A);
    }

    public void setImportAsDatatypes(String string) {
        this.getConfiguration().put(A, string);
    }

    public boolean isImportAsAttributes() {
        return this.getConfiguration().getBoolean(C);
    }

    public void setImportAsAttributes(boolean bl) {
        this.getConfiguration().putBoolean(C, bl);
    }

    public boolean isImportAsDatatypes() {
        return this.getConfiguration().getBoolean(A);
    }

    public void setImportAsDatatypes(boolean bl) {
        this.getConfiguration().putBoolean(A, bl);
    }

    public String getImportAsAttributesDescription() {
        return this.getConfiguration().getString(B);
    }

    public void setImportAsAttributesDescription(String string) {
        this.getConfiguration().putString(B, string);
    }

    public List getImportAsAttributesList() {
        Pattern pattern = Pattern.compile(E);
        String string = this.getImportAsAttributesDescription();
        boolean bl = false;
        if (string == null) {
            string = D;
            bl = true;
        }
        String[] stringArray = pattern.split(string);
        List<String> list = Arrays.asList(stringArray);
        List list2 = CollectionFactory.createArrayList(list);
        if (bl) {
            this.convertImportAsAttributesList2String(list2);
        }
        return list2;
    }

    public void convertImportAsAttributesList2String(List list) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = "";
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            stringBuffer.append(string);
            stringBuffer.append(string2);
            string = E;
        }
        this.setImportAsAttributesDescription(stringBuffer.toString());
    }

    public void addImportAsAttributesPackage(String string) {
        List list = this.getImportAsAttributesList();
        list.add(string);
        this.convertImportAsAttributesList2String(list);
    }

    public boolean removeImportAsAttributesPackage(String string) {
        List list = this.getImportAsAttributesList();
        boolean bl = list.remove(string);
        if (bl) {
            this.convertImportAsAttributesList2String(list);
        }
        return bl;
    }

    public void saveAsDefault() {
        Configuration configuration = this.getApplicationConfiguration();
        configuration.putBoolean(C, this.isImportAsAttributes());
        configuration.putBoolean(A, this.isImportAsDatatypes());
        configuration.putString(B, this.getImportAsAttributesDescription());
    }

    public void resetToDefaults() {
        Configuration configuration = this.getApplicationConfiguration();
        this.setImportAsAttributes(configuration.getBoolean(C, false));
        this.setImportAsDatatypes(configuration.getBoolean(A, true));
        this.setImportAsAttributesDescription(configuration.getString(B, D));
    }
}

