/*
 * Decompiled with CFR 0.152.
 */
package com.gentleware.poseidon.ui;

import com.gentleware.jboogie.util.JBoogieUtils;
import com.gentleware.openapi.jboogie.Project;
import com.gentleware.openapi.jboogie.ProjectAction;
import com.gentleware.openapi.swingx.Localizer;
import com.gentleware.openapi.swingx.ResourceId;
import com.gentleware.openapi.swingx.SwingFactory;
import com.gentleware.poseidon.BuildProperties;
import com.gentleware.poseidon.kernel.PoseidonProject;
import com.gentleware.poseidon.merging.ProjectReaderWriterManager;
import com.gentleware.poseidon.openapi.PoseidonUIConnector;
import com.gentleware.poseidon.ui.CoreResourceBundle;
import com.gentleware.poseidon.ui.MenuResourceBundle;
import com.gentleware.poseidon.ui.PoseidonFrame;
import com.gentleware.poseidon.util.FileFilters;
import com.gentleware.poseidon.util.UmlFunctions;
import com.gentleware.swingx.SuffixFileFilter;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.beans.PropertyVetoException;
import java.io.File;
import java.text.MessageFormat;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;

public class ActionExportProjectToXmi
extends ProjectAction {
    private static final Logger I = Logger.getLogger((String)"com.gentleware.poseidon.ui.ActionExportProjectToXmi");
    private static JFileChooser K;
    private static JPanel L;
    private static JCheckBox J;

    public ActionExportProjectToXmi(Project project) {
        super(project, MenuResourceBundle.ExportProjectToXmi);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.doExport();
    }

    public void doExport() {
        if (ProjectReaderWriterManager.getInstance().allowedToSave((PoseidonProject)this.getProject())) {
            this.B();
        } else {
            String string = Localizer.localize((ResourceId)CoreResourceBundle.evaluationLimit);
            Object[] objectArray = new Object[]{BuildProperties.getPoseidonNameShort(), BuildProperties.getEvalLimit()};
            String string2 = MessageFormat.format(string, objectArray);
            String string3 = Localizer.localize((ResourceId)CoreResourceBundle.evalLimitTitle);
            JBoogieUtils.showMessageDialog((Component)PoseidonUIConnector.getApplicationWindow(), (Object)string2, (String)string3, (int)1);
        }
    }

    private static void C() {
        if (K != null) {
            return;
        }
        K = new JFileChooser();
        K.setName("ExportProjectToXmi");
        SuffixFileFilter suffixFileFilter = FileFilters.getFilter("xmi");
        K.addChoosableFileFilter((FileFilter)suffixFileFilter);
        K.removeChoosableFileFilter(K.getAcceptAllFileFilter());
        K.setFileFilter((FileFilter)suffixFileFilter);
        L = new JPanel(new FlowLayout());
        J = SwingFactory.makeCheckBox((ResourceId)MenuResourceBundle.SaveWithDiagram);
        J.setEnabled(true);
        J.setSelected(true);
        L.add(J);
        K.setAccessory(L);
    }

    private boolean B() {
        String string;
        PoseidonProject poseidonProject = (PoseidonProject)this.getProject();
        if (poseidonProject == null) {
            return false;
        }
        Frame frame = PoseidonUIConnector.getApplicationWindow();
        ActionExportProjectToXmi.C();
        try {
            if (poseidonProject.getUrl() != null) {
                string = poseidonProject.getUrl().getFile();
                if (string.endsWith(".zuml")) {
                    string = string.substring(0, string.length() - ".zuml".length());
                }
                if (string.length() > 0 && !string.startsWith("/FILE1/+/")) {
                    K.setSelectedFile(new File(string));
                }
            }
        }
        catch (RuntimeException runtimeException) {
            I.error((Object)"[ActionExportProjectToXmi:Opening FileChooser]", (Throwable)runtimeException);
        }
        string = poseidonProject.getName();
        K.setDialogTitle(Localizer.localize((ResourceId)MenuResourceBundle.ExportProjectToXmi) + ": " + string);
        int n2 = K.showSaveDialog(frame);
        if (n2 != 0) {
            return false;
        }
        File file = K.getSelectedFile();
        if (file == null) {
            return false;
        }
        String string2 = file.getPath();
        boolean bl = string2.endsWith(".xmi");
        if (!bl) {
            file = new File(string2 + ".xmi");
        }
        PoseidonUIConnector.showStatus("Writing " + file.getPath() + " ...");
        poseidonProject.updateProjectBeforeAction();
        boolean bl2 = J == null ? false : J.isSelected();
        boolean bl3 = UmlFunctions.exportToXmi(poseidonProject, file, false, bl2);
        if (bl3 && string.equals(Localizer.localize((ResourceId)CoreResourceBundle.Untitled))) {
            try {
                poseidonProject.setFile(file);
                PoseidonFrame poseidonFrame = (PoseidonFrame)PoseidonUIConnector.getApplicationWindow();
                poseidonFrame.updateTitle();
            }
            catch (PropertyVetoException propertyVetoException) {
                I.error((Object)("Cannot set project name " + file.getName()), (Throwable)propertyVetoException);
            }
        }
        return bl3;
    }
}

