/*
 * Decompiled with CFR 0.152.
 */
package com.gentleware.poseidon.ui;

import com.gentleware.jboogie.kernel.ProjectImpl;
import com.gentleware.jboogie.kernel.TargetManager;
import com.gentleware.jboogie.model_management.DiAccessory;
import com.gentleware.jboogie.ui.DiagramPanel;
import com.gentleware.openapi.configuration.Configuration;
import com.gentleware.openapi.configuration.Services;
import com.gentleware.openapi.jboogie.Project;
import com.gentleware.openapi.jboogie.Target;
import com.gentleware.openapi.swingx.SwingUtil;
import com.gentleware.openapi.swingx.XTab;
import com.gentleware.openapi.swingx.XTabbedPane;
import com.gentleware.openapi.util.CollectionFactory;
import com.gentleware.openapi.util.Files;
import com.gentleware.openapi.util.ServiceRegistry;
import com.gentleware.openapi.util.Utils;
import com.gentleware.poseidon.jboogie.PoseidonApplicationState;
import com.gentleware.poseidon.kernel.PoseidonProject;
import com.gentleware.poseidon.openapi.PoseidonProjectConnector;
import com.gentleware.poseidon.openapi.PoseidonUIConnector;
import com.gentleware.poseidon.ui.ActionOpenNamedProject;
import com.gentleware.poseidon.ui.BirdviewPanel;
import com.gentleware.poseidon.ui.DetailsPane;
import com.gentleware.poseidon.ui.DiagramManager;
import com.gentleware.poseidon.ui.G;
import com.gentleware.poseidon.ui.MainPanel;
import com.gentleware.poseidon.ui.NavigationPanel;
import com.gentleware.poseidon.ui.PoseidonPanelManager;
import com.gentleware.poseidon.ui.ProjectPanelManager;
import com.gentleware.poseidon.ui.SplashScreen;
import com.gentleware.poseidon.ui.StatusBar;
import com.gentleware.poseidon.ui.ThreeSplitsManager;
import com.gentleware.poseidon.ui.gadgets.A;
import com.gentleware.poseidon.ui.gadgets.SelectionToolbar;
import com.gentleware.poseidon.util.L;
import edu.umd.cs.piccolo.PCanvas;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Point;
import java.awt.datatransfer.Clipboard;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.jmi.reflect.RefObject;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;
import org.netbeans.jmiimpl.omg.uml2.diagraminterchange.DiagramImpl;
import org.omg.uml2.diagraminterchange.Diagram;

public class ProjectPanel
extends JPanel {
    private static final Logger M = Logger.getLogger((String)"com.gentleware.poseidon.ui.ProjectPanel");
    private static int D = 280;
    private static int L = 512;
    public static final String PROJECT_PROPERTY = "project";
    public static final String PROPERTY_EVENT_CREATED = "Created";
    private static Map C = CollectionFactory.createHashMap();
    private static int J;
    private static Map T;
    private NavigationPanel K;
    private MainPanel B;
    private G I;
    private BirdviewPanel A;
    protected DetailsPane _detailsPane;
    private DiagramManager E;
    private StatusBar O;
    private JSplitPane F;
    private JSplitPane U;
    private JSplitPane W;
    private PropertyChangeSupport R = new PropertyChangeSupport(this);
    private static VetoableChangeSupport V;
    private Clipboard Q;
    private ProjectPanelManager P;
    private PoseidonProject G;
    private JPanel S;
    protected int _dividerLocation;
    private static VetoableChangeSupport N;
    protected static int DIVIDER_SIZE;
    private static Class class$com$gentleware$poseidon$ui$ProjectPanel;

    public synchronized void setProject(Project project) {
        if (this.G != null) {
            C.remove(this.G);
        }
        if (!(project instanceof PoseidonProject)) {
            throw new IllegalArgumentException("ProjectPanel can only be connected to a PoseidonProject");
        }
        this.G = (PoseidonProject)project;
        this.init();
        C.put(this.G, this);
        this.R.firePropertyChange(PROJECT_PROPERTY, null, this.G);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.R.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.R.removePropertyChangeListener(propertyChangeListener);
    }

    public static void addProjectPanelListener(VetoableChangeListener vetoableChangeListener) {
        V.removeVetoableChangeListener(vetoableChangeListener);
        V.addVetoableChangeListener(vetoableChangeListener);
    }

    public static void removeProjectPanelListener(VetoableChangeListener vetoableChangeListener) {
        V.removeVetoableChangeListener(vetoableChangeListener);
    }

    public static void fireProjectPanelCreated(ProjectPanel projectPanel, ProjectPanel projectPanel2) throws PropertyVetoException {
        V.fireVetoableChange(PROPERTY_EVENT_CREATED, projectPanel, projectPanel2);
    }

    public static ProjectPanel getCurrentPanel() {
        return ProjectPanel.getPanelFor((Project)PoseidonApplicationState.getInstance().getCurrentProject());
    }

    public static void addPoseidonStartCompletedListener(VetoableChangeListener vetoableChangeListener) {
        N.removeVetoableChangeListener(vetoableChangeListener);
        N.addVetoableChangeListener(vetoableChangeListener);
    }

    public static void firePoseidonStartCompleted() throws PropertyVetoException {
        N.fireVetoableChange("AppStarted", null, PoseidonProjectConnector.getCurrentProject());
        VetoableChangeListener[] vetoableChangeListenerArray = N.getVetoableChangeListeners();
        List list = CollectionFactory.createArrayList(Arrays.asList(vetoableChangeListenerArray));
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            VetoableChangeListener vetoableChangeListener = (VetoableChangeListener)iterator.next();
            N.removeVetoableChangeListener(vetoableChangeListener);
        }
    }

    protected void init() {
        this.removeAll();
        this.O = new StatusBar(true);
        this.Q = new Clipboard("Poseidon");
        this.setName("MainFrame");
        SplashScreen.showStatus("Making main window: Diagram Area");
        this.B = new MainPanel();
        SplashScreen.showStatus("Making main window: Bird/ToDo Area");
        this.E = new DiagramManager(this);
        this.A = new BirdviewPanel(this);
        SplashScreen.showStatus("Making main window: Tree Area");
        this.I = new G(this);
        PoseidonPanelManager.addPropertyChangeListener(this.I, "MultiPerspectiveTabs");
        SplashScreen.showStatus("Making main window: Details Pane");
        if (this._detailsPane != null) {
            this._detailsPane.clearModelTarget();
        }
        this._detailsPane = new DetailsPane(this);
        this.setLayout(new BorderLayout());
        SplashScreen.showStatus("Making main window: Layouting");
        this.P = this.G.getPanelManager();
        this.S = new JPanel(new BorderLayout());
        this.updateToolBar();
        this.add((Component)this.S, "North");
        this.add(this.createPanes(), "Center");
        this.add((Component)this.O, "South");
        Frame frame = PoseidonUIConnector.getApplicationWindow();
        if (frame instanceof JFrame) {
            ((JFrame)frame).setJMenuBar(this.P.getUpdatedMenuBar());
        }
        if (this.K != null) {
            this.K.setRoot(this.G);
        }
        PoseidonProject poseidonProject = this.getOwningProject();
        this.getDetailsPane().refreshTabbedPane((Project)poseidonProject);
        com.gentleware.poseidon.ui.gadgets.A.A().A((Project)poseidonProject);
        this.repaint();
    }

    public void shutdown() {
        String string;
        this.saveRecentFileList();
        this.saveSplitterLocation();
        if (this._detailsPane != null) {
            this._detailsPane.dispose();
        }
        if (this.K != null) {
            this.K.dispose();
        }
        PoseidonPanelManager.removePropertyChangeListener(this.I, "MultiPerspectiveTabs");
        PoseidonProject poseidonProject = this.getOwningProject();
        URL uRL = poseidonProject.getUrl();
        if (uRL == null) {
            string = "";
        } else {
            string = uRL.toExternalForm();
            if (!string.endsWith(".zuml")) {
                string = string + ".zuml";
            }
        }
        Services.getInstance().getConfiguration().put("poseidon/opened/project", string);
        C.remove(poseidonProject);
        if (this.E != null) {
            this.E.dispose();
        }
        if (this.B != null) {
            this.B.dispose();
        }
        if (this.I != null) {
            this.I.G();
        }
        if (this.S != null) {
            this.S.removeAll();
        }
    }

    public BirdviewPanel getBirdview() {
        return this.A;
    }

    public ProjectPanelManager getPanelManager() {
        return this.P;
    }

    public DiagramManager getDiagramManager() {
        return this.E;
    }

    public static ProjectPanel getPanelFor(Project project) {
        return (ProjectPanel)C.get(project);
    }

    public Locale getLocale() {
        return Locale.getDefault();
    }

    public void saveSplitterLocation() {
        if (this.K != null && this.K.isShowing() && !Boolean.getBoolean("poseidon-ide-integration")) {
            Configuration configuration = Services.getInstance().getConfiguration();
            configuration.putInteger("poseidon/screen/split/horizontal/left", this.K.getHeight());
            configuration.putInteger("poseidon/screen/split/vertical", this.K.getWidth());
            configuration.putInteger("poseidon/screen/split/horizontal/right", this.B.getHeight());
        }
    }

    public Clipboard getClipboard() {
        return this.Q;
    }

    public Point getMainSplitLocation() {
        if (this.F == null) {
            return new Point(0, 0);
        }
        return this.F.getLocation();
    }

    protected Component createPanes() {
        this.K = (NavigationPanel)ServiceRegistry.get().getService((Object)"treeview", new Object[]{this}, false);
        this.U = new JSplitPane(0, this.K, this.I);
        this.U.setName("LeftSplit");
        this.U.setDividerSize(DIVIDER_SIZE);
        this.U.setDividerLocation(Services.getInstance().getConfiguration().getInteger("poseidon/screen/split/horizontal/left", L));
        this.U.setOneTouchExpandable(true);
        this.U.setContinuousLayout(true);
        SelectionToolbar selectionToolbar = new SelectionToolbar();
        selectionToolbar.setName("tab-buttons");
        this.B.add((Component)((Object)selectionToolbar), "South");
        this.W = new JSplitPane(0, this.B, this._detailsPane);
        this.W.setName("RightSplit");
        this.W.setDividerSize(DIVIDER_SIZE);
        this.W.setDividerLocation(Services.getInstance().getConfiguration().getInteger("poseidon/screen/split/horizontal/right", L));
        this.W.setOneTouchExpandable(true);
        this.W.setContinuousLayout(true);
        this.F = new JSplitPane(1, this.U, this.W);
        this.F.setName("MainSplit");
        this.F.setDividerSize(DIVIDER_SIZE);
        this.F.setDividerLocation(Services.getInstance().getConfiguration().getInteger("poseidon/screen/split/vertical", D));
        this.F.setOneTouchExpandable(true);
        this.F.setContinuousLayout(true);
        this.A();
        return this.F;
    }

    private void A() {
        ThreeSplitsManager.instantiate(this.W, this.F);
    }

    public void updateToolBar() {
        if (ProjectImpl.isGuiMode()) {
            if (ProjectPanelManager.getToolBar() != null) {
                this.S.remove(ProjectPanelManager.getToolBar());
            }
            JToolBar jToolBar = this.P.getUpdatedToolBar((Project)this.getOwningProject());
            this.S.add((Component)jToolBar, "South");
            this.S.validate();
        }
    }

    public void selectInitialTarget() {
        Runnable runnable = new Runnable(){

            public void run() {
                try {
                    RefObject refObject = ProjectPanel.this.G.getInitialTarget();
                    TargetManager targetManager = ProjectPanel.this.G.getTargetManager();
                    targetManager.setSelectedElement(null);
                    targetManager.setSelectedElement(refObject);
                }
                catch (Exception exception) {
                    M.error((Object)"Cannot select initial target", (Throwable)exception);
                }
            }
        };
        SwingUtil.invokeNowOrLater((Runnable)runnable);
    }

    public void addToRecentFileList(File file) {
        File file2 = Files.getCanonicalFile((File)file);
        URL uRL = Files.toUrl((File)file2);
        this.addToRecentFileList(uRL);
    }

    public void addToRecentFileList(URL uRL) {
        ActionOpenNamedProject actionOpenNamedProject;
        int n2;
        String string = uRL.toExternalForm();
        Integer n3 = (Integer)T.get(string);
        int n4 = n3 == null ? J : n3;
        int n5 = ProjectPanelManager.getMaxOpenedFiles();
        ActionOpenNamedProject[] actionOpenNamedProjectArray = ProjectPanelManager.getOpenedProjects();
        if (n4 >= n5) {
            n4 = n5 - 1;
        }
        for (n2 = n4; n2 > 0; --n2) {
            actionOpenNamedProject = actionOpenNamedProjectArray[n2];
            ActionOpenNamedProject actionOpenNamedProject2 = actionOpenNamedProjectArray[n2 - 1];
            URL uRL2 = actionOpenNamedProject2.getProjectUrl();
            actionOpenNamedProject.setProjectUrl(uRL2);
        }
        actionOpenNamedProjectArray[0].setProjectUrl(uRL);
        T.clear();
        if (J < n5 && n3 == null) {
            ++J;
        }
        for (n2 = 0; n2 < J; ++n2) {
            actionOpenNamedProject = actionOpenNamedProjectArray[n2];
            T.put(actionOpenNamedProject.getProjectUrl().toExternalForm(), new Integer(n2));
        }
        ProjectPanelManager.setOpenedProjects(actionOpenNamedProjectArray);
        Frame frame = PoseidonUIConnector.getApplicationWindow();
        if (frame instanceof JFrame) {
            ((JFrame)frame).setJMenuBar(this.P.getUpdatedMenuBar());
        }
    }

    public void saveRecentFileList() {
        List list = CollectionFactory.createArrayList((int)J);
        for (int i2 = 0; i2 < J; ++i2) {
            URL uRL = ProjectPanelManager.getOpenedProjects()[i2].getProjectUrl();
            if (uRL == null) continue;
            String string = uRL.toExternalForm();
            list.add(string);
        }
        Configuration configuration = Services.getInstance().getConfiguration();
        configuration.putStringList("poseidon/opened/proj", list);
    }

    public void loadRecentFileList() {
        Configuration configuration = Services.getInstance().getConfiguration();
        List list = configuration.getStringList("poseidon/opened/proj");
        for (int i2 = list.size() - 1; i2 >= 0; --i2) {
            URL uRL;
            block8: {
                File file;
                String string = (String)list.get(i2);
                if (string == null || string.length() == 0) continue;
                try {
                    uRL = new URL(string);
                }
                catch (MalformedURLException malformedURLException) {
                    file = new File(string);
                    if (!file.exists()) {
                        M.warn((Object)("Skipping recent project - not a valid url: " + string));
                        continue;
                    }
                    uRL = Files.toUrl((File)file);
                }
                String string2 = uRL.getProtocol();
                if ("file".equals(string2)) {
                    try {
                        file = Utils.urlToFile((URL)uRL);
                        if (file == null) continue;
                        if (!file.exists()) {
                        }
                        break block8;
                    }
                    catch (RuntimeException runtimeException) {
                        M.error((Object)runtimeException);
                    }
                    continue;
                }
            }
            this.addToRecentFileList(uRL);
        }
    }

    public MainPanel getMainPanel() {
        return this.B;
    }

    public DiagramPanel getCurrentDiagramPanel() {
        DiagramPanel diagramPanel = null;
        if (this.B != null) {
            XTab xTab = this.B.getCurrentTab();
            if (xTab != null && !(xTab instanceof DiagramPanel)) {
                throw new IllegalStateException("Selected editor tab " + xTab + " is not a DiagramPanel!");
            }
            diagramPanel = (DiagramPanel)xTab;
        }
        return diagramPanel;
    }

    public DiagramImpl getCurrentDiagram() {
        DiagramPanel diagramPanel = this.getCurrentDiagramPanel();
        return diagramPanel == null ? null : diagramPanel.getDiagram();
    }

    public PCanvas getCurrentCanvas() {
        DiagramPanel diagramPanel = this.getCurrentDiagramPanel();
        return diagramPanel == null ? null : diagramPanel.getCanvas();
    }

    public List getAllGraphs() {
        List list = CollectionFactory.createArrayList();
        List list2 = this.B.getAllTabs();
        int n2 = list2.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            JPanel jPanel = (JPanel)list2.get(i2);
            if (!(jPanel instanceof DiagramPanel)) continue;
            DiagramPanel diagramPanel = (DiagramPanel)jPanel;
            PCanvas pCanvas = diagramPanel.getCanvas();
            list.add(pCanvas);
        }
        return list;
    }

    public StatusBar getStatusBar() {
        return this.O;
    }

    public void hideNavPane() {
        if (this.K == null || this.U == null) {
            return;
        }
        this._dividerLocation = this.U.getDividerLocation();
        JPanel jPanel = new JPanel();
        jPanel.setBackground(Color.white);
        this.U.setTopComponent(jPanel);
        this.U.setDividerLocation(this._dividerLocation);
        this.K.setEnabled(false);
        this.K.setVisible(false);
    }

    public void showNavPane() {
        if (this.K == null) {
            return;
        }
        this.U.setLeftComponent(this.K);
        this.K.setEnabled(true);
        this.K.setVisible(true);
        this.U.setTopComponent(this.K);
        this.U.setDividerLocation(this._dividerLocation);
    }

    public NavigationPanel getNavPane() {
        return this.K;
    }

    public void setNavPane(NavigationPanel navigationPanel) {
        this.K = navigationPanel;
        if (this.K != null) {
            this.K.setRoot(this.G);
            this.showNavPane();
        }
    }

    public DetailsPane getDetailsPane() {
        return this._detailsPane;
    }

    public G getPerspectivePane() {
        return this.I;
    }

    public void hidePerspectivePane() {
        Insets insets = this.U.getInsets();
        int n2 = insets != null ? insets.bottom : 0;
        int n3 = this.U.getHeight() - n2;
        this.U.setDividerLocation(n3);
    }

    public void showPerspectivePane() {
        Insets insets = this.U.getInsets();
        int n2 = insets != null ? insets.bottom : 0;
        int n3 = insets != null ? insets.bottom : 0;
        int n4 = this.U.getHeight() - n2;
        if (this.U.getDividerLocation() >= n4 - 10) {
            int n5 = (this.U.getHeight() - n3 - n2) * 3 / 4;
            this.U.setDividerLocation(n5);
        }
    }

    public void jumpToDiagramShowing(L l2) {
        int n2;
        if (l2.C() == 0) {
            return;
        }
        final RefObject refObject = (RefObject)l2.A(0);
        final TargetManager targetManager = this.P.getProject().getTargetManager();
        if (refObject instanceof Diagram && l2.C() > 1) {
            targetManager.setSelectedElement(refObject);
            targetManager.setSelectedElement((RefObject)l2.A(1));
            return;
        }
        if (refObject instanceof Diagram && l2.C() == 1) {
            targetManager.setSelectedElement(refObject);
            targetManager.setSelectedElements(null);
            return;
        }
        Collection collection = this.P.getProject().getDiagrams();
        Target target = targetManager.getTarget();
        Diagram diagram = target.getTargetedDiagram();
        DiAccessory diAccessory = this.P.getProject().getDiAccessory();
        if (diagram != null && (n2 = diAccessory.countContainedElements(diagram, l2.D())) == l2.C()) {
            targetManager.setSelectedElement(refObject);
            return;
        }
        Diagram diagram2 = null;
        int n3 = 0;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Diagram diagram3 = (Diagram)iterator.next();
            int n4 = diAccessory.countContainedElements(diagram3, l2.D());
            if (n4 > n3) {
                n3 = n4;
                diagram2 = diagram3;
            }
            if (n4 != l2.C()) continue;
            break;
        }
        if (diagram2 != null) {
            targetManager.setSelectedElement(diagram2);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    boolean bl = Services.getInstance().getConfiguration().getBoolean("poseidon/scrolldiagram/enabled", true);
                    Services.getInstance().getConfiguration().putBoolean("poseidon/scrolldiagram/enabled", false);
                    targetManager.setSelectedElement(refObject);
                    Services.getInstance().getConfiguration().putBoolean("poseidon/scrolldiagram/enabled", bl);
                }
            });
        }
    }

    public void showStatus(String string) {
        this.O.showStatus(string);
    }

    public PoseidonProject getOwningProject() {
        return this.G;
    }

    protected void addDetailsTab(XTab xTab) {
        XTabbedPane xTabbedPane = this.getDetailsPane().getTabbedPane();
        xTabbedPane.addTab(xTab);
    }

    protected void insertDetailsTab(int n2, XTab xTab) {
        XTabbedPane xTabbedPane = this.getDetailsPane().getTabbedPane();
        xTabbedPane.insertTab(xTab.getTitle(), null, (Component)xTab, "", n2);
    }

    static {
        T = CollectionFactory.createHashMap();
        V = new VetoableChangeSupport(class$com$gentleware$poseidon$ui$ProjectPanel == null ? (class$com$gentleware$poseidon$ui$ProjectPanel = ProjectPanel.A("com.gentleware.poseidon.ui.ProjectPanel")) : class$com$gentleware$poseidon$ui$ProjectPanel);
        N = new VetoableChangeSupport(class$com$gentleware$poseidon$ui$ProjectPanel == null ? (class$com$gentleware$poseidon$ui$ProjectPanel = ProjectPanel.A("com.gentleware.poseidon.ui.ProjectPanel")) : class$com$gentleware$poseidon$ui$ProjectPanel);
        DIVIDER_SIZE = 9;
    }

    private static Class A(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }
}

