/*
 * Decompiled with CFR 0.152.
 */
package com.gentleware.poseidon.util.plugin;

import com.gentleware.anvil.kernel.LicenseData;
import com.gentleware.anvil.kernel.ProductEditionImpl;
import com.gentleware.anvil.kernel.ProductImpl;
import com.gentleware.anvil.kernel.RegistrationResourceBundle;
import com.gentleware.jboogie.kernel.ProjectImpl;
import com.gentleware.jboogie.util.JBoogieUtils;
import com.gentleware.locksmith.client.LicenseChecker;
import com.gentleware.locksmith.client.LicenseKeys;
import com.gentleware.openapi.swingx.Localizer;
import com.gentleware.openapi.swingx.ResourceId;
import com.gentleware.openapi.util.CollectionFactory;
import com.gentleware.openapi.util.Product;
import com.gentleware.openapi.util.ProductVersion;
import com.gentleware.openapi.util.Strings;
import com.gentleware.poseidon.BuildProperties;
import com.gentleware.poseidon.jboogie.PoseidonApplicationState;
import com.gentleware.poseidon.kernel.PoseidonProject;
import com.gentleware.poseidon.model_management.Profile;
import com.gentleware.poseidon.model_management.ProfileException;
import com.gentleware.poseidon.model_management.ProfileRegistry;
import com.gentleware.poseidon.ui.SplashScreen;
import com.gentleware.poseidon.util.PoseidonUtils;
import com.gentleware.poseidon.util.plugin.A;
import com.gentleware.poseidon.util.plugin.B;
import com.gentleware.poseidon.util.plugin.C;
import com.gentleware.poseidon.util.plugin.D;
import com.gentleware.poseidon.util.plugin.E;
import com.gentleware.poseidon.util.plugin.PoseidonIllegalModuleException;
import com.gentleware.poseidon.util.plugin.PoseidonModuleDescription;
import com.gentleware.poseidon.util.plugin.PoseidonModuleInstall;
import com.gentleware.poseidon.util.plugin.PoseidonModuleItem;
import java.awt.Component;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarFile;
import java.util.zip.ZipFile;
import javax.swing.JFrame;
import org.apache.log4j.Logger;
import org.openide.ErrorManager;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.io.NbObjectInputStream;
import org.openide.util.io.NbObjectOutputStream;
import org.openide.util.io.SafeException;

public final class PoseidonModuleInstaller {
    private static final Logger D = Logger.getLogger((String)"com.gentleware.poseidon.util.plugin.PoseidonModuleInstaller");
    private static final Object B = new Object();
    private static final String F = "externalizedModules.ser";
    static B miSupport;
    private static boolean A;
    private static final PropertyChangeSupport E;
    private static ClassLoader G;
    static final List _defaultModules;
    static final String _noValidLicense;
    static final String _pluginsNotInstalled;
    static final String _missingPlugins;
    static final String _enablePlugins;
    static final String _enablePluginsTitle;
    static final String _disablePlugins;
    static final String _disablePluginsTitle;
    static final String JAR_EXT = ".jar";
    static final int ENABLED_MODULE = 1;
    static final int DISABLED_MODULE = 2;
    static final int AUTOLOAD_CENTRAL_MODULE = 4;
    static final int AUTOLOAD_USER_MODULE = 8;
    static final int RESTORED_MODULE = 32;
    static final String INSTALLED_MODULES = "installedModules.xml";
    static File centralModuleDirectory;
    static File userModuleDirectory;
    static boolean _defaultModulesInstalled;
    private static Class class$com$gentleware$poseidon$util$plugin$PoseidonModuleInstaller;

    private PoseidonModuleInstaller() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ClassLoader getModuleClassLoader() {
        Object object = B;
        synchronized (object) {
            if (G == null) {
                G = PoseidonModuleInstaller.C();
            }
            return G;
        }
    }

    public static void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        E.addPropertyChangeListener(propertyChangeListener);
    }

    public static void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        E.removePropertyChangeListener(propertyChangeListener);
    }

    public static PoseidonModuleItem[] getPoseidonModuleItems(int n2) {
        Collection collection = miSupport.A(n2);
        return collection.toArray(new PoseidonModuleItem[collection.size()]);
    }

    public static PoseidonModuleDescription[] getPoseidonModuleDescriptions(int n2) {
        Collection collection = miSupport.A(n2);
        PoseidonModuleItem[] poseidonModuleItemArray = collection.toArray(new PoseidonModuleItem[collection.size()]);
        PoseidonModuleDescription[] poseidonModuleDescriptionArray = new PoseidonModuleDescription[poseidonModuleItemArray.length];
        for (int i2 = 0; i2 < poseidonModuleItemArray.length; ++i2) {
            poseidonModuleDescriptionArray[i2] = poseidonModuleItemArray[i2].getDescription();
        }
        return poseidonModuleDescriptionArray;
    }

    public static PoseidonModuleItem getByName(String string) {
        return miSupport.A(string);
    }

    public static synchronized void initialize(File file, File file2, int n2, int n3) {
        Object object;
        Object object2;
        Iterator iterator;
        miSupport = new B();
        miSupport.A(file, file2);
        Collection collection = miSupport.A(1);
        Set set = CollectionFactory.createHashSet();
        Collection collection2 = miSupport.A(14);
        PoseidonModuleInstaller.A(collection, collection2, (Collection)set);
        collection.addAll(set);
        List list = null;
        try {
            list = PoseidonModuleInstaller.resolveOrdering(collection);
        }
        catch (PoseidonIllegalModuleException poseidonIllegalModuleException) {
            D.warn((Object)"[PoseidonModuleInstaller] caught exception during initialization!", (Throwable)poseidonIllegalModuleException);
        }
        if (list == null) {
            list = CollectionFactory.createArrayList();
        }
        Collection collection3 = miSupport.A(1);
        collection3.removeAll(list);
        if (list.size() > 0 && !PoseidonApplicationState.isCE()) {
            D.info((Object)PoseidonModuleInstaller.getStringFromResource("INFO_LoadedModules", PoseidonModuleInstaller.B(collection)));
        }
        Object object3 = list.iterator();
        while (object3.hasNext()) {
            iterator = (PoseidonModuleItem)object3.next();
            object2 = ((PoseidonModuleItem)((Object)iterator)).getDescription();
            try {
                object = ((PoseidonModuleDescription)object2).getModule();
                if (!PoseidonModuleInstaller.checkForValidLicense(object)) {
                    ((PoseidonModuleItem)((Object)iterator)).setEnabledNoNotify(false);
                    continue;
                }
                com.gentleware.poseidon.util.plugin.A.J().A(PoseidonModuleInstaller.getStringFromResource("MSG_Install_Section", ((PoseidonModuleItem)((Object)iterator)).getDescription().getName()));
                if (collection3.contains(iterator)) {
                    A = true;
                    ((PoseidonModuleItem)((Object)iterator)).setEnabledNoNotify(false);
                    continue;
                }
                miSupport.B((PoseidonModuleItem)((Object)iterator));
                ((PoseidonModuleItem)((Object)iterator)).restoreLayer();
                ((PoseidonModuleItem)((Object)iterator)).restoreSection();
                ((PoseidonModuleItem)((Object)iterator)).restoreDefault();
            }
            catch (Exception exception) {
                D.error((Object)exception);
            }
        }
        try {
            object3 = PoseidonModuleInstaller.resolveOrdering(miSupport.A(12), miSupport.A(1));
            iterator = object3.iterator();
            while (iterator.hasNext()) {
                miSupport.B((PoseidonModuleItem)iterator.next());
            }
        }
        catch (PoseidonIllegalModuleException poseidonIllegalModuleException) {
            D.error((Object)("[PoseidonModuleInstaller] in initalize " + poseidonIllegalModuleException.toString()), (Throwable)poseidonIllegalModuleException);
        }
        try {
            PoseidonModuleInstaller.A();
        }
        catch (IOException iOException) {
            D.warn((Object)"[PoseidonModuleInstaller] exception caught during initialization!", (Throwable)iOException);
        }
        int n4 = 0;
        iterator = list.iterator();
        D.info((Object)"Initializing plugins.");
        while (iterator.hasNext()) {
            ++n4;
            object2 = (PoseidonModuleItem)iterator.next();
            object = ((PoseidonModuleItem)object2).getDescription().getName();
            SplashScreen.showStatus("Loading " + (String)object);
            if (((PoseidonModuleItem)object2).isEnabled() && !"Poseidon-Core".equals(object)) {
                com.gentleware.poseidon.util.plugin.A.J().A(PoseidonModuleInstaller.getStringFromResource("MSG_Install_Module", object));
                long l2 = System.currentTimeMillis();
                if (((PoseidonModuleItem)object2).isUpdated()) {
                    ((PoseidonModuleItem)object2).updatedCode();
                    A = true;
                } else {
                    ((PoseidonModuleItem)object2).restoreCode();
                }
                long l3 = System.currentTimeMillis();
                String string = Strings.leftPad((String)Long.toString(l3 - l2), (int)5);
                D.info((Object)("Plugin startup time " + Strings.rightPad((String)object, (int)25) + string + " ms"));
            }
            ((PoseidonModuleItem)object2).verifyClassLoader();
            if (n4 <= 1) continue;
            int n5 = (int)((float)n3 * (float)n4 / (float)list.size());
            SplashScreen.showProgress(n2 + n5);
        }
        E.firePropertyChange(null, null, null);
    }

    private static void A(Collection collection, Collection collection2, Collection collection3) {
        Map map = CollectionFactory.createHashMap();
        Iterator iterator = collection2.iterator();
        while (iterator.hasNext()) {
            PoseidonModuleItem poseidonModuleItem = (PoseidonModuleItem)iterator.next();
            map.put(poseidonModuleItem.getDescription().getCodeName(), poseidonModuleItem);
        }
        iterator = collection.iterator();
        while (iterator.hasNext()) {
            PoseidonModuleInstaller.A((PoseidonModuleItem)iterator.next(), map, collection3);
        }
    }

    private static void A(PoseidonModuleItem poseidonModuleItem, Map map, Collection collection) {
        PoseidonModuleDescription._B[] _BArray = poseidonModuleItem.getDescription().getDependencies();
        for (int i2 = 0; i2 < _BArray.length; ++i2) {
            PoseidonModuleItem poseidonModuleItem2;
            if (_BArray[i2].A() != 1 || (poseidonModuleItem2 = (PoseidonModuleItem)map.get(_BArray[i2].C())) == null || collection.contains(poseidonModuleItem2)) continue;
            collection.add(poseidonModuleItem2);
            PoseidonModuleInstaller.A(poseidonModuleItem2, map, collection);
        }
    }

    public static boolean checkForValidLicense(PoseidonModuleInstall poseidonModuleInstall) {
        Object object;
        String string;
        boolean bl = false;
        String string2 = poseidonModuleInstall.getModuleName();
        D.debug((Object)("[PoseidonModuleInstaller] checkForValidLicense(): " + string2));
        String string3 = poseidonModuleInstall.getModuleEdition();
        String string4 = poseidonModuleInstall.getModuleVersion();
        if (string2 == null || string2.startsWith("@") && string2.endsWith("@") || string4 == null || string4.startsWith("@") && string4.endsWith("@")) {
            return true;
        }
        if (Strings.isEmpty((String)string2)) {
            D.error((Object)"Plugin has no name! Probably outdated plugin version.");
        } else if (Strings.isEmpty((String)string4)) {
            D.error((Object)"Plugin has no version! Probably outdated plugin version.");
        } else {
            string = string4.indexOf(46) < 0 && !string4.startsWith("@") ? string4 + ".0" : string4;
            try {
                object = Strings.isEmpty((String)string3) ? ProductEditionImpl.get((String)string3) : null;
                ProductVersion productVersion = ProductVersion.createProductVersion((String)string);
                ProductImpl productImpl = new ProductImpl(string2, object, productVersion);
                ProductImpl productImpl2 = BuildProperties.getPoseidonProduct();
                LicenseData licenseData = LicenseKeys.getInstance().getModuleLicenseData((Product)productImpl, productImpl2);
                bl = _defaultModules.contains(string2) || "Uml-To-Mof".equalsIgnoreCase(string2) ? true : (PoseidonApplicationState.isCE() ? false : LicenseChecker.getInstance().isLicensed(licenseData));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                D.error((Object)illegalArgumentException);
            }
        }
        if (!bl) {
            string = string2;
            string = string != null ? string + ", " + string4 : "";
            if (ProjectImpl.isGuiMode()) {
                object = MessageFormat.format(_noValidLicense, string);
                JBoogieUtils.showMessageDialog((Component)new JFrame(), (Object)object, (String)"License", (int)0);
            }
        }
        return bl;
    }

    public static synchronized void autoLoadModules() {
        PoseidonModuleInstaller.A(12);
        com.gentleware.poseidon.util.plugin.A.J().A("");
        E.firePropertyChange(null, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void A(int n2) {
        Object object;
        Object object2;
        Iterator iterator;
        Collection collection = miSupport.A(4);
        Collection collection2 = miSupport.A(8);
        List list = CollectionFactory.createArrayList();
        if ((n2 & 4) != 0) {
            list.addAll(collection);
        }
        if ((n2 & 8) != 0) {
            list.addAll(collection2);
        }
        if ((n2 & 0xC) == 0 || (n2 & 0xFFFFFFF7 & 0xFFFFFFFB) != 0) {
            throw new IllegalArgumentException("PoseidonModuleInstaller.autoLoadModules: kind=" + n2);
        }
        List list2 = null;
        try {
            list2 = PoseidonModuleInstaller.resolveOrdering((Collection)list, miSupport.A(3));
        }
        catch (PoseidonIllegalModuleException poseidonIllegalModuleException) {
            D.warn((Object)"[PoseidonModuleInstaller] exception caught in autoLoadModules!", (Throwable)poseidonIllegalModuleException);
        }
        catch (NullPointerException nullPointerException) {
            D.warn((Object)("[PoseidonModuleInstaller] autoLoadModules" + nullPointerException.toString()), (Throwable)nullPointerException);
        }
        Collection collection3 = miSupport.A(n2);
        collection3.removeAll(list2);
        if (list2 == null) {
            list2 = CollectionFactory.createArrayList();
        }
        Collection collection4 = miSupport.A(n2);
        collection4.removeAll(collection3);
        Collection collection5 = miSupport.B(collection4);
        if (collection5 != null && collection5.size() > 0) {
            iterator = new StringBuffer();
            object2 = collection5.iterator();
            while (object2.hasNext()) {
                ((StringBuffer)((Object)iterator)).append(((PoseidonModuleItem)object2.next()).getDescription().getCodeName()).append("\n");
            }
            object2 = collection5.iterator();
            while (object2.hasNext()) {
                object = (PoseidonModuleItem)object2.next();
                PoseidonModuleDescription poseidonModuleDescription = ((PoseidonModuleItem)object).getDescription();
                if (PoseidonModuleInstaller.checkForValidLicense(poseidonModuleDescription.getModule())) {
                    ((PoseidonModuleItem)object).setEnabled(true);
                    continue;
                }
                ((PoseidonModuleItem)object).setEnabled(false);
            }
        }
        if (list2.size() > 0) {
            D.info((Object)PoseidonModuleInstaller.getStringFromResource("INFO_InstalledModules", PoseidonModuleInstaller.B(list2)));
        }
        iterator = list2.iterator();
        while (iterator.hasNext()) {
            object2 = (PoseidonModuleItem)iterator.next();
            object = ((PoseidonModuleItem)object2).getDescription();
            D.info((Object)((PoseidonModuleDescription)object).getName());
            if (!PoseidonModuleInstaller.checkForValidLicense(((PoseidonModuleDescription)object).getModule())) {
                ((PoseidonModuleItem)object2).setEnabledNoNotify(false);
                continue;
            }
            com.gentleware.poseidon.util.plugin.A.J().A(PoseidonModuleInstaller.getStringFromResource("MSG_Install_Section", ((PoseidonModuleItem)object2).getDescription().getName()));
            miSupport.B((PoseidonModuleItem)object2, miSupport.A((PoseidonModuleItem)object2));
            if (collection3.contains(object2)) {
                ((PoseidonModuleItem)object2).setEnabledNoNotify(false);
                miSupport.A((PoseidonModuleItem)object2, 2);
                continue;
            }
            miSupport.A((PoseidonModuleItem)object2, 1);
            ((PoseidonModuleItem)object2).restoreLayer();
            if (PoseidonModuleInstaller.isMultiuser() && collection.contains(object2)) {
                ((PoseidonModuleItem)object2).restoreSection();
            } else {
                ((PoseidonModuleItem)object2).installSection();
            }
            ((PoseidonModuleItem)object2).restoreDefault();
        }
        list2.size();
        iterator = list2.iterator();
        while (iterator.hasNext()) {
            object2 = (PoseidonModuleItem)iterator.next();
            object = ((PoseidonModuleItem)object2).getDescription();
            if (!PoseidonModuleInstaller.checkForValidLicense(((PoseidonModuleDescription)object).getModule())) continue;
            com.gentleware.poseidon.util.plugin.A.J().A(PoseidonModuleInstaller.getStringFromResource("MSG_Install_Module", ((PoseidonModuleItem)object2).getDescription().getName()));
            if (((PoseidonModuleItem)object2).isEnabled()) {
                if (PoseidonModuleInstaller.isMultiuser() && collection.contains(object2)) {
                    ((PoseidonModuleItem)object2).restoreCode();
                } else {
                    ((PoseidonModuleItem)object2).installCode();
                }
            }
            ((PoseidonModuleItem)object2).verifyClassLoader();
        }
        if (!list2.isEmpty()) {
            com.gentleware.poseidon.util.plugin.A.J().A(PoseidonModuleInstaller.getStringFromResource("MSG_Install_Complete", new Integer(list2.size()), ((PoseidonModuleItem)list2.iterator().next()).getDescription().getName()));
            E.firePropertyChange(null, null, null);
        }
        if (!list2.isEmpty() || A) {
            miSupport.C();
        }
    }

    public static boolean exit() {
        PoseidonModuleItem poseidonModuleItem;
        Collection collection = miSupport.A(1);
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            poseidonModuleItem = (PoseidonModuleItem)iterator.next();
            if (poseidonModuleItem.closing()) continue;
            return false;
        }
        try {
            PoseidonModuleInstaller.B();
        }
        catch (IOException iOException) {
            D.warn((Object)"[PoseidonModuleInstaller] exception caught in exit!", (Throwable)iOException);
        }
        iterator = collection.iterator();
        while (iterator.hasNext()) {
            poseidonModuleItem = (PoseidonModuleItem)iterator.next();
            poseidonModuleItem.closeCode();
        }
        return true;
    }

    public static synchronized PoseidonModuleItem installFromFile(File file, boolean bl) throws IOException {
        Collection collection;
        PoseidonModuleDescription._B[] _BArray;
        Object object;
        int n2;
        int n3 = 3;
        if (file.getParentFile().equals(PoseidonModuleInstaller.getCentralModuleDirectory())) {
            n3 = 2;
        } else if (file.getParentFile().equals(PoseidonModuleInstaller.getUserModuleDirectory())) {
            n3 = 1;
        }
        PoseidonModuleItem poseidonModuleItem = n3 == 3 ? new PoseidonModuleItem(n3, file.getPath(), true, bl) : new PoseidonModuleItem(n3, file.getName(), true, bl);
        PoseidonModuleItem poseidonModuleItem2 = miSupport.A(poseidonModuleItem.getDescription().getCodeNameBase());
        File file2 = poseidonModuleItem2 != null ? poseidonModuleItem2.getJar() : null;
        File file3 = poseidonModuleItem.getJar();
        if (poseidonModuleItem2 != null && ((n2 = miSupport.A(poseidonModuleItem2)) == 1 || n2 == 2)) {
            if (file3 != null && !file3.equals(file2)) {
                PoseidonModuleInstaller.deleteModule(poseidonModuleItem2);
            } else {
                return null;
            }
        }
        if (PoseidonModuleInstaller.resolveOrdering(Collections.nCopies(1, poseidonModuleItem), 3).isEmpty()) {
            StringBuffer stringBuffer = new StringBuffer(200);
            object = poseidonModuleItem.getDescription().getName();
            stringBuffer.append(MessageFormat.format(_pluginsNotInstalled, object));
            _BArray = poseidonModuleItem.getDescription().getDependencies();
            for (int i2 = 0; i2 < _BArray.length; ++i2) {
                stringBuffer.append(_BArray[i2].C());
                stringBuffer.append("\n");
            }
            String string = _missingPlugins;
            int n4 = JBoogieUtils.showConfirmDialog((Component)((Object)C.C()), (Object)stringBuffer, (String)string, (int)-1);
            if (n4 == -1) {
                return null;
            }
        }
        if ((collection = PoseidonModuleInstaller.checkDependenciesOnDisabled(poseidonModuleItem.getDescription())) != null) {
            object = collection.iterator();
            while (object.hasNext()) {
                _BArray = (PoseidonModuleDescription._B[])object.next();
                if ("IDE Core".equals(_BArray.getDescription().getName())) continue;
                _BArray.setEnabled(true);
            }
        } else {
            return null;
        }
        PoseidonModuleInstaller.A(poseidonModuleItem);
        miSupport.A(poseidonModuleItem, 1);
        E.firePropertyChange(null, null, null);
        miSupport.C();
        return poseidonModuleItem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void deployTestModule(File file) throws IOException {
        Object object;
        Object object2;
        Object object3;
        Iterator iterator;
        Collection collection;
        block13: {
            file = file.getAbsoluteFile();
            collection = miSupport.A(15);
            iterator = collection.iterator();
            while (iterator.hasNext()) {
                object3 = (PoseidonModuleItem)iterator.next();
                if (!file.equals(((PoseidonModuleItem)object3).getJar())) continue;
                ((PoseidonModuleItem)object3).setReloadable(true);
                List list = PoseidonModuleInstaller.getDependentModules((PoseidonModuleItem)object3);
                List list2 = CollectionFactory.createArrayList((Collection)list);
                Collections.reverse(list2);
                iterator = list2.iterator();
                while (iterator.hasNext()) {
                    ((PoseidonModuleItem)iterator.next()).setEnabled(false);
                }
                ((PoseidonModuleItem)object3).setEnabled(false);
                ((PoseidonModuleItem)object3).setEnabled(true);
                iterator = list.iterator();
                while (iterator.hasNext()) {
                    ((PoseidonModuleItem)iterator.next()).setEnabled(true);
                }
                return;
            }
            try {
                object2 = new JarFile(file);
                try {
                    object = ((JarFile)object2).getManifest().getMainAttributes().getValue(PoseidonModuleDescription.TAG_MAGIC);
                    if (object != null) {
                        int n2 = ((String)object).lastIndexOf(47);
                        object3 = n2 != -1 ? ((String)object).substring(0, n2) : object;
                        break block13;
                    }
                    throw new IOException("JAR " + file + " had no tag " + PoseidonModuleDescription.TAG_MAGIC + " in its manifest");
                }
                finally {
                    ((ZipFile)object2).close();
                }
            }
            catch (IOException iOException) {
                D.warn((Object)"[PoseidonModuleInstaller] exception caught in deployTestModule!", (Throwable)iOException);
                object3 = null;
            }
        }
        object2 = Collections.EMPTY_SET;
        if (object3 != null) {
            iterator = collection.iterator();
            while (iterator.hasNext()) {
                object = (PoseidonModuleItem)iterator.next();
                String string = ((PoseidonModuleItem)object).getDescription().getCodeNameBase();
                if (!string.equals(object3)) continue;
                object2 = PoseidonModuleInstaller.getDependentModules((PoseidonModuleItem)object);
                List list = CollectionFactory.createArrayList((Collection)object2);
                Collections.reverse(list);
                iterator = list.iterator();
                while (iterator.hasNext()) {
                    ((PoseidonModuleItem)iterator.next()).setEnabled(false);
                }
                ((PoseidonModuleItem)object).setEnabled(false);
                miSupport.B((PoseidonModuleItem)object, miSupport.A((PoseidonModuleItem)object));
                E.firePropertyChange(null, null, null);
                miSupport.C();
                break;
            }
        }
        PoseidonModuleInstaller.installFromFile(file, true);
        iterator = object2.iterator();
        while (iterator.hasNext()) {
            ((PoseidonModuleItem)iterator.next()).setEnabled(true);
        }
    }

    static String getMissed(int n2, Collection collection) {
        return PoseidonModuleInstaller.A(miSupport.A(n2), collection);
    }

    private static String A(Collection collection, Collection collection2) {
        int n2;
        StringBuffer stringBuffer = new StringBuffer();
        List list = CollectionFactory.createArrayList();
        Set set = CollectionFactory.createHashSet();
        set.addAll(collection2);
        do {
            n2 = 0;
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                Set set2 = CollectionFactory.createHashSet();
                Iterator iterator2 = collection.iterator();
                while (iterator2.hasNext()) {
                    set2.add(((PoseidonModuleItem)iterator2.next()).getDescription());
                }
                iterator2 = set.iterator();
                while (iterator2.hasNext()) {
                    set2.add(((PoseidonModuleItem)iterator2.next()).getDescription());
                }
                String string = "";
                if ("" == null) continue;
                ++n2;
                iterator.remove();
                list.add("");
                stringBuffer.append("").append("\n");
            }
        } while (n2 > 0);
        if (list.size() > 0) {
            return stringBuffer.toString();
        }
        return null;
    }

    public static synchronized boolean deleteModule(PoseidonModuleItem poseidonModuleItem) {
        if (poseidonModuleItem != null) {
            int n2 = miSupport.A(poseidonModuleItem);
            if (n2 != 1 && n2 != 2) {
                return false;
            }
            if (poseidonModuleItem.canDestroy()) {
                PoseidonModuleInstaller.C(poseidonModuleItem);
                miSupport.B(poseidonModuleItem, n2);
                E.firePropertyChange(null, null, null);
                miSupport.C();
                return true;
            }
            if (poseidonModuleItem.canDisable()) {
                poseidonModuleItem.setEnabled(false);
                return true;
            }
            return false;
        }
        return false;
    }

    static synchronized void changeModule(PoseidonModuleItem poseidonModuleItem) {
        Collection collection;
        if (poseidonModuleItem.isEnabled()) {
            Collection collection2 = PoseidonModuleInstaller.checkDependenciesOnDisabled(poseidonModuleItem.getDescription());
            if (collection2 != null) {
                Iterator iterator = collection2.iterator();
                while (iterator.hasNext()) {
                    PoseidonModuleItem poseidonModuleItem2 = (PoseidonModuleItem)iterator.next();
                    PoseidonModuleDescription poseidonModuleDescription = poseidonModuleItem2.getDescription();
                    if ("IDE Core".equals(poseidonModuleItem2.getDescription().getName())) continue;
                    poseidonModuleItem2.setEnabled(PoseidonModuleInstaller.checkForValidLicense(poseidonModuleDescription.getModule()));
                }
            }
        } else if (!poseidonModuleItem.isEnabled() && (collection = PoseidonModuleInstaller.checkDependenciesOnEnabled(poseidonModuleItem.getDescription())) != null) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                PoseidonModuleItem poseidonModuleItem3 = (PoseidonModuleItem)iterator.next();
                if ("IDE Core".equals(poseidonModuleItem3.getDescription().getName())) continue;
                poseidonModuleItem3.setEnabled(false);
            }
        }
        PoseidonModuleInstaller.changeEnabled(poseidonModuleItem);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static synchronized void changeEnabled(PoseidonModuleItem poseidonModuleItem) {
        block7: {
            try {
                if (poseidonModuleItem.isEnabled()) {
                    try {
                        poseidonModuleItem.reload();
                    }
                    catch (Exception exception) {
                        D.info((Object)("[PoseidonModuleInstaller] changeEnabled" + exception.toString()), (Throwable)exception);
                        miSupport.C();
                        return;
                    }
                    PoseidonModuleInstaller.A(poseidonModuleItem);
                    break block7;
                }
                PoseidonModuleInstaller.C(poseidonModuleItem);
            }
            finally {
                miSupport.C();
            }
        }
    }

    static Collection checkDependenciesOnDisabled(PoseidonModuleDescription poseidonModuleDescription) {
        return PoseidonModuleInstaller.A(miSupport.B(poseidonModuleDescription));
    }

    static Collection checkDependenciesOnDisabled(Collection collection) {
        return PoseidonModuleInstaller.A(miSupport.B(collection));
    }

    static Collection checkDependenciesOnEnabled(PoseidonModuleDescription poseidonModuleDescription) {
        return PoseidonModuleInstaller.C(miSupport.A(poseidonModuleDescription));
    }

    public static List getModuleJars() {
        Iterator iterator = miSupport.A(3).iterator();
        List list = CollectionFactory.createArrayList();
        while (iterator.hasNext()) {
            list.addAll(((PoseidonModuleItem)iterator.next()).getAllJars());
        }
        return list;
    }

    private static ClassLoader C() {
        ClassLoader[] classLoaderArray;
        if (miSupport != null) {
            Collection collection = miSupport.A(1);
            classLoaderArray = new ClassLoader[collection.size()];
            Iterator iterator = collection.iterator();
            int n2 = 0;
            while (iterator.hasNext()) {
                PoseidonModuleItem poseidonModuleItem = (PoseidonModuleItem)iterator.next();
                poseidonModuleItem.ensureClassLoader();
                classLoaderArray[n2++] = poseidonModuleItem.getDescription().getClassLoader();
            }
        } else {
            classLoaderArray = new ClassLoader[]{};
        }
        return new _A(classLoaderArray);
    }

    static File getCentralModuleDirectory() {
        return centralModuleDirectory;
    }

    static File getUserModuleDirectory() {
        return userModuleDirectory;
    }

    static boolean isMultiuser() {
        return !Utilities.compareObjects((Object)PoseidonModuleInstaller.getUserModuleDirectory(), (Object)PoseidonModuleInstaller.getCentralModuleDirectory());
    }

    public static String getLibFile() {
        String string;
        File file = PoseidonUtils.getInstallationDirectory();
        File file2 = new File(file, "build/lib");
        File file3 = new File(file2, "poseidon2.jar");
        if (file3.exists()) {
            try {
                file2 = file2.getCanonicalFile();
            }
            catch (IOException iOException) {
                D.info((Object)iOException);
            }
            return file2.getPath() + File.separator;
        }
        File file4 = new File(file, "lib");
        File file5 = new File(file4, "poseidon2.jar");
        if (file5.exists()) {
            try {
                file4 = file4.getCanonicalFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            string = file4.getPath() + File.separator;
        } else {
            String string2 = System.getProperty("poseidon.lib");
            try {
                file4 = new File(string2);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                file4 = file4.getCanonicalFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            string = Strings.replaceAll((String)file4.getPath(), (String)"%20", (String)" ");
        }
        return string;
    }

    static void appendToModuleClassLoader(PoseidonModuleItem poseidonModuleItem) {
        poseidonModuleItem.ensureClassLoader();
        ((D)PoseidonModuleInstaller.getModuleClassLoader()).A(poseidonModuleItem.getDescription().getClassLoader());
    }

    static void invalidateModuleClassLoader() {
        if (G == null) {
            return;
        }
        ((D)G).B();
        G = null;
        com.gentleware.poseidon.util.plugin.E.C();
    }

    private static String B(PoseidonModuleItem poseidonModuleItem) {
        String string = poseidonModuleItem.getDescription().getSpecVersion();
        String string2 = poseidonModuleItem.getDescription().getImplVersion();
        MessageFormat messageFormat = new MessageFormat(PoseidonModuleInstaller.getStringFromResource("INFO_ModuleSummary"));
        return messageFormat.format(new Object[]{poseidonModuleItem.getDescription().getCodeName(), string == null ? PoseidonModuleInstaller.getStringFromResource("INFO_NullSpec") : string, string2 == null ? PoseidonModuleInstaller.getStringFromResource("INFO_NullImpl") : string2});
    }

    private static String B(Collection collection) {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = collection.iterator();
        boolean bl = true;
        while (iterator.hasNext()) {
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append(PoseidonModuleInstaller.getStringFromResource("INFO_ModuleSummarySeparator"));
            }
            stringBuffer.append(PoseidonModuleInstaller.B((PoseidonModuleItem)iterator.next()));
        }
        return stringBuffer.toString();
    }

    private static void A(PoseidonModuleItem poseidonModuleItem) {
        ProfileRegistry profileRegistry;
        Profile profile;
        PoseidonModuleInstaller.appendToModuleClassLoader(poseidonModuleItem);
        String string = poseidonModuleItem.getDescription().getName();
        if ("IDE Core".equals(string)) {
            return;
        }
        PoseidonModuleDescription poseidonModuleDescription = poseidonModuleItem.getDescription();
        if (!PoseidonModuleInstaller.checkForValidLicense(poseidonModuleDescription.getModule())) {
            poseidonModuleItem.setEnabled(false);
            return;
        }
        com.gentleware.poseidon.util.plugin.A.J().A(PoseidonModuleInstaller.getStringFromResource("MSG_Install_Section", string));
        poseidonModuleItem.restoreLayer();
        poseidonModuleItem.installSection();
        poseidonModuleItem.restoreDefault();
        com.gentleware.poseidon.util.plugin.A.J().A(PoseidonModuleInstaller.getStringFromResource("MSG_Install_Module", poseidonModuleItem.getDescription().getName()));
        poseidonModuleItem.installCode();
        com.gentleware.poseidon.util.plugin.A.J().A(PoseidonModuleInstaller.getStringFromResource("MSG_Install_Complete", new Integer(1), poseidonModuleItem.getDescription().getName()));
        poseidonModuleItem.verifyClassLoader();
        if (!PoseidonApplicationState.isCE()) {
            D.info((Object)PoseidonModuleInstaller.getStringFromResource("INFO_ModuleInstalled", PoseidonModuleInstaller.B(poseidonModuleItem)));
        }
        if ((profile = (profileRegistry = PoseidonProject.getProfileRegistry()).getProfileByModuleName(string)) != null) {
            try {
                profileRegistry.loadProfile(profile.getProfileName());
            }
            catch (ProfileException profileException) {
                D.warn((Object)"Unexpected exception. For some reason the profile we just found via its module-name disappeared from the registered profile-list.", (Throwable)profileException);
            }
        }
    }

    private static void C(PoseidonModuleItem poseidonModuleItem) {
        com.gentleware.poseidon.util.plugin.A.J().A(PoseidonModuleInstaller.getStringFromResource("MSG_Uninstall_Module", poseidonModuleItem.getDescription().getName()));
        poseidonModuleItem.uninstallCode();
        com.gentleware.poseidon.util.plugin.A.J().A(PoseidonModuleInstaller.getStringFromResource("MSG_Uninstall_Section", poseidonModuleItem.getDescription().getName()));
        poseidonModuleItem.uninstallSection();
        poseidonModuleItem.unrestoreLayer();
        poseidonModuleItem.unrestoreDefault();
        ProfileRegistry profileRegistry = PoseidonProject.getProfileRegistry();
        Profile profile = profileRegistry.getProfileByModuleName(poseidonModuleItem.getDescription().getName());
        if (profile != null) {
            try {
                profileRegistry.unloadProfile(profile.getProfileName());
            }
            catch (ProfileException profileException) {
                D.warn((Object)"Unexpected exception caught which signals that the profile we just found is not registered anymore now.", (Throwable)profileException);
            }
        }
        PoseidonModuleInstaller.invalidateModuleClassLoader();
        poseidonModuleItem.release();
        com.gentleware.poseidon.util.plugin.A.J().A(PoseidonModuleInstaller.getStringFromResource("MSG_Uninstall_Complete", new Integer(1), poseidonModuleItem.getDescription().getName()));
        D.info((Object)PoseidonModuleInstaller.getStringFromResource("INFO_ModuleUninstalled", PoseidonModuleInstaller.B(poseidonModuleItem)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void B() throws IOException {
        IOException iOException;
        block13: {
            iOException = null;
            try {
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(new File(PoseidonModuleInstaller.getUserModuleDirectory(), F))));
                try {
                    Iterator iterator = miSupport.A(1).iterator();
                    while (iterator.hasNext()) {
                        PoseidonModuleItem poseidonModuleItem = (PoseidonModuleItem)iterator.next();
                        try {
                            NbObjectOutputStream.writeSafely((ObjectOutput)objectOutputStream, (Object)((Object)poseidonModuleItem.getDescription().getModule()));
                        }
                        catch (SafeException safeException) {
                            if (iOException == null) {
                                iOException = new IOException();
                            }
                            com.gentleware.poseidon.util.plugin.A.J().C().annotate((Throwable)iOException, (Throwable)safeException);
                        }
                    }
                    NbObjectOutputStream.writeSafely((ObjectOutput)objectOutputStream, null);
                }
                finally {
                    objectOutputStream.close();
                }
            }
            catch (IOException iOException2) {
                throw iOException2;
            }
            catch (ThreadDeath threadDeath) {
                throw threadDeath;
            }
            catch (Throwable throwable) {
                A a2;
                ErrorManager errorManager;
                if (iOException == null) {
                    iOException = new IOException();
                }
                if ((errorManager = (a2 = com.gentleware.poseidon.util.plugin.A.J()).C()) == null) break block13;
                errorManager.annotate((Throwable)iOException, throwable);
            }
        }
        if (iOException != null) {
            throw iOException;
        }
    }

    private static void A() throws IOException {
        File file = new File(PoseidonModuleInstaller.getUserModuleDirectory(), F);
        if (!file.exists()) {
            return;
        }
        ObjectInputStream objectInputStream = new ObjectInputStream(new BufferedInputStream(new FileInputStream(file)));
        while (true) {
            try {
                while (NbObjectInputStream.readSafely((ObjectInput)objectInputStream) != null) {
                }
            }
            catch (SafeException safeException) {
                D.debug((Object)safeException);
                continue;
            }
            break;
        }
        try {
            NbObjectInputStream.readSafely((ObjectInput)objectInputStream);
        }
        catch (EOFException eOFException) {
            D.debug((Object)eOFException);
        }
        catch (SafeException safeException) {
            D.debug((Object)safeException);
        }
        objectInputStream.close();
    }

    protected static Collection resolveOrdering(Collection collection, int n2) {
        return PoseidonModuleInstaller.resolveOrdering(collection, n2, false);
    }

    protected static Collection resolveOrdering(Collection collection, int n2, boolean bl) {
        Collection collection2 = miSupport.A(n2);
        if (bl) {
            collection2.removeAll(collection);
        }
        try {
            List list = PoseidonModuleInstaller.resolveOrdering(collection, collection2);
            return list;
        }
        catch (PoseidonIllegalModuleException poseidonIllegalModuleException) {
            D.warn((Object)("[PoseidonModuleInstaller] resolve ordering " + poseidonIllegalModuleException.toString()), (Throwable)poseidonIllegalModuleException);
            return CollectionFactory.createArrayList();
        }
    }

    protected static List resolveOrdering(Collection collection) throws PoseidonIllegalModuleException {
        return PoseidonModuleInstaller.resolveOrdering(collection, CollectionFactory.createArrayList());
    }

    protected static List resolveOrdering(Collection collection, Collection collection2) throws PoseidonIllegalModuleException {
        Collection<PoseidonModuleDescription> collection3;
        Object object;
        Map map = CollectionFactory.createHashMap((int)collection.size());
        Iterator<Object> iterator = collection.iterator();
        while (iterator.hasNext()) {
            object = (PoseidonModuleItem)iterator.next();
            map.put(((PoseidonModuleItem)object).getDescription(), object);
        }
        if (collection2 == null) {
            object = PoseidonModuleDescription.resolveOrdering(map.keySet());
        } else {
            Object object2;
            iterator = collection2.iterator();
            collection3 = CollectionFactory.createHashSet();
            while (iterator.hasNext()) {
                object2 = (PoseidonModuleItem)iterator.next();
                collection3.add(((PoseidonModuleItem)object2).getDescription());
            }
            iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                object2 = (Map.Entry)iterator.next();
                PoseidonModuleItem poseidonModuleItem = (PoseidonModuleItem)object2.getValue();
                poseidonModuleItem.ensureClassLoader();
            }
            object = PoseidonModuleDescription.resolveOrderingForRealInstall(collection3, map.keySet());
        }
        collection3 = CollectionFactory.createArrayList((int)collection.size());
        iterator = object.iterator();
        while (iterator.hasNext()) {
            collection3.add((PoseidonModuleDescription)map.get(iterator.next()));
        }
        return collection3;
    }

    private static Collection A(Collection collection) {
        Object object;
        if (collection == null) {
            return null;
        }
        if (collection.size() == 0) {
            return collection;
        }
        StringBuffer stringBuffer = new StringBuffer(200);
        stringBuffer.append(_enablePlugins);
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            object = (PoseidonModuleItem)iterator.next();
            PoseidonModuleDescription poseidonModuleDescription = ((PoseidonModuleItem)object).getDescription();
            stringBuffer.append(poseidonModuleDescription.getName());
            stringBuffer.append("  (");
            stringBuffer.append(poseidonModuleDescription.getCodeNameBase());
            stringBuffer.append(") \n");
        }
        object = _enablePluginsTitle;
        int n2 = JBoogieUtils.showConfirmDialog((Component)((Object)C.C()), (Object)stringBuffer, (String)object, (int)2);
        if (n2 == 2) {
            return null;
        }
        try {
            List list = PoseidonModuleInstaller.resolveOrdering(collection, miSupport.A(1));
            return list;
        }
        catch (PoseidonIllegalModuleException poseidonIllegalModuleException) {
            D.error((Object)"[PoseidonModuleInstaller] exception caught in askAndOrderToEnable!", (Throwable)poseidonIllegalModuleException);
            return null;
        }
    }

    private static Collection C(Collection collection) {
        Object object;
        if (collection == null) {
            return null;
        }
        if (collection.size() == 0) {
            return collection;
        }
        StringBuffer stringBuffer = new StringBuffer(200);
        stringBuffer.append(_disablePlugins);
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            object = (PoseidonModuleItem)iterator.next();
            PoseidonModuleDescription poseidonModuleDescription = ((PoseidonModuleItem)object).getDescription();
            stringBuffer.append(poseidonModuleDescription.getName());
            stringBuffer.append("  (");
            stringBuffer.append(poseidonModuleDescription.getCodeNameBase());
            stringBuffer.append(") \n");
        }
        object = _disablePluginsTitle;
        int n2 = JBoogieUtils.showConfirmDialog((Component)((Object)C.C()), (Object)stringBuffer, (String)object, (int)-1);
        if (n2 == 0) {
            return collection;
        }
        return null;
    }

    static List getDependentModules(PoseidonModuleItem poseidonModuleItem) {
        return miSupport.A(poseidonModuleItem.getDescription(), 1);
    }

    static String getStringFromResource(String string) {
        return NbBundle.getBundle((Class)(class$com$gentleware$poseidon$util$plugin$PoseidonModuleInstaller == null ? (class$com$gentleware$poseidon$util$plugin$PoseidonModuleInstaller = PoseidonModuleInstaller.A("com.gentleware.poseidon.util.plugin.PoseidonModuleInstaller")) : class$com$gentleware$poseidon$util$plugin$PoseidonModuleInstaller)).getString(string);
    }

    static String getStringFromResource(String string, Object object) {
        MessageFormat messageFormat = new MessageFormat(PoseidonModuleInstaller.getStringFromResource(string));
        return messageFormat.format(new Object[]{object});
    }

    static String getStringFromResource(String string, Object object, Object object2) {
        MessageFormat messageFormat = new MessageFormat(PoseidonModuleInstaller.getStringFromResource(string));
        return messageFormat.format(new Object[]{object, object2});
    }

    public static Collection getAllInstalledParts(int n2) {
        return miSupport.A(n2);
    }

    static {
        A = true;
        E = new PropertyChangeSupport(new PoseidonModuleInstaller());
        _defaultModules = CollectionFactory.createArrayList();
        _noValidLicense = Localizer.localize((ResourceId)RegistrationResourceBundle.msgNoValidLicense);
        _pluginsNotInstalled = Localizer.localize((ResourceId)RegistrationResourceBundle.pluginsNotInstalled);
        _missingPlugins = Localizer.localize((ResourceId)RegistrationResourceBundle.missingPlugins);
        _enablePlugins = Localizer.localize((ResourceId)RegistrationResourceBundle.enablePlugins);
        _enablePluginsTitle = Localizer.localize((ResourceId)RegistrationResourceBundle.enablePluginsTitle);
        _disablePlugins = Localizer.localize((ResourceId)RegistrationResourceBundle.disablePlugins);
        _disablePluginsTitle = Localizer.localize((ResourceId)RegistrationResourceBundle.disablePluginsTitle);
        _defaultModules.add("Uml-1.4");
        _defaultModules.add("TreeView");
        _defaultModules.add("UmlGadgets");
        _defaultModules.add("Enhanced-Editor");
        _defaultModules.add("Reverse-Engineering");
        _defaultModules.add("UML-to-Java");
        _defaultModules.add("Printing");
        _defaultModules.add("Wmf-Export");
        _defaultModules.add("Uml-to-Ant");
        ProductEditionImpl productEditionImpl = BuildProperties.getPoseidonEdition();
        if (productEditionImpl.compareTo(ProductEditionImpl.SE) >= 0) {
            _defaultModules.add("UMLdoc");
        }
        if (productEditionImpl.compareTo(ProductEditionImpl.PE) >= 0 && productEditionImpl.compareTo(ProductEditionImpl.EmbEd) != 0 && productEditionImpl.compareTo(ProductEditionImpl.EmbEE) != 0) {
            _defaultModules.add("Roundtrip-Engineering");
            _defaultModules.add("Jar-Import");
            _defaultModules.add("MDLImport");
            _defaultModules.add("UML-to-IDL");
            _defaultModules.add("UML-to-VBNet");
            _defaultModules.add("UML-to-CSharp");
            _defaultModules.add("UML-to-PHP");
            _defaultModules.add("UML-to-Delphi");
            _defaultModules.add("UML-to-DDL");
            _defaultModules.add("UML-to-Perl");
            _defaultModules.add("Uml-to-CPP");
            _defaultModules.add("UML-to-Ecore");
        }
        if (productEditionImpl == ProductEditionImpl.PE) {
            _defaultModules.add("IDE-Integration");
        }
        if (productEditionImpl.compareTo(ProductEditionImpl.PE) >= 0) {
            _defaultModules.add("Auto-Layout");
        }
        if (productEditionImpl == ProductEditionImpl.EmbEd || productEditionImpl == ProductEditionImpl.EmbEE) {
            _defaultModules.add("Embedded-Codegen");
            _defaultModules.add("Jar-Import");
            _defaultModules.add("MDLImport");
        }
        if (BuildProperties.getPoseidonEdition().isTeamAware()) {
            _defaultModules.add("Enterprise Edition");
            _defaultModules.add("CVS-Client");
        }
    }

    private static Class A(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    private static final class _A
    extends D {
        public _A(ClassLoader[] classLoaderArray) {
            super(new URL[0], classLoaderArray);
        }
    }
}

