/*
 * Decompiled with CFR 0.152.
 */
package com.gentleware.treeview.base;

import com.gentleware.openapi.util.CollectionFactory;
import com.gentleware.openapi.util.MultiMap;
import com.gentleware.treeview.base.AbstractTreeModel;
import com.gentleware.treeview.base.DefaultTreeViewModel;
import com.gentleware.treeview.base.TreePerspective;
import com.gentleware.treeview.base.TreeView;
import com.gentleware.treeview.base.TreeViewModel;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.jmi.reflect.InvalidObjectException;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public abstract class DefaultTreeView
implements TreeView {
    private static final Logger C = Logger.getLogger("com.gentleware.poseidon.ui.treeview.DefaultTreeView");
    private Object E;
    private List D;
    private boolean B;
    private TreeViewModel G;
    private TreePerspective A;
    private TreeView F;
    private MultiMap H = CollectionFactory.createMultiHashMap();

    public abstract void sortChildren();

    protected abstract void initChildren();

    public DefaultTreeView() {
    }

    public DefaultTreeView(Object object) {
        this.setViewedObject(object);
    }

    public Object clone() {
        DefaultTreeView defaultTreeView = null;
        try {
            defaultTreeView = (DefaultTreeView)super.clone();
            if (this.D != null) {
                defaultTreeView.D = CollectionFactory.createArrayList();
                Iterator iterator = this.D.iterator();
                while (iterator.hasNext()) {
                    Object object = ((TreeView)iterator.next()).clone();
                    defaultTreeView.D.add(object);
                }
            }
            defaultTreeView.H = CollectionFactory.createMultiHashMap((MultiMap)this.H);
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            C.debug("[DefaultTreeView] clone:", cloneNotSupportedException);
        }
        return defaultTreeView;
    }

    public void setPerspective(TreePerspective treePerspective) {
        this.A = treePerspective;
    }

    public TreePerspective getPerspective() {
        if (this.A != null) {
            return this.A;
        }
        if (this.getParent() != null) {
            return ((TreeView)this.getParent()).getPerspective();
        }
        return this.G.getPerspective();
    }

    public boolean insert(TreeView treeView) {
        return this.insert(treeView, false);
    }

    public boolean insert(TreeView treeView, boolean bl) {
        Object object;
        boolean bl2 = this.A(treeView);
        if (treeView instanceof DefaultTreeView) {
            object = (DefaultTreeView)treeView;
            ((DefaultTreeView)object).collectChildren();
        }
        if (bl && bl2) {
            this.sortChildren();
            this.updateChildrenBelow(this);
            if (this.getChildCount() > 1) {
                object = (DefaultTreeViewModel)this.getTreeModel();
                ((AbstractTreeModel)object).fireChildAdded(treeView.getPathToRoot(), treeView, this.getIndex(treeView));
            } else {
                object = (DefaultTreeViewModel)this.getTreeModel();
                if (object != null && treeView != null) {
                    ((AbstractTreeModel)object).fireTreeStructureChanged(treeView.getPathToRoot());
                }
            }
        }
        return true;
    }

    private boolean A(TreeView treeView) {
        Object object = treeView.getViewedObject();
        List list = this.collectChildren();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            TreeView treeView2 = (TreeView)list.get(i2);
            Object object2 = treeView2.getViewedObject();
            if (object2 != object) continue;
            return false;
        }
        this.collectChildren().add(treeView);
        return true;
    }

    public boolean shouldElementBeViewed(Object object) {
        TreeView treeView = this.getChildFor(object);
        if (treeView != null || object == null) {
            return false;
        }
        Class<?> clazz = object.getClass();
        Collection collection = this.getFilterFor(clazz);
        if (collection != null) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                TreePerspective.Filter filter = (TreePerspective.Filter)iterator.next();
                boolean bl = filter.shouldBeViewed(object);
                if (bl) continue;
                return false;
            }
        }
        return true;
    }

    public void remove(TreeView treeView) {
        List list = this.getChildren();
        if (list != null) {
            list.remove(treeView);
        }
        treeView.removeAllListeners();
    }

    public Object getViewedObject() {
        return this.E;
    }

    public void setViewedObject(Object object) {
        this.E = object;
    }

    public void setParent(TreeView treeView) {
        this.F = treeView;
    }

    public void setTreeModel(TreeViewModel treeViewModel) {
        this.G = treeViewModel;
    }

    public TreeViewModel getTreeModel() {
        return this.G;
    }

    public TreePath getPathToRoot() {
        LinkedList<TreeNode> linkedList = new LinkedList<TreeNode>();
        for (TreeNode treeNode = this.getParent(); treeNode != null; treeNode = treeNode.getParent()) {
            linkedList.addFirst(treeNode);
        }
        return new TreePath(linkedList.toArray());
    }

    public TreeView getChildFor(Object object) {
        Enumeration enumeration = this.children();
        while (enumeration.hasMoreElements()) {
            TreeView treeView = (TreeView)enumeration.nextElement();
            Object object2 = treeView.getViewedObject();
            if (object2 != object) continue;
            return treeView;
        }
        return null;
    }

    public void addChild(TreeNode treeNode) {
        this.D.add(treeNode);
    }

    public Enumeration children() {
        return new _A(this.collectChildren());
    }

    public boolean getAllowsChildren() {
        return this.B;
    }

    public TreeNode getChildAt(int n2) {
        return (TreeNode)this.collectChildren().get(n2);
    }

    public int getChildCount() {
        return this.collectChildren().size();
    }

    public int getIndex(TreeNode treeNode) {
        return this.collectChildren().indexOf(treeNode);
    }

    public TreeNode getParent() {
        return this.F;
    }

    public boolean isLeaf() {
        return this.D != null ? this.D.isEmpty() : this.computeIsLeaf();
    }

    protected boolean computeIsLeaf() {
        return this.collectChildren().isEmpty();
    }

    public String toString() {
        return this.getViewedObject().toString();
    }

    protected List collectChildren() {
        if (this.D == null) {
            this.D = CollectionFactory.createArrayList();
            try {
                this.initChildren();
            }
            catch (InvalidObjectException invalidObjectException) {
                C.error("Tree: prevented UI lockup through initChildren()");
            }
            try {
                this.sortChildren();
            }
            catch (InvalidObjectException invalidObjectException) {
                C.error("Tree: prevented UI lockup through sortChildren()");
            }
        }
        return this.D;
    }

    public List getChildren() {
        return this.D;
    }

    protected void setChildren(List list) {
        this.D = list;
    }

    protected boolean isAllowsChildren() {
        return this.B;
    }

    protected void setAllowsChildren(boolean bl) {
        this.B = bl;
    }

    public boolean isEditable() {
        return true;
    }

    public Icon getIcon() {
        return null;
    }

    public void addFilter(Class clazz, TreePerspective.Filter filter) {
        this.H.add((Object)clazz, (Object)filter);
    }

    public Collection getFilterFor(Class clazz) {
        Collection collection = null;
        if (!this.H.isEmpty()) {
            Class<?>[] classArray = clazz.getInterfaces();
            for (int i2 = 0; i2 < classArray.length && (collection = this.H.getAll(classArray[i2])) == null; ++i2) {
            }
        }
        return collection;
    }

    protected void updateChildrenBelow(final DefaultTreeView defaultTreeView) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                DefaultTreeViewModel defaultTreeViewModel = (DefaultTreeViewModel)DefaultTreeView.this.getTreeModel();
                int n2 = defaultTreeView.getChildCount();
                if (defaultTreeViewModel != null) {
                    int[] nArray = new int[n2];
                    TreeNode[] treeNodeArray = new TreeNode[n2];
                    for (int i2 = 0; i2 < n2; ++i2) {
                        nArray[i2] = i2;
                        treeNodeArray[i2] = (TreeNode)defaultTreeViewModel.getChild(defaultTreeView, i2);
                    }
                    defaultTreeViewModel.fireChildrenChanged(DefaultTreeView.this.getPathToRoot(), treeNodeArray, nArray);
                }
            }
        });
    }

    public String getValueToEdit() {
        return this.toString();
    }

    private class _A
    implements Enumeration {
        private Iterator A;

        _A(List list) {
            List list2 = CollectionFactory.createArrayList((Collection)list);
            this.A = list2.iterator();
        }

        public boolean hasMoreElements() {
            return this.A.hasNext();
        }

        public Object nextElement() {
            return this.A.next();
        }
    }
}

