/*
 * Decompiled with CFR 0.152.
 */
package com.gentleware.treeview.base;

import com.gentleware.jboogie.kernel.HighlightManager;
import com.gentleware.jboogie.ui.IconProvider;
import com.gentleware.openapi.swingx.SwingUtil;
import com.gentleware.openapi.util.Strings;
import com.gentleware.poseidon.jboogie.PoseidonApplicationState;
import com.gentleware.poseidon.kernel.PoseidonProject;
import com.gentleware.treeview.base.TreeView;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public abstract class TreeViewCellRenderer
extends DefaultTreeCellRenderer {
    private static final Logger B = Logger.getLogger("com.gentleware.poseidon.ui.treeview.TreeViewCellRenderer");
    private IconProvider F;
    private final Color A = new Color(255, 0, 0, 80);
    private final Color E = new Color(0, 255, 0, 80);
    private Color D = Color.gray;
    private static final Color C = Color.white;

    protected abstract boolean hasGeneratedDefaultName(Object var1);

    protected abstract String getToolTipText(Object var1, PoseidonProject var2);

    public TreeViewCellRenderer(IconProvider iconProvider) {
        this.F = iconProvider;
    }

    public void setIconRenderer(IconProvider iconProvider) {
        this.F = iconProvider;
    }

    public synchronized Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n2, boolean bl4) {
        PoseidonProject poseidonProject = PoseidonApplicationState.getInstance().getCurrentProject();
        if (object == null) {
            SwingUtil.setToolTipText((JComponent)this, null);
            return null;
        }
        boolean bl5 = this.hasGeneratedDefaultName(object);
        TreePath treePath = jTree.getLeadSelectionPath();
        bl4 = treePath == null ? false : treePath.getLastPathComponent() == object;
        super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n2, bl4);
        Icon icon = this.getIcon(object);
        this.setIcon(icon);
        this.setOpaque(false);
        Color color = this.getForegroundColor(object, bl5, bl, bl4);
        this.setForeground(color);
        String string = this.getText(object);
        this.setText(string);
        this.highlightViewedObject(object, poseidonProject);
        this.setOpenIcon(icon);
        this.setClosedIcon(icon);
        this.setLeafIcon(icon);
        String string2 = this.getToolTipText(object, poseidonProject);
        if (Strings.isEmpty((String)string2)) {
            SwingUtil.setToolTipText((JComponent)this, null);
            SwingUtil.setToolTipText((JComponent)jTree, null);
        } else {
            SwingUtil.setToolTipText((JComponent)this, (String)(string2 + " "));
            SwingUtil.setToolTipText((JComponent)jTree, (String)(string2 + " "));
        }
        return this;
    }

    protected String getText(Object object) {
        String string = object.toString();
        String string2 = Strings.isEmpty((String)string) ? "" : string;
        return string2;
    }

    protected Icon getIcon(Object object) {
        Icon icon = null;
        try {
            icon = object instanceof TreeView ? ((TreeView)object).getIcon() : this.F.getIcon(object);
        }
        catch (Throwable throwable) {
            B.error("[TreeViewCellRenderer reports an exception:]", throwable);
        }
        return icon;
    }

    protected Color getForegroundColor(Object object, boolean bl, boolean bl2, boolean bl3) {
        if (bl && !bl2 && !bl3) {
            return this.D;
        }
        if (!bl2) {
            return this.getTextNonSelectionColor();
        }
        return this.getTextSelectionColor();
    }

    protected boolean highlightViewedObject(Object object, PoseidonProject poseidonProject) {
        boolean bl = false;
        if (object instanceof TreeView) {
            TreeView treeView = (TreeView)object;
            Object object2 = treeView.getViewedObject();
            if (poseidonProject != null) {
                HighlightManager highlightManager = poseidonProject.getHighlightManager();
                if (highlightManager.isRemotelyLocked(object2)) {
                    this.setBackground(this.A);
                    bl = true;
                }
                if (highlightManager.isLocallyLocked(object2)) {
                    this.setBackground(this.E);
                    bl = true;
                }
            }
        }
        if (!bl) {
            this.setBackground(C);
        }
        return bl;
    }

    public Color getBackgroundNonSelectionColor() {
        return null;
    }

    public Icon getDefaultLeafIcon() {
        return this.getIcon();
    }

    public Icon getDefaultOpenIcon() {
        return this.getIcon();
    }

    public Icon getDefaultClosedIcon() {
        return this.getIcon();
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public void updateUI() {
        super.updateUI();
        this.setLeafIcon(UIManager.getIcon("Tree.leafIcon"));
        this.setClosedIcon(UIManager.getIcon("Tree.closedIcon"));
        this.setOpenIcon(UIManager.getIcon("Tree.openIcon"));
        this.setTextSelectionColor(UIManager.getColor("Tree.selectionForeground"));
        this.setTextNonSelectionColor(UIManager.getColor("Tree.textForeground"));
        this.setBackgroundSelectionColor(UIManager.getColor("Tree.selectionBackground"));
        this.setBackgroundNonSelectionColor(UIManager.getColor("Tree.textBackground"));
        this.setBorderSelectionColor(UIManager.getColor("Tree.selectionBorderColor"));
    }
}

