/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util;

import java.awt.AWTEvent;
import java.awt.ActiveEvent;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;
import org.openide.util.AsyncGUIJob;
import org.openide.util.Cancellable;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;

final class AsyncInitSupport
implements AWTEventListener,
HierarchyListener,
Runnable {
    private static final Object CANCELLED_LOCK = new Object();
    private Task initTask;
    private boolean wasCancelled;
    private Component comp4Init;
    private AsyncGUIJob initJob;

    public AsyncInitSupport(Component comp4Init, AsyncGUIJob initJob) {
        this.comp4Init = comp4Init;
        this.initJob = initJob;
        if (comp4Init.isShowing()) {
            throw new IllegalStateException("Component already shown, can't be inited: " + comp4Init);
        }
        Toolkit.getDefaultToolkit().addAWTEventListener(this, 8192L);
        comp4Init.addHierarchyListener(this);
        if (!RepaintManager.currentManager(comp4Init).isDoubleBufferingEnabled()) {
            new PrimerEvent(new WeakReference<Component>(comp4Init)).postThyself();
        }
    }

    public void eventDispatched(AWTEvent event) {
        if (!(event instanceof PrimerEvent) && event.getSource() instanceof Component && SwingUtilities.isDescendingFrom(this.comp4Init, (Component)event.getSource())) {
            this.start();
        }
    }

    private void start() {
        this.detach();
        if (this.initTask == null) {
            this.initTask = RequestProcessor.getDefault().post(this);
        }
    }

    private void detach() {
        Toolkit.getDefaultToolkit().removeAWTEventListener(this);
    }

    public void hierarchyChanged(HierarchyEvent evt) {
        if ((evt.getChangeFlags() & 4L) != 0L && !this.comp4Init.isShowing()) {
            this.comp4Init.removeHierarchyListener(this);
            this.cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (!SwingUtilities.isEventDispatchThread()) {
            boolean localCancel;
            this.initJob.construct();
            this.comp4Init.removeHierarchyListener(this);
            Object object = CANCELLED_LOCK;
            synchronized (object) {
                localCancel = this.wasCancelled;
            }
            if (!localCancel) {
                SwingUtilities.invokeLater(this);
            }
        } else {
            this.initJob.finished();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancel() {
        if (this.initTask != null && !this.initTask.isFinished() && this.initJob instanceof Cancellable) {
            Object object = CANCELLED_LOCK;
            synchronized (object) {
                this.wasCancelled = true;
            }
            ((Cancellable)((Object)this.initJob)).cancel();
        }
    }

    private class PrimerEvent
    extends AWTEvent
    implements ActiveEvent {
        private static final int MAX_RUN_COUNT = 500;
        private int runCount;

        private PrimerEvent(Reference source) {
            super(source, 800);
            this.runCount = 0;
        }

        public void postThyself() {
            Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(this);
        }

        private Component getComponent() {
            return (Component)((Reference)super.getSource()).get();
        }

        public void dispatch() {
            if (this.runCount++ == 500) {
                AsyncInitSupport.this.detach();
                return;
            }
            if (AsyncInitSupport.this.wasCancelled || AsyncInitSupport.this.initTask != null) {
                AsyncInitSupport.this.detach();
                return;
            }
            Component c = this.getComponent();
            if (c != null && c.isDisplayable()) {
                AsyncInitSupport.this.start();
            } else if (c != null) {
                this.postThyself();
            }
        }
    }
}

