/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util.lookup;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.lookup.ALPairComparator;
import org.openide.util.lookup.ArrayStorage;
import org.openide.util.lookup.DelegatingStorage;
import org.openide.util.lookup.InheritanceTree;
import org.openide.util.lookup.WaitableResult;

public class AbstractLookup
extends Lookup
implements Serializable {
    static final long serialVersionUID = 5L;
    private static Object treeLock = new Object();
    private Object tree;
    private int count;
    private static Object activeQueue;

    public AbstractLookup(Content content) {
        content.attach(this);
    }

    AbstractLookup(Content content, Storage storage) {
        this(content);
        this.tree = storage;
        this.initialize();
    }

    AbstractLookup(Content content, Integer trashhold) {
        this(content);
        this.tree = trashhold;
    }

    public String toString() {
        if (this.tree instanceof Storage) {
            return "AbstractLookup" + this.lookup(new Lookup.Template(Object.class)).allItems();
        }
        return super.toString();
    }

    protected AbstractLookup() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Storage enterStorage() {
        while (true) {
            Object object = treeLock;
            synchronized (object) {
                if (this.tree instanceof Storage) {
                    if (this.tree instanceof DelegatingStorage) {
                        DelegatingStorage del = (DelegatingStorage)this.tree;
                        del.checkForTreeModification();
                        try {
                            treeLock.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        continue;
                    }
                    this.tree = new DelegatingStorage((Storage)this.tree);
                    return (Storage)this.tree;
                }
                this.tree = this.tree instanceof Integer ? new ArrayStorage((Integer)this.tree) : new ArrayStorage();
            }
            this.initialize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Storage exitStorage() {
        Object object = treeLock;
        synchronized (object) {
            Storage stor = ((DelegatingStorage)this.tree).exitDelegate();
            this.tree = stor;
            treeLock.notifyAll();
            return stor;
        }
    }

    protected void initialize() {
    }

    protected void beforeLookup(Lookup.Template template) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void addPair(Pair pair) {
        HashSet toNotify;
        block6: {
            toNotify = new HashSet();
            Object transaction = null;
            Storage t = this.enterStorage();
            try {
                transaction = t.beginTransaction(-2);
                if (t.add(pair, transaction)) {
                    try {
                        pair.setIndex(t, this.count++);
                    }
                    catch (IllegalStateException ex) {
                        t.remove(pair, transaction);
                        throw ex;
                    }
                    t.endTransaction(transaction, toNotify);
                    break block6;
                }
                t.endTransaction(transaction, new HashSet());
            }
            finally {
                this.exitStorage();
            }
        }
        AbstractLookup.notifyListeners(toNotify);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void removePair(Pair pair) {
        HashSet toNotify = new HashSet();
        Object transaction = null;
        Storage t = this.enterStorage();
        try {
            transaction = t.beginTransaction(-1);
            t.remove(pair, transaction);
            t.endTransaction(transaction, toNotify);
        }
        finally {
            this.exitStorage();
        }
        AbstractLookup.notifyListeners(toNotify);
    }

    protected final void setPairs(Collection collection) {
        this.notifyCollectedListeners(this.setPairsAndCollectListeners(collection));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final HashSet setPairsAndCollectListeners(Collection collection) {
        HashSet toNotify = new HashSet(27);
        Object transaction = null;
        Storage t = this.enterStorage();
        try {
            HashMap<Pair, Info> shouldBeThere = new HashMap<Pair, Info>(collection.size() * 2);
            this.count = 0;
            Iterator it = collection.iterator();
            transaction = t.beginTransaction(collection.size());
            while (it.hasNext()) {
                Pair item = (Pair)it.next();
                if (t.add(item, transaction)) {
                    // empty if block
                }
                shouldBeThere.put(item, new Info(this.count++, transaction));
            }
            t.retainAll(shouldBeThere, transaction);
            t.endTransaction(transaction, toNotify);
        }
        finally {
            this.exitStorage();
        }
        return toNotify;
    }

    final void notifyCollectedListeners(Object listeners) {
        AbstractLookup.notifyListeners((HashSet)listeners);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void writeObject(ObjectOutputStream oos) throws IOException {
        Storage s = this.enterStorage();
        try {
            s.beginTransaction(Integer.MAX_VALUE);
            oos.defaultWriteObject();
        }
        finally {
            this.exitStorage();
        }
    }

    public final Object lookup(Class clazz) {
        Lookup.Item item = this.lookupItem(new Lookup.Template(clazz));
        return item == null ? null : item.getInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Lookup.Item lookupItem(Lookup.Template template) {
        this.beforeLookup(template);
        ArrayList list = null;
        Storage t = this.enterStorage();
        try {
            Enumeration en = t.lookup(template.getType());
            Pair pair = AbstractLookup.findSmallest(en, template);
            return pair;
        }
        catch (ISE ex) {
            list = new ArrayList();
            Enumeration en = t.lookup(null);
            while (en.hasMoreElements()) {
                list.add(en.nextElement());
            }
        }
        finally {
            this.exitStorage();
        }
        return AbstractLookup.findSmallest(Collections.enumeration(list), template);
    }

    private static Pair findSmallest(Enumeration en, Lookup.Template template) {
        int smallest = InheritanceTree.unsorted(en) ? Integer.MAX_VALUE : Integer.MIN_VALUE;
        Pair res = null;
        while (en.hasMoreElements()) {
            Pair item = (Pair)en.nextElement();
            if (!AbstractLookup.matches(template, item, false)) continue;
            if (smallest == Integer.MIN_VALUE) {
                return item;
            }
            if (smallest <= item.getIndex()) continue;
            smallest = item.getIndex();
            res = item;
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Lookup.Result lookup(Lookup.Template template) {
        while (true) {
            ISE toRun = null;
            Storage t = this.enterStorage();
            try {
                R r = new R();
                ReferenceToResult newRef = new ReferenceToResult(r, this, template);
                newRef.next = t.registerReferenceToResult(newRef);
                R r2 = r;
                return r2;
            }
            catch (ISE ex) {
                toRun = ex;
            }
            finally {
                this.exitStorage();
            }
            toRun.recover(this);
        }
    }

    private static void notifyListeners(Set allAffectedResults) {
        if (allAffectedResults.isEmpty()) {
            return;
        }
        Iterator it = allAffectedResults.iterator();
        while (it.hasNext()) {
            R result = (R)it.next();
            result.fireStateChanged();
        }
    }

    static void notifyListeners(Object[] listeners, LookupEvent ev) {
        for (int i = listeners.length - 1; i >= 0; i -= 2) {
            LookupListener ll = (LookupListener)listeners[i];
            try {
                ll.resultChanged(ev);
                continue;
            }
            catch (RuntimeException e) {
                e.printStackTrace();
            }
        }
    }

    static boolean matches(Lookup.Template t, Pair item, boolean deepCheck) {
        String id = t.getId();
        if (id != null && !item.getId().equals(id)) {
            return false;
        }
        Object instance = t.getInstance();
        if (instance != null && !item.creatorOf(instance)) {
            return false;
        }
        if (deepCheck) {
            return item.instanceOf(t.getType());
        }
        return true;
    }

    private static boolean compareArrays(Object[] a, Object[] b) {
        if (a == null) {
            return b == null;
        }
        if (b == null) {
            return false;
        }
        if (a.length != b.length) {
            return false;
        }
        for (int i = 0; i < a.length; ++i) {
            if (a[i] == null) {
                if (b[i] == null) continue;
                return false;
            }
            if (b[i] == null) {
                return false;
            }
            if (a[i].equals(b[i])) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean cleanUpResult(Lookup.Template template) {
        Storage t = this.enterStorage();
        try {
            boolean bl = t.cleanUpResult(template) == null;
            return bl;
        }
        finally {
            this.exitStorage();
        }
    }

    private static ReferenceQueue activeQueue() {
        if (activeQueue == null) {
            try {
                Class<?> c = Class.forName("org.openide.util.Utilities");
                Object[] noArgs = new Class[]{};
                Method m = c.getDeclaredMethod("activeReferenceQueue", (Class<?>[])noArgs);
                activeQueue = m.invoke(null, noArgs);
            }
            catch (Exception ex) {
                activeQueue = ex;
            }
        }
        return activeQueue instanceof ReferenceQueue ? (ReferenceQueue)activeQueue : null;
    }

    static final class ISE
    extends IllegalStateException {
        private List jobs;

        public ISE(String msg) {
            super(msg);
        }

        public void registerJob(Job job) {
            if (this.jobs == null) {
                this.jobs = new ArrayList();
            }
            this.jobs.add(job);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void recover(AbstractLookup lookup) {
            if (this.jobs == null) {
                throw this;
            }
            Iterator it = this.jobs.iterator();
            while (it.hasNext()) {
                Job j = (Job)it.next();
                j.before();
            }
            Storage s = lookup.enterStorage();
            try {
                Iterator it2 = this.jobs.iterator();
                while (it2.hasNext()) {
                    Job j = (Job)it2.next();
                    j.inside();
                }
            }
            finally {
                lookup.exitStorage();
            }
        }

        static interface Job {
            public void before();

            public void inside();
        }
    }

    static final class ReferenceIterator {
        private ReferenceToResult first;
        private ReferenceToResult current;
        private R currentResult;

        public ReferenceIterator(ReferenceToResult first) {
            this.first = first;
        }

        public boolean next() {
            ReferenceToResult prev;
            ReferenceToResult ref;
            if (this.current == null) {
                ref = this.first;
                prev = null;
            } else {
                prev = this.current;
                ref = this.current.next;
            }
            while (ref != null) {
                R result = (R)ref.get();
                if (result == null) {
                    if (prev == null) {
                        this.first = ref.next;
                    } else {
                        prev.next = ref.next;
                    }
                    prev = ref;
                    ref = ref.next;
                    continue;
                }
                this.currentResult = result;
                this.current = ref;
                return true;
            }
            this.currentResult = null;
            this.current = null;
            return false;
        }

        public ReferenceToResult current() {
            return this.current;
        }

        public ReferenceToResult first() {
            return this.first;
        }
    }

    static final class ReferenceToResult
    extends WeakReference
    implements Runnable {
        private ReferenceToResult next;
        public final Lookup.Template template;
        public final AbstractLookup lookup;
        public Object caches;

        private ReferenceToResult(R result, AbstractLookup lookup, Lookup.Template template) {
            super(result, AbstractLookup.activeQueue());
            this.template = template;
            this.lookup = lookup;
            this.getResult().reference = this;
        }

        R getResult() {
            return (R)this.get();
        }

        public void run() {
            this.lookup.cleanUpResult(this.template);
        }

        public void cloneList(Storage storage) {
            ReferenceIterator it = new ReferenceIterator(this);
            while (it.next()) {
                ReferenceToResult current = it.current();
                ReferenceToResult newRef = new ReferenceToResult(current.getResult(), current.lookup, current.template);
                newRef.next = storage.registerReferenceToResult(newRef);
                newRef.caches = current.caches;
                if (current.caches != current) continue;
                current.getResult().initItems(storage);
            }
        }
    }

    static interface Storage {
        public Object beginTransaction(int var1);

        public void endTransaction(Object var1, Set var2);

        public boolean add(Pair var1, Object var2);

        public void remove(Pair var1, Object var2);

        public void retainAll(Map var1, Object var2);

        public Enumeration lookup(Class var1);

        public ReferenceToResult registerReferenceToResult(ReferenceToResult var1);

        public ReferenceToResult cleanUpResult(Lookup.Template var1);
    }

    static final class Info {
        public int index;
        public Object transaction;

        public Info(int i, Object t) {
            this.index = i;
            this.transaction = t;
        }
    }

    public static class Content
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private AbstractLookup al = null;
        private transient ArrayList earlyPairs;

        final synchronized void attach(AbstractLookup al) {
            if (this.al == null) {
                this.al = al;
                if (this.earlyPairs != null) {
                    Pair[] p = this.earlyPairs.toArray(new Pair[this.earlyPairs.size()]);
                    for (int i = 0; i < p.length; ++i) {
                        this.addPair(p[i]);
                    }
                }
            } else {
                throw new IllegalStateException("Trying to use content for " + al + " but it is already used for " + this.al);
            }
            this.earlyPairs = null;
        }

        public final void addPair(Pair pair) {
            AbstractLookup a = this.al;
            if (a != null) {
                a.addPair(pair);
            } else {
                if (this.earlyPairs == null) {
                    this.earlyPairs = new ArrayList(3);
                }
                this.earlyPairs.add(pair);
            }
        }

        public final void removePair(Pair pair) {
            AbstractLookup a = this.al;
            if (a != null) {
                a.removePair(pair);
            } else {
                if (this.earlyPairs == null) {
                    this.earlyPairs = new ArrayList(3);
                }
                this.earlyPairs.remove(pair);
            }
        }

        public final void setPairs(Collection c) {
            AbstractLookup a = this.al;
            if (a != null) {
                a.setPairs(c);
            } else {
                this.earlyPairs = new ArrayList(c);
            }
        }
    }

    static final class R
    extends WaitableResult {
        public ReferenceToResult reference;
        private Object listeners;

        private boolean isSimple() {
            Storage s = (Storage)this.reference.lookup.tree;
            return DelegatingStorage.isSimple(s);
        }

        private Object getFromCache(int indx) {
            if (this.isSimple()) {
                return null;
            }
            Object maybeArray = this.reference.caches;
            if (maybeArray instanceof Object[]) {
                return ((Object[])maybeArray)[indx];
            }
            return null;
        }

        private Set getClassesCache() {
            return (Set)this.getFromCache(0);
        }

        private void setClassesCache(Set s) {
            if (this.isSimple()) {
                this.reference.caches = this.reference;
                return;
            }
            if (!(this.reference.caches instanceof Object[])) {
                this.reference.caches = new Object[3];
            }
            ((Object[])this.reference.caches)[0] = s;
        }

        private Collection getInstancesCache() {
            return (Collection)this.getFromCache(1);
        }

        private void setInstancesCache(Collection c) {
            if (this.isSimple()) {
                this.reference.caches = this.reference;
                return;
            }
            if (!(this.reference.caches instanceof Object[])) {
                this.reference.caches = new Object[3];
            }
            ((Object[])this.reference.caches)[1] = c;
        }

        private Object[] getItemsCache() {
            return (Object[])this.getFromCache(2);
        }

        private void setItemsCache(Collection c) {
            if (this.isSimple()) {
                this.reference.caches = this.reference;
                return;
            }
            if (!(this.reference.caches instanceof Object[])) {
                this.reference.caches = new Object[3];
            }
            ((Object[])this.reference.caches)[2] = c.toArray();
        }

        private void clearCaches() {
            if (this.reference.caches instanceof Object[]) {
                this.reference.caches = new Object[3];
            }
        }

        public synchronized void addLookupListener(LookupListener l) {
            if (this.listeners == null) {
                this.listeners = l;
                return;
            }
            if (this.listeners instanceof LookupListener) {
                ArrayList<Object> arr = new ArrayList<Object>();
                arr.add(this.listeners);
                this.listeners = arr;
            }
            ((ArrayList)this.listeners).add(l);
        }

        public synchronized void removeLookupListener(LookupListener l) {
            if (this.listeners == null) {
                return;
            }
            if (this.listeners == l) {
                this.listeners = null;
                return;
            }
            ArrayList arr = (ArrayList)this.listeners;
            arr.remove(l);
            if (arr.size() == 1) {
                this.listeners = arr.iterator().next();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void fireStateChanged() {
            LookupListener[] arr;
            Object[] newArray;
            Object[] previousItems = this.getItemsCache();
            this.clearCaches();
            if (previousItems != null && AbstractLookup.compareArrays(previousItems, newArray = this.allItemsWithoutBeforeLookup().toArray())) {
                return;
            }
            R r = this;
            synchronized (r) {
                if (this.listeners == null) {
                    return;
                }
                if (this.listeners instanceof LookupListener) {
                    arr = new LookupListener[]{(LookupListener)this.listeners};
                } else {
                    ArrayList l = (ArrayList)this.listeners;
                    arr = l.toArray(new LookupListener[l.size()]);
                }
            }
            LookupListener[] ll = arr;
            LookupEvent ev = new LookupEvent(this);
            for (int i = 0; i < ll.length; ++i) {
                ll[i].resultChanged(ev);
            }
        }

        public Collection allInstances() {
            this.reference.lookup.beforeLookup(this.reference.template);
            ArrayList<Object> s = this.getInstancesCache();
            if (s != null) {
                return s;
            }
            Collection items = this.allItemsWithoutBeforeLookup();
            s = new ArrayList<Object>(items.size());
            Iterator it = items.iterator();
            while (it.hasNext()) {
                Lookup.Item item = (Lookup.Item)it.next();
                Object obj = item.getInstance();
                if (obj == null) continue;
                s.add(obj);
            }
            this.setInstancesCache(s);
            return s;
        }

        public Set allClasses() {
            this.reference.lookup.beforeLookup(this.reference.template);
            HashSet<Class> s = this.getClassesCache();
            if (s != null) {
                return s;
            }
            s = new HashSet<Class>();
            Iterator it = this.allItemsWithoutBeforeLookup().iterator();
            while (it.hasNext()) {
                Lookup.Item item = (Lookup.Item)it.next();
                Class clazz = item.getType();
                if (clazz == null) continue;
                s.add(clazz);
            }
            this.setClassesCache(s);
            return s;
        }

        public Collection allItems() {
            this.reference.lookup.beforeLookup(this.reference.template);
            return this.allItemsWithoutBeforeLookup();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Collection allItemsWithoutBeforeLookup() {
            Pair i;
            Object[] c = this.getItemsCache();
            if (c != null) {
                return Collections.unmodifiableList(Arrays.asList(c));
            }
            ArrayList<Pair> saferCheck = null;
            Storage t = this.reference.lookup.enterStorage();
            try {
                Collection collection = Collections.unmodifiableCollection(this.initItems(t));
                return collection;
            }
            catch (ISE ex) {
                saferCheck = new ArrayList<Pair>();
                Enumeration en = t.lookup(null);
                while (en.hasMoreElements()) {
                    i = (Pair)en.nextElement();
                    saferCheck.add(i);
                }
            }
            finally {
                this.reference.lookup.exitStorage();
            }
            Iterator it = saferCheck.iterator();
            TreeSet<Pair> items = new TreeSet<Pair>(ALPairComparator.DEFAULT);
            while (it.hasNext()) {
                i = (Pair)it.next();
                if (!AbstractLookup.matches(this.reference.template, i, false)) continue;
                items.add(i);
            }
            return Collections.unmodifiableCollection(items);
        }

        private Collection initItems(Storage t) {
            Enumeration en = t.lookup(this.reference.template.getType());
            TreeSet<Pair> items = new TreeSet<Pair>(ALPairComparator.DEFAULT);
            while (en.hasMoreElements()) {
                Pair i = (Pair)en.nextElement();
                if (!AbstractLookup.matches(this.reference.template, i, false)) continue;
                items.add(i);
            }
            this.setItemsCache(items);
            return items;
        }

        protected void beforeLookup(Lookup.Template t) {
            if (t.getType() == this.reference.template.getType()) {
                this.reference.lookup.beforeLookup(t);
            }
        }

        public String toString() {
            return super.toString() + " for " + this.reference.template;
        }
    }

    public static abstract class Pair
    extends Lookup.Item
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private int index = -1;

        final int getIndex() {
            return this.index;
        }

        final void setIndex(Storage tree, int x) {
            if (tree == null) {
                this.index = x;
                return;
            }
            if (this.index != -1) {
                throw new IllegalStateException("You cannot use " + this + " in more than one AbstractLookup");
            }
            this.index = x;
        }

        protected Pair() {
        }

        protected abstract boolean instanceOf(Class var1);

        protected abstract boolean creatorOf(Object var1);
    }
}

