/*
 * Decompiled with CFR 0.152.
 */
package com.gentleware.configuration;

import com.gentleware.configuration.C;
import com.gentleware.configuration.F;
import com.gentleware.openapi.configuration.ConfigurationException;
import com.gentleware.openapi.configuration.ConfigurationNode;
import com.gentleware.openapi.configuration.ConfigurationReader;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public final class XmlConfigurationReader
extends ConfigurationReader {
    private final InputStream I;

    public XmlConfigurationReader(InputStream inputStream) {
        this.I = inputStream;
    }

    public void read(ConfigurationNode configurationNode) throws IOException, ConfigurationException {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(this.I);
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        sAXParserFactory.setNamespaceAware(true);
        sAXParserFactory.setValidating(false);
        try {
            C c = new C();
            F f = new F(configurationNode);
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            XMLReader xMLReader = sAXParser.getXMLReader();
            xMLReader.setErrorHandler(c);
            xMLReader.setContentHandler(f);
            InputSource inputSource = new InputSource(bufferedInputStream);
            inputSource.setEncoding("UTF-8");
            xMLReader.parse(inputSource);
        }
        catch (SAXException sAXException) {
            throw new ConfigurationException("Parsing error", sAXException);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new ConfigurationException("Parser configuration exception", parserConfigurationException);
        }
    }
}

